/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-03-22 15:03:17 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_obs_admin_columns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `list_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `list_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `columns` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `list_id` (`list_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=40535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_podsrel` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pod_id` int unsigned DEFAULT NULL,
  `field_id` int unsigned DEFAULT NULL,
  `item_id` bigint unsigned DEFAULT NULL,
  `related_pod_id` int unsigned DEFAULT NULL,
  `related_field_id` int unsigned DEFAULT NULL,
  `related_item_id` bigint unsigned DEFAULT NULL,
  `weight` smallint unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_item_idx` (`field_id`,`item_id`),
  KEY `rel_field_rel_item_idx` (`related_field_id`,`related_item_id`),
  KEY `field_rel_item_idx` (`field_id`,`related_item_id`),
  KEY `rel_field_item_idx` (`related_field_id`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=49330 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1312477 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1007053 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_snippets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scope` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'global',
  `priority` smallint NOT NULL DEFAULT '10',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `revision` bigint NOT NULL DEFAULT '1',
  `cloud_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_obs_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_obs_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=335 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_obs_admin_columns */
INSERT INTO `wp_obs_admin_columns` VALUES("1", "67cc8a15d5864", "composante", "", "a:4:{s:5:\"title\";a:5:{s:4:\"type\";s:5:\"title\";s:5:\"label\";s:5:\"Titre\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:1:\"%\";s:4:\"name\";s:5:\"title\";}s:4:\"date\";a:5:{s:4:\"type\";s:4:\"date\";s:5:\"label\";s:4:\"Date\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:1:\"%\";s:4:\"name\";s:4:\"date\";}s:14:\"294882695df3b6\";a:5:{s:4:\"type\";s:23:\"categorie-etablissement\";s:5:\"label\";s:25:\"Catégorie établissement\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:1:\"%\";s:4:\"name\";s:14:\"294882695df3b6\";}s:14:\"451703a66b020c\";a:15:{s:4:\"type\";s:11:\"column-meta\";s:5:\"label\";s:9:\"Effectifs\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:1:\"%\";s:5:\"field\";s:8:\"effectif\";s:10:\"field_type\";s:7:\"numeric\";s:13:\"number_format\";s:0:\"\";s:6:\"before\";s:0:\"\";s:5:\"after\";s:0:\"\";s:4:\"sort\";s:3:\"off\";s:11:\"inline-edit\";s:2:\"on\";s:9:\"bulk-edit\";s:3:\"off\";s:15:\"smart-filtering\";s:3:\"off\";s:6:\"export\";s:3:\"off\";s:4:\"name\";s:14:\"451703a66b020c\";}}", NULL, "2025-03-08 18:19:01", "2025-03-08 18:28:49");

/* INSERT TABLE DATA: wp_obs_duplicator_packages */
INSERT INTO `wp_obs_duplicator_packages` VALUES("3", "20241123_observatoiredelenseignements", "f3ff081d6ae093fc2844_20250322150249", "22", "2025-03-22 15:03:17", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-03-22 15:02:49\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:37:\"20241123_observatoiredelenseignements\";s:4:\"Hash\";s:35:\"f3ff081d6ae093fc2844_20250322150249\";s:8:\"NameHash\";s:73:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.9\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:75:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1810;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11456;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-03-22 15:02:49\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20241123_observatoiredelenseignements\";s:4:\"Hash\";s:35:\"f3ff081d6ae093fc2844_20250322150249\";s:8:\"NameHash\";s:73:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:91:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:89:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:86:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:194:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/backups-dup-lite/tmp/20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:84:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-admin\";i:1;s:87:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-includes\";i:2;s:96:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:75:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public\";i:1;s:75:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public\";i:2;s:86:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content\";i:3;s:94:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/uploads\";i:4;s:94:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/plugins\";i:5;s:97:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/mu-plugins\";i:6;s:93:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:107:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_obs_options */
INSERT INTO `wp_obs_options` VALUES("1", "siteurl", "http://localhost:10004", "yes");
INSERT INTO `wp_obs_options` VALUES("2", "home", "http://localhost:10004", "yes");
INSERT INTO `wp_obs_options` VALUES("3", "blogname", "Observatoire de l&#039;enseignement supérieur privé", "yes");
INSERT INTO `wp_obs_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_obs_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("6", "admin_email", "contact@oesp.fr", "yes");
INSERT INTO `wp_obs_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_obs_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_obs_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_obs_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_obs_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_obs_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_obs_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_obs_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_obs_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_obs_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_obs_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_obs_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_obs_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_obs_options` VALUES("29", "rewrite_rules", "a:166:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"visualizer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"visualizer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"visualizer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"visualizer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"visualizer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"visualizer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"visualizer/([^/]+)/embed/?$\";s:43:\"index.php?visualizer=$matches[1]&embed=true\";s:31:\"visualizer/([^/]+)/trackback/?$\";s:37:\"index.php?visualizer=$matches[1]&tb=1\";s:39:\"visualizer/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?visualizer=$matches[1]&paged=$matches[2]\";s:46:\"visualizer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?visualizer=$matches[1]&cpage=$matches[2]\";s:35:\"visualizer/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?visualizer=$matches[1]&page=$matches[2]\";s:27:\"visualizer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"visualizer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"visualizer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"visualizer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"visualizer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"visualizer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"composante/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"composante/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"composante/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"composante/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"composante/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"composante/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"composante/([^/]+)/embed/?$\";s:43:\"index.php?composante=$matches[1]&embed=true\";s:31:\"composante/([^/]+)/trackback/?$\";s:37:\"index.php?composante=$matches[1]&tb=1\";s:39:\"composante/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?composante=$matches[1]&paged=$matches[2]\";s:46:\"composante/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?composante=$matches[1]&cpage=$matches[2]\";s:35:\"composante/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?composante=$matches[1]&page=$matches[2]\";s:27:\"composante/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"composante/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"composante/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"composante/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"composante/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"composante/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"etablissement/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"etablissement/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"etablissement/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"etablissement/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"etablissement/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"etablissement/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"etablissement/([^/]+)/embed/?$\";s:46:\"index.php?etablissement=$matches[1]&embed=true\";s:34:\"etablissement/([^/]+)/trackback/?$\";s:40:\"index.php?etablissement=$matches[1]&tb=1\";s:42:\"etablissement/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?etablissement=$matches[1]&paged=$matches[2]\";s:49:\"etablissement/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?etablissement=$matches[1]&cpage=$matches[2]\";s:38:\"etablissement/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?etablissement=$matches[1]&page=$matches[2]\";s:30:\"etablissement/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"etablissement/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"etablissement/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"etablissement/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"etablissement/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"etablissement/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"formation/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"formation/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"formation/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"formation/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"formation/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"formation/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"formation/([^/]+)/embed/?$\";s:42:\"index.php?formation=$matches[1]&embed=true\";s:30:\"formation/([^/]+)/trackback/?$\";s:36:\"index.php?formation=$matches[1]&tb=1\";s:38:\"formation/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?formation=$matches[1]&paged=$matches[2]\";s:45:\"formation/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?formation=$matches[1]&cpage=$matches[2]\";s:34:\"formation/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?formation=$matches[1]&page=$matches[2]\";s:26:\"formation/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"formation/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"formation/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"formation/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"formation/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"formation/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=40&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_obs_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_obs_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_obs_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_obs_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_obs_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("39", "recently_edited", "a:5:{i:0;s:108:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/themes/neve/style.css\";i:1;s:146:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/plugins/codepress-admin-columns/codepress-admin-columns.php\";i:3;s:112:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/themes/neve/functions.php\";i:4;s:113:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/themes/neve/footer-pwa.php\";i:5;s:0:\"\";}", "no");
INSERT INTO `wp_obs_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_obs_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_obs_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_obs_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `wp_obs_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_obs_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_obs_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_obs_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_obs_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_obs_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_obs_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_obs_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_obs_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_obs_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_obs_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_obs_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_obs_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_obs_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_obs_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_obs_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_obs_options` VALUES("67", "close_comments_for_old_posts", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_obs_options` VALUES("69", "thread_comments", "", "yes");
INSERT INTO `wp_obs_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_obs_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_obs_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_obs_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_obs_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_obs_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_obs_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("79", "uninstall_plugins", "a:4:{s:27:\"leaflet-map/leaflet-map.php\";a:2:{i:0;s:11:\"Leaflet_Map\";i:1;s:9:\"uninstall\";}s:40:\"wp-smart-preloader/inc/wsp_uninstall.php\";a:2:{i:0;s:18:\"WP_smart_preloader\";i:1;s:13:\"wsp_uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:28:\"migrate-guru/migrateguru.php\";a:2:{i:0;s:10:\"MGWPAction\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_obs_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_obs_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("82", "page_on_front", "40", "yes");
INSERT INTO `wp_obs_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("86", "site_icon", "1001094", "on");
INSERT INTO `wp_obs_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_obs_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("89", "wp_page_for_privacy_policy", "1001000", "yes");
INSERT INTO `wp_obs_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("91", "admin_email_lifespan", "1755975255", "yes");
INSERT INTO `wp_obs_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_obs_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_obs_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_obs_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_obs_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_obs_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("99", "wp_obs_attachment_pages_enabled", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("100", "initial_db_version", "56657", "yes");
INSERT INTO `wp_obs_options` VALUES("101", "wp_obs_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:64:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:20:\"manage_admin_columns\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;s:10:\"copy_posts\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:10:\"copy_posts\";b:1;}}}", "on");
INSERT INTO `wp_obs_options` VALUES("102", "fresh_site", "0", "off");
INSERT INTO `wp_obs_options` VALUES("103", "user_count", "3", "off");
INSERT INTO `wp_obs_options` VALUES("104", "widget_block", "a:5:{i:4;a:1:{s:7:\"content\";s:71:\"<!-- wp:group -->\n<div class=\"wp-block-group\"></div>\n<!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:8;a:1:{s:7:\"content\";s:332:\"<!-- wp:image {\"id\":1000974,\"width\":\"184px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"http://localhost:10004/wp-content/uploads/2025/02/Fichier-3-1.svg\" alt=\"\" class=\"wp-image-1000974\" style=\"width:184px;height:auto\"/></figure>\n<!-- /wp:image -->\";}}", "on");
INSERT INTO `wp_obs_options` VALUES("105", "sidebars_widgets", "a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"blog-sidebar\";a:1:{i:0;s:7:\"block-4\";}s:12:\"shop-sidebar\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:18:\"footer-one-widgets\";a:0:{}s:18:\"footer-two-widgets\";a:1:{i:0;s:7:\"block-8\";}s:20:\"footer-three-widgets\";a:0:{}s:19:\"footer-four-widgets\";a:1:{i:0;s:10:\"nav_menu-3\";}s:13:\"array_version\";i:3;}", "on");
INSERT INTO `wp_obs_options` VALUES("106", "cron", "a:14:{i:1742658297;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1742659200;a:1:{s:30:\"visualizer_schedule_refresh_db\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1742672391;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742676296;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742676423;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742719496;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742719650;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742719651;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742739364;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742805899;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1742824800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1742892296;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743167011;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_obs_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("119", "widget_nav_menu", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:8:\"nav_menu\";i:4;}}", "on");
INSERT INTO `wp_obs_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("121", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("122", "theme_mods_twentytwentyfour", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "no");
INSERT INTO `wp_obs_options` VALUES("126", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_obs_options` VALUES("136", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1707122889;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_obs_options` VALUES("163", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("166", "current_theme", "Neve", "yes");
INSERT INTO `wp_obs_options` VALUES("167", "theme_mods_neve", "a:157:{i:0;b:0;s:30:\"neve_auto_migrated_to_new_skin\";b:1;s:19:\"neve_ran_migrations\";b:1;s:22:\"neve_migrated_builders\";b:1;s:13:\"neve_new_skin\";s:3:\"new\";s:24:\"neve_migrated_hfg_colors\";b:1;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:7:\"top-bar\";i:4;s:6:\"footer\";i:8;}s:13:\"ti_prev_theme\";s:15:\"twentyseventeen\";s:18:\"custom_css_post_id\";i:120;s:17:\"logo_show_tagline\";i:0;s:26:\"nav-icon_button_appearance\";a:13:{s:12:\"borderRadius\";a:4:{s:3:\"top\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:11:\"borderWidth\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:15:\"rgba(0,0,0,0.5)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:7:\"outline\";s:10:\"background\";s:0:\"\";s:15:\"backgroundHover\";s:0:\"\";s:4:\"text\";s:0:\"\";s:9:\"textHover\";s:0:\"\";}s:32:\"hfg_header_layout_top_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:0:\"\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:33:\"hfg_header_layout_main_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:0:\"\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:35:\"hfg_header_layout_bottom_background\";a:8:{s:4:\"type\";s:5:\"image\";s:8:\"imageUrl\";s:60:\"http://localhost:10004/wp-content/uploads/2025/02/entete.jpg\";s:10:\"focusPoint\";a:2:{s:1:\"x\";s:4:\"0.31\";s:1:\"y\";s:4:\"0.53\";}s:10:\"colorValue\";s:7:\"#ffffff\";s:17:\"overlayColorValue\";s:16:\"rgba(0,0,0,0.63)\";s:14:\"overlayOpacity\";i:48;s:5:\"fixed\";b:1;s:11:\"useFeatured\";b:0;}s:36:\"hfg_header_layout_sidebar_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:17:\"var(--nv-site-bg)\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:32:\"hfg_footer_layout_top_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:7:\"#9b844e\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:35:\"hfg_footer_layout_bottom_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:7:\"#ffffff\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:24:\"neve_blog_archive_layout\";s:7:\"default\";s:24:\"neve_post_excerpt_length\";d:40;s:28:\"neve_advanced_layout_options\";b:1;s:32:\"neve_blog_archive_sidebar_layout\";s:10:\"full-width\";s:31:\"neve_blog_archive_content_width\";i:100;s:21:\"neve_body_font_family\";s:9:\"Noto Sans\";s:25:\"neve_headings_font_family\";s:0:\"\";s:22:\"neve_button_appearance\";a:13:{s:12:\"borderRadius\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:11:\"borderWidth\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:15:\"rgba(0,0,0,0.5)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:7:\"outline\";s:10:\"background\";s:17:\"var(--nv-site-bg)\";s:15:\"backgroundHover\";s:26:\"var(--nv-secondary-accent)\";s:4:\"text\";s:7:\"#bda364\";s:9:\"textHover\";s:7:\"#ffffff\";}s:24:\"neve_h1_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.4\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"36\";s:6:\"tablet\";s:2:\"24\";s:7:\"desktop\";s:3:\"024\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:1;}s:20:\"neve_container_width\";s:42:\"{\"mobile\":748,\"tablet\":992,\"desktop\":1170}\";s:28:\"neve_default_container_style\";s:9:\"contained\";s:24:\"neve_h2_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";d:1.3;s:6:\"tablet\";d:1.2;s:7:\"desktop\";s:3:\"1.4\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"18\";s:6:\"tablet\";s:2:\"20\";s:7:\"desktop\";s:2:\"20\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:1;}s:24:\"neve_h3_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"400\";s:13:\"textTransform\";s:10:\"capitalize\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.2\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:3:\"016\";s:6:\"tablet\";s:2:\"18\";s:7:\"desktop\";s:2:\"24\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:1;}s:31:\"neve_single_post_sidebar_layout\";s:10:\"full-width\";s:31:\"neve_other_pages_sidebar_layout\";s:10:\"full-width\";s:30:\"neve_single_post_content_width\";i:75;s:30:\"neve_other_pages_content_width\";i:100;s:21:\"neve_typeface_general\";a:6:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:6:\"mobile\";i:15;s:6:\"tablet\";i:16;s:7:\"desktop\";i:16;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.5\";s:6:\"tablet\";s:3:\"1.7\";s:7:\"desktop\";s:5:\"1.875\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";s:1:\"0\";}s:10:\"fontWeight\";s:3:\"300\";s:13:\"textTransform\";s:4:\"none\";s:4:\"flag\";b:1;}s:18:\"primary-menu_color\";s:20:\"var(--nv-text-color)\";s:25:\"primary-menu_active_color\";s:7:\"#cf9862\";s:24:\"primary-menu_hover_color\";s:7:\"#cf9862\";s:31:\"primary-menu_component_typeface\";a:5:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";i:1;s:6:\"tablet\";i:1;s:7:\"desktop\";s:5:\"0.875\";}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";d:1.6000000000000001;s:6:\"tablet\";d:1.6000000000000001;s:7:\"desktop\";d:1.6000000000000001;s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"fontWeight\";s:3:\"400\";s:13:\"textTransform\";s:4:\"none\";}s:16:\"neve_grid_layout\";s:35:\"{\"desktop\":2,\"tablet\":2,\"mobile\":1}\";s:32:\"neve_secondary_button_appearance\";a:13:{s:12:\"borderRadius\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:11:\"borderWidth\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:15:\"rgba(0,0,0,0.5)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:4:\"fill\";s:10:\"background\";s:24:\"var(--nv-primary-accent)\";s:15:\"backgroundHover\";s:24:\"var(--nv-primary-accent)\";s:4:\"text\";s:24:\"var(--nv-primary-accent)\";s:9:\"textHover\";s:22:\"var(--nv-text-dark-bg)\";}s:11:\"custom_logo\";i:168;s:14:\"logo_max_width\";s:41:\"{\"mobile\":132,\"tablet\":190,\"desktop\":189}\";s:19:\"neve_button_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"24\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"24\";}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"24\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:33:\"neve_blog_list_alternative_layout\";b:1;s:24:\"neve_h4_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"700\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"16\";s:6:\"tablet\";s:2:\"16\";s:7:\"desktop\";s:2:\"20\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:24:\"neve_h5_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"14\";s:6:\"tablet\";s:2:\"14\";s:7:\"desktop\";s:2:\"16\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:24:\"neve_h6_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"14\";s:6:\"tablet\";s:2:\"14\";s:7:\"desktop\";s:2:\"16\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:18:\"neve_global_colors\";a:2:{s:13:\"activePalette\";s:4:\"base\";s:8:\"palettes\";a:4:{s:4:\"base\";a:3:{s:4:\"name\";s:4:\"Base\";s:13:\"allowDeletion\";b:0;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#fcaf3b\";s:19:\"nv-secondary-accent\";s:7:\"#ab641d\";s:10:\"nv-site-bg\";s:7:\"#ffffff\";s:11:\"nv-light-bg\";s:7:\"#ededed\";s:10:\"nv-dark-bg\";s:7:\"#14171c\";s:13:\"nv-text-color\";s:7:\"#2b2b2b\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}s:8:\"darkMode\";a:3:{s:4:\"name\";s:9:\"Dark Mode\";s:13:\"allowDeletion\";b:0;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#fcaf3b\";s:19:\"nv-secondary-accent\";s:7:\"#ab641d\";s:10:\"nv-site-bg\";s:7:\"#121212\";s:11:\"nv-light-bg\";s:7:\"#2b2b2b\";s:10:\"nv-dark-bg\";s:7:\"#1a1a1a\";s:13:\"nv-text-color\";s:7:\"#ffffff\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}s:5:\"green\";a:3:{s:4:\"name\";s:5:\"Green\";s:13:\"allowDeletion\";b:1;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#55f5a3\";s:19:\"nv-secondary-accent\";s:7:\"#2b2b2b\";s:10:\"nv-site-bg\";s:7:\"#ffffff\";s:11:\"nv-light-bg\";s:7:\"#f5f3eb\";s:10:\"nv-dark-bg\";s:7:\"#000000\";s:13:\"nv-text-color\";s:7:\"#000000\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}s:4:\"blue\";a:3:{s:4:\"name\";s:4:\"Blue\";s:13:\"allowDeletion\";b:1;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#3d6fe5\";s:19:\"nv-secondary-accent\";s:7:\"#01216b\";s:10:\"nv-site-bg\";s:7:\"#ffffff\";s:11:\"nv-light-bg\";s:7:\"#f0eff4\";s:10:\"nv-dark-bg\";s:7:\"#0d1317\";s:13:\"nv-text-color\";s:7:\"#121212\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}}}s:39:\"hfg_footer_layout_bottom_new_text_color\";s:22:\"var(--nv-text-dark-bg)\";s:12:\"logo_display\";s:7:\"default\";s:20:\"neve_button_typeface\";a:5:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:6:\"mobile\";s:2:\"14\";s:6:\"tablet\";s:2:\"14\";s:7:\"desktop\";s:2:\"14\";}s:4:\"flag\";b:0;s:10:\"lineHeight\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";d:1.6000000000000001;s:6:\"tablet\";d:1.6000000000000001;s:7:\"desktop\";d:1.6000000000000001;}s:10:\"fontWeight\";s:3:\"400\";s:13:\"textTransform\";s:4:\"none\";}s:25:\"neve_fallback_font_family\";s:28:\"Arial, Helvetica, sans-serif\";s:24:\"neve_form_fields_padding\";a:5:{s:3:\"top\";s:2:\"10\";s:6:\"bottom\";i:10;s:4:\"left\";i:12;s:5:\"right\";i:12;s:4:\"unit\";s:2:\"px\";}s:21:\"neve_form_button_type\";s:7:\"primary\";s:30:\"neve_form_fields_border_radius\";a:5:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"unit\";s:2:\"px\";}s:34:\"neve_archive_typography_post_title\";a:3:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:6:\"mobile\";s:2:\"28\";s:6:\"tablet\";s:2:\"32\";s:7:\"desktop\";s:2:\"32\";}s:4:\"flag\";b:0;s:10:\"lineHeight\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:0:\"\";}}s:38:\"neve_single_post_typography_post_title\";a:3:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:6:\"mobile\";s:2:\"28\";s:6:\"tablet\";s:2:\"40\";s:7:\"desktop\";s:2:\"40\";}s:4:\"flag\";b:1;s:10:\"lineHeight\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:0:\"\";}}s:20:\"hfg_footer_layout_v2\";s:631:\"{\"desktop\":{\"top\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[{\"id\":\"footer-two-widgets\"}],\"c-left\":[{\"id\":\"footer-four-widgets\"},{\"id\":\"footer-menu\"}],\"center\":[],\"c-right\":[],\"right\":[]},\"bottom\":{\"left\":[],\"c-left\":[{\"id\":\"footer_copyright\"}],\"center\":[],\"c-right\":[],\"right\":[]}},\"mobile\":{\"top\":{\"left\":[],\"c-left\":[{\"id\":\"footer-two-widgets\"},{\"id\":\"footer-four-widgets\"},{\"id\":\"footer-menu\"}],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"bottom\":{\"left\":[{\"id\":\"footer_copyright\"}],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]}}}\";s:33:\"neve_form_fields_background_color\";s:17:\"var(--nv-site-bg)\";s:38:\"neve_layout_single_post_elements_order\";s:29:\"[\"content\",\"tags\",\"comments\"]\";s:23:\"neve_post_header_layout\";s:5:\"cover\";s:22:\"neve_post_cover_height\";s:93:\"{\"mobile\":250,\"tablet\":30,\"desktop\":40,\"suffix\":{\"tablet\":\"vh\",\"desktop\":\"vh\",\"mobile\":\"px\"}}\";s:25:\"neve_post_title_alignment\";a:3:{s:6:\"mobile\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:7:\"desktop\";s:4:\"left\";}s:24:\"neve_post_title_position\";a:3:{s:6:\"mobile\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:7:\"desktop\";s:8:\"flex-end\";}s:26:\"neve_post_cover_text_color\";s:22:\"var(--nv-text-dark-bg)\";s:34:\"neve_post_cover_title_boxed_layout\";b:0;s:44:\"neve_post_cover_title_boxed_background_color\";s:17:\"var(--nv-dark-bg)\";s:26:\"neve_post_content_ordering\";s:36:\"[\"thumbnail\",\"title-meta\",\"excerpt\"]\";s:19:\"neve_enable_masonry\";b:0;s:30:\"neve_post_thumbnail_box_shadow\";i:2;s:18:\"primary-menu_style\";s:11:\"style-plain\";s:32:\"neve_post_cover_background_color\";s:17:\"var(--nv-dark-bg)\";s:23:\"neve_post_cover_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:15;s:6:\"bottom\";i:40;s:4:\"left\";i:15;}s:6:\"tablet\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:30;s:6:\"bottom\";i:60;s:4:\"left\";i:30;}s:7:\"desktop\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:40;s:6:\"bottom\";s:2:\"60\";s:4:\"left\";i:40;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:31:\"neve_post_cover_overlay_opacity\";d:50;s:25:\"neve_post_cover_container\";s:9:\"contained\";s:35:\"neve_post_cover_title_boxed_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:15;s:6:\"bottom\";i:40;s:4:\"left\";i:15;}s:6:\"tablet\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:30;s:6:\"bottom\";i:60;s:4:\"left\";i:30;}s:7:\"desktop\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:40;s:6:\"bottom\";s:2:\"60\";s:4:\"left\";i:40;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:29:\"neve_form_fields_border_width\";a:5:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:4:\"left\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}s:29:\"neve_form_fields_border_color\";s:18:\"var(--nv-light-bg)\";s:21:\"neve_input_text_color\";s:20:\"var(--nv-text-color)\";s:20:\"logo_title_font_size\";s:38:\"{\"mobile\":24,\"tablet\":24,\"desktop\":50}\";s:20:\"hfg_header_layout_v2\";s:668:\"{\"desktop\":{\"top\":{\"left\":[{\"id\":\"logo\"}],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[{\"id\":\"secondary-menu\"}]},\"main\":{\"left\":[{\"id\":\"primary-menu\"}],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[{\"id\":\"header_search_responsive\"},{\"id\":\"button_base\"}]},\"bottom\":{\"left\":[],\"c-left\":[],\"center\":[{\"id\":\"custom_html\"},{\"id\":\"header_search\"}],\"c-right\":[],\"right\":[]}},\"mobile\":{\"top\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[{\"id\":\"logo\"}],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[{\"id\":\"nav-icon\"}]},\"bottom\":{\"left\":[],\"c-left\":[],\"center\":[{\"id\":\"header_search\"}],\"c-right\":[],\"right\":[]},\"sidebar\":[{\"id\":\"primary-menu\"}]}}\";s:28:\"hfg_header_layout_top_height\";s:90:\"{\"mobile\":0,\"tablet\":0,\"desktop\":0,\"suffix\":{\"mobile\":\"px\",\"tablet\":\"px\",\"desktop\":\"rem\"}}\";s:34:\"header_search_responsive_icon_size\";i:15;s:37:\"header_search_responsive_field_height\";s:39:\"{\"mobile\":144,\"tablet\":40,\"desktop\":38}\";s:26:\"header_search_field_height\";s:38:\"{\"mobile\":40,\"tablet\":40,\"desktop\":36}\";s:29:\"header_search_field_text_size\";s:38:\"{\"mobile\":14,\"tablet\":14,\"desktop\":14}\";s:29:\"hfg_header_layout_main_height\";s:35:\"{\"mobile\":0,\"tablet\":0,\"desktop\":0}\";s:31:\"hfg_header_layout_bottom_height\";s:37:\"{\"mobile\":0,\"tablet\":0,\"desktop\":430}\";s:25:\"header_search_placeholder\";s:37:\"Trouver mon établissement privé ...\";s:23:\"header_search_icon_type\";s:17:\"hfgs-icon-style-2\";s:32:\"header_search_field_border_width\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:30:\"header_search_field_text_color\";s:7:\"#ffffff\";s:38:\"hfg_header_layout_bottom_bottom_border\";s:35:\"{\"mobile\":0,\"tablet\":0,\"desktop\":0}\";s:10:\"logo_color\";s:7:\"#c36767\";s:9:\"logo_logo\";s:44:\"{\"light\":1001097,\"dark\":1001097,\"same\":true}\";s:15:\"logo_show_title\";i:0;s:34:\"primary-menu_component_font_family\";s:9:\"Noto Sans\";s:28:\"hfg_header_layout_top_layout\";s:16:\"layout-contained\";s:22:\"secondary-menu_spacing\";s:37:\"{\"mobile\":20,\"tablet\":20,\"desktop\":5}\";s:29:\"primary-menu_expand_dropdowns\";i:1;s:26:\"secondary-menu_hover_color\";s:7:\"#403a3a\";s:26:\"secondary-menu_item_height\";s:38:\"{\"mobile\":25,\"tablet\":25,\"desktop\":26}\";s:20:\"primary-menu_spacing\";s:38:\"{\"mobile\":20,\"tablet\":20,\"desktop\":32}\";s:24:\"primary-menu_item_height\";s:37:\"{\"mobile\":25,\"tablet\":25,\"desktop\":1}\";s:36:\"hfg_header_layout_main_bottom_border\";s:89:\"{\"mobile\":0,\"tablet\":0,\"desktop\":0,\"suffix\":{\"mobile\":\"px\",\"tablet\":\"px\",\"desktop\":\"px\"}}\";s:35:\"hfg_header_layout_main_border_color\";s:7:\"#000000\";s:29:\"primary-menu_component_margin\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"10\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"10\";s:4:\"left\";s:1:\"0\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:35:\"hfg_header_layout_top_bottom_border\";s:35:\"{\"mobile\":0,\"tablet\":0,\"desktop\":1}\";s:34:\"hfg_header_layout_top_border_color\";s:7:\"#020202\";s:21:\"nav-icon_label_margin\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";s:1:\"0\";s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:5;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:5;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:18:\"nav-icon_menu_icon\";s:5:\"arrow\";s:26:\"nav-icon_component_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"00\";s:5:\"right\";s:2:\"00\";s:6:\"bottom\";s:2:\"00\";s:4:\"left\";s:2:\"00\";}s:6:\"tablet\";a:4:{s:3:\"top\";i:10;s:5:\"right\";i:15;s:6:\"bottom\";i:10;s:4:\"left\";i:15;}s:7:\"desktop\";a:4:{s:3:\"top\";i:10;s:5:\"right\";i:15;s:6:\"bottom\";i:10;s:4:\"left\";i:15;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:34:\"header_search_responsive_icon_type\";s:17:\"hfgs-icon-style-2\";s:31:\"hfg_header_layout_bottom_layout\";s:16:\"layout-fullwidth\";s:33:\"header_search_field_border_radius\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"32\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:2:\"32\";s:4:\"left\";s:2:\"32\";}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"25\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:2:\"25\";s:4:\"left\";s:2:\"25\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:30:\"header_search_field_background\";s:13:\"rgba(0,0,0,0)\";s:31:\"header_search_component_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"150\";s:5:\"right\";i:0;s:6:\"bottom\";s:2:\"20\";s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:4:\"0200\";s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:31:\"header_search_button_appearance\";s:11:\"icon_button\";s:30:\"header_search_component_margin\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:40:\"header_search_responsive_field_text_size\";s:38:\"{\"mobile\":77,\"tablet\":14,\"desktop\":14}\";s:41:\"header_search_responsive_field_background\";s:19:\"rgba(255,255,255,0)\";s:41:\"header_search_responsive_field_text_color\";s:7:\"#000000\";s:30:\"neve_body_font_family_variants\";a:1:{i:0;s:3:\"600\";}s:28:\"neve_headings_h1_font_family\";s:9:\"Noto Sans\";s:28:\"neve_headings_h4_font_family\";s:4:\"Lato\";s:37:\"hfg_footer_layout_main_columns_number\";i:2;s:37:\"hfg_footer_layout_main_columns_layout\";s:5:\"equal\";s:37:\"hfg_footer_layout_main_vertical_align\";s:6:\"center\";s:35:\"footer-four-widgets_component_align\";a:3:{s:7:\"desktop\";s:5:\"right\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:6:\"center\";}s:23:\"footer-menu_item_height\";s:38:\"{\"mobile\":25,\"tablet\":25,\"desktop\":15}\";s:27:\"footer-menu_component_align\";a:3:{s:7:\"desktop\";s:5:\"right\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:6:\"center\";}s:30:\"footer-menu_component_typeface\";a:5:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";i:1;s:6:\"tablet\";i:1;s:7:\"desktop\";s:1:\"1\";}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";d:1.6000000000000001;s:6:\"tablet\";d:1.6000000000000001;s:7:\"desktop\";d:1.6000000000000001;s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:4:\"none\";}s:33:\"hfg_footer_layout_main_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:7:\"#9b844e\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:17:\"footer-menu_color\";s:17:\"var(--nv-site-bg)\";s:23:\"footer-menu_hover_color\";s:18:\"var(--nv-light-bg)\";s:19:\"custom_html_content\";s:101:\"<p>Observatoire <span class=\"mini\">de <br /><span>l\'</span> </span>enseignement supérieur privé</p>\";s:36:\"hfg_footer_layout_top_vertical_align\";s:6:\"center\";s:36:\"hfg_footer_layout_top_columns_number\";i:3;s:34:\"footer-two-widgets_component_align\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:6:\"center\";}s:34:\"header_search_responsive_open_type\";s:7:\"minimal\";s:43:\"header_search_responsive_field_border_width\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:30:\"header_search_responsive_color\";s:7:\"#000000\";s:36:\"header_search_responsive_hover_color\";s:7:\"#737373\";s:44:\"header_search_responsive_field_border_radius\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"31\";s:5:\"right\";s:2:\"31\";s:6:\"bottom\";s:2:\"31\";s:4:\"left\";s:2:\"31\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:42:\"header_search_responsive_component_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:10;s:6:\"bottom\";i:0;s:4:\"left\";i:10;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:10;s:6:\"bottom\";i:0;s:4:\"left\";i:10;}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"00\";s:5:\"right\";s:2:\"10\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"10\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:36:\"header_search_responsive_placeholder\";s:31:\"Rechercher un établissement...\";s:20:\"neve_pagination_type\";s:8:\"infinite\";s:26:\"neve_blog_post_meta_fields\";s:382:\"[{\"slug\":\"author\",\"title\":\"Auteur\\/autrice\",\"visibility\":\"yes\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"},{\"slug\":\"date\",\"title\":\"Date\",\"visibility\":\"yes\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"},{\"slug\":\"comments\",\"title\":\"Commentaires\",\"visibility\":\"no\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"},{\"slug\":\"category\",\"title\":\"Cat\\u00e9gorie\",\"visibility\":\"no\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"}]\";s:23:\"neve_page_header_layout\";s:6:\"normal\";s:20:\"neve_page_hide_title\";b:0;s:23:\"neve_metadata_separator\";s:0:\"\";s:33:\"neve_archive_typography_post_meta\";a:3:{s:13:\"textTransform\";s:4:\"none\";s:4:\"flag\";b:0;s:10:\"lineHeight\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:0:\"\";}}s:20:\"secondary-menu_style\";s:11:\"style-plain\";s:24:\"button_base_text_setting\";s:14:\"Nous soutenir \";s:24:\"button_base_link_setting\";s:68:\"https://fr.ulule.com/observatoire-de-l-enseignement-superieur-prive/\";s:19:\"button_base_new_tab\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("168", "theme_switched", "", "yes");
INSERT INTO `wp_obs_options` VALUES("169", "neve_install", "1707122890", "yes");
INSERT INTO `wp_obs_options` VALUES("176", "neve_user_check_time", "1707122890", "yes");
INSERT INTO `wp_obs_options` VALUES("177", "neve_new_user", "yes", "yes");
INSERT INTO `wp_obs_options` VALUES("183", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_obs_options` VALUES("184", "site_logo", "168", "yes");
INSERT INTO `wp_obs_options` VALUES("193", "wp_obs_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_obs_options` VALUES("195", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("207", "pods_framework_upgraded_1_x", "2", "yes");
INSERT INTO `wp_obs_options` VALUES("208", "pods_framework_version_first", "3.0.10", "yes");
INSERT INTO `wp_obs_options` VALUES("213", "pods_component_settings", "{\"components\":{\"templates\":[],\"migrate-packages\":[]}}", "yes");
INSERT INTO `wp_obs_options` VALUES("238", "widget_pods_widget_single", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("239", "widget_pods_widget_list", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("240", "widget_pods_widget_field", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("241", "widget_pods_widget_form", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("242", "widget_pods_widget_view", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_obs_options` VALUES("250", "wisdom_notification_times", "a:1:{s:4:\"pods\";i:1707123279;}", "yes");
INSERT INTO `wp_obs_options` VALUES("274", "leaflet_osm_Ha+Ling%2C+canmore", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"51.0657947\";s:3:\"lng\";s:12:\"-115.4020319\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("275", "leaflet_geocoded_locations", "a:10:{i:0;s:30:\"leaflet_osm_Ha+Ling%2C+canmore\";i:1;s:40:\"leaflet_osm_twilight+lane%2C+nova+scotia\";i:2;s:17:\"leaflet_osm_Miami\";i:3;s:20:\"leaflet_osm_San+Juan\";i:4;s:19:\"leaflet_osm_Bermuda\";i:5;s:20:\"leaflet_osm_Sayulita\";i:6;s:27:\"leaflet_osm_Puerto+Vallarta\";i:7;s:34:\"leaflet_osm_Halifax%2C+Nova+Scotia\";i:8;s:20:\"leaflet_osm_Tanzania\";i:9;s:21:\"leaflet_osm_las+vegas\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("276", "leaflet_osm_twilight+lane%2C+nova+scotia", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"44.8970644\";s:3:\"lng\";s:11:\"-63.6247722\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("277", "leaflet_osm_Miami", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"25.7741728\";s:3:\"lng\";s:9:\"-80.19362\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("278", "leaflet_osm_San+Juan", "O:8:\"stdClass\":2:{s:3:\"lat\";s:9:\"18.465299\";s:3:\"lng\";s:10:\"-66.116666\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("279", "leaflet_osm_Bermuda", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"32.2937417\";s:3:\"lng\";s:11:\"-64.7815286\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("280", "leaflet_osm_Sayulita", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"20.8689257\";s:3:\"lng\";s:12:\"-105.4407022\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("281", "leaflet_osm_Puerto+Vallarta", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"20.6407176\";s:3:\"lng\";s:11:\"-105.220306\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("282", "leaflet_osm_Halifax%2C+Nova+Scotia", "O:8:\"stdClass\":2:{s:3:\"lat\";s:9:\"44.648618\";s:3:\"lng\";s:11:\"-63.5859487\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("283", "leaflet_osm_Tanzania", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"-6.5247123\";s:3:\"lng\";s:10:\"35.7878438\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("284", "leaflet_osm_las+vegas", "O:8:\"stdClass\":2:{s:3:\"lat\";s:10:\"36.1672559\";s:3:\"lng\";s:11:\"-115.148516\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("304", "visualizer_fresh_install", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("305", "visualizer-new-user", "yes", "yes");
INSERT INTO `wp_obs_options` VALUES("306", "visualizer_install", "1707125533", "yes");
INSERT INTO `wp_obs_options` VALUES("311", "visualizer-upgraded", "3.10.6", "yes");
INSERT INTO `wp_obs_options` VALUES("312", "visualizer-upgraded-from", "0.0.0", "yes");
INSERT INTO `wp_obs_options` VALUES("319", "optml-version", "3.12.4", "yes");
INSERT INTO `wp_obs_options` VALUES("322", "optml_settings", "a:50:{s:7:\"api_key\";s:0:\"\";s:12:\"service_data\";s:0:\"\";s:12:\"cache_buster\";s:0:\"\";s:19:\"cache_buster_assets\";s:0:\"\";s:19:\"cache_buster_images\";s:0:\"\";s:3:\"cdn\";s:8:\"disabled\";s:14:\"admin_bar_item\";s:7:\"enabled\";s:8:\"lazyload\";s:7:\"enabled\";s:5:\"scale\";s:8:\"disabled\";s:20:\"network_optimization\";s:8:\"disabled\";s:20:\"lazyload_placeholder\";s:7:\"enabled\";s:11:\"bg_replacer\";s:7:\"enabled\";s:14:\"video_lazyload\";s:7:\"enabled\";s:13:\"retina_images\";s:8:\"disabled\";s:16:\"limit_dimensions\";s:7:\"enabled\";s:12:\"limit_height\";i:1080;s:11:\"limit_width\";i:1920;s:12:\"resize_smart\";s:8:\"disabled\";s:9:\"no_script\";s:8:\"disabled\";s:7:\"filters\";a:0:{}s:11:\"cloud_sites\";a:2:{s:3:\"all\";s:5:\"false\";s:27:\"observatoire.franceserv.com\";s:4:\"true\";}s:8:\"watchers\";s:0:\"\";s:7:\"quality\";s:4:\"auto\";s:5:\"wm_id\";i:-1;s:10:\"wm_opacity\";i:1;s:11:\"wm_position\";s:4:\"soea\";s:4:\"wm_x\";i:0;s:4:\"wm_y\";i:0;s:8:\"wm_scale\";i:0;s:14:\"image_replacer\";s:7:\"enabled\";s:12:\"img_to_video\";s:8:\"disabled\";s:10:\"css_minify\";s:7:\"enabled\";s:9:\"js_minify\";s:8:\"disabled\";s:13:\"report_script\";s:8:\"disabled\";s:4:\"avif\";s:8:\"disabled\";s:11:\"autoquality\";s:7:\"enabled\";s:15:\"native_lazyload\";s:8:\"disabled\";s:13:\"offload_media\";s:8:\"disabled\";s:12:\"cloud_images\";s:7:\"enabled\";s:14:\"strip_metadata\";s:7:\"enabled\";s:20:\"skip_lazyload_images\";s:1:\"2\";s:19:\"defined_image_sizes\";a:0:{}s:15:\"banner_frontend\";s:8:\"disabled\";s:17:\"offloading_status\";s:8:\"disabled\";s:15:\"rollback_status\";s:8:\"disabled\";s:11:\"best_format\";s:8:\"disabled\";s:21:\"offload_limit_reached\";s:8:\"disabled\";s:13:\"offload_limit\";i:50000;s:17:\"placeholder_color\";s:0:\"\";s:26:\"show_offload_finish_notice\";s:0:\"\";}", "no");
INSERT INTO `wp_obs_options` VALUES("323", "optml_defaults_updated", "yes", "yes");
INSERT INTO `wp_obs_options` VALUES("324", "optimole_wp_install", "1707125571", "yes");
INSERT INTO `wp_obs_options` VALUES("356", "optml_notice_optin", "yes", "yes");
INSERT INTO `wp_obs_options` VALUES("491", "wisdom_allow_tracking", "a:1:{s:4:\"pods\";s:4:\"pods\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("492", "wisdom_block_notice", "a:1:{s:4:\"pods\";s:4:\"pods\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("493", "wisdom_collect_email", "a:1:{s:4:\"pods\";s:4:\"pods\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("494", "wisdom_admin_emails", "a:1:{s:4:\"pods\";s:22:\"castaromain@zaclys.net\";}", "yes");
INSERT INTO `wp_obs_options` VALUES("495", "wisdom_last_track_time", "a:1:{s:4:\"pods\";i:1707126759;}", "yes");
INSERT INTO `wp_obs_options` VALUES("687", "leaflet_default_lat", "50.6128", "yes");
INSERT INTO `wp_obs_options` VALUES("688", "leaflet_default_lng", "3.0494", "yes");
INSERT INTO `wp_obs_options` VALUES("689", "leaflet_default_zoom", "15", "yes");
INSERT INTO `wp_obs_options` VALUES("690", "leaflet_default_height", "800", "yes");
INSERT INTO `wp_obs_options` VALUES("691", "leaflet_default_width", "100%", "yes");
INSERT INTO `wp_obs_options` VALUES("692", "leaflet_fit_markers", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("693", "leaflet_show_zoom_controls", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("694", "leaflet_scroll_wheel_zoom", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("695", "leaflet_double_click_zoom", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("696", "leaflet_default_min_zoom", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("697", "leaflet_default_max_zoom", "19", "yes");
INSERT INTO `wp_obs_options` VALUES("698", "leaflet_default_tiling_service", "other", "yes");
INSERT INTO `wp_obs_options` VALUES("699", "leaflet_mapquest_appkey", "Indiquez une clé de l’API si vous choisissez MapQuest", "yes");
INSERT INTO `wp_obs_options` VALUES("700", "leaflet_map_tile_url", "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", "yes");
INSERT INTO `wp_obs_options` VALUES("701", "leaflet_map_tile_url_subdomains", "abc", "yes");
INSERT INTO `wp_obs_options` VALUES("702", "leaflet_detect_retina", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("703", "leaflet_tilesize", "", "yes");
INSERT INTO `wp_obs_options` VALUES("704", "leaflet_mapid", "", "yes");
INSERT INTO `wp_obs_options` VALUES("705", "leaflet_accesstoken", "", "yes");
INSERT INTO `wp_obs_options` VALUES("706", "leaflet_zoomoffset", "", "yes");
INSERT INTO `wp_obs_options` VALUES("707", "leaflet_tile_no_wrap", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("708", "leaflet_js_url", "https://unpkg.com/leaflet@1.9.4/dist/leaflet.js", "yes");
INSERT INTO `wp_obs_options` VALUES("709", "leaflet_css_url", "https://unpkg.com/leaflet@1.9.4/dist/leaflet.css", "yes");
INSERT INTO `wp_obs_options` VALUES("710", "leaflet_default_attribution", "<a href=\"http://leafletjs.com\" title=\"Une bibliothèque JS pour des cartes interactives\">Leaflet</a>; © <a href=\"http://www.openstreetmap.org/copyright\">OpenStreetMap</a> contributeurs", "yes");
INSERT INTO `wp_obs_options` VALUES("711", "leaflet_show_scale", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("712", "leaflet_geocoder", "osm", "yes");
INSERT INTO `wp_obs_options` VALUES("713", "leaflet_google_appkey", "Indiquez votre clé Google API", "yes");
INSERT INTO `wp_obs_options` VALUES("714", "leaflet_togeojson_url", "https://unpkg.com/@mapbox/togeojson@0.16.0/togeojson.js", "yes");
INSERT INTO `wp_obs_options` VALUES("715", "leaflet_shortcode_in_excerpt", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("1345", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("1560", "neve_notice_dismissed", "yes", "yes");
INSERT INTO `wp_obs_options` VALUES("1561", "themeisle_sdk_notifications", "a:2:{s:17:\"last_notification\";a:2:{s:2:\"id\";s:22:\"visualizer_review_flag\";s:10:\"display_at\";i:1738060760;}s:24:\"last_notification_active\";i:1738078395;}", "yes");
INSERT INTO `wp_obs_options` VALUES("1830", "db_upgraded", "", "on");
INSERT INTO `wp_obs_options` VALUES("1837", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:15:\"contact@oesp.fr\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1741295683;}", "off");
INSERT INTO `wp_obs_options` VALUES("2241", "visualizer_logger_flag", "no", "auto");
INSERT INTO `wp_obs_options` VALUES("2247", "can_compress_scripts", "0", "on");
INSERT INTO `wp_obs_options` VALUES("2309", "pods_framework_version_last", "3.0.10", "on");
INSERT INTO `wp_obs_options` VALUES("2310", "pods_framework_version", "3.2.8", "on");
INSERT INTO `wp_obs_options` VALUES("2311", "pods_framework_db_version", "2.3.5", "on");
INSERT INTO `wp_obs_options` VALUES("2367", "pods_callouts", "a:2:{s:17:\"friends_2024_docs\";i:1;s:13:\"access_rights\";i:1;}", "auto");
INSERT INTO `wp_obs_options` VALUES("10957", "duplicator_version_plugin", "1.5.11.2", "auto");
INSERT INTO `wp_obs_options` VALUES("10959", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1732354199;s:10:\"updateTime\";i:1732354199;}", "off");
INSERT INTO `wp_obs_options` VALUES("10960", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_obs_options` VALUES("10961", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_obs_options` VALUES("10962", "duplicator_settings", "a:20:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:3;s:14:\"usage_tracking\";b:1;i:0;b:0;}", "auto");
INSERT INTO `wp_obs_options` VALUES("10964", "duplicator_notifications", "a:4:{s:6:\"update\";i:1742634230;s:4:\"feed\";a:1:{i:0;a:7:{s:5:\"title\";s:49:\"Introducing One-Click Backup Record Cleanups 🫧\";s:7:\"content\";s:202:\"New Duplicator features get rid of your backup clutter! Enjoy one-click cleanups, auto-deletion, and better security with updated PHP/WordPress requirements. Update today for a tidier backup experience!\";s:4:\"type\";s:4:\"lite\";s:2:\"id\";i:20;s:3:\"btn\";a:4:{s:8:\"main_url\";s:157:\"https://duplicator.com/announcement-duplicator-backup-cleanups/?utm_source=dup-notification&utm_medium=in-plugin-cta&utm_campaign=announcement-backup-cleanup\";s:9:\"main_text\";s:10:\"Learn More\";s:7:\"alt_url\";s:124:\"https://duplicator.com/pricing?utm_source=dup-notification&utm_medium=in-plugin-cta&utm_campaign=announcement-backup-cleanup\";s:8:\"alt_text\";s:11:\"Upgrade Now\";}s:5:\"start\";s:19:\"2025-03-20 00:00:00\";s:3:\"end\";s:19:\"2025-03-28 00:00:00\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_obs_options` VALUES("10966", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("10967", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-03-22 15:02:49\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20241123_observatoiredelenseignements\";s:4:\"Hash\";s:35:\"f3ff081d6ae093fc2844_20250322150249\";s:8:\"NameHash\";s:73:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:75:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1810;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11456;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-03-22 15:02:49\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20241123_observatoiredelenseignements\";s:4:\"Hash\";s:35:\"f3ff081d6ae093fc2844_20250322150249\";s:8:\"NameHash\";s:73:\"20241123_observatoiredelenseignements_f3ff081d6ae093fc2844_20250322150249\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:89:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:84:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-admin\";i:1;s:87:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-includes\";i:2;s:96:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:75:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public\";i:1;s:75:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public\";i:2;s:86:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content\";i:3;s:94:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/uploads\";i:4;s:94:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/plugins\";i:5;s:97:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/mu-plugins\";i:6;s:93:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:107:\"/home/romain/Local Sites/observatoire-enseignement-suprieur-priv/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wp_obs_options` VALUES("10968", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_obs_options` VALUES("14445", "neve_review_flag", "no", "auto");
INSERT INTO `wp_obs_options` VALUES("18237", "neve_logger_flag", "no", "auto");
INSERT INTO `wp_obs_options` VALUES("19480", "ai1wm_updater", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("19493", "swift_performance_plugin_organizer", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("19494", "jetpack_active_modules", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("19605", "visualizer_review_flag", "no", "auto");
INSERT INTO `wp_obs_options` VALUES("19678", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1738147211;}}", "on");
INSERT INTO `wp_obs_options` VALUES("19731", "recovery_mode_email_last_sent", "1738161735", "auto");
INSERT INTO `wp_obs_options` VALUES("19747", "bodhi_svgs_plugin_version", "2.5.8", "auto");
INSERT INTO `wp_obs_options` VALUES("19748", "bodhi_svgs_settings", "a:5:{s:8:\"restrict\";a:1:{i:0;s:13:\"administrator\";}s:24:\"sanitize_on_upload_roles\";a:2:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";}s:13:\"advanced_mode\";s:2:\"on\";s:22:\"sanitize_svg_front_end\";s:2:\"on\";s:10:\"css_target\";s:0:\"\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("23956", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.0.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1738849338;s:7:\"version\";s:5:\"6.0.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_obs_options` VALUES("24100", "font-awesome-releases", "a:2:{s:12:\"refreshed_at\";i:1738923625;s:4:\"data\";a:3:{s:16:\"latest_version_5\";s:6:\"5.15.4\";s:16:\"latest_version_6\";s:5:\"6.7.2\";s:8:\"releases\";a:62:{s:5:\"5.0.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-VVoO3UHXsmXwXvf1kJx2jV3b1LbOfTqKL46DdeLG8z4pImkQ4GAP9GMy+MxHMDYG\";s:14:\"css/brands.css\";s:71:\"sha384-JT52EiskN0hkvVxJA8d2wg8W/tLxrC02M4u5+YAezNnBlY/N2yy3X51pKC1QaPkw\";s:19:\"css/fontawesome.css\";s:71:\"sha384-7mC9VNNEUg5vt0kVQGblkna/29L8CpTJ5fkpo0nlmTbfCoDXyuK/gPO3wx8bglOz\";s:15:\"css/regular.css\";s:71:\"sha384-JZ2w5NHrKZS6hqVAVlhUO3eHPVzjDZqOpWBZZ6opcmMwVjN7uoagKSSftrq8F0pn\";s:13:\"css/solid.css\";s:71:\"sha384-TQW9cJIp+U8M7mByg5ZKUQoIxj0ac36aOpNzqQ04HpwyrJivS38EQsKHO2rR5eit\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-X1ZQAmDHBeo7eaAJwWMyyA3mva9mMK10CpRFvX8PejR0XIUjwvGDqr2TwJqwbH9S\";s:9:\"js/all.js\";s:71:\"sha384-2CD5KZ3lSO1FK9XJ2hsLsEPy5/TBISgKIk2NSEcS03GbEnWEfhzd0x6DBIkqgPN1\";s:12:\"js/brands.js\";s:71:\"sha384-i3UPn8g8uJGiS6R/++68nHyfYAnr/lE/biTuWYbya2dONccicnZZPlAH6P8EWf28\";s:17:\"js/fontawesome.js\";s:71:\"sha384-tqpP2rDLsdWkeBrG3Jachyp0yzl/pmhnsdV88ySUFZATuziAnHWsHRSS97l5D9jn\";s:13:\"js/regular.js\";s:71:\"sha384-hXqI+wajk6jJu2DXwf2oqBg6q5+HqXM5yz9smX94pDjiLzH81gAuVtjter66i1Ct\";s:11:\"js/solid.js\";s:71:\"sha384-kbPfTyGdGugnvSKEBJCd6+vYipOQ6a+2np5O4Ty3sW7tgI0MpwPyAh+QwUpMujV9\";s:14:\"js/v4-shims.js\";s:71:\"sha384-BRge2B8T+0rmvB/KszFfdQ0PDvPnhV2J80JMKrnq21Fq6tHeKFhSIrdoroXvk7eB\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-bJB2Wn8ZuuMwYA12t6nmPqVTqT64ruKTAWqdxs/Oal3vexA7RPAo3FtVU5hIil2E\";s:14:\"css/brands.css\";s:71:\"sha384-F8vNf2eNIHep58ofQztLhhWsZXaTzzfZRqFfWmh7Cup7LqrF0HCtB6UCAIIkZZYZ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CTTGZltCsihOiEwOCbT7p1lhij8kYk6lapCladmNzxj4yXj/AKp6q3+CRoNN3UCG\";s:15:\"css/regular.css\";s:71:\"sha384-GtLUznQ3nMgus15JP1pAE2UH9HAQi8gjQTNfIT+Gq6zFPeeq3y+Xtxt5HUBFF0YO\";s:13:\"css/solid.css\";s:71:\"sha384-WEKepgUDOaHRK2/r+qA7W/Srd+36IIOmBm/+wm9aSz6acYC0LkyM9UJElLVNy95T\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-sV6Qj6KRPF7HrXfo5NK0evVt+YbNxUuGZU2udYKDAxwxPVTuEE6lofcZJhRMK4WT\";s:9:\"js/all.js\";s:71:\"sha384-xiGKJ+4CP2p2WkTifyjHDeZVAg1zBrnJV8LU33N7J+5BWp1biPcSpEJJY7hFiRLn\";s:12:\"js/brands.js\";s:71:\"sha384-V+scQ15NnQuKVajRBsSery7bV87d0xDAoCs4pB8ZcwW74+zzW5CkgRmIFOYw8kKX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-CxMnuVDquTXcsJnW1rAfSm4uzGr12HENF1oe+JRZm4jcQDerJ6VeA1XLvAso396r\";s:13:\"js/regular.js\";s:71:\"sha384-ihKlq3j4PocIYMPkNra+ieEVsLuFzj4rp1yjn3jq+La7r4G9kf9COpWfOI8SGapM\";s:11:\"js/solid.js\";s:71:\"sha384-KDEuZV2OBU0Q264kBX2Idu9gYr5z/fQrtvUsKfuKGEDkDxV0GBVN/qi3QoLZPmbJ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-0nloDHslShcnKvH94Zv8nb0zPlzTFCzfZGx9YxR2ngUWs9HXXHVx1PUQw0u9/7LE\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-KFTzeUQSHjcfuC8qqdFm+laWVqpkucx/3uXo41hhKQzUEtbNnNSk8KEEBZ+2lEQy\";s:14:\"css/brands.css\";s:71:\"sha384-J6h7hpR0mfr79Ck/ZfDrhN14FnkbkLbd+mm0yTw5spSpK08yOK/AB9IRR/Dcg8EJ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-l2oTZy4pLseT/J6oW0mwsjKPhjpTctOfU191uVonzezZiqw9PPcz4AMKsIAeyR4P\";s:15:\"css/regular.css\";s:71:\"sha384-cDXlx+8npD3wa2ahyeSZvsi9VlRrMmJVIB1rpK7Ftyq4cppWM9d2mBhrlOqYBljt\";s:13:\"css/solid.css\";s:71:\"sha384-ioYc/tyAAvPTKdlEWH/BDO/Fn0RGAWisNzyfZNt74mHfA6UPN2tzjD6Nm4ieQfBR\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-bnoXyQHIAXdkrtQTtvuajtPgmWqHQ8657dQ4vzySapygDMqzijBpEq96AwgX2u4N\";s:9:\"js/all.js\";s:71:\"sha384-4OPaVeLgwRHdGJplmRGxGcoGYwxBAdR8Qr9z/Av7blRYPlRIPtjTygdtpQlD1HHv\";s:12:\"js/brands.js\";s:71:\"sha384-68dqWCRgViK/UsBTW5vGfntS6GdBDT5D4KWUBXTf6IkF2NFFD+X/0QNs0FZaIELt\";s:17:\"js/fontawesome.js\";s:71:\"sha384-sBtO3o3oG61AtAKrg74kfk50JP0YHcRTwOXgTeUobbJJBgYiCcmtkh784fmHww23\";s:13:\"js/regular.js\";s:71:\"sha384-J0ggktpCvzBHSxd/a8EBQgQDIWBtASK5rhHMvGWuR/UyjuPgX0iCAcb3OlfhvlQz\";s:11:\"js/solid.js\";s:71:\"sha384-DX1/9hggbc1yKVl40n2dNF9OzLf9ZPwZm87WzIW+FinkgjSq18PXpUxOL4I0iS1+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-kysXtDCmCTYxM55rHL+9xPu6+Inoi3ZzZHvcxkXs+iPj5nymJKlauQdXyzubyD0b\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.4\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-DmABxgPhJN5jlTwituIyzIUk6oqyzf3+XuP7q3VfcWA2unxgim7OSSZKKf0KSsnh\";s:14:\"css/brands.css\";s:71:\"sha384-1beec9tTZuu+KrTudmvRnGpK81r78DKCAXdphCvdG+PR+n/WCczsYPqTBTvYsM7z\";s:19:\"css/fontawesome.css\";s:71:\"sha384-xdTUmhbcetyLRVL4PAriRajOve+/5pjOiy5sJABnhXMcRMVc9HI9s2KmOCjjDK/P\";s:15:\"css/regular.css\";s:71:\"sha384-nM5tBytXTc1HDZ/A3My2gNT2TxLk/M/5yFi0QrOxaZjBi7QpKUfA2QqT+fcSxSlg\";s:13:\"css/solid.css\";s:71:\"sha384-g2aKxiZcFezoVOq4MsjaxuBbSxSlXD/NRQ5GaPLfvCtcTLgP3fYZKKAGxCM/wMfe\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MCR8qGTbdyK+hklwz1eKgGiAjT57F5HEJMs/uHRAwZ6GI5602TyGI89FyrbUwiIc\";s:9:\"js/all.js\";s:71:\"sha384-nVi8MaibAtVMFZb4R1zHUW/DsTJpG/YwPknbGABVOgk5s6Vhopl6XQD/pTCG/DKB\";s:12:\"js/brands.js\";s:71:\"sha384-dl3ONr32uA3YqpqKWzhXLs5k1YbKOn3dwiMbEP1S/XQMa3LPRwvJrhW7+lomL/uc\";s:17:\"js/fontawesome.js\";s:71:\"sha384-l7FyBM+wFIWpfmy8RYkWgEu/Me6Hrz98ijLu4nP3PkGbTtTCvtHB5ktI8hLEgEG3\";s:13:\"js/regular.js\";s:71:\"sha384-lwwoO5Gg19TptbILrLBjV28EVJ9RW3tD3cGyjCRn3OY9IuLua/YRlE47btZIXfMv\";s:11:\"js/solid.js\";s:71:\"sha384-4KkAk2UXMS9Xl3FoAAN43VJxRZ/emjElCz60xUTegPOZlbPLZGylvor2v7wQ0JNb\";s:14:\"js/v4-shims.js\";s:71:\"sha384-yfrMPoFcXUzdvECrvYRYE7wlxouXxjRSge5x6BlPPOb38tW4n0e8EW79RGU7VY0R\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-1RxicL8bcQJWgpr/clvtGVG7DVFJvDX/DVsJsbjKhXtdo8r5WVZQqB9AHTNPr08A\";s:14:\"css/brands.css\";s:71:\"sha384-sFwP5Zsnp6I4zQxUMPHvv8Bk16eEzU0YhaNbMCftDHPKDD+BR8WdXAHKL4xpipII\";s:19:\"css/fontawesome.css\";s:71:\"sha384-VFi8UvBDvM8muKO8ogMXi2j8vdJiu8hq1uxpX/NS8BsftBiJpheM5AuhFH1dvURx\";s:13:\"css/light.css\";s:71:\"sha384-4FGoKudkcpRXgx5UNFa5TxzaHUhnvCGFDeZKncEn9KJx/l07kcid3VbpwajrvrFW\";s:15:\"css/regular.css\";s:71:\"sha384-eyjlqgvgpHiWM0GoL4/hsTh22piTKmMTM+sfJYacddG2n9AEubqQB/w4CPJK1/1b\";s:13:\"css/solid.css\";s:71:\"sha384-TlWtvBj4TXNlpJC5Qq4aHel0R/dywVcP/6eOFC0qptQ71WWSxJCvuTajjGb1duS9\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-rHay3RzsgCtbjvDmBLThu6ESXlU4Al5STjlHSpNygnbeyt04OP1uKZVXB2Zy16+T\";s:9:\"js/all.js\";s:71:\"sha384-vV0064GQjt+TcoZxVPm/f6vyAivSNofFvOHKLWxcDl784Dzm9W4BBpoTvUG4vi5a\";s:12:\"js/brands.js\";s:71:\"sha384-/877azmwW/YhoBsPeM9dh61dNr5XGbuk24lyjPbFWyrPaZPyU2oxgOY6PE1OH4z4\";s:17:\"js/fontawesome.js\";s:71:\"sha384-7L9/YJQEf9kLPc6sdtoVIsuBNxCVi4OmHPcszcY685IJIcB52hgYoL1OiwTawJS/\";s:11:\"js/light.js\";s:71:\"sha384-iXxa9ExuZ0Fi2N2VO/buuWuAgYIUXNtOaJiKLa40Bjt43KJpzJdhg2TBHyBVqCPh\";s:13:\"js/regular.js\";s:71:\"sha384-YzSStfq1m16y1v5M97ViNRpiQUCVpagVVOkqlmww8otyjFkY6EXT4dShlKNuxRDu\";s:11:\"js/solid.js\";s:71:\"sha384-WJDZ/GI6pz1VoELs6i44T3f00fguksrLXIx3LXHdlaAzmOvX/mTK5j+qzHJdKejC\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8XZ16R7aSGin4NRuv6gn5xfbsvad5H8LR41g48iduwkfZEqDgXlvUjkJKgxqZUiW\";}}}s:5:\"5.0.6\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-VY3F8aCQDLImi4L+tPX4XjtiJwXDwwyXNbkH7SHts0Jlo85t1R15MlXVBKLNx+dj\";s:14:\"css/brands.css\";s:71:\"sha384-rK0EPNdv8UCeRNPzX+96ARRlf9hZM+OukGceDTdbPH30DYcSI1x5QyBU7d2I2kHX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-dbkYY2NmVwxaFrr4gq04oVh6w39ovmevsgD80Il1Od3hwpgREqyPb3XqbpaSwN4x\";s:15:\"css/regular.css\";s:71:\"sha384-HGbVnizaFNw8zW+vIol9xMwBFWdV7/k61278Zo1bnMy9dLmjv48D7rtpgYRTe5Pd\";s:13:\"css/solid.css\";s:71:\"sha384-GfC9nfESTZkjCPFbevBVig3FTd6wkjRRYMtj+qFgK8mMBvGIje2rrALgiBy6pwRL\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-U2b24h7gWqOYespg+vI5yiIn4ZYlTevT0N96xkGrw7ktP1gg9XwqEslsdTLJdlGg\";s:9:\"js/all.js\";s:71:\"sha384-0AJY8UERsBUKdWcyF3o2kisLKeIo6G4Tbd8Y6fbyw6qYmn4WBuqcvxokp8m2UzSD\";s:12:\"js/brands.js\";s:71:\"sha384-4iSpDug9fizYiQRPpPafdAh5NaF8yzNMjOvu3veWgaFm0iIo8y4vUi7f3Yyz5WP1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-rttr/ldR2uHigckjTCjMDe47ySeFVaL3Q7xUkJZir56u8Z8h/XnHJXHocgyfb25F\";s:13:\"js/regular.js\";s:71:\"sha384-G375DXNEVfALvsggywPWDYrRxNOvXaCYt/kiq/GXmbaDW8/B0XtbC8iuLpXXm1jF\";s:11:\"js/solid.js\";s:71:\"sha384-U0ZJ7q5xbT8hEoRqj61HzpvsqNOQ8bsHY2VqSRPqGOzjHXmmV70Aw+DBC/PT00p4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-L8zntmMOcCbOxXiL5Rjn6ubB7KunZiQ8U3bb9x6FFTGDEvVEESW9n+x49jm34K3W\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-ldFHeX3xCFvM4uf7m0mCMIoCPVwM71jopwqLZRldf+ojynoGVSxDiphfScLukkwO\";s:14:\"css/brands.css\";s:71:\"sha384-Ks7IvHjmJ4FIFxhK4iNrtW0rAVo1DlCYpe/nDsK8CnU+yactd38YiNE1GT018WPg\";s:19:\"css/fontawesome.css\";s:71:\"sha384-sATKZbJwxaEIU3unIoL1VMbIyrNNh7PlgnaiWlicWXeRA7qdnzfFzMP9AaN2wfTU\";s:13:\"css/light.css\";s:71:\"sha384-YWWfxaKIDrbFXuVQnpxASJDHmFl2K5f2vDgrcROb+rYycoqcQVdMlfu3U38boTg/\";s:15:\"css/regular.css\";s:71:\"sha384-CydLcYoDSbudHX/6hygyQD4jBMPsv91d/RwdtH1qxI79KG8kII/OzxKDwsswywA4\";s:13:\"css/solid.css\";s:71:\"sha384-uBARwTxpZ7FB08kQlCOS/dUaN3TrGGcHthrXYIhZBpdq7YtUdVDM1sAUH9NIozMl\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-BptPo+4C0N+fnMTnfw7ddW/zYUJhuNEe7edve8UrMbs+fCpfDJvJcC/lpa5Nvaky\";s:9:\"js/all.js\";s:71:\"sha384-FrB6Se1Wkxlx66xA4rPuOoOolLyQt5B1uptDmtLJSIVRJDbNkmE3QOLipnMuAbUW\";s:12:\"js/brands.js\";s:71:\"sha384-G12tjfNd/W8L4IrE5+f13LUbpzVowwhNDv+WNecvxjbaGN9bbSY7epBOqUlRqXnq\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ln5PcCmuH8v+AF9nt+HkM2GfXjsn1CtVc0n+ciM8+oe3nwGyPCceDVva7bUjNfo0\";s:11:\"js/light.js\";s:71:\"sha384-jzS22FYPy68IBBet2IRM5aQDOXjg9X1g+drXIVonDtyqGFCtUA0YIdgHdvCCX/fD\";s:13:\"js/regular.js\";s:71:\"sha384-M8TFIPAJNl8UIC8OP6GFcIE0SHkGN4zjwwjz+BBTz60XhNegOrZmjNtTQNKifmXX\";s:11:\"js/solid.js\";s:71:\"sha384-R/e3QvpS9m8HcN9b9l6nNo678ekTXL31kFY/XtRHSjrihDX8A2DF8HaXhdlAtzMx\";s:14:\"js/v4-shims.js\";s:71:\"sha384-X9eLyweB0LOTEGCwMARo9+zibrXQYmBMSrhFk4ncpT/WYnPIcpTg0IgBFDgzuPwL\";}}}s:5:\"5.0.8\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-3AB7yXWz4OeoZcPbieVW64vVXEwADiYyAEhwilzWsLw+9FgqpyjjStpPnpBO8o8S\";s:14:\"css/brands.css\";s:71:\"sha384-IiIL1/ODJBRTrDTFk/pW8j0DUI5/z9m1KYsTm/RjZTNV8RHLGZXkUDwgRRbbQ+Jh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-q3jl8XQu1OpdLgGFvNRnPdj5VIlCvgsDQTQB6owSOHWlAurxul7f+JpUOVdAiJ5P\";s:15:\"css/regular.css\";s:71:\"sha384-A/oR8MwZKeyJS+Y0tLZ16QIyje/AmPduwrvjeH6NLiLsp4cdE4uRJl8zobWXBm4u\";s:13:\"css/solid.css\";s:71:\"sha384-v2Tw72dyUXeU3y4aM2Y0tBJQkGfplr39mxZqlTBDUZAb9BGoC40+rdFCG0m10lXk\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-TGBI4yK0MJz2ga16RLBBt4xT4aoPMPmRYhfu1Kl5IJ0gsLyOBIKHEb49BtoO+lPS\";s:9:\"js/all.js\";s:71:\"sha384-SlE991lGASHoBfWbelyBPLsUlwY1GwNDJo3jSJO04KZ33K2bwfV9YBauFfnzvynJ\";s:12:\"js/brands.js\";s:71:\"sha384-sCI3dTBIJuqT6AwL++zH7qL8ZdKaHpxU43dDt9SyOzimtQ9eyRhkG3B7KMl6AO19\";s:17:\"js/fontawesome.js\";s:71:\"sha384-7ox8Q2yzO/uWircfojVuCQOZl+ZZBg2D2J5nkpLqzH1HY0C1dHlTKIbpRz/LG23c\";s:13:\"js/regular.js\";s:71:\"sha384-t7yHmUlwFrLxHXNLstawVRBMeSLcXTbQ5hsd0ifzwGtN7ZF7RZ8ppM7Ldinuoiif\";s:11:\"js/solid.js\";s:71:\"sha384-+Ga2s7YBbhOD6nie0DzrZpJes+b2K1xkpKxTFFcx59QmVPaSA8c7pycsNaFwUK6l\";s:14:\"js/v4-shims.js\";s:71:\"sha384-4CnzNxEP5RK316IYY2+W4hc05uJdfd+p9iNVeNG9Ws3Qxf5tKolysO9wu/8rloj2\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-OGsxOZf8qnUumoWWSmTqXMPSNI9URpNYN35fXDb5Cv5jT6OR673ah1e5q+9xKTq6\";s:14:\"css/brands.css\";s:71:\"sha384-VRONz34zTLl4P+DLYyJ8kP8C3tB1PGtqL5p8nBAvHuoc1u32bR3RHixrjffD8Fly\";s:19:\"css/fontawesome.css\";s:71:\"sha384-+5VkSw5C1wIu2iUZEfX77QSYRb5fhjmEsRn8u4r9Ma8mvu/GvTag4LDSEAw7RjXl\";s:13:\"css/light.css\";s:71:\"sha384-shmfBA2CRxp88gq8NcvWbEN8KExYU4uvQUBEG36BStGZ5k91nGKE4wDvvWvuimbu\";s:15:\"css/regular.css\";s:71:\"sha384-0w6MzzKHIB9cUlfWSmSp1Pj6XqGGDseWSMz1Yppk3UOc1dhYhpFx1AuCkMBECEvC\";s:13:\"css/solid.css\";s:71:\"sha384-+iHwwKZGTdlVFbv4fsKmLkogfdKlp47zQGkSMDN3ANc8kXjyKudKvQwinI5VH+2C\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-b2wDmqWyAwmI2rS5ut5UweBS1V32L/k1+2Oo7eCaHdXOS/1bFwC8AKevTI6N28LN\";s:9:\"js/all.js\";s:71:\"sha384-816IUmmhAwCMonQiPZBO/PTgzgsjHtpb78rpsLzldhb4HZjFzBl06Z3eu4ZuwHTz\";s:12:\"js/brands.js\";s:71:\"sha384-gJijC/2qM/p3zm2wHECHX1OMLdzlu61sNp7YfmFQxo+OyT9hO1orX7MmnHhaoXQ4\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ht3fAeBiX/rVmKVyMwONAIIt0aRoPzZgq1FzdRgR9zFo+Kcd8YDwUbFlTItfaYW4\";s:11:\"js/light.js\";s:71:\"sha384-mfSnp84URDGC1t+cg63LgVKwEs63ulRUpjNneyDZMGMAE9ZKUNZ85rMBMHucGLYP\";s:13:\"js/regular.js\";s:71:\"sha384-SIp/+zr0hyfSVIQPkAwB/L1h4fph6T3CmU4mE7IFtGJlgwoCko0Bye/1J0sjyh4v\";s:11:\"js/solid.js\";s:71:\"sha384-jTxqWCb7UqRDQDd2Nkuh5BkHe9k+ElbFLa3NaJfid5kBK/+cVktzVRXrw0isFWxf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-w/sFNq23wbOXJOUpFyISABLXk9tA4Z8r9hl80er2mobEwgS7VXXYDANaWyrCWe3/\";}}}s:5:\"5.0.9\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-5SOiIsAziJl6AWe0HWRKTXlfcSHKmYV4RBF18PPJ173Kzn7jzMyFuTtk8JA7QQG1\";s:14:\"css/brands.css\";s:71:\"sha384-ATC/oZittI09GYIoscTZKDdBr/kI3lCwzw3oBMnOYCPVNJ4i7elNlCxSgLfdfFbl\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Lyz+8VfV0lv38W729WFAmn77iH5OSroyONnUva4+gYaQTic3iI2fnUKtDSpbVf0J\";s:15:\"css/regular.css\";s:71:\"sha384-seionXF7gEANg+LFxIOw3+igh1ZAWgHpNR8SvE64G/Zgmjd918dTL55e8hOy7P4T\";s:13:\"css/solid.css\";s:71:\"sha384-29Ax2Ao1SMo9Pz5CxU1KMYy+aRLHmOu6hJKgWiViCYpz3f9egAJNwjnKGgr+BXDN\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hl6tZnMfNiJHYyFxpmnRV8+pziARxY3X/4XWfFXldG7sdkkLv+Od2Gpc57P7C1g6\";s:9:\"js/all.js\";s:71:\"sha384-8iPTk2s/jMVj81dnzb/iFR2sdA7u06vHJyyLlAd4snFpCl/SnyUjRrbdJsw1pGIl\";s:12:\"js/brands.js\";s:71:\"sha384-qJKAzpOXfvmSjzbmsEtlYziSrpVjh5ROPNqb8UZ60myWy7rjTObnarseSKotmJIx\";s:17:\"js/fontawesome.js\";s:71:\"sha384-2IUdwouOFWauLdwTuAyHeMMRFfeyy4vqYNjodih+28v2ReC+8j+sLF9cK339k5hY\";s:13:\"js/regular.js\";s:71:\"sha384-BazKgf1FxrIbS1eyw7mhcLSSSD1IOsynTzzleWArWaBKoA8jItTB5QR+40+4tJT1\";s:11:\"js/solid.js\";s:71:\"sha384-P4tSluxIpPk9wNy8WSD8wJDvA8YZIkC6AQ+BfAFLXcUZIPQGu4Ifv4Kqq+i2XzrM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9f5gaI9TkuYhi5O/inzfdOXx2nkIhDsLtXqBNmtY6/c5PoqXfd0U2DAjqQVSCXQh\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-L+XK540vkePe55E7PAfByfvW0XpsyYpsifTpgh/w8WvH6asVg/c2zqp0EfZfZTbF\";s:14:\"css/brands.css\";s:71:\"sha384-+LMmZxgyldhNCY6nei3oAWJjHbpbROtVb+f5Ux/nahA+Xjm3wcNdu7zyB39Yj38S\";s:19:\"css/fontawesome.css\";s:71:\"sha384-31qpW3hduWGiGey9tdI9rBBxiog5pxZbPiAlD6YKIgy0P2V1meprKhvpk+xJDkMw\";s:13:\"css/light.css\";s:71:\"sha384-wD8IB6DSQidXyIWfwBrsFwTaHTQDsgzyeqzhd1jNdBZHvGSa7KRGb6Q5sMlroCyk\";s:15:\"css/regular.css\";s:71:\"sha384-hJbmKHxbgrH79UtKxubo1UTe96bOL4Xfhjaqr0csD1UMPEPbeV+446QAC+IGxY+b\";s:13:\"css/solid.css\";s:71:\"sha384-k8v16DuQ4ZFtRfpTeqTW4tcHIj5tkvUNQm1QiLs90XiToLzyFeV+yxujHjSZ2wim\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-yVUvm1bVSmayKKt0YHPKotNQzlBvgNhEBbQ6U1d38bjpapXMVmE+SLXrpQ9td4Ij\";s:9:\"js/all.js\";s:71:\"sha384-DtPgXIYsUR6lLmJK14ZNUi11aAoezQtw4ut26Zwy9/6QXHH8W3+gjrRDT+lHiiW4\";s:12:\"js/brands.js\";s:71:\"sha384-yIJb2TJeTM04vupX+3lv0Qp9j0Pnk8Qm9UPYlXr3H0ROCHNNLoacpS++HWDabbzi\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8QYlVHotqQzcAVhJny7MO9ZR0hASr6cRCpURV+EobTTAv5wftkn4i+U6UrMqoCis\";s:11:\"js/light.js\";s:71:\"sha384-06sraYAcw8BzUjsPn5z8Qi/QAA2/ZJl5GN3LGtRp7k+tZpu7kw+sRNXDDTU4RkOt\";s:13:\"js/regular.js\";s:71:\"sha384-C6h/8oKUfY6cVuGfFSu9uGIlFkaD1u1j+ByYGFTdFbOpHOHpw39lKxqEpRgLQg6A\";s:11:\"js/solid.js\";s:71:\"sha384-nISI3wKDp2gWn9L91zXOKXZ6JPt2mteGTnaJAMfeNgAoeLKl2AQsWLH69HMmBXHa\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vuyo8HdrwozCl2DhHOJ40ytjEx9FGy0cqu8i5GHeIoSUm6MPgqCXAVoUIsudKfuE\";}}}s:6:\"5.0.10\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-+d0P83n9kaQMCwj8F4RJB66tzIwOKmrdb46+porD/OvrJ+37WqIM7UoBtwHO6Nlg\";s:14:\"css/brands.css\";s:71:\"sha384-KtmfosZaF4BaDBojD9RXBSrq5pNEO79xGiggBxf8tsX+w2dBRpVW5o0BPto2Rb2F\";s:19:\"css/fontawesome.css\";s:71:\"sha384-8WwquHbb2jqa7gKWSoAwbJBV2Q+/rQRss9UXL5wlvXOZfSodONmVnifo/+5xJIWX\";s:15:\"css/regular.css\";s:71:\"sha384-R7FIq3bpFaYzR4ogOiz75MKHyuVK0iHja8gmH1DHlZSq4tT/78gKAa7nl4PJD7GP\";s:13:\"css/solid.css\";s:71:\"sha384-HTDlLIcgXajNzMJv5hiW5s2fwegQng6Hi+fN6t5VAcwO/9qbg2YEANIyKBlqLsiT\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ucawWSvpdgQ67m4VQzI6qBOHIsGRoY2soJtCkkp15b6IaNCLgauWkbKR8SAuiDQ7\";s:9:\"js/all.js\";s:71:\"sha384-slN8GvtUJGnv6ca26v8EzVaR9DC58QEwsIk9q1QXdCU8Yu8ck/tL/5szYlBbqmS+\";s:12:\"js/brands.js\";s:71:\"sha384-6jhVhr5a+Z1nLr9h+fd7ocMEo847wnGFelCHddaOOACUeZNoQwFXTxh4ysXVam8u\";s:17:\"js/fontawesome.js\";s:71:\"sha384-M2FSA4xMm1G9m4CNXM49UcDHeWcDZNucAlz1WVHxohug0Uw1K+IpUhp/Wjg0y6qG\";s:13:\"js/regular.js\";s:71:\"sha384-JWLWlnwX0pRcCBsI3ZzOEyVDoUmngnFnbXR9VedCc3ko4R3xDG+KTMYmVciWbf4N\";s:11:\"js/solid.js\";s:71:\"sha384-Q7KAHqDd5trmfsv85beYZBsUmw0lsreFBQZfsEhzUtUn5HhpjVzwY0Aq4z8DY9sA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-RLvgmog5EsZMMDnT3uJo6ScffPHTtMbhtV8pcT8kP5UJzlVRU1SP9Hccelk3zYZc\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-KwxQKNj2D0XKEW5O/Y6haRH39PE/xry8SAoLbpbCMraqlX7kUP6KHOnrlrtvuJLR\";s:14:\"css/brands.css\";s:71:\"sha384-cyAsyPMdnj21FGg6BEGfZdZ99a/opKBeFa8z5VoHPsPj+tLRYSxkRlPWnGkCJGyA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HE+OCjOJOPZavEcVffA6E24sIfY2RwV4JRieXa/3N5iCY8vgnTwZemElENQ8ak/K\";s:13:\"css/light.css\";s:71:\"sha384-k/d3hya1Xwx/V3yLAr7/6ibFaFIaN+xeY1eIv42A1Bn2HgfB+/YjLscji1sHLOkb\";s:15:\"css/regular.css\";s:71:\"sha384-D4yOV+i5oKU6w8CiadBDVtSim/UXmlmQfrIdRsuKT3nYhiF/Tb6YLQtyF9l0vqQF\";s:13:\"css/solid.css\";s:71:\"sha384-WjYgBJXUWNFTzFd4wNJuzUZx28GSgjzXrPO4LJrng96HFrI/nLrG1R5NET65v1yR\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-S/uB02cfkgX8kd+j6f3gmw/PPTg8xSiE/w6d8dE852PzHXkGBYLrqpWFse9hInR2\";s:9:\"js/all.js\";s:71:\"sha384-+1nLPoB0gaUktsZJP+ycZectl3GX7wP8Xf2PE/JHrb7X1u7Emm+v7wJMbAcPr8Ge\";s:12:\"js/brands.js\";s:71:\"sha384-OwdVp9K/baqiXthTvRnYzMcsTaqwG19SfDkTRc/GBIhK9eYlWVVBEvLlueA0STAP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TxXqLyCP6HYGVtr9V1M1rQE7IMbBEZoDdOX+MFeYNbWNwopWKVQM8NyqtU2x+5t2\";s:11:\"js/light.js\";s:71:\"sha384-rv/n2A+UxOzR1qs4wrcOtJ7Ai5Hcn3QQ8tvEkOo5lCvqCD3xwpeO3KZP18JpSXr3\";s:13:\"js/regular.js\";s:71:\"sha384-QNGmoJVI8f07j7N4+DSn4Cdob1PTBJOR6jRGwUwqSPyL2HmvWaBPXuSXOcStGo9D\";s:11:\"js/solid.js\";s:71:\"sha384-m3J/Wb6KcNkFJIpCugSSJITG80sKhEA+16UCFdq1LnpMTOCXwwpeyrE1FmyqoArv\";s:14:\"js/v4-shims.js\";s:71:\"sha384-H+U1wWQdWbEtuQPJ4ZpMl8yWydI6xc/306L/NZkpGY8BGpeSpu39V20x03S3xcMw\";}}}s:6:\"5.0.12\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-G0fIWCsCzJIMAVNQPfjH08cyYaUtMwjJwqiRKxxE/rx96Uroj1BtIQ6MLJuheaO9\";s:14:\"css/brands.css\";s:71:\"sha384-Pln/erVatVEIIVh7sfyudOXs5oajCSHg7l5e2Me02e3TklmDuKEhQ8resTIwyI+w\";s:19:\"css/fontawesome.css\";s:71:\"sha384-rnr8fdrJ6oj4zli02To2U/e6t1qG8dvJ8yNZZPsKHcU7wFK3MGilejY5R/cUc5kf\";s:15:\"css/regular.css\";s:71:\"sha384-RGDxJbFQcd3/Rei8rYb+3xO3YREd0abxm8WfLkYj7j4HHo5ZVuNUGVx8H8GbpFTQ\";s:13:\"css/solid.css\";s:71:\"sha384-VxweGom9fDoUf7YfLTHgO0r70LVNHP5+Oi8dcR4hbEjS8UnpRtrwTx7LpHq/MWLI\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-N44Xrku5FaDiZLZ8lncIZLh+x9xiqk1r0NTlUJQ5xanSpdORyQHP4Zp2WQJ9GlpJ\";s:9:\"js/all.js\";s:71:\"sha384-Voup2lBiiyZYkRto2XWqbzxHXwzcm4A5RfdfG6466bu5LqjwwrjXCMBQBLMWh7qR\";s:12:\"js/brands.js\";s:71:\"sha384-BPIhZF7kZGuZzBS4SP/oIqzpxWuOUtsPLUTVGpGw+EtB1wKt1hv63jb2OCroS3EX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-6AOxTjzzZLvbTJayrLOYweuPckqh0rrB4Sj+Js8Vzgr85/qm2e0DRqi+rBzyK52J\";s:13:\"js/regular.js\";s:71:\"sha384-6XNKyHeL6pEPXURVNSKQ0lUP80a5FHqN0oFqSSS8Qviyy2u0KmCMJlQ5iLiAAPBg\";s:11:\"js/solid.js\";s:71:\"sha384-652/z7yNdGONCCBu0u5h5uF9voJhBdgruAuIDVheEaQ7O/ZC9wyyV+yZsYb32Wy7\";s:14:\"js/v4-shims.js\";s:71:\"sha384-STc8Gazx86A+NmeBWQTqa5Ob1wGSRQZevexYiUkKdiqZhi5LSZ28XYAvgptHK5HH\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-HX5QvHXoIsrUAY0tE/wG8+Wt1MwvaY28d9Zciqcj6Ob7Tw99tFPo4YUXcZw9l930\";s:14:\"css/brands.css\";s:71:\"sha384-M4owBK0KiG0Vz+G5z/8v8tBb1+w9ts66Z6xKkZEPgBwzISkrcNra4GxZcvJPyaGB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ZDxYpspDwfEsC0ZJDb74i/Rqjb1CnX3a69Dz9vXv4PvvlTEkgMI02TATTRNJoZ06\";s:13:\"css/light.css\";s:71:\"sha384-PWGGmWk9+xVydf1Gzso0ouaikBBKLu4nCY52q+tBUMq5iXmRhpgTuDkjbtxZ1rXT\";s:15:\"css/regular.css\";s:71:\"sha384-tYZB+BP2inzRg01pQhSlW4Tloc0ULXYGiBaf5kSB5Tb3+l84bJy+PKerqziKz3iv\";s:13:\"css/solid.css\";s:71:\"sha384-KY40QRrgoQAM9BPN+gm7JoK30M/P6QqKRCbXUS3uWbPfycyiVeEsPkGNMhcNL3DU\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ubRAMbpAKC+ULwg5mkUQLFReIXq1yeiKIcfV7cYp+rEaeINfEglYX6JOte80PCDk\";s:9:\"js/all.js\";s:71:\"sha384-quzri7saio48xMf3ED3HiI5YaItt68Q+0J3qc9EIfk1jk3QqCJhS24l6CZpUGfEe\";s:12:\"js/brands.js\";s:71:\"sha384-QlvHmHtevrYI4s/vdiK6chTDouw2pRA5av6ZLVtENubkoCgSZz4ZaXVvplQ1FRPs\";s:17:\"js/fontawesome.js\";s:71:\"sha384-CUrLKzrygRugRUPtEJ1u4nV4Ec6GnuDMRDGaxfoFXLI+sraWS6rqGg2Sjfs6BTet\";s:11:\"js/light.js\";s:71:\"sha384-z7YlG414oqy0TO7qY/nGfC8zd1LL8JAX3iNQ3iLybUIziHzaMYqBwUvhizEwV0Fd\";s:13:\"js/regular.js\";s:71:\"sha384-p/qo0lifpToZ0ubNiv1WFzlmYJU+BOenvU+evARCvCqALvbpZuqmZQ207vmYD6QL\";s:11:\"js/solid.js\";s:71:\"sha384-y//1Knkpeyl2S568g2ECqUA4n3MKf+kpj1/sfjUQbR1WtBPONceBHrQVMiAqfjLH\";s:14:\"js/v4-shims.js\";s:71:\"sha384-6+8zJP76v3EziONR2vMd32iSU3qbdicAE8KNp+NWniM6mBmvN80NlY+sbvCO+w7M\";}}}s:6:\"5.0.13\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp\";s:14:\"css/brands.css\";s:71:\"sha384-VGCZwiSnlHXYDojsRqeMn3IVvdzTx5JEuHgqZ3bYLCLUBV8rvihHApoA1Aso2TZA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-GVa9GOgVQgOk+TNYXu7S/InPTfSDTtBalSgkgqQ7sCik56N9ztlkoTr2f/T44oKV\";s:15:\"css/regular.css\";s:71:\"sha384-EWu6DiBz01XlR6XGsVuabDMbDN6RT8cwNoY+3tIH+6pUCfaNldJYJQfQlbEIWLyA\";s:13:\"css/solid.css\";s:71:\"sha384-Rw5qeepMFvJVEZdSo1nDQD5B6wX0m7c5Z/pLNvjkB14W6Yki1hKbSEQaX9ffUbWe\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-LAtyQAMHxrIJzktG06ww5mJ0KQ+uCqQIJFjwj+ceCjUlZ2jkLwJZt1nBGw4KaFEZ\";s:9:\"js/all.js\";s:71:\"sha384-xymdQtn1n3lH2wcu0qhcdaOpQwyoarkgLVxC/wZ5q7h9gHtxICrpcaSUfygqZGOe\";s:12:\"js/brands.js\";s:71:\"sha384-G/XjSSGjG98ANkPn82CYar6ZFqo7iCeZwVZIbNWhAmvCF2l+9b5S21K4udM7TGNu\";s:17:\"js/fontawesome.js\";s:71:\"sha384-6OIrr52G08NpOFSZdxxz1xdNSndlD4vdcf/q2myIUVO0VsqaGHJsB0RaBE01VTOY\";s:13:\"js/regular.js\";s:71:\"sha384-IJ3h7bJ6KqiB70L7/+fc44fl+nKF5eOFkgM9l/zZii9xs7W2aJrwIlyHZiowN+Du\";s:11:\"js/solid.js\";s:71:\"sha384-tzzSw1/Vo+0N5UhStP3bvwWPq+uvzCMfrN1fEFe+xBmv1C/AtVX5K0uZtmcHitFZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-qqI1UsWtMEdkxgOhFCatSq+JwGYOQW+RSazfcjlyZFNGjfwT/T1iJ26+mp70qvXx\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-oi8o31xSQq8S0RpBcb4FaLB8LJi9AT8oIdmS1QldR8Ui7KUQjNAnDlJjp55Ba8FG\";s:14:\"css/brands.css\";s:71:\"sha384-t3MQUMU0g3tY/0O/50ja6YVaEFYwPpOiPbrHk9p5DmYtkHJU2U1/ujNhYruOJwcj\";s:19:\"css/fontawesome.css\";s:71:\"sha384-LDuQaX4rOgqi4rbWCyWj3XVBlgDzuxGy/E6vWN6U7c25/eSJIwyKhy9WgZCHQWXz\";s:13:\"css/light.css\";s:71:\"sha384-d8NbeymhHpk+ydwT2rk4GxrRuC9pDL/3A6EIedSEYb+LE+KQ5QKgIWTjYwHj/NBs\";s:15:\"css/regular.css\";s:71:\"sha384-HLkkol/uuRVQDnHaAwidOxb1uCbd78FoGV/teF8vONYKRP9oPQcBZKFdi3LYDy/C\";s:13:\"css/solid.css\";s:71:\"sha384-drdlAcijFWubhOfj9OS/gy2Gs34hVhVT90FgJLzrldrLI+7E7lwBxmanEEhKTRTS\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-8YpCivPy+AkMdZ0uAvEP04Gs77AN/6mS5AmZqkCwniP51zSG8rCMaH06OYuC4iXd\";s:9:\"js/all.js\";s:71:\"sha384-d84LGg2pm9KhR4mCAs3N29GQ4OYNy+K+FBHX8WhimHpPm86c839++MDABegrZ3gn\";s:12:\"js/brands.js\";s:71:\"sha384-44Hl7UlQr9JXHFcZOp9qWHk2H1lrsAN/cG3GNgB2JqbciecuJ2/B9sjelOMttzBM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-BUkEHIKZJ0ussRY3zYfFL7R0LpqWmucr9K38zMTJWdGQywTjmzbejVSNIHuNEhug\";s:11:\"js/light.js\";s:71:\"sha384-+iGqamqASU/OvBgGwlIHH6HSEgiluzJvTqcjJy8IN9QG9aUfd0z0pKpTlH7TpU7X\";s:13:\"js/regular.js\";s:71:\"sha384-1bAvs6o5Yb7MMzvTI3oq2qkreCQFDXb6KISLBhrHR+3sJ/mm7ZWfnQVRwScbPEmd\";s:11:\"js/solid.js\";s:71:\"sha384-CucLC75yxFXtBjA/DCHWMS14abAUhf5HmFRdHyKURqqLqi3OrLsyhCyqp83qjiOR\";s:14:\"js/v4-shims.js\";s:71:\"sha384-LDfu/SrM7ecLU6uUcXDDIg59Va/6VIXvEDzOZEiBJCh148mMGba7k3BUFp1fo79X\";}}}s:5:\"5.1.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-lKuwvrZot6UHsBSfcMvOkWwlCMgc0TaWr+30HWe3a4ltaBwTZhyTEggF5tJv8tbt\";s:14:\"css/brands.css\";s:71:\"sha384-7xAnn7Zm3QC1jFjVc1A6v/toepoG3JXboQYzbM0jrPzou9OFXm/fY6Z/XiIebl/k\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ozJwkrqb90Oa3ZNb+yKFW2lToAWYdTiF1vt8JiH5ptTGHTGcN7qdoR1F95e0kYyG\";s:15:\"css/regular.css\";s:71:\"sha384-avJt9MoJH2rB4PKRsJRHZv7yiFZn8LrnXuzvmZoD3fh1aL6aM6s0BBcnCvBe6XSD\";s:13:\"css/solid.css\";s:71:\"sha384-TbilV5Lbhlwdyc4RuIV/JhD8NR+BfMrvz4BL5QFa2we1hQu6wvREr3v6XSRfCTRp\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-5aLiCANDiVeIiNfzcW+kXWzWdC6riDYfxLS6ifvejaqYOiEufCh0zVLMkW4nr8iC\";s:16:\"css/v4-shims.css\";s:71:\"sha384-epK5t6ciulYxBQbRDZyYJFVuWey/zPlkBIbv6UujFdGiIwQCeWOyv5PVp2UQXbr2\";s:9:\"js/all.js\";s:71:\"sha384-3LK/3kTpDE/Pkp8gTNp2gR/2gOiwQ6QaO7Td0zV76UFJVhqLl4Vl3KL1We6q6wR9\";s:12:\"js/brands.js\";s:71:\"sha384-ZqDZAkGUHrXxm3bvcTCmQWz4lt7QGLxzlqauKOyLwg8U0wYcYPDIIVTbZZXjbfsM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-juNb2Ils/YfoXkciRFz//Bi34FN+KKL2AN4R/COdBOMD9/sV/UsxI6++NqifNitM\";s:13:\"js/regular.js\";s:71:\"sha384-Y+AVd32cSTAMpwehrH10RiRmA28kvu879VbHTG58mUFhd+Uxl/bkAXsgcIesWn3a\";s:11:\"js/solid.js\";s:71:\"sha384-Z7p3uC4xXkxbK7/4keZjny0hTCWPXWfXl/mJ36+pW7ffAGnXzO7P+iCZ0mZv5Zt0\";s:14:\"js/v4-shims.js\";s:71:\"sha384-3qT9zZfeo1gcy2NmVv5dAhtOYkj91cMLXRkasOiRB/v+EU3G+LZUyk5uqZQdIPsV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-87DrmpqHRiY8hPLIr7ByqhPIywuSsjuQAfMXAE0sMUpY3BM7nXjf+mLIUSvhDArs\";s:14:\"css/brands.css\";s:71:\"sha384-C1HxUFJBptCeaMsYCbPUw8fdL2Cblu3mJZilxrfujE+7QLr8BfuzBl5rPLNM61F6\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PnWzJku7hTqk2JREATthkLpYeVVGcBbXG5yEzk7hD2HIr/VxffIDfNSR7p7u4HUy\";s:13:\"css/light.css\";s:71:\"sha384-ANTAgj8tbw0vj4HgQ4HsB886G2pH15LXbruHPCBcUcaPAtn66UMxh8HQcb1cH141\";s:15:\"css/regular.css\";s:71:\"sha384-6kuJOVhnZHzJdVIZJcWiMZVi/JwinbqLbVxIbR73nNqXnYJDQ5TGtf+3XyASO4Am\";s:13:\"css/solid.css\";s:71:\"sha384-rvfDcG9KDoxdTesRF/nZ/sj8CdQU+hy6JbNMwxUTqpoI2LaPK8ASQk6E4bgabrox\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-/h6SKuA/ysT91EgYEGm9B6Z6zlaxuvKeW/JB7FWdGwCFalafxmGzJE2a63hS1BLm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-2RBBYH6GaI11IJzJ6V1eL7kXXON+epoQIt+HqpzQdBrtyT7gNwKPDxo2roxUbtW9\";s:9:\"js/all.js\";s:71:\"sha384-E5SpgaZcbSJx0Iabb3Jr2AfTRiFnrdOw1mhO19DzzrT9L+wCpDyHUG2q07aQdO6E\";s:12:\"js/brands.js\";s:71:\"sha384-QPbiRUBnwCr8JYNjjm7CB0QP9h4MLvWUZhsChFX6dLzRkY22/nAxVYqa5nUTd6PL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-ckjcH5WkBMAwWPjTJiy7K2LaLp37yyCVKAs3DKjhPdo0lRCDIScolBzRsuaSu+bQ\";s:11:\"js/light.js\";s:71:\"sha384-77i21WTcIcnSPKxwR794RLUQitpNqm6K3Fxsjx8hgoc3ZZbPJu5orgvU/7xS3EFq\";s:13:\"js/regular.js\";s:71:\"sha384-S21AhcbZ5SXPXH+MH7JuToqmKYXviahLaD1s9yApRbu1JDiMjPBGQIw/3PCHKUio\";s:11:\"js/solid.js\";s:71:\"sha384-q6QALO/4RSDjqnloeDcGnkB0JdK3MykIi6dUW5YD66JHE3JFf8rwtV5AQdYHdE0X\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9gfBAY6DS3wT0yuvYN1aaA1Q9R0fYQHliQWLChuYDWJJ0wQJpoNZrzlcqd4+qqny\";}}}s:5:\"5.1.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-O8whS3fhG2OnA5Kas0Y9l3cfpmYjapjI0E4theH4iuMD+pLhbf6JI0jIMfYcK3yZ\";s:14:\"css/brands.css\";s:71:\"sha384-SYNjKRRe+vDW0KSn/LrkhG++hqCLJg9ev1jIh8CHKuEA132pgAz+WofmKAhPpTR7\";s:19:\"css/fontawesome.css\";s:71:\"sha384-0b7ERybvrT5RZyD80ojw6KNKz6nIAlgOKXIcJ0CV7A6Iia8yt2y1bBfLBOwoc9fQ\";s:15:\"css/regular.css\";s:71:\"sha384-QNorH84/Id/CMkUkiFb5yTU3E/qqapnCVt6k5xh1PFIJ9hJ8VfovwwH/eMLQTjGS\";s:13:\"css/solid.css\";s:71:\"sha384-S2gVFTIn1tJ/Plf+40+RRAxBCiBU5oAMFUJxTXT3vOlxtXm7MGjVj62mDpbujs4C\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-EH3TEAKYd7R0QbCS4OFuYoEpaXITVg5c/gdZ/beEaAbRjMGVuVLLFjiIKOneCzGZ\";s:16:\"css/v4-shims.css\";s:71:\"sha384-LCsPWAjCFLDeFHB5Y0SBIOqgC5othK8pIZiJAdbJDiN10B2HXEm1mFNHtED8cViz\";s:9:\"js/all.js\";s:71:\"sha384-BtvRZcyfv4r0x/phJt9Y9HhnN5ur1Z+kZbKVgzVBAlQZX4jvAuImlIz+bG7TS00a\";s:12:\"js/brands.js\";s:71:\"sha384-0inRy4HkP0hJ038ZyfQ4vLl+F4POKbqnaUB6ewmU4dWP0ki8Q27A0VFiVRIpscvL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-NY6PHjYLP2f+gL3uaVfqUZImmw71ArL9+Roi9o+I4+RBqArA2CfW1sJ1wkABFfPe\";s:13:\"js/regular.js\";s:71:\"sha384-sAzYCvbTTKFOxT4VHu+ZjHRMXjvfjT6TAqOng28g4jba88Peg5+hkoVIqQKGjmj1\";s:11:\"js/solid.js\";s:71:\"sha384-GXi56ipjsBwAe6v5X4xSrVNXGOmpdJYZEEh/0/GqJ3JTHsfDsF8v0YQvZCJYAiGu\";s:14:\"js/v4-shims.js\";s:71:\"sha384-T69Lzd4bE7W8/vVrxvfsx45/AAKf6QmKEg5zSl0v9aZwo/pTKseq81mxdpARTQpx\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-xyMU7RufUdPGVOZRrc2z2nRWVWBONzqa0NFctWglHmt5q5ukL22+lvHAqhqsIm3h\";s:14:\"css/brands.css\";s:71:\"sha384-E5dVkWQIVhVPtBz/KK2TS7EM9l1+5XiWFPX7l3+5ayHPwDguGsHqof3GQbk55AS3\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bHoj6f1b1CQ6zapOREeYBO/JnDjeV1fLuKn3KHnbqAAnkLva11KY3m8YyKPVXYLF\";s:13:\"css/light.css\";s:71:\"sha384-EGKQAl6ZrGi/zGxZ4ykVhc/A3tFVeBiLnneETILtcxQnZpo7ejmb4BkNa3zSgo4K\";s:15:\"css/regular.css\";s:71:\"sha384-AKIrAHbICIQF+NEqtykrcdzMjExDiKLa9hOyUVsr4PlHtktH7xaD10vO98UnPjuE\";s:13:\"css/solid.css\";s:71:\"sha384-Ux3tEr1RmnxCht2XbPkWWBuotwMVXKOe0PkWN/nmiD5CSV6Tyjl+Kr0J0iX1yd0q\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-++BmJ9x4V05AhCNnLr/RjPTY4BAFuhZsESUqH5hiwZspBvy7F+DRGvSH8tGHw9P/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TUicmScQcYANFcc4OQKEX6V1Zek9o9t+dwW/2tZoXmSigBk9JqfHxZZFlSo+0oRl\";s:9:\"js/all.js\";s:71:\"sha384-cHcg4nvWPIGArJhEgL2F5e09Cn1GyPQpNYKbPatFCpDefCbezZjPA3PhLozKTZnv\";s:12:\"js/brands.js\";s:71:\"sha384-KCMfKsP/3VgeibBQRMu4bT+9041Hi2v9PIz9FLOPJBEvxCBklc4o7tRwwQu4FWsT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EWJRWU7LQt+ri8YtDjTr8adATyP7y8DwlpE8zruoUC4nHNjtWZMU+iPYK+tFaV3U\";s:11:\"js/light.js\";s:71:\"sha384-0rp6k6cJIuLV1ORowDSSKr4VbEqb664PQUWdBvhJyt6IfkshVb0r6UlOkX6yVdaI\";s:13:\"js/regular.js\";s:71:\"sha384-Mw6yr+W+X+ckaAUbsPUb2BcU3Af9aSjmPMIlMr2iplN0VQIpscDWy/VwY5w0sz9w\";s:11:\"js/solid.js\";s:71:\"sha384-PyvJtlnGBA/R+hfVbHbnzfeT8G/iTORqPhR5WKGTQXlfmLe5bV+d64NECHG4sIMa\";s:14:\"js/v4-shims.js\";s:71:\"sha384-rJQjFeDWQReL3KmIeV81jB594CgKx/MmXyAgiuu88Jo253P+PSMgWzivZQtR6N6J\";}}}s:5:\"5.2.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ\";s:14:\"css/brands.css\";s:71:\"sha384-nT8r1Kzllf71iZl81CdFzObMsaLOhqBU1JD2+XoAALbdtWaXDOlWOZTR4v1ktjPE\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HbmWTHay9psM8qyzEKPc8odH4DsOuzdejtnr+OFtDmOcIVnhgReQ4GZBH7uwcjf6\";s:15:\"css/regular.css\";s:71:\"sha384-zkhEzh7td0PG30vxQk1D9liRKeizzot4eqkJ8gB3/I+mZ1rjgQk+BSt2F6rT2c+I\";s:13:\"css/solid.css\";s:71:\"sha384-wnAC7ln+XN0UKdcPvJvtqIH3jOjs9pnKnq9qX68ImXvOGz2JuFoEiCjT8jyZQX2z\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-jKeGgxY7zPT61fNXg6OMRDu8vsxOPRLMlgAIUHo1KVag4lyu5B03KsDLYOTMM4ld\";s:16:\"css/v4-shims.css\";s:71:\"sha384-W14o25dsDf2S/y9FS68rJKUyCoBGkLwr8owWTSTTHj4LOoHdrgSxw1cmNQMULiRb\";s:9:\"js/all.js\";s:71:\"sha384-4oV5EgaV02iISL2ban6c/RmotsABqE4yZxZLcYMAdG7FAPsyHYAPpywE9PJo+Khy\";s:12:\"js/brands.js\";s:71:\"sha384-4BRtleJgTYsMKIVuV1Z7lNE29r4MxwKR7u88TWG2GaXsmSljIykt/YDbmKndKGID\";s:17:\"js/fontawesome.js\";s:71:\"sha384-QcnrgQuRmocjIBY6ByWMmDvUg3HO4MSdVjY7ynJwZfvTDhVPPQOUI9TRzc6/7ZO1\";s:13:\"js/regular.js\";s:71:\"sha384-YdSTwqfKxyP06Jj3UzTeumv8M+Pme60+KND4oF+5r5VeUCvdkw7NhSzFYWbe00ba\";s:11:\"js/solid.js\";s:71:\"sha384-YmNA3b9AQuWW8KZguYfqJa/YhKNTwGVD5pQc1cN0ZAVRudFFtR17HR7rooNcVXe4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-rn4uxZDX7xwNq5bkqSbpSQ3s4tK9evZrXAO1Gv9WTZK4p1+NFsJvOQmkos19ebn2\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-TXfwrfuHVznxCssTxWoPZjhcss/hp38gEOH8UPZG/JcXonvBQ6SlsIF49wUzsGno\";s:14:\"css/brands.css\";s:71:\"sha384-Ei2oxwH0wpwmp7KPdhYnajC5fWDdMENOjDw9OfzWvcFcOGn0Egy+L5AAculaqBbD\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4eP+1rYQmuI3hxrmyE+GT/EIiNbF4R85ciN3jMpmIh+bU5Hz2IU7AdcVe+JS+AJz\";s:13:\"css/light.css\";s:71:\"sha384-pcDR01P1wNxsYZiEYdROCAYhU2u8VHOctLrYRonRFtkf/TGEQFWt0rqFbPGWlyn4\";s:15:\"css/regular.css\";s:71:\"sha384-g3XsWx0Sqi7JIjLKVnwUxEvqrxTMQPIf3PN+vTdWY2AhduP/rnj0rw89v0nbD4Ro\";s:13:\"css/solid.css\";s:71:\"sha384-B/E/KxBX31kY/5sew+X4c8e6ErosbqOOsA3t4k6VVmx8Hrz//v0tEUtXmUVx9X6Q\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-O6mvz45yC1vfdu/EgUxAoSGrP+sFtepMtj7eOQIW1G3WT9Sj5djActZC0hd/F42D\";s:16:\"css/v4-shims.css\";s:71:\"sha384-2QRS8Mv2zxkE2FAZ5/vfIJ7i0j+oF15LolHAhqFp9Tm4fQ2FEOzgPj4w/mWOTdnC\";s:9:\"js/all.js\";s:71:\"sha384-yBZ34R8uZDBb7pIwm+whKmsCiRDZXCW1vPPn/3Gz0xm4E95frfRNrOmAUfGbSGqN\";s:12:\"js/brands.js\";s:71:\"sha384-eg9wHuvEPj6+GlGomBRaMHLF0QfCnjdASWDKd84DMeM9phhyDaPFou/nHJBt0bz+\";s:17:\"js/fontawesome.js\";s:71:\"sha384-FQUuiJxt9F0hPc9IP3M5ndmqK53iBCGcy4ZSx8QirhYOIs8l7x+e1/zdswyZEigi\";s:11:\"js/light.js\";s:71:\"sha384-glAz6mCeiwAe/kHHHG/OvhrjA4+AH55ZfH8fwYp48YCY61POwUmOrH/oYOaF2Ujy\";s:13:\"js/regular.js\";s:71:\"sha384-8hKZY21U4J3r9N0GFl+24YnDkbRhs8y/nXT6BaZ+sOJDNmz+1DhFawE9UYL37XzB\";s:11:\"js/solid.js\";s:71:\"sha384-1j3ph9Rf+Aaz6rrizz6cdFxU9ZbUyvkbiwQ5+T/BY4I5mk37vUpTA8S9ZZOlfdWu\";s:14:\"js/v4-shims.js\";s:71:\"sha384-aoMjEUBUPf5GpXx1WJUeTZ/gBmGqQB1u8uUc2J5LW2xnQtJKkGulESZ+rkoj182s\";}}}s:5:\"5.3.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU\";s:14:\"css/brands.css\";s:71:\"sha384-rf1bqOAj3+pw6NqYrtaE1/4Se2NBwkIfeYbsFdtiR6TQz0acWiwJbv1IM/Nt/ite\";s:19:\"css/fontawesome.css\";s:71:\"sha384-1rquJLNOM3ijoueaaeS5m+McXPJCGdr5HcA03/VHXxcp2kX2sUrQDmFc3jR5i/C7\";s:15:\"css/regular.css\";s:71:\"sha384-ZlNfXjxAqKFWCwMwQFGhmMh3i89dWDnaFU2/VZg9CvsMGA7hXHQsPIqS+JIAmgEq\";s:13:\"css/solid.css\";s:71:\"sha384-VGP9aw4WtGH/uPAOseYxZ+Vz/vaTb1ehm1bwx92Fm8dTrE+3boLfF1SpAtB1z7HW\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-4K9ulTwOtsXr+7hczR7fImKfUZY5THwqvfxwPx1VUCEOt4qssi2Vm+kHY7NJQPoy\";s:16:\"css/v4-shims.css\";s:71:\"sha384-lmquXrF9qn7mMo6iRQ662vN44vTTVUBpcdtDFWPxD9uFPqC/aMn6pcQrTTupiv1A\";s:9:\"js/all.js\";s:71:\"sha384-kW+oWsYx3YpxvjtZjFXqazFpA7UP/MbiY4jvs+RWZo2+N94PFZ36T6TFkc9O3qoB\";s:12:\"js/brands.js\";s:71:\"sha384-2vdvXGQdnt+ze3ylY5ESeZ9TOxwxlOsldUzQBwtjvRpen1FwDT767SqyVbYrltjb\";s:17:\"js/fontawesome.js\";s:71:\"sha384-2OfHGv4zQZxcNK+oL8TR9pA+ADXtUODqGpIRy1zOgioC4X3+2vbOAp5Qv7uHM4Z8\";s:13:\"js/regular.js\";s:71:\"sha384-sqmLTIuB+bQgkyOcdJ/hAvXl51Z7qqdK/lcH/rt6sdvDKFincQWI+fVgcDZM6NMz\";s:11:\"js/solid.js\";s:71:\"sha384-GJiigN/ef2B3HMj0haY+eMmG4EIIrhWgGJ2Rv0IaWnNdWdbWPr1sRLkGz7xfjOFw\";s:14:\"js/v4-shims.js\";s:71:\"sha384-DtdEw3/pBQuSag11V3is/UZMjGkGMLDRBgk1UVAOvH6cYoqKjBmCEhePm13skjRV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-9ralMzdK1QYsk4yBY680hmsb4/hJ98xK3w0TIaJ3ll4POWpWUYaA2bRjGGujGT8w\";s:14:\"css/brands.css\";s:71:\"sha384-AOiME8p6xSUbTO/93cbYmpOihKrqxrLjvkT2lOpIov+udKmjXXXFLfpKeqwTjNTC\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Yz2UJoJEWBkb0TBzOd2kozX5/G4+z5WzWMMZz1Np2vwnFjF5FypnmBUBPH2gUa1F\";s:13:\"css/light.css\";s:71:\"sha384-9QuzjQIM/Un6pY9bKVJGLW8PauASO8Mf9y3QcsHhfZSXNyXGoXt/POh3VLeiv4mw\";s:15:\"css/regular.css\";s:71:\"sha384-pofSFWh/aTwxUvfNhg+LRpOXIFViguTD++4CNlmwgXOrQZj1EOJewBT+DmUVeyJN\";s:13:\"css/solid.css\";s:71:\"sha384-wJu5pIbEyJzi+kRgVKVQkPNKI104yNC+IAyK7XXEVGgPGe+LTEERIkpSZbc/wrOx\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hmg9TonawJaGH8ayFFnEBwvkx61BYLPAOV7b/YDGQEVIs1jh9pWQigAavMuD+Vc/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1YFoQoO5Em1oxLErpWpJuswiqPFVHl8HLDUaLjJGJH8+Nra/Y1D6uOZkEgfH5OZf\";s:9:\"js/all.js\";s:71:\"sha384-eAVkiER0fL/ySiqS7dXu8TLpoR8d9KRzIYtG0Tz7pi24qgQIIupp0fn2XA1H90fP\";s:12:\"js/brands.js\";s:71:\"sha384-am5AyalpQCEfbKe6FYiGZc2vX080nrcueZmrbkljxLdQDJ5q5Vu9QDROD/QefEp1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-u3o36ga3mMU6/lK/zdiER4h7pPtAK7wBuN0DrZPH22v01RZL8bKZkULIjxcx2/X/\";s:11:\"js/light.js\";s:71:\"sha384-2R0W5LA7dXp3ze/WhvjXlUcDaHRhtGlKYxN9QMhGDdjmj2EI1bub5ysSwofJwGfI\";s:13:\"js/regular.js\";s:71:\"sha384-EbI+OvKb7noKOfu8MSi/vCbi0KWlM61MjHDmRk4/vwJkPsMIRcJggYLDGWv7VeYY\";s:11:\"js/solid.js\";s:71:\"sha384-U4vTrZsQ4ooEtzL162EZfTtCiJNTXOwGDBzV91//DI5L/h48ibzHBiHJmPLpx2hO\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8e1r0+5VTqCqkg/9vG+cnipytzBkEh9fpESgVwBZAizMkWRfiaTkdhgdnhLGwuPd\";}}}s:5:\"5.4.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz\";s:14:\"css/brands.css\";s:71:\"sha384-Px1uYmw7+bCkOsNAiAV5nxGKJ0Ixn5nChyW8lCK1Li1ic9nbO5pC/iXaq27X5ENt\";s:19:\"css/fontawesome.css\";s:71:\"sha384-BzCy2fixOYd0HObpx3GMefNqdbA7Qjcc91RgYeDjrHTIEXqiF00jKvgQG0+zY/7I\";s:15:\"css/regular.css\";s:71:\"sha384-4e3mPOi7K1/4SAx8aMeZqaZ1Pm4l73ZnRRquHFWzPh2Pa4PMAgZm8/WNh6ydcygU\";s:13:\"css/solid.css\";s:71:\"sha384-osqezT+30O6N/vsMqwW8Ch6wKlMofqueuia2H7fePy42uC05rm1G+BUPSd2iBSJL\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-2MWWLQq91kFwloAny7gkgoeV33bD/cE3A9ZbB2rCN/YAAR/VEHVoDq6vRJJYTaxM\";s:16:\"css/v4-shims.css\";s:71:\"sha384-YIDcSvDDaIskj/WDlWwjrNdK194YAGWc1CScdo2tXl3IQVS1zS07xQaoAFlXCf1P\";s:9:\"js/all.js\";s:71:\"sha384-L469/ELG4Bg9sDQbl0hvjMq8pOcqFgkSpwhwnslzvVVGpDjYJ6wJJyYjvG3u8XW7\";s:12:\"js/brands.js\";s:71:\"sha384-lc/yFuYW3B0EW9B2QSpod2KeBxq6/ZizGwAW6mRLUe3kKUVlSBfDIVZKwKIz/DBg\";s:17:\"js/fontawesome.js\";s:71:\"sha384-ISRc+776vRkDOTSbmnyoZFmwHy7hw2UR3KJpb4YtcfOyqUqhLGou8j5YmYnvQQJ4\";s:13:\"js/regular.js\";s:71:\"sha384-SQqzt64aAzh3UJ9XghcA//GE8+NxAIRcuCrrekyDokXP6Bbt/FYAFlV6VSPrZKwH\";s:11:\"js/solid.js\";s:71:\"sha384-agDKwSYPuGlC0wD14lKXXwb94jlUkbkoSugquwmKRKWv/nDXe1kApDS/gqUlRQmZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/s2EnwEz7C3ziRundAGzeOAoGYffu84oY4SOHjhI/2Wqk3Z0usUm9bjdduzhZ9+z\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-POYwD7xcktv3gUeZO5s/9nUbRJG/WOmV6jfEGikMJu77LGYO8Rfs2X7URG822aum\";s:14:\"css/brands.css\";s:71:\"sha384-rmUpvtaCngUop5CYz7WL1LnqkMweXskxP+1AXmkuMSbImsUuy82bUYS4A8Syd3Pf\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PPeKwWhk5XZBVVq089DuhGmjaEVB1r+jdmx6jZrqzlef8ojhZXG+E/D6SP7uO1dk\";s:13:\"css/light.css\";s:71:\"sha384-DZAoxBcs4G15aUXLX4vKbO53ye8L8AB/zg07HOVhIMVclhx8rdWye0AJSQl51ehV\";s:15:\"css/regular.css\";s:71:\"sha384-xKPOvJDwdb/n5w2kh6cxds98Ae2d5N63xkIydEdoYeA2bxIKUmmyU9lZ9j58mLYS\";s:13:\"css/solid.css\";s:71:\"sha384-oT4lQmwnKx98HRnFgaGvgCdjtKOjep9CjfMdAOPtJU8Vy6NY3X34GfqL0H43ydJn\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-j2EtHJUHBAZF9vkmX0TSA/QqYMf0Npp9P2leJGZFDbLHbcI62HH8w7FRcUMNf8Q2\";s:16:\"css/v4-shims.css\";s:71:\"sha384-aaXKvb/d7l2hTm3ZDWCy5v4ct5zXIslt+70K4xalZPLu3ifrkYcG61m4u+DIQGEk\";s:9:\"js/all.js\";s:71:\"sha384-0+tugznPwCEvPiypW+OwmFjAQvRKlgI0ZZZW3nofNlLMmbYXbmNvfX/9up9XQSRs\";s:12:\"js/brands.js\";s:71:\"sha384-ShBqjf9lFG58e2NmhnbVlhAOPCWdzkPbBmAEcQ37Liu3TwOYxIizS7J1P3rRLJHm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8vKKeD0uIV/HXM5ym3RGB4O7rZ43fCdpiXqP047w7sEE3igcK0Y1U9ApEArcRBDJ\";s:11:\"js/light.js\";s:71:\"sha384-jlaccvPpizUbHU/8pYAsDEwhhBae8MUcYqHHsKkjFcFsEp3Y6LrVXh0GA84aAkTg\";s:13:\"js/regular.js\";s:71:\"sha384-MB7Bz/7e8sBWnZgblSLUfFOOi+V1PIkRG/Ex1NMeu0CovaXCzHyCMwAwOF+FAo1s\";s:11:\"js/solid.js\";s:71:\"sha384-KlTWIsOnBg7LJobQmLsv5fQ1qbx73K+o8/xhoUDoIba13SxF4bT5W2WgV3d8mZIw\";s:14:\"js/v4-shims.js\";s:71:\"sha384-e+EZ4XUeGXVd0FDmP/mFu7FFe+qVX738ayOS2AErNIPSLz5oZ3OgVa9zEyCds3HP\";}}}s:5:\"5.4.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-/rXc/GQVaYpyDdyxK+ecHPVYJSN9bmVFBvjA/9eOB+pb3F2w2N6fc5qB9Ew5yIns\";s:14:\"css/brands.css\";s:71:\"sha384-BCEeiNUiLzxxoeYaIu7jJqq0aVVz2O2Ig4WbWEmRQ2Dx/AAxNV1wMDBXyyrxw1Zd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HU5rcgG/yUrsDGWsVACclYdzdCcn5yU8V/3V84zSrPDHwZEdjykadlgI6RHrxGrJ\";s:15:\"css/regular.css\";s:71:\"sha384-OEIzojYBMrmz48aIjVQj7VG38613/sxpP58OW9h5zBYC7biGFlv9tyu5kWmaAYlF\";s:13:\"css/solid.css\";s:71:\"sha384-uKQOWcYZKOuKmpYpvT0xCFAs/wE157X5Ua3H5onoRAOCNkJAMX/6QF0iXGGQV9cP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+moUZLBX5mmeUnjaImkzlTo5cXyQWAvzbqQapNFd7+dGIaap0koo0rtfe8lHD38R\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SlbnWxwEHTVYxDLrpIRrG2BpsTpWALbJ6Tx5Fq+XNHRBL7xI6xwhVpuUGrrbLBXe\";s:9:\"js/all.js\";s:71:\"sha384-wp96dIgDl5BLlOXb4VMinXPNiB32VYBSoXOoiARzSTXY+tsK8yDTYfvdTyqzdGGN\";s:12:\"js/brands.js\";s:71:\"sha384-i1RNpxOOEnRm63Ii3TuV0aM8bJ+6Pv6XHpRSJbN7QlIzZIsl7m36R0GhOTTGN3F9\";s:17:\"js/fontawesome.js\";s:71:\"sha384-n1qPouQQJ9VNZnZeNZWSDiclpIOJwZBS2bkD6rEX+DTmMXTKXBVCZw2cGbU/I17z\";s:13:\"js/regular.js\";s:71:\"sha384-Uj7q9rRb3eJNp0j1kXwOBgEWDGbAiJ7Dcuz4hLRQdtza6pawbo/Bmwgr58THzHyR\";s:11:\"js/solid.js\";s:71:\"sha384-OQNCj138epg9A13jaL9L/d5vMlK2jyPL4aOgi37KYt07aZARbv/eFGp/wnrCxkW5\";s:14:\"js/v4-shims.js\";s:71:\"sha384-fzYnAZZYxpOQTjc3Y1eP04DGdMLAy+PeiZ8+ICh4FDLkJR/NJiAgKgK2vEpGx3au\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-zhaLg9HKxTxDljOPXpWHGn91XMDH+sYAWRSgvzHes290/ISyrNicGrd6BInTnx3L\";s:14:\"css/brands.css\";s:71:\"sha384-RjTk1OTKX8K8S4QfwhFOfbNSbQxLFgN6jqDw05QuBDDEbc/x6xlPtkPSO4vA1TtI\";s:19:\"css/fontawesome.css\";s:71:\"sha384-XkH+Vmez3OoFo52K+SkBE61xZ7vKh9tF35gL9Yf8rD3RtKUqIQGoTJTsLdR5u8rt\";s:13:\"css/light.css\";s:71:\"sha384-n0uyPlhqrQyWPPzm6+B9xDeZKCD81RgGRsTO7PQt3McgMXSR9zjhGaD5cXHwk+D8\";s:15:\"css/regular.css\";s:71:\"sha384-+OdrK32QtByk1ipA7b4+uLddrcWs2bx3nn37Dl5h98PW1AYKIrRZKveBl6AcpgcD\";s:13:\"css/solid.css\";s:71:\"sha384-SYCdBxlsgGngJi9eiKt5Tk6UtOJs1Jq5eU3yZDZ+hOe0GKk/obXhHy50IYVVdJro\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3f24zIRoR/ma/cnROK52rTVZpgCXKQ92/89RDq7GO7/9IxIl3VQV/tF6ecGgvUs8\";s:16:\"css/v4-shims.css\";s:71:\"sha384-ah4vMGE5UgKcCIB90FZl8BOcusXAVTm070n1UuOrNQA9QwkgnhqASrop/Oblr6wY\";s:9:\"js/all.js\";s:71:\"sha384-+lZy0zDh4RS9ZG6+Od6x6irKqoBH4NSy0m7IW8UGbzGZ/rupt9Cd9NdEb5S7+V9w\";s:12:\"js/brands.js\";s:71:\"sha384-LVdS6BqWBV1V0OyGzWK0HrGN4uDZbpO6hja1oVh86MhthieoER2crgKS/KsaiN8E\";s:17:\"js/fontawesome.js\";s:71:\"sha384-zMrS036pMtJ0Ukzo5x2YiTrYDGDaoeO8Yd0IHhI/PaEnfrY/nMHqvKME8C7dHhUE\";s:11:\"js/light.js\";s:71:\"sha384-hOiC7FL4572/E3aEEeWM6dF3ch/qFz59R91pAJqjYEKHBXN5u7e2oAYAgeSGF1VB\";s:13:\"js/regular.js\";s:71:\"sha384-f1yYCENdJ+9NE5J2T8weglyMCtTqRJOeGP9qaLwO43aYY0PVeuAfmsGgTegByFW6\";s:11:\"js/solid.js\";s:71:\"sha384-XlRgTEYU6HJ02+ZCuXW2/CgjnpV2+8FuQPTJSJ/+ZCQS5ZXRfIS5FHDRhMvOL++d\";s:14:\"js/v4-shims.js\";s:71:\"sha384-6TX+vqRZyQq+vB25wCb101/vY510EN37QZgs5f1dfG1+QYuIoQGdFFV8sx8W36AL\";}}}s:5:\"5.5.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU\";s:14:\"css/brands.css\";s:71:\"sha384-QT2Z8ljl3UupqMtQNmPyhSPO/d5qbrzWmFxJqmY7tqoTuT2YrQLEqzvVOP2cT5XW\";s:19:\"css/fontawesome.css\";s:71:\"sha384-u5J7JghGz0qUrmEsWzBQkfvc8nK3fUT7DCaQzNQ+q4oEXhGSx+P2OqjWsfIRB8QT\";s:15:\"css/regular.css\";s:71:\"sha384-z3ccjLyn+akM2DtvRQCXJwvT5bGZsspS4uptQKNXNg778nyzvdMqiGcqHVGiAUyY\";s:13:\"css/solid.css\";s:71:\"sha384-rdyFrfAIC05c5ph7BKz3l5NG5yEottvO/DQ0dCrwD8gzeQDjYBHNr1ucUpQuljos\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NKdowA6EzI4CWz/dLjoC7dhVj+KczesQbwkbt6y3aRTi1JPZBy2uOocsmHmYvkux\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TTjEZR8VsD+LjNa98drkrTRYhdUEaS3gAGE7PGnx2qkePR3fZtnVNoAfxPNyf+IQ\";s:9:\"js/all.js\";s:71:\"sha384-GqVMZRt5Gn7tB9D9q7ONtcp4gtHIUEW/yG7h98J7IpE3kpi+srfFyyB/04OV6pG0\";s:12:\"js/brands.js\";s:71:\"sha384-S2C955KPLo8/zc2J7kJTG38hvFV+SnzXM6hwfEUhGHw5wPo6uXbnbjSJgw3clO4G\";s:17:\"js/fontawesome.js\";s:71:\"sha384-bNOdVeWbABef8Lh4uZ8c3lJXVlHdf8W5hh1OpJ4dGyqIEhMmcnJrosjQ36Kniaqm\";s:13:\"js/regular.js\";s:71:\"sha384-XrvTJeiQ46fxxPrZP6fay5yejA2FV4G1XsS8E4Piz6Fz+7FaEFTw7A7GR972irVV\";s:11:\"js/solid.js\";s:71:\"sha384-Xgf/DMe1667bioB9X1UM5QX+EG6FolMT4K7G+6rqNZBSONbmPh/qZ62nBPfTx+xG\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vBDTb50BKnwbvJZ5ZC5dsGJNQydTI7ZoAjCeJkdta6nSewwGXCnppKI5lrIQX4Qu\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-j8y0ITrvFafF4EkV1mPW0BKm6dp3c+J9Fky22Man50Ofxo2wNe5pT1oZejDH9/Dt\";s:14:\"css/brands.css\";s:71:\"sha384-t0iPfoyIjBoVR2Kw/65HArpRWQy0/xKBUmdEVTs5VYBb/yiPZxMY6egc9MROr/Og\";s:19:\"css/fontawesome.css\";s:71:\"sha384-srL3Qh9R/n855m4o5fegS//B2q0R1md7z6ndDYaPj8iEp0j0IuKdFVWMY0JosKPF\";s:13:\"css/light.css\";s:71:\"sha384-33RmjeesW9BZ4wR2Gm3n4iBXOvGTto4znqL2kZleiRanWDxM59IHIq5RsbRioqxb\";s:15:\"css/regular.css\";s:71:\"sha384-UPs+YiUhgn0/I0swkJmk3PSj3SWmzDrM+S0S09xLI/UUmHBU7ivRHryI3uVL6H+m\";s:13:\"css/solid.css\";s:71:\"sha384-YIyAArzQv8q6Av1kr9cwxHhFcfNBUaolJindR2XO8E3OLp6z3d8My3oWLd33ET7M\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-a2sfkqnB9p/zq6OT4QhuD80qQZ70fGDmo4JUNqP5E7NIICvgRNPjIBkQE/Qcl3SN\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SNyDPad7e8WM4Nu7W/f1x3qsDrLxMCvXurQfwNdp418WWmkkTQuPBGYDZA6rSg0X\";s:9:\"js/all.js\";s:71:\"sha384-3yBLeJ4waqGSAf4A8pjZ13UF7GuhgbdKnBQvIp/TkWoXtQbtwjlIPNjkDRJ46UCn\";s:12:\"js/brands.js\";s:71:\"sha384-oMyy7aPCmlH4ZGEaKHW+zAoaKDWIFh6iqJ53lusMpn+Kp8SN5nJ2kzkP1qd0+icb\";s:17:\"js/fontawesome.js\";s:71:\"sha384-oPma1F1txBbqTG+1O7BEx0A/qFtD+R661ULJLmI9RDQ0PfbRP1tQU3vBIBbJIAxL\";s:11:\"js/light.js\";s:71:\"sha384-SVEn5VmGP1fxV9V5TOZOTwL9dCg50Yb0Xn4fbV9Ic/kp8we6kv4zPVcs9seU0675\";s:13:\"js/regular.js\";s:71:\"sha384-gbY/GPDSEaMQ9cjqWLbLcaxUCtCeExO9oUEZLrOQHfFLoV5ouwIrqF6mGnjyIOc2\";s:11:\"js/solid.js\";s:71:\"sha384-VxezC2Q+YoC+yUILib+HlmOsFiqNzYtQIXsHYY6ST7QZVfgBNs2giKE97ijGMgUH\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8sPM0eSaqmdF9ruedfsxEZfxVcIp0cwhosrBhWl/Q4t1eQSMXl6tYenNe87MraQ6\";}}}s:5:\"5.6.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-aOkxzJ5uQz7WBObEZcHvV5JvRW3TUc2rNPA7pe3AwnsUohiw1Vj2Rgx2KSOkF5+h\";s:14:\"css/brands.css\";s:71:\"sha384-oT8S/zsbHtHRVSs2Weo00ensyC4I8kyMsMhqTD4XrWxyi8NHHxnS0Hy+QEtgeKUE\";s:19:\"css/fontawesome.css\";s:71:\"sha384-J4287OME5B0yzlP80TtfccOBwJJt6xiO2KS14V7z0mVCRwpz+71z7lwP4yoFbTnD\";s:15:\"css/regular.css\";s:71:\"sha384-yWI8JeRmJFie/rrEn4skBd/XXXfUWuc7wAhaj9q71PzjdYD3JslHSEU7BXCCcVyP\";s:13:\"css/solid.css\";s:71:\"sha384-COsgLGwf6vbsibKzWojSqhIjQND/Sa0RWQ5BHFrKOz5JrUObnh5GEBUH2oZwITuM\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-nHELFCUV8tffuhz6PkFYcEl6VCneIQgaHNbLkOHukzJs12+rUiKwsVmVhbqhEAq7\";s:16:\"css/v4-shims.css\";s:71:\"sha384-HiCW4rrGA9WlUM512GMhD+YfcMidwWluZzyu+X55gfVYgAPrlIkG5BnHyAl/VHJO\";s:9:\"js/all.js\";s:71:\"sha384-z9ZOvGHHo21RqN5De4rfJMoAxYpaVoiYhuJXPyVmSs8yn20IE3PmBM534CffwSJI\";s:12:\"js/brands.js\";s:71:\"sha384-GEA3+tbEaglIUriKygE2OQX9k7YrAMJ5oZF0mb8Xx7hUmTTWDuQDtPY4l13jl99w\";s:17:\"js/fontawesome.js\";s:71:\"sha384-tHFnt8QELQGC1IJzcTUX5zFEnn/FLVa0ADTmxRyeSmWukJ4umWnJbwiMTkw/bKEK\";s:13:\"js/regular.js\";s:71:\"sha384-gy4pB6yY1j4DPCG6rZcE6NX1Lnqz8ZJEfotVUvCN2EGwlUS3WUHxcn8rrEOYiyiS\";s:11:\"js/solid.js\";s:71:\"sha384-akyniW0Jfrt1Z7kvRmaF2fkq9vuVQAPEGN4qq7s17l9PG3zz7FThoWnfVxpvnUn9\";s:14:\"js/v4-shims.js\";s:71:\"sha384-08SAgv7bDUyzB5O71dehOCZ42IpryGqW/G+GdxeFmBfaB71QIZWe5ZXBFKYFTEu4\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-rTQdcTFdT69CgbBErourkScWQ6j5WQ4aAoCF0UyPhog3PNysM/xz/kqshWKP4NLA\";s:14:\"css/brands.css\";s:71:\"sha384-84OQfm1oTwjnXmujNUnQC09L4G7mglZspQwfSNPvf5V3zAA1sdvqbIigA9AWY5DB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NFsDS9VURN70zaqw67F1OtJ6MtdeCrHeGMD1KzqIv5ft0JiHgVtV7u+v09yR+iEZ\";s:13:\"css/light.css\";s:71:\"sha384-aofICWgqJQbZZCaWEU7H0ULLqXTBu/DAALblEYqLfQSjb2ASOw0tADOdJ5rmVDWL\";s:15:\"css/regular.css\";s:71:\"sha384-voao2F8iKUwwSMRhLJ982edrRSHOmc5v5rvQ/5aH5pvSAx1aoL6usygGSRz3jfHF\";s:13:\"css/solid.css\";s:71:\"sha384-RYuivM1ikcxEL+96Q/7B/CcvyswPRuOatldvqvk+Bm3hwVKZUjay1ohuPUyD9ZYk\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NYMicmsVmKaI5/JVN8JamOLMuIrbzeu4Gc+cike3jcoDpaLfMtvWPJeNhnx8K8x0\";s:16:\"css/v4-shims.css\";s:71:\"sha384-L7wiz9NeFS+vFpG/jl0zBsE7EqrVfeNoaHhnvxlsfwihUr9FIbDnfQqv5r8o02wQ\";s:9:\"js/all.js\";s:71:\"sha384-rDdEqfkiaN9iEfS6XrBzTxL5wVFzBoMsyHmoAIl/T7VdxJvGYuM5bDlDOkmE6r3C\";s:12:\"js/brands.js\";s:71:\"sha384-TN18fDSDUbMxI3DK3z2G8Pl68N7jvVjWPBx8z0m7YhoWKnmGdKRJ6S90IcyeUXUy\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Oa9P+sg4Q/5Yo0a/UoRAG8zLSexWLxLgbPb12tgvs/swrfePVf6IdrwoW2RGV2pU\";s:11:\"js/light.js\";s:71:\"sha384-6DMqAgIR8HN9OqBF3zfhQ4Tmh+KO9Sf0QAwxGkiaKO51dFGBBxBTmdOSneYESZZ0\";s:13:\"js/regular.js\";s:71:\"sha384-LvwwgOzFfwTikawPye02NmwONhyBLBbmu04J+IuLBS6HdNHX3JnRqY80mscKVLTH\";s:11:\"js/solid.js\";s:71:\"sha384-71d190zi1266uo3WuvCJ77V1YdXxDfm5GPMySGFKTMHsoHaxKhPe5XkKaH9iPLWC\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Rr25noDuBAtBUFs9feRsF3EK8Pw5bWuhYxD7ztcDUJqR/eiCpNPGIeyO5Ago6pYW\";}}}s:5:\"5.6.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-gfdkjb5BdAXd+lj+gudLWI+BXq4IuLW5IT+brZEZsLFm++aCMlF1V92rMkPaX4PP\";s:14:\"css/brands.css\";s:71:\"sha384-whKHCkwP9f4MyD1vda26+XRyEg2zkyZezur14Kxc784RxUU1E7HvWVYj9EoJnUV7\";s:19:\"css/fontawesome.css\";s:71:\"sha384-WK8BzK0mpgOdhCxq86nInFqSWLzR5UAsNg0MGX9aDaIIrFWQ38dGdhwnNCAoXFxL\";s:15:\"css/regular.css\";s:71:\"sha384-l+NpTtA08hNNeMp0aMBg/cqPh507w3OvQSRoGnHcVoDCS9OtgxqgR7u8mLQv8poF\";s:13:\"css/solid.css\";s:71:\"sha384-aj0h5DVQ8jfwc8DA7JiM+Dysv7z+qYrFYZR+Qd/TwnmpDI6UaB3GJRRTdY8jYGS4\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ir31wc9kqVZclsGL3U5IucynDpj1TeEzDCvxEWqw8QuxLFETRgirOiygjXdjId3z\";s:16:\"css/v4-shims.css\";s:71:\"sha384-s0z+GcIRRdtdjGfnyKRFh9Oaw3aasU/TFotdFmreqjf+a+Mks2Umj0CrlN0S9lqi\";s:9:\"js/all.js\";s:71:\"sha384-R5JkiUweZpJjELPWqttAYmYM1P3SNEJRM6ecTQF05pFFtxmCO+Y1CiUhvuDzgSVZ\";s:12:\"js/brands.js\";s:71:\"sha384-rsLJp1pKbmeEMVcdsNJfAWZ9FQP5CrQt6Vikj/usZcTgrD28FhqYqKJn5XIaoXjm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-T6YzYwAGZAItTIkYlBzfwqa07o9R1AND3Lgt6Or6c5IdukY7tqShoryqwpKrpeIB\";s:13:\"js/regular.js\";s:71:\"sha384-+e+pqX41PD6VrFw9HZ3YKJHFT+SZoEMBmnMpLUpHrdd5BE46xHCrzap9c6kfTi9H\";s:11:\"js/solid.js\";s:71:\"sha384-8Lgyylu0vfTGCXDKe435hJgX8s96c19R+dvpH0NHKdX47GA7TmMj+BDiZZ76qqhT\";s:14:\"js/v4-shims.js\";s:71:\"sha384-LqOeBjW8oAuwB6xooSoyjAV+CcJLQGftH6m0Xoo+mhJ0TlEAVR9jBsAXXpeEJlyP\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-NJXGk7R+8gWGBdutmr+/d6XDokLwQhF1U3VA7FhvBDlOq7cNdI69z7NQdnXxcF7k\";s:14:\"css/brands.css\";s:71:\"sha384-2k7wpGHb3PA1OZUtSqAk+nIVo2wgBQdEoL1F/FnC+/HHi2bh3N9aSstY0Af72gka\";s:19:\"css/fontawesome.css\";s:71:\"sha384-GQK3B9PHv3SNzYUrdlEpL6CFKQlW/Co4va906SViL0F6U16Li47NXtvwWmFnetYk\";s:13:\"css/light.css\";s:71:\"sha384-QXb14MpvHKJr57ixwhGSXACaU/eGo/NwF/uWE97+C5QPdq8sLQhM1+WKDk6vando\";s:15:\"css/regular.css\";s:71:\"sha384-ThqFFlbk+2bnAn1zc61SL7r8sFUVUkFvtsT+jYr1Jy6xTlvdcqzcerrDGrHqWv6j\";s:13:\"css/solid.css\";s:71:\"sha384-pbj30780YbUh3WmbEAhOL8tHgoaU4xrdmAN+RewL6HsW9EOMIIE4+6rerMXTfJXq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-fjim8BUuF/D2Y8Qyr4U5iLdeKqzyQe927qD4SIdbPDyX2iSN6xNGhoyd2jTiw+Sx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-c2aTxrKw0nWEPlLqENAD5t3J3Ajs/o5LBudKFP44hexDYKKQTgRCAaECkBk+p3L9\";s:9:\"js/all.js\";s:71:\"sha384-ncMWtRMSOo+cLmfdaa6vmMGzBJKysBDF9tq5YK1MAnAjcyipdW2vgTS1jOntY4fs\";s:12:\"js/brands.js\";s:71:\"sha384-+4YdTIsot+hvYL7nKQ9cJs7OWaFvJ7ZTkVretfEoX8uDiTED9tumG/9RsRmlW3jX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ya+lFT8MCnVaSXkMxO4FEUsv4BG1VrVAMY0PiCnmJ4Sq57zoarae8T2EgioHiaMA\";s:11:\"js/light.js\";s:71:\"sha384-hy7ipunNmCKP7KpzkasGow2eTRYx9IbxV0BvBqlWLWRu8mlWMNrj9y6qOLEnxIuF\";s:13:\"js/regular.js\";s:71:\"sha384-8VWoI12VOwcfxYszEUreYXR4Jh1+oxv+mfsVISgPJTsc2Ftw4RC+bO719C+PunjY\";s:11:\"js/solid.js\";s:71:\"sha384-Pl3KUQLNwa33i6dvnL77HMDxZPk93eoi1kB5xZ0eGKgTEt39iQkHdSM6/w53By9e\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ts+GFi6rOAISeHC+EnLaj6AOSoosWr3TALIaYSeHCVsNHkGLlTtzdbMvolIe6tG7\";}}}s:5:\"5.6.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-UHRtZLI+pbxtHCWp1t77Bi1L4ZtiqrqD80Kn4Z8NTSRyMA2Fd33n5dQ8lWUE00s/\";s:14:\"css/brands.css\";s:71:\"sha384-1KLgFVb/gHrlDGLFPgMbeedi6tQBLcWvyNUN+YKXbD7ZFbjX6BLpMDf0PJ32XJfX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jLuaxTTBR42U2qJ/pm4JRouHkEDHkVqH0T1nyQXn1mZ7Snycpf6Rl25VBNthU4z0\";s:15:\"css/regular.css\";s:71:\"sha384-aubIA90W7NxJ+Ly4QHAqo1JBSwQ0jejV75iHhj59KRwVjLVHjuhS3LkDAoa/ltO4\";s:13:\"css/solid.css\";s:71:\"sha384-+0VIRx+yz1WBcCTXBkVQYIBVNEFH1eP6Zknm16roZCyeNg2maWEpk/l/KsyFKs7G\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-KHV7fADs212mr+U2tmuDnxozv2BzTX1qhxPoZ/lT2QcUFkjwat694MI3AzyiVJ+q\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-EIHISlAOj4zgYieurP0SdoiBYfGJKkgWedPHH4jCzpCXLmzVsw1ouK59MuUtP4a1\";s:12:\"js/brands.js\";s:71:\"sha384-VLgz+MgaFCnsFLiBwE3ItNouuqbWV2ZnIqfsA6QRHksEAQfgbcoaQ4PP0ZeS0zS5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-treYPdjUrP4rW5q82SnECO7TPVAz4bpas16yuE9F5o7CeBn2YYw1yr5oC8s8Mf8t\";s:13:\"js/regular.js\";s:71:\"sha384-V+AkgA1cZ+p3DRK63AHCaXvO68V7B5eHoxl7QVN21zftbkFn/sGAIVR7vmQL3Zhp\";s:11:\"js/solid.js\";s:71:\"sha384-F4BRNf3onawQt7LDHDJm/hwm3wBtbLIfGk1VSB/3nn3E+7Rox1YpYcKJMsmHBJIl\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-LRlmVvLKVApDVGuspQFnRQJjkv0P7/YFrw84YYQtmYG4nK8c+M+NlmYDCv0rKWpG\";s:14:\"css/brands.css\";s:71:\"sha384-1KLgFVb/gHrlDGLFPgMbeedi6tQBLcWvyNUN+YKXbD7ZFbjX6BLpMDf0PJ32XJfX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-toEUmnrGu+eq8XUD6ovsr/vFX+R3v9+FUGAnpef+uwGKMCeqZkcZfkXQ0Pls5WS7\";s:13:\"css/light.css\";s:71:\"sha384-ouQ4uivIto2ZdBS6+torZMbImJhWA6/m7/CAGY9z0FNDmoAF6uWAEnavvIsR1EBt\";s:15:\"css/regular.css\";s:71:\"sha384-IXqJGQI1K0IzdpdY2ASrRbDgPr1rUKzDAA90uL7iX1hPQf6Tkve9Z82TUVWm9aje\";s:13:\"css/solid.css\";s:71:\"sha384-5XPOduYq6F78ZOuHxFHpQJCD2l7aCHCf0+o8qKTD2VfqJTgPT3YkyuBGsDSrVsic\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-KHV7fADs212mr+U2tmuDnxozv2BzTX1qhxPoZ/lT2QcUFkjwat694MI3AzyiVJ+q\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-4Gm0M5DjJ0zGaEtLu0ztNIoHWiuJ5rKiaVlpZKeNqXAW49eIIa2ymxb3C4c3uEXR\";s:12:\"js/brands.js\";s:71:\"sha384-VLgz+MgaFCnsFLiBwE3ItNouuqbWV2ZnIqfsA6QRHksEAQfgbcoaQ4PP0ZeS0zS5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-treYPdjUrP4rW5q82SnECO7TPVAz4bpas16yuE9F5o7CeBn2YYw1yr5oC8s8Mf8t\";s:11:\"js/light.js\";s:71:\"sha384-E2rKHkorMllWJmt2GKXlwZ3+kPl6i3FrJ8ihFkf6F7F/AtGvuXY21bQC8mhz2Po+\";s:13:\"js/regular.js\";s:71:\"sha384-nX7teCj1FtQErhxXjr+JWXfe4EjU6KlgeVBHAzQ/L95eWzwx+W1+HuQGmxZT9VkS\";s:11:\"js/solid.js\";s:71:\"sha384-2ZaaAuh8tTVN1nHRrlXAX1tz8fGhZDgusJdBI5BBGycCq37AUonw8dHlPpx7iD6N\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-qD/MNBVMm3hVYCbRTSOW130+CWeRIKbpot9/gR1BHkd7sIct4QKhT1hOPd+2hO8K\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-av0fZBtv517ppGAYKqqaiTvWEK6WXW7W0N1ocPSPI/wi+h8qlgWck2Hikm5cxH0E\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-uyhTADGMAJuHgGNdH+rozTpOkfXUORTgjTmMBtxR8ISQjOs+IIWb8UBn9ixSd4xo\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-av0fZBtv517ppGAYKqqaiTvWEK6WXW7W0N1ocPSPI/wi+h8qlgWck2Hikm5cxH0E\";s:11:\"js/light.js\";s:71:\"sha384-Vs12SjRkIvphC81scjUNowpLYnSOLOrSGxOwVe00oEvWto49wVgjd6BfdeCPcArI\";s:13:\"js/regular.js\";s:71:\"sha384-JZmzMsvgUATRcNmXpyJHLhiqsREsPN/GBj7O5ifVfRU1o4vBp2dsjawGzYzl0QVW\";s:11:\"js/solid.js\";s:71:\"sha384-OzCiQJ65BS/RiwFjTWyem+uRtZ4/LnrVVbwHTT8fR5Q9rYqAaavyOK51RDxkXQzm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-eVEQC9zshBn0rFj4+TU78eNA19HMNigMviK/PU/FFjLXqa/GKPgX58rvt5Z8PLs7\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Qmms7kHsbqYnKkSwiePYzreT+ufFVSNBhfLOEp0sEEfEVdORDs/aEnGaJy/l4eoy\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-5atZgfYD4MHp6kAnxjw4yM3binN4Yh5XXKAIO6m2kIB9CqdRUladdvTdffLnTK3N\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Qmms7kHsbqYnKkSwiePYzreT+ufFVSNBhfLOEp0sEEfEVdORDs/aEnGaJy/l4eoy\";s:11:\"js/light.js\";s:71:\"sha384-ua13CrU9gkzyOVxhPFl96iHgwnYTuTZ96YYiG08m1fYLvz8cVyHluzkzK9WcFLpT\";s:13:\"js/regular.js\";s:71:\"sha384-SdSeoV46BZSFmxvlUQwl3ImF6ton2ST4pPzYOmTTkFUm+UjdzORM0pTtF0sIHydx\";s:11:\"js/solid.js\";s:71:\"sha384-eLZVpmyzMTRsfwRGkcmyu0PXR5qqYDBCSh5PoYLdWFfDmMIibSuru0Blk+nq1Vfm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-0pzryjIRos8mFBWMzSSZApWtPl/5++eIfzYmTgBBmXYdhvxPc+XcFEk+zJwDgWbP\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-xl26xwG2NVtJDw2/96Lmg09++ZjrXPc89j0j7JHjLOdSwHDHPHiucUjfllW0Ywrq\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-I3Hhe9TkmlsxzooTtbRzdeLbmkFQE9DVzX/19uTZfHk1zn/uWUyk+a+GyrHyseSq\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-xl26xwG2NVtJDw2/96Lmg09++ZjrXPc89j0j7JHjLOdSwHDHPHiucUjfllW0Ywrq\";s:11:\"js/light.js\";s:71:\"sha384-ua13CrU9gkzyOVxhPFl96iHgwnYTuTZ96YYiG08m1fYLvz8cVyHluzkzK9WcFLpT\";s:13:\"js/regular.js\";s:71:\"sha384-SdSeoV46BZSFmxvlUQwl3ImF6ton2ST4pPzYOmTTkFUm+UjdzORM0pTtF0sIHydx\";s:11:\"js/solid.js\";s:71:\"sha384-eLZVpmyzMTRsfwRGkcmyu0PXR5qqYDBCSh5PoYLdWFfDmMIibSuru0Blk+nq1Vfm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.8.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-Mmxa0mLqhmOeaE8vgOSbKacftZcsNYDjQzuCOm6D02luYSzBG8vpaOykv9lFQ51Y\";s:14:\"css/brands.css\";s:71:\"sha384-5G2m52y/zN053yjBCyNXXotYpL2r5k1wg9aakiM5OgK9kdcCB68EECUce5vZiz/8\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Sbwc59I1SOoVoCGgBCwAe/M1j5a9cHixHv/7x9vOxORnT73jUaxyK0paobkk3JSt\";s:15:\"css/regular.css\";s:71:\"sha384-Vma7aWQBdmjVfr98uRd1HcA/r6wPYrlNrIvQBJhDCvZi3X9gVuHtqUKUYep/1KKk\";s:13:\"css/solid.css\";s:71:\"sha384-n4xPrkfCJ3FzmPwM/Nf1QQu7Qx6oDcsbMp+qPOxrJ5w0Tq19ZWd9ylcMWkzKEpwP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-5ywFB7dcUP6RcAWMLvCE58MQE5YMXWSPjly1IqItdN0w0TqoJD+w68U7C3ShoZRk\";s:16:\"css/v4-shims.css\";s:71:\"sha384-IaQiZkMW7NRKIS04GeT98++WyQ6RNaEQlHoHoDrhU+hhCJE4EkfL7itJyj/vanQT\";s:9:\"js/all.js\";s:71:\"sha384-ukiibbYjFS/1dhODSWD+PrZ6+CGCgf8VbyUH7bQQNUulL+2r59uGYToovytTf4Xm\";s:12:\"js/brands.js\";s:71:\"sha384-Gt4maPu5ZO/PkTh32sKMYmmCLGuWtMkv5YBtFZpx4Tu+Of3kFZPYBw9iD/pi4L6s\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TAztyRuTlqgZ97tz982rMo44MRC58wyCC0pqKZY3cKWJNkK00qMd3DhQ7R25jpCe\";s:13:\"js/regular.js\";s:71:\"sha384-IQnlolMpq26nEj6AOd6JOnY2jqCa69uFBqCGBCWSm4EFZYprebVtp3Z2xVLMElvs\";s:11:\"js/solid.js\";s:71:\"sha384-prcFDC6iTvvWsx2iSZtbDdeMVWWOtxcQXXagr9uPHwi42uae31Y3Q17eehHuC0JL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-l9bFz0TmR1ecMQdb9mzBeiLLX3z0mqeK0Bsxhim3nnHB9PoA6o3FUumLH7K6W6/D\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-/pOR6TNYPdUaQQQRKQ4XHznZ4U2K/Lscb3u6jshUngC/31fLTuyX9FZb24gp4O3J\";s:14:\"css/brands.css\";s:71:\"sha384-OxPYtFc8yWHWBo2MFY4rHs5dKcTpNGuyft0hQ+K/vSUJA21jrxi+Py412o2wMvsL\";s:19:\"css/fontawesome.css\";s:71:\"sha384-/0C3VuTlEzBany89/Wf2OJLSGrduLCC28kuoGL/PCGJjGj01pVtiqOcgZZ9AtlET\";s:13:\"css/light.css\";s:71:\"sha384-YmipRqYc8Wly1koaxcpAPTnvJIqXBN4Ue5+l0drZn34sdM+UufP6v8D8/s9xxXOI\";s:15:\"css/regular.css\";s:71:\"sha384-iUhpWyroENmdb/oNEGUdCk4J+TfFOm/SNYi79nN/Hb1aQgjofylAAuRTUfpK2yP1\";s:13:\"css/solid.css\";s:71:\"sha384-maIT5Qg1FqlJhNYpN2IgLAb5XPLY8CqZ7tKBQyjHh+nx/7JXsI5bp+8JHnUgeuyw\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-BUeh/IoVXY+o863GdrQzogOOSo3ABFpxuc9xZhQVnsM2T2vKmrpHGZwaEqqX/SZs\";s:16:\"css/v4-shims.css\";s:71:\"sha384-lRITDKAHusCdCcsQiEA2IIoqExMRD36Tbn9CZj00L8klRpDyMeOoPSv6ubcNAHux\";s:9:\"js/all.js\";s:71:\"sha384-gUdv3ElxXd3gVdbCqjppYoQanRONrQDSdaZY3zn1KeASeS8YGy+T/JDaD2ohyarV\";s:12:\"js/brands.js\";s:71:\"sha384-XLy4uPbRNbMJUgEm6JLmHI784E68XjgSbheIn0fP/6GdZtCcsZmlXvceAGvhzKCh\";s:17:\"js/fontawesome.js\";s:71:\"sha384-aoV9M7ZLyivlmo8GKrkeWiOUQzBnYBpP6U8gW7WXfhssy+HtO87KzowcBokSiK3g\";s:11:\"js/light.js\";s:71:\"sha384-+itlrN2dvS1RqmWnkLQkDqzANbdKqtt6JyQfE/DXxFnhg/PXf0ufRBCSp0c6q81i\";s:13:\"js/regular.js\";s:71:\"sha384-GoKOHat5yLSUYiGMfLJkuCErUZrNlW+2FeFYuKOt7sUWbqvMQOqfB+mdpfCU/8Q4\";s:11:\"js/solid.js\";s:71:\"sha384-jOmpRjxTFmJAVhf7+H7o9joWtQWHRZLdr+B25WojM1yfhB9wFkDvQ3x0VDDn4aAI\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gaNKDFtFZuAyZDkB8Wov1Vl24lMu5MD5MXLmUSu+4HzB8tTVwemJnhqN4Zuj27wd\";}}}s:5:\"5.8.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf\";s:14:\"css/brands.css\";s:71:\"sha384-n9+6/aSqa9lBidZMRCQHTHKJscPq6NW4pCQBiMmHdUCvPN8ZOg2zJJTkC7WIezWv\";s:19:\"css/fontawesome.css\";s:71:\"sha384-vd1e11sR28tEK9YANUtpIOdjGW14pS87bUBuOIoBILVWLFnS+MCX9T6MMf0VdPGq\";s:15:\"css/regular.css\";s:71:\"sha384-FKw7x8fCxuvzBwOJmhTJJsKzBl8dnN9e2R4+pXRfYoHivikuHkzWyhKWDSMcGNK8\";s:13:\"css/solid.css\";s:71:\"sha384-QokYePQSOwpBDuhlHOsX0ymF6R/vLk/UQVz3WHa6wygxI5oGTmDTv8wahFOSspdm\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-acBDV8BDMPEP50gJeFdMIg9yE8eOPuFdBV9r+2F492NUbKhURdQvglFkG0Q+0rlE\";s:16:\"css/v4-shims.css\";s:71:\"sha384-knhdgIEP1JBPHETtXGyUk1FXV22kd1ZAN8yyExweAKAfztV5+kSBjUff4pHDG38c\";s:9:\"js/all.js\";s:71:\"sha384-g5uSoOSBd7KkhAMlnQILrecXvzst9TdC09/VM+pjDTCM+1il8RHz5fKANTFFb+gQ\";s:12:\"js/brands.js\";s:71:\"sha384-rUOIFHM3HXni/WG5pzDhA1e2Js5nn4bWudTYujHbbI9ztBIxK54CL4ZNZWwcBQeD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EMmnH+Njn8umuoSMZ3Ae3bC9hDknHKOWL2e9WJD/cN6XLeAN7tr5ZQ0Hx5HDHtkS\";s:13:\"js/regular.js\";s:71:\"sha384-Uc9toywOA44owltk1MWl0lQZ+L0mBzJkLQcdif6+JtG9izvok9DLJtCZX57Uq3k2\";s:11:\"js/solid.js\";s:71:\"sha384-IA6YnujJIO+z1m4NKyAGvZ9Wmxrd4Px8WFqhFcgRmwLaJaiwijYgApVpo1MV8p77\";s:14:\"js/v4-shims.js\";s:71:\"sha384-DWlD0qU0+4WTFKXrFbt8wXq/1NHvOGT8vwllYM0W2gIeqgaCC3bZ0U464mDtbR70\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-Bx4pytHkyTDy3aJKjGkGoHPt3tvv6zlwwjc3iqN7ktaiEMLDPqLSZYts2OjKcBx1\";s:14:\"css/brands.css\";s:71:\"sha384-9Wenwezdk1eEhfcpps+Heco4zWw6KuZ2VlevoPomUwWYYZd3nBX0kZ1hBV2zSIKF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4HqGlagEHMyfaDQVabl1wx7GCtGw6hDl3sKJEhqQjOCrXrvizhaA2j4hK8Piewtr\";s:13:\"css/light.css\";s:71:\"sha384-3SMOAKCN8LYSMjkWz1ChDg4pHSLtD+LuKXaZoHxE1oyDneLR6Ebjm3XHMHO9fWu3\";s:15:\"css/regular.css\";s:71:\"sha384-ELBQxbOyxSZRtZPNO1mVgYkEzMOXFNmQY6CLV1nw+4IZoiHWeuwYTnABxPxxsuBE\";s:13:\"css/solid.css\";s:71:\"sha384-MkkthiFx7890Rev6vwUJO4gRT4yuH5tqMm/Wl4/n9/qptaBpiGcMyjfgq2K4h394\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-LnvOeE4ntog9dzgq63i0OoI6jKPp3p0y693Fh4Fd4eOyx/UsAw0kHXbLKqML1p9R\";s:16:\"css/v4-shims.css\";s:71:\"sha384-68zdIccmue/irEHOgRiyNsWTZAGftSb6RkEtUhgaD+8213AXnbThq7m3WsO+B02H\";s:9:\"js/all.js\";s:71:\"sha384-GBwm0s/0wYcqnK/JmrCoRqWYIWzFiGEucsfFqkB76Ouii5+d4R31vWHPQtfhv55b\";s:12:\"js/brands.js\";s:71:\"sha384-b4zU5X+9uCyU5wpeWBsEIFph6tTD8ERLbUs93uYGQGNqzbcfPDeY6c4jMhTAfBri\";s:17:\"js/fontawesome.js\";s:71:\"sha384-w6QYwIdCVqcYkHtaFutVu3VlDeu+pBFvlp7e0/tygMFwnWTl13KuVYfsp0ediPpA\";s:11:\"js/light.js\";s:71:\"sha384-avwGKnev1pyXYEbWxXSg9S4rpTsws+5vQpoj76SfcccEzOL162Ei8+z4a6AlaMeE\";s:13:\"js/regular.js\";s:71:\"sha384-lv9QOXVC8fPRX14JTtgPGx1JjQPfjnqnp+bTlEnrW2FRawdJ4V8oe4Yq4kdfgJIp\";s:11:\"js/solid.js\";s:71:\"sha384-sJjbbGVKgAaulHq0KZK5MsUx9YmPj+4G3oY2vmW12iBNEFkkhObBezK0ZhSXchIs\";s:14:\"js/v4-shims.js\";s:71:\"sha384-J8Vif9iMSqb5RK45yq6+dnrM1lTP1oQcIHtKpoH0irzUJD/1gCK0pQgIr0hO+hta\";}}}s:5:\"5.8.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-oS3vJWv+0UjzBfQzYUhtDYW+Pj2yciDJxpsK1OYPAYjqT085Qq/1cq5FLXAZQ7Ay\";s:14:\"css/brands.css\";s:71:\"sha384-i2PyM6FMpVnxjRPi0KW/xIS7hkeSznkllv+Hx/MtYDaHA5VcF0yL3KVlvzp8bWjQ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-sri+NftO+0hcisDKgr287Y/1LVnInHJ1l+XC7+FOabmTTIK0HnE2ID+xxvJ21c5J\";s:15:\"css/regular.css\";s:71:\"sha384-hCIN6p9+1T+YkCd3wWjB5yufpReULIPQ21XA/ncf3oZ631q2HEhdC7JgKqbk//4+\";s:13:\"css/solid.css\";s:71:\"sha384-ioUrHig76ITq4aEJ67dHzTvqjsAP/7IzgwE7lgJcg2r7BRNGYSK0LwSmROzYtgzs\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PLvJTjM1QH/74H66d1I1vU8KYsjkbjSJn87gUIUsIO6Xjf8fRO8Hxdevr46EkV7M\";s:16:\"css/v4-shims.css\";s:71:\"sha384-XyBa62YmP9n5OJlz31oJcSVUqdJJ1dgQZriaAHtKZn/8Bu8KJ+PMJ/jjVGvhwvQi\";s:9:\"js/all.js\";s:71:\"sha384-DJ25uNYET2XCl5ZF++U8eNxPWqcKohUUBUpKGlNLMchM7q4Wjg2CUpjHLaL8yYPH\";s:12:\"js/brands.js\";s:71:\"sha384-GtvEzzhN52RvAD7CnSR7TcPw555abR8NK28tAqa/GgIDk59o0TsaK6FHglLstzCf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ia7KZbX22R7DDSbxNmxHqPQ15ceNzg2U4h5A8dy3K47G2fV1k658BTxXjp7rdhXa\";s:13:\"js/regular.js\";s:71:\"sha384-iFYyWQkY/Zvsdq3IIxRJI2FBoXPj6g73ok7rIH3sZGulA7E5PvFqB5BOELomUuyh\";s:11:\"js/solid.js\";s:71:\"sha384-+2/MEhV42Ne5nONkjLVCZFGh5IaEQmfXyvGlsibBiATelTFbVGoLB1sqhczi0hlf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-5i8QG9UXrCZePXfj1ac87dq22tNtGoJ22fmjXaJI8iIy072+ZKv1NZHbsTMfYvnV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-xVVam1KS4+Qt2OrFa+VdRUoXygyKIuNWUUUBZYv+n27STsJ7oDOHJgfF0bNKLMJF\";s:14:\"css/brands.css\";s:71:\"sha384-BeZiOfMYSXjscewXEIJ0PDoBy27u+zVSTP5ZuW3kjEZKCn7pOB7v+oQVtAtHfY0v\";s:19:\"css/fontawesome.css\";s:71:\"sha384-fqilzf6i0kkOYm+DT4UC9pWzYf4/eFdJKroY1jZyE7n8eYLujyYM9VCucGf/LdVD\";s:13:\"css/light.css\";s:71:\"sha384-0WqtEOayxoyo7wgxUc5l2RvIbaWTyny0LrJbwsKhrKXUyopxvaNFLIoob4dXRwLO\";s:15:\"css/regular.css\";s:71:\"sha384-jyNdSTwsauV6/i9u6sKFOZBrxlr4QREAY295HsNy8laz4LYryhnPdz0ewFVERKfV\";s:13:\"css/solid.css\";s:71:\"sha384-dUUyoHgD2BplZp1AnRbRu0HPC5jscpJEJaJjqnBh7Y5PT1gW7cM6BQEgrcOsSa7e\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+BcpgpzTfqttc/C2LUPzGXIGunaa/aIuSC/BPO2BBqqMbHNRCF7d3DU54LxbCzTS\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TpRSvWoRbPKMMxDvVZgEa9wxoOZyawahRkC2P+ksDRxjPSvZjhEf5nU7pqSWBCQF\";s:9:\"js/all.js\";s:71:\"sha384-RLPiEwcAdrH2NjFcwJipJtlFoIN1xvqPYeeDX5yYtSNu+HTIkQCDvPQ9thsUnPUS\";s:12:\"js/brands.js\";s:71:\"sha384-NBtHk407eZGNubj82MbaKt5CrNLfhnYmCbpjSyDk/nWemMXE/mfvm3c1MPjfnWmU\";s:17:\"js/fontawesome.js\";s:71:\"sha384-b7K10RWf2Q3m26zPrKzM95th5yJnxEw+vpCzNITZFKV8UgxPgHb61bS0xFkKdV2I\";s:11:\"js/light.js\";s:71:\"sha384-BMiulaMo0kY9ExzwDFFjsXkU373Br7qSwYa/hdDlWEWEkE3flk4mBFvMwlpye3Aw\";s:13:\"js/regular.js\";s:71:\"sha384-uMEQdPXvyCTabszTyCxRRMDh/xIcRlT/fpq2DKkcjR6+lOqq2111EL0C1OiRVu1E\";s:11:\"js/solid.js\";s:71:\"sha384-9fQzIUDeLlrPRI2CT9AqVv6Yr0JgEY0+rr7ngyaatQAQrEHhCv5CvG8F8UFdgk7u\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Ts0FauTmSRKZNl+Uw+WC04UuoVYd2gXlJ+OcUvb1NDrV2XmDcgCr8PPv5MY/7KZR\";}}}s:5:\"5.9.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-i1LQnF23gykqWXg6jxC2ZbCbUMxyw5gLZY6UiUS98LYV5unm8GWmfkIS6jqJfb4E\";s:14:\"css/brands.css\";s:71:\"sha384-vfTtNoEyqnxivzqkzc+mvlVeCWPGwMlIIkeTkt0mcUQNmFLyyXxY5SgZIkKQIXRK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NnhYAEceBbm5rQuNvCv6o4iIoPZlkaWfvuXVh4XkRNvHWKgu/Mk2nEjFZpPQdwiz\";s:15:\"css/regular.css\";s:71:\"sha384-5E/NXotaQSDJW8gq/9pxwQHSPRrb21suHuLPqOIlgob8QC8ltM13i6HLujrhWmBL\";s:13:\"css/solid.css\";s:71:\"sha384-ypqxM+6jj5ropInEPawU1UEhbuOuBkkz59KyIbbsTu4Sw62PfV3KUnQadMbIoAzq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Bfk4oyOug+rBqsciYilQ+iwazXsMTURz/M6Gfx7fb02KNeW5VHwt7aHTXWNU9B2W\";s:16:\"css/v4-shims.css\";s:71:\"sha384-zpflLcSaYRmTsnK2LTOdvChgML+Tt/4aE2szcblLVBXd8Jq/HGz6rhZqZ+4TkK75\";s:9:\"js/all.js\";s:71:\"sha384-7Gk1S6elg570RSJJxILsRiq8o0CO99g1zjfOISrqjFUCjxHDn3TmaWoWOqt6eswF\";s:12:\"js/brands.js\";s:71:\"sha384-CZZj1HZWqgh/CGR22Lnl6+fZC6IDR10ga+wECjipCR3zId+7ZxZP1JNI+YgdzyO/\";s:17:\"js/fontawesome.js\";s:71:\"sha384-RXRrB6R44g3RRohoKLAOK5MjNq4PVvz7iZErCckeyobGIJLpTP2qq6xjJFuKnfZu\";s:13:\"js/regular.js\";s:71:\"sha384-xrLv+W4OudHJZ6QDKuv+el28Wyr4OMO0qSQuBiPqhBsnSGKdGct/ElQm+2/fx/eS\";s:11:\"js/solid.js\";s:71:\"sha384-kDWpGOpzLEy85/cK1Df/ba6PkpDHAKUGOX4YHEt0sFzHdrTY1rGmT/gYHN3zCcF0\";s:14:\"js/v4-shims.js\";s:71:\"sha384-npD7syUhXOZUTbAzJEyIPGq/8gGAhBmei7JkUwUki9hAtz9oPkFJwx5f3vGb7SOi\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-vlOMx0hKjUCl4WzuhIhSNZSm2yQCaf0mOU1hEDK/iztH3gU4v5NMmJln9273A6Jz\";s:14:\"css/brands.css\";s:71:\"sha384-wRa49NRotGDh34aLO1Hjbu65qHSTF/ZNSBm7uTpMUa2EQ1Csq7Zlswm+FR9hcWtn\";s:19:\"css/fontawesome.css\";s:71:\"sha384-QSCxeayZXa6bvOhHReoQRGN7utvnOnY3JoBHGxM61JQQ1EXA7AT3m7dnlHXLhnCj\";s:13:\"css/light.css\";s:71:\"sha384-/ggAGHSQWxssDRflcj0aeAlGN2rNgsnWOLv1ZU5FEvjQWxP53glq5pNPjtfldVVN\";s:15:\"css/regular.css\";s:71:\"sha384-FrLF2uGffV1P93pQZme192v/cHRu1XlgjMreWAScHPPjBz/p9pNTx/bTV83x8peQ\";s:13:\"css/solid.css\";s:71:\"sha384-KyLwW4NRDhAz4RVatBCvFATniD3ze5rJvP1usxUFectdGgG8n+7OTcZug8s4bj5H\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-dwNK02s77FqYOBDJpF4ttbI23g2UUTrI9euJ+OQGonHAy4W1kCpAyV7ozLK24GWz\";s:16:\"css/v4-shims.css\";s:71:\"sha384-tlZ/hMWxtcO6JxnBPYGsa5Oiu1gmAqp/bY7s7G6m5OOCJvcNQ6Fo39YHu4Elr+Hf\";s:9:\"js/all.js\";s:71:\"sha384-nKdXFHC25mX+ztWymakpQ8nRykznAcZ+yHi9XETJ8CuVvvSGeg/0QCPhvDb41hUb\";s:12:\"js/brands.js\";s:71:\"sha384-4Md2NBtJT8CgVnGaoonPkhRdMvGcFRH/nATvRJ0+2VsJ5bjySPpBil+KbSC+9yFv\";s:17:\"js/fontawesome.js\";s:71:\"sha384-nFIVFc2+uHHcH70YEBnMC6UmUjVxcQ0rZJe7u58lz5aUDQRz0l3xFmVSdao7Ag/K\";s:11:\"js/light.js\";s:71:\"sha384-C6XejYBP1H4YOZVReSXSBion6LKXOt7htNgjRlcKQSsMnL+/Ok1vyvI5EQs1/H1e\";s:13:\"js/regular.js\";s:71:\"sha384-GlXg5Pw5UjuoWpx2tbE3LsctnmBsngO5u5c+nK1slAwSuwN86zPzez+sFxncM+Tc\";s:11:\"js/solid.js\";s:71:\"sha384-pAEZwWHMzeWUPLx+edoghTzc+LBoBSIWMNFPeZGDiFDP6WL4g+EHr7DhQMUpjSLZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-A2MQ6ZItVBjKp0Efdmi8Xze6uRApxGoHzuGImgZGk6JfuaQ9Vkcev6HtJSQzftWE\";}}}s:6:\"5.10.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-0c38nfCMzF8w8DBI+9nTWzApOpr1z0WuyswL4y6x/2ZTtmj/Ki5TedKeUcFusC/k\";s:14:\"css/brands.css\";s:71:\"sha384-19EzMRnOAF4Gg36FukRf0Bee26rnZC49Ld5mFG+8XiQ8ddeKQYj7Rnl12YxIoHe6\";s:19:\"css/fontawesome.css\";s:71:\"sha384-YYaKmJMZQbIhKGKC1QGjVKSQ3s9OlZitN6xQQEPksarSkM0WNkq5Kke0yehyNwyT\";s:15:\"css/regular.css\";s:71:\"sha384-OVGJJ0J6OIuVjxoE5rUQPFweGgzO0xT+HKN5IChh3LTrsWQKjHocfKq+nk/8DogN\";s:13:\"css/solid.css\";s:71:\"sha384-dHM1276IWlmmltsiRRg04ASaTBbgAqnnjneOemUaqff0rqTtVHw5qqKE5i0k4Qll\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-oBn2TNb41FLJEvg05fPEoAhWHErn7PR1FiyT6NjQkoPzDDg1n/e/GrwRgh34gDmQ\";s:16:\"css/v4-shims.css\";s:71:\"sha384-R4Ah6+FGj2TWi1SbbJo01aRwLwdNunBoW4ALQ4SdcDpyQpKoP0pTL3Ce0Hf0oMOh\";s:9:\"js/all.js\";s:71:\"sha384-BfzGEucsDAHnSR99xBvG8cNHx7h6sEbKJejtvqlMrN8nMi3gP2ds+sMAjWfWnZyn\";s:12:\"js/brands.js\";s:71:\"sha384-SgCx6DCTHwPNfTrT8PeDNKVR+bLsTKTVnBbtZYSLgfp4dd+KGa6j4/Jy96HTd0nw\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-yhpUSfH+AXwjqsle/7pS92NQZivmuHw41bqBfGxkaV4ftpRTE9Z6MNd2oh9x/BBm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-LMbxIMq/Ra43sLL8MF9d0C8NDym6Cp7d2rtvvZUd5n4EuGE3GSYBmf6JV41EB7+y\";s:13:\"js/regular.js\";s:71:\"sha384-eX5P9jt8OdQQ4ME1Y4Q90r5k0qCw55F9jie73NYjcSEHIYYV+x3MW3XgqK7HDuOG\";s:11:\"js/solid.js\";s:71:\"sha384-WvtEEwvz7coGHFMqz/gUsacHkjubSgzLIieTORXey1KIpl+/r1Sk5owMdBxnGFHy\";s:14:\"js/v4-shims.js\";s:71:\"sha384-RT+uACaLSP2jOOLdRXKvxcgxA/WNa36UYkM14r9ODCgz51g7frfTdR+Jv3q46NW3\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p\";s:14:\"css/brands.css\";s:71:\"sha384-/BwiSb9M4ZqztN8bEG+VrC9ohWSBX3qEV95+/+gBJoE4+zG3KqcLj8ShUhBIALSm\";s:15:\"css/duotone.css\";s:71:\"sha384-R3QzTxyukP03CMqKFe0ssp5wUvBPEyy9ZspCB+Y01fEjhMwcXixTyeot+S40+AjZ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-eHoocPgXsiuZh+Yy6+7DsKAerLXyJmu2Hadh4QYyt+8v86geixVYwFqUvMU8X90l\";s:13:\"css/light.css\";s:71:\"sha384-2CRj/5C4pwyS5v+q0KXxQ39b3qsKQNE6T+9FFaAOlps/XjJcK+M20aMUxuQtRLaZ\";s:15:\"css/regular.css\";s:71:\"sha384-pWItZRjB6NLzlrnwcL+2alve4CtHiaLj9W5ZwGPgy6dtMzCPsGv/qEcRvrbVkW5i\";s:13:\"css/solid.css\";s:71:\"sha384-Zbnz7QaugaSWTYmuSFTHGzMLxXAu2vzmqJhA/DS3bnaZGJaatH8apOWXfFaP6PMh\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-85qDq8Thytv8iDkEBcdksps8EZiX4DEo3vh6Ijk38Xi4RVm37Ttn+HU9rsXho2fN\";s:16:\"css/v4-shims.css\";s:71:\"sha384-y51MGgwaeLjbh5fbY1GJ6PypnEoMkGu8MoR1HRE/p/hHfiEE1G9bK/79bstJpyYk\";s:9:\"js/all.js\";s:71:\"sha384-G/ZR3ntz68JZrH4pfPJyRbjW+c0+ojii5f+GYiYwldYU69A+Ejat6yIfLSxljXxD\";s:12:\"js/brands.js\";s:71:\"sha384-8TDwqaS9Kr9a/3cVS6+XkvWUM1tz6XdS8s2urD5rXY1Cz22kPF77ZuG1gIWaz6kZ\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-JB1N15Wp6AIOL3sQ9Tm4a0kATlQy9/+/nLmU9B2wv4K4gGNAUFZEU7qDcxIPJLXy\";s:13:\"js/duotone.js\";s:71:\"sha384-PcDzzpTJzDDda2YUM4EY5ZqnZQ3DTIFtoaAn7t07N0UIY1HVyaxIHRzROmFBd48z\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8YSeMunSTZdDZy7rZxfG3NqC3KnYaCKxTJMm9yoILgIoMpXeTKDrV8TeV9C5ItEc\";s:11:\"js/light.js\";s:71:\"sha384-sEc8iKGnMxm+Dm4AQabXbw0DKZU9FtFrWMppMOsxaUZsLL5pcpQs4aL/OfefTw7g\";s:13:\"js/regular.js\";s:71:\"sha384-wNQjNuGVt9TzLWqaxsZvH5uIDIxEkpSCeSPg6nF2ud6AK9jXY9yMFA6CbcZrr+cZ\";s:11:\"js/solid.js\";s:71:\"sha384-Vh+IVHoo4c4JXOfJBoUxIiEJf6bB443zoyGtwY8WbBmCU+7fAq9QX9JLtFcNSPZl\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vzU1ar4oP9lOG/JJdj1q/+3aatI/ZbpyHIMelvsAi2Ee8gCiTIb/YhqRymLLZkje\";}}}s:6:\"5.10.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-wxqG4glGB3nlqX0bi23nmgwCSjWIW13BdLUEYC4VIMehfbcro/ATkyDsF/AbIOVe\";s:14:\"css/brands.css\";s:71:\"sha384-+B+cmd37r9agFUqHw5ABups/+o97SqA/Y6S5b3ly2q0ABacloQs0HZOQAX1NpJhF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jUGOH+gYMCfz2jbO6DW8vojES/a323h7dcoT6qI7Bvod9mew/wwTZryjccmaMOkf\";s:15:\"css/regular.css\";s:71:\"sha384-gr19od0wAxe2+mYHEXvS7Y1ppn+ESoAQzTYGPauVJYyAYYl0NBQaKveeQnzez2Rm\";s:13:\"css/solid.css\";s:71:\"sha384-VUnOJnDrNS0aVOhF6puq5SPJOP5oOvIO6n54m14E2/OHv6DU1gklJ4EImoD382c5\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-94OQehjHMl3lApC2tWmjwtxlB0oEtSE2zrTdf8uuWEaDEkkCxXK/w0vFs5J5WPU1\";s:16:\"css/v4-shims.css\";s:71:\"sha384-i1lF6V7EeiD7KOgGLtAvJiK1GAQx4ogzG6B9gpEaDuHSLZuM3sFtPZrI6H2Gzqs6\";s:9:\"js/all.js\";s:71:\"sha384-aC/bNmpJEYrEVX5KNHN+m0CmvycQX9wDnYv8X2gdXQjrbtDP5OcU5DRiXwL6bPwr\";s:12:\"js/brands.js\";s:71:\"sha384-BZIBcmKlroIkWe3e13MZbUHZdmagAU/8cnXo9mIW5p5wzf+/U5ULLQ8TVioSuCnC\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-A6TzAYakDQ9XwDY1hOPxAxI/3t6kol61Ed9hvHegEwcENzAE0vLojG6wItQDmclf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-NXKh+ixIINN/JHIorH6fcTNwaAekBk2v7azch6cKmQm7wtb0yBt8ctqn1FAspAW5\";s:13:\"js/regular.js\";s:71:\"sha384-7Sk1mIxPYoZb2I3YK86sPsPMftKqv0aWP+dgX//x1mF1mSOYydXmX7DbtHN99bea\";s:11:\"js/solid.js\";s:71:\"sha384-dc4FEGpFyXnyL9DbieF6I8Xzipdt7GRHX6k8RM/ow6+IDISjPeeTwTiAkNzjv2OI\";s:14:\"js/v4-shims.js\";s:71:\"sha384-BtUWeH6hQDQGUZewQDmWRMisAxvs1LtqoVQgmbFptFnH1GpBw2b2vZenxfFmRtOS\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-y++enYq9sdV7msNmXr08kJdkX4zEI1gMjjkw0l9ttOepH7fMdhb7CePwuRQCfwCr\";s:14:\"css/brands.css\";s:71:\"sha384-9J78p9RP9gty/jk0TJPvYSzmYYCH4cRRkDMnZGxZNh1wdaXLvXzIk90EWrxjjqr9\";s:15:\"css/duotone.css\";s:71:\"sha384-Na50X0DRTNz+Sc+4XbFXONmaknKHBHw6gvRZ4coLQCl7ZLXziulq+4wvTZxkaM+U\";s:19:\"css/fontawesome.css\";s:71:\"sha384-OvQaO09Stu8nVnOdc+6B3WjpKg9dfBxoakdLxJKAYgsz62+DzBUCvWRxPl9LRVSq\";s:13:\"css/light.css\";s:71:\"sha384-CL557/BMzDSg/4ctPpKDphHJgLqpdJ5rvOklcaHzLHpX+qsgd4V/xao6Rya4xKMQ\";s:15:\"css/regular.css\";s:71:\"sha384-yLDdP4XFV3JqISKN0JaZ0kdyks9S+U2o9uBmNbmZh85yjdF/kpu+oY3/eXQcGHhT\";s:13:\"css/solid.css\";s:71:\"sha384-BrYpEWmuPyxLgVmvUGa111AoxZ3kKwiG4TVjjewWZV9vww+dTLWpmEffDSEg9Gf5\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-V8iByeksgr2la9ceLV1jNv7uWdzI3pYZLNzgYqWmQuQZa7khs4d6QC84YnMWoKxx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-rql5zubvrhoXpo5buqgoiKryiT02OHCEtveKZrj4NX/C2Kuy7W2P7vl+RVzBUl9m\";s:9:\"js/all.js\";s:71:\"sha384-FW78RPcSpi13vjx77nPWQIrQbNSLkPBopb0qGzLCxD2x4Kr6FA8V05C/6cpgkKPL\";s:12:\"js/brands.js\";s:71:\"sha384-DGr5D3fYhGn4bylN+nFRaxvPt6s4FjV7B5EhOOFUKW0JKU2vco3q3xtgSZeeEYpw\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-++EkH6KNUkbsGzUhPmRa5yboy873FnCrHLPNWnvcfYOzCCShCQHtdQ3RQTt3WDsW\";s:13:\"js/duotone.js\";s:71:\"sha384-QwVJpiaupNLHQYsfQUftqzWXMT+SsU4AKnlvxDGzNjTq5xPXRbG/ohsvyIEyK2uf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v97MeHGTkmNphZhn+D7412xlPlc61o4jy6CouRwKfNltfXH68HcYhmQBr2j/J/Vp\";s:11:\"js/light.js\";s:71:\"sha384-TZInz5PvbxRzxSlGI1WYKmrrBBk/XTTZymO6w+smmSVD6RFpfZd+JtSye/viSFxA\";s:13:\"js/regular.js\";s:71:\"sha384-ZlV+aQMpcvCEqNPe9qTu/S6+eBL+DfRjOxr9wtsoZyGnJ/vwQk/U2SZhZ8tJqH5F\";s:11:\"js/solid.js\";s:71:\"sha384-WtnuXyp6MLUsHy3FAqJyL7aL0a/mdUjPwIs/Ub7FXJZufo/0qH9aFsTDY5Q6Bx3m\";s:14:\"js/v4-shims.js\";s:71:\"sha384-P9HMMmM/ObyzYMvKfF0Xf40MYwNdkI08AwhSyCsAVlmXZkJ9GaI0Z23pozRg8HAe\";}}}s:6:\"5.10.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-rtJEYb85SiYWgfpCr0jn174XgJTn4rptSOQsMroFBPQSGLdOC5IbubP6lJ35qoM9\";s:14:\"css/brands.css\";s:71:\"sha384-qVnmyLTtnGPGEN3HDG2MCEOXWH1Yk/i70lKRuV+gMCDQg+jblQlFGPf1mejWUyYG\";s:19:\"css/fontawesome.css\";s:71:\"sha384-hM7EQerc09E4O3zhtvF2iqcB4ZkEu9xkLQndhXdGGCEJ/sB4JK54SuKGmIC35UTf\";s:15:\"css/regular.css\";s:71:\"sha384-zuVEAfuEXYtKnHpmwmkhzwMdR2uek5gePU1XveESmScyRJHbncv8rLEAt+ofv7ze\";s:13:\"css/solid.css\";s:71:\"sha384-qPldrzmea0i8jhonuql0da/kQWeaXdQl+krGXcTQUdRUGHcXBfSrBbZLbyMcCWcF\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-G0mvrlfkz9DnjBCRmY8Wf7nC8wTxDsHE3pGAc7/4rDLh5+v9Z00qi/uyjjcDf1nf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-updXts+unDswrMsYxLc5R+HfSmF8CuEIOe48Rj3DoVoPUIImOT1fs26H/tr/H9gC\";s:9:\"js/all.js\";s:71:\"sha384-QMu+Y+eu45Nfr9fmFOlw8EqjiUreChmoQ7k7C1pFNO8hEbGv9yzsszTmz+RzwyCh\";s:12:\"js/brands.js\";s:71:\"sha384-0kDL5YEgNJjL/kNToZYEds3evLmosarb6OU2eKqRYu6O28jcJc121tjUC40sG9VB\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-Hg1lNcVEsyCqBb1J4/U9X9IW2DEhAKIBfBIE0J0eiWGEX9LEpEULwcsqoAb6HDgG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-5WtMZ7frOu4PgR22YgRSlercgEU28i5Zn39Svk6+2cg1MOigLDSsvXccsmJO2Wxp\";s:13:\"js/regular.js\";s:71:\"sha384-CYi/gunDGMYA12KV546MNRqsjbbWSyKgPjA9BwVMBQmIMhzVrjyUJwkV9uujzHLJ\";s:11:\"js/solid.js\";s:71:\"sha384-RbVpZhfPW/1SmcShwIOauawY5vJWxTCeEnmiUCiY2SbkrbKuSGTqJ9NnBUmcP95A\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gDM1aRghQ5DRg+fSCROSYawrJhbAHqa6Teb2Br0qRJtb+vRJlyU4U4xnmN5cwJ9j\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-XxNLWSzCxOe/CFcHcAiJAZ7LarLmw3f4975gOO6QkxvULbGGNDoSOTzItGUG++Q+\";s:14:\"css/brands.css\";s:71:\"sha384-hIpb1kefRKjC/r6WxN0S6Nai7+AuherqCoHKD0HNdXkbzJkZcS4o62bJ7ODiBWAu\";s:15:\"css/duotone.css\";s:71:\"sha384-B6+5TXCEkY2Io8b+v2Ki0aEWnpCFgBYkOzXAHY3oQ4tr90JpQC1RErwFbvJ9CRt8\";s:19:\"css/fontawesome.css\";s:71:\"sha384-1sdMwbsd8X7Y+nVcEr/4D35smQEaEd6Qz+R00Y+NPUkG8MyRa97RrX5I4nqDt6X7\";s:13:\"css/light.css\";s:71:\"sha384-dlxpRYGi8Pjg49IqtrDIVZmCOQZ//oDKDkoqbn/IXrwwQDP4Uf0ys6+eH1z9sfhV\";s:15:\"css/regular.css\";s:71:\"sha384-hKM7KqUOh6F2PI59uEhofbDs/5qHHdJEULlmNWJEQcu3D/5/vl5zpwBrveC4GAbI\";s:13:\"css/solid.css\";s:71:\"sha384-FCdq+BRoY+lV7Zy7HKKQ4zoywYLRyasGk6IrmrXfmYs0xIgL0QrPeEPTu3T4Uqcc\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+OTv1mrGtdzHGeAuFSVKpPvaMXNpUu+W+Xs4xYz2RgUlrBctmMyE3noRImN5j+ot\";s:16:\"css/v4-shims.css\";s:71:\"sha384-88Tda+TyAtJK9/cRRXAWdJjyE56Tg4ai2x7RoSEqSVodcInAoV0HNQ2ofaGCidyr\";s:9:\"js/all.js\";s:71:\"sha384-lowSFbzpSYKDOsvnpi2JVneSnkrbVjOTwcHOWpC+tj/YT1mxTDIB3ZqbtllmfUSC\";s:12:\"js/brands.js\";s:71:\"sha384-nyTyvpFz3BvQZucRUSSEDlyivN7GAC2Xhgl9M92o/rt/KfEZ7LkqusFXlCjM4DvC\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-eYjh/PZbsWw6lqYWtDM+NlcRs3pUkOk8r4mxv/x0xDjmYPXTxPKQ8ZNXxOnd0UCL\";s:13:\"js/duotone.js\";s:71:\"sha384-2j1n2yG+7lkO9CjnN1DSQOGJoDEaJPEr+TPmTer3pK/yD3bQ/Kk8bqJyS3LfCK26\";s:17:\"js/fontawesome.js\";s:71:\"sha384-sy0tjZ+ivgcg2wUVVEmLMO5wfntWOSyQaD7AQec0iXINci5JAP92T8sM4YldYQIA\";s:11:\"js/light.js\";s:71:\"sha384-vh/BsPXkl02OgBjk1HJkukipMWFU6vHADY4W3u9BXIrKjcRFw5Y5XikVLoLElHee\";s:13:\"js/regular.js\";s:71:\"sha384-p89srWlrnSOel/vi/SpBD/wyTTJhu+27jcfOazOCUnLTpcxG+NVuYs/okkO2JBox\";s:11:\"js/solid.js\";s:71:\"sha384-JzK2muq5DGAdfmBP1xyuFUAYGceTmP/Y84tZvRxkdtsjwuIcd8Hpf1D+5izeBUQP\";s:14:\"js/v4-shims.js\";s:71:\"sha384-z089sTZgTLfns4lyNCTpVbdQA6JAhOs6JXwRH4ig0M6EHPg+Lzp/hdcx2OHQn/v8\";}}}s:6:\"5.11.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-XLYVh3ZsmvjnjODXg/qvDYjcINmPLORACP+Tk6qA3jNLbStl84PzAeEz2Su02511\";s:14:\"css/brands.css\";s:71:\"sha384-ngkCSSyhFgmeG9/8GICGMwnX44Q70/NN2XuNgrpMHOAjXVjYwTvtQML/2+2EH5mm\";s:19:\"css/fontawesome.css\";s:71:\"sha384-saSWCOAroWA1DTfG19axC5l7ej+/lsLpGrQjthhULGGw0FKZqZmxdjRhWqjypqgH\";s:15:\"css/regular.css\";s:71:\"sha384-NJ6bXu66piTFdxVfLXmQuxcjGye4blIA4H2DybHqY1WFdYSxbKQo6W0G53caD7MY\";s:13:\"css/solid.css\";s:71:\"sha384-1Ln0i7HCe1LMHO25AgX/9s/3XzTLIMev2SYgQz8xSyXSa3775gIb15NIpJoDRYDg\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-utbeJwkEmotPPgnsjR2cFDH5mR1JrU1EX02CRdVYlT6MuuLA6/jK0M1UcDXBVNa1\";s:16:\"css/v4-shims.css\";s:71:\"sha384-QZ/09hWMymER1waFUW4M2iM55h3bf5FVf516rOAYf9G2mHSpAj+oo/6jrxhxiVq4\";s:9:\"js/all.js\";s:71:\"sha384-Zgm+jt84FBq52ezxzG1WPrUHXPTLraCVSuBDiGgz/mX0FZxgdkTZNephFvciYglv\";s:12:\"js/brands.js\";s:71:\"sha384-FYnxcuBilMBfd4M0z3ZhTEWrorBL6P6mqaDWsYN46z3iJszwg7yqVAft8mxPhWQf\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-nDF1UhY85TnH6TtkBtlcaTXQh2EGA+oy54oi//hchZ6BIO8n0yZOdEDcqy3Lj6SH\";s:17:\"js/fontawesome.js\";s:71:\"sha384-+4PGPfaOiBMXBdbxBpjj3c78flBTf1SoDBBbEHY2P8SuIKsjNJ59vjhjpMClcRVk\";s:13:\"js/regular.js\";s:71:\"sha384-sPFXZNRvY5NMeQlqaEJyF/3Lrrcqi+EowkFdHnHe2B5/GSLq+RN8eAfpDiFzWveB\";s:11:\"js/solid.js\";s:71:\"sha384-abaNJNBN26YUz3JKjkP/eHqZP+7EaMLIkyR/I4JNQXin7CWBKc81Tmgh2//K2gfd\";s:14:\"js/v4-shims.js\";s:71:\"sha384-uQinggJhGToi55IHZla+hhoeR3xafp4JLhuIZzag3QFHKDyLLolL8IuCRM2aLdxy\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-eRd7BE4pd4YyGL79iaO+/+GQtuNU464XOqRShZHNdRwR66wJIzi0UirzOFzuoMOo\";s:14:\"css/brands.css\";s:71:\"sha384-/DL+sGDGYNVXNSXzx8omqgYJuKJWhPfJC0j3sM06CPE7CKypUtyAtAburBBMbhWn\";s:15:\"css/duotone.css\";s:71:\"sha384-JrGJDz5LRxQ3s3dW4Av8oo0oPABX1FQPzGwpVizHFqVT7RXKd2suPslh8/k6EFvo\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ASwVckljSlVqrp7J4fCNW1Zfqp4GBw13f/oq/bwtr1KNG1j5lzKrfTpvoivwJZpS\";s:13:\"css/light.css\";s:71:\"sha384-SE3odAKV/Li06jtOem3j03b4qHD5AfOLS3ip3Ie7HS0QtdLJuRozlFcEiBnKhIjj\";s:15:\"css/regular.css\";s:71:\"sha384-v0Phnxb9e1tIN8ABEpuqr9+U98eA2hbSnnxnIFWqTyvwFd4QjVV9NOCl19hLotTv\";s:13:\"css/solid.css\";s:71:\"sha384-23irw3gzc0cirSOm9k0vC4Cb8339DDxFatLW9p83F4RsFK/1HuRvePKAltYrdlBX\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-c8uzxHbCxkqcTDgRCHmj0nVIK7Z72qzR5ciNuZIQQKWVMb0Trzdh3g9EmdybHyb/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-+/X59I6aJtu7U5st0yw42TmOgz2GTi80ici4b4Zr3fVKaib7AhAhXm17vhXVqNN6\";s:9:\"js/all.js\";s:71:\"sha384-jaxx6ehyna+t5i9JERhQruWpH3C/xGZQJz6/+xqO5C/eWWJ7ysIZIe9BAULfRy+f\";s:12:\"js/brands.js\";s:71:\"sha384-om6tKqxNyejPYGBkAEpF5czG8EOB93m9G17YUGoJgRtei7kJnA4P4+w73UfDPtLl\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-I8WM/bXtfWQr8u2t0OIaUfJNpTd6LnCbNnrQpaKQN4/Pdek5IOtrXdpcXpLwzCoc\";s:13:\"js/duotone.js\";s:71:\"sha384-tit+/K18O6+uMPCuvEcobuzvT7aFly7Raxqnszuar7OzNloVr2oIugu9S/T3MNgn\";s:17:\"js/fontawesome.js\";s:71:\"sha384-kAYceFs9TzH4f4HsWzAZvbE7yJRTcOUe2UeJVCdVV8AYbspSlxAIwUg7yGHrtSKe\";s:11:\"js/light.js\";s:71:\"sha384-zam67iVIo4OJbdPFYrgsf4Te4l96q61wYKpT72nLO78ICkwXk27OlsN4SQYHOlI6\";s:13:\"js/regular.js\";s:71:\"sha384-8QzBYxpPIH9HEZ96HhicnkJ8XYzELjI6YQabAc2ANT0wExEgzeKwnNdQM3B0YPzX\";s:11:\"js/solid.js\";s:71:\"sha384-vTIqr5UHlJnlDEDAZB19P3NuSQy0Ynbzj7w5ofBkLPpN1bb7N2uZ/z0GNZGCIFxW\";s:14:\"js/v4-shims.js\";s:71:\"sha384-56L2fWZDluSTJKVxfc7PF+HoFsBrcdkn/Wj79nB2pzTgaYmqLT5T2pn6PLbMvHHq\";}}}s:6:\"5.11.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-IT8OQ5/IfeLGe8ZMxjj3QQNqT0zhBJSiFCL3uolrGgKRuenIU+mMS94kck/AHZWu\";s:14:\"css/brands.css\";s:71:\"sha384-UMAQJEtrY4iFRXQIYIXWfTd0GPzHrhSPK1SJ3fEeGGgtkC3m5qhKESA0yOXahpmJ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-8dpIy0am6bmWHK+abUbC1sgkCSD6WstSMjjNB7JVa+rprKurA6xisqNHg6DESJWW\";s:15:\"css/regular.css\";s:71:\"sha384-5JoPxivOfpG9KRKbjXkqhwpMZ7vvAATGi77NPd6sC2ruJrWa/hKqoLBIWC1n1N/U\";s:13:\"css/solid.css\";s:71:\"sha384-20Qlvv++Kgw8B9SXDkUX4JrITPco1UXcaB1mkymQFgx8cM9azG2Ig9Sy3khBpWip\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-jv39B+1DxC6iSROYUwIeI9RUDrl9ckXFPOOlys2dTXchRTodXzqX0lm6GUwN4iLA\";s:16:\"css/v4-shims.css\";s:71:\"sha384-iJU+Et4BsM2cUxdymLmM7B8IF6IkyAYIcJRKroT/XuA5+2bWL9u+KJ1ZItC4bcdo\";s:9:\"js/all.js\";s:71:\"sha384-4Uei2cJ8mOycRxb1dxppaomro+V4vHdGuT3NfYGpENdgukEOcOrNB43OdzBiHdpZ\";s:12:\"js/brands.js\";s:71:\"sha384-q5JjSRgEoLV9cBFXvjGX8xxIxWN+LcGaDFBxSid/9XwjhecfXMQK9Ak7bcPSFT0M\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-LqGhhRx8iThhBm6ytksB4x9veweiV+qNa2soZmn8V37E4Nohq1ccRoaSr4o8YAGQ\";s:17:\"js/fontawesome.js\";s:71:\"sha384-jwx8I0tSvPLf7ZV1KwBdmXpCHgduVujQNEzmHuLEiCYql63uV/C9TCtdBU7E5TL/\";s:13:\"js/regular.js\";s:71:\"sha384-W1XmDNwB/NY1P/H0BiR107pc9NC7aTrPvwXbrZewndT3nyrmFm/7IIc0AxxcHQ/N\";s:11:\"js/solid.js\";s:71:\"sha384-kDwQ866HvlesMeZEZYvoa7AceBir+K+jB/0PVVSs/1bX0JtTvAm3aFEgOCOCt3c3\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gtnOUe72T7BrqVgxbkcbbwZGJLyyHFFtefPxPZ5t/rmQ7vMNXbxml7JJkSNfHmkV\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-sr3GDThhNP8BxHFoTK4zKFgOjcrT8vzaiLwnwU+yB31BCaNj3QMX6YVXcv8AeBAy\";s:14:\"css/brands.css\";s:71:\"sha384-4sG0FgVejJMQM47pqYyG+7afeARX2P0HYkQ8JCKf3ZqTcpJ3/SWefUFX8kdm8eYV\";s:15:\"css/duotone.css\";s:71:\"sha384-q4v2/qv2HhGIAcd04NDH2XuGq8Bzu+xNYUI3gcKFfWt09m/dgZlvUC0rQJ3KtGg/\";s:19:\"css/fontawesome.css\";s:71:\"sha384-O68Og25nY+MZZRUiP6gm7XPDuHsNC5DgKWEoxn6+3CFcGLRXuFihbGO/8c5Ned0i\";s:13:\"css/light.css\";s:71:\"sha384-Rg8mXhpzJH99uBsgdsCp9zXjkcsw/pm+s4Kgu/56eRQSd8SAszYc6hssH5MLusHl\";s:15:\"css/regular.css\";s:71:\"sha384-RjVm0cyaQYehIEaR5Tt+JDfgnUUtY7GP/N4rEglG6DxLUhzozRl6HTH5NfPQ0X1/\";s:13:\"css/solid.css\";s:71:\"sha384-/SNkE+jEmgiOubdXCmBU+e2fWH200um/crHWjo/Rni9rhQuxT4demqM/PAyc+tXU\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-9q0WPwNHncxttx1Sf3c/G9lszy6f82L4rYAYW+JF0PRBNvJ1mVyYivrsep7J+Fud\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1oMR0RRrEohmWSZo0t/tezQF1gyGc/b73Bba+qyZLEGdTAPORCf4p+pQm/iycsgj\";s:9:\"js/all.js\";s:71:\"sha384-7DVhSuOn0R5KmazSuDzmwQHOIPfU4+n8x8AifcGCoSOGATBJh55ZY41LSL37PB6m\";s:12:\"js/brands.js\";s:71:\"sha384-QRf6gn0gPrg4U0aYZ5s/Sx7xXy9gplYMzh82CI51530v89R9s9xGG8ljaSqYflQU\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-jKcJk7TgESeW6RZgq9/e8kTr0jRQ/JvaM//YDKwhF9wyvXk8lQs27OQ6cgv3FXTt\";s:13:\"js/duotone.js\";s:71:\"sha384-CeUA4+L5GZZwc5CGnvQVaT/Yrv5HuRydWW/QDCiXZnuORKxut4zKDa2WUaCS7fvo\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hvER25BD06AWxsJLW7cQmGKjQp9PSZttpMIo36kIq2TTPEhP4lIT3VMFul89Ym6d\";s:11:\"js/light.js\";s:71:\"sha384-qvh52W5+cWrTxhfM559wBnsSqplMQIEjQkHnAE8c6MViBcH1OKvI1u4IGR+26hZK\";s:13:\"js/regular.js\";s:71:\"sha384-owKa0I4sfD0ooTioBE3KJEbjcmAZi2LeCbkqHr7/vkUeG/U5OyCGxYlcz8axgnSe\";s:11:\"js/solid.js\";s:71:\"sha384-hNm7JVaYkbmX1gZWRwOXVFKJ3onp68grA2bFGmFSMCQueJbgNvKR+iItAjM/PiuT\";s:14:\"js/v4-shims.js\";s:71:\"sha384-1MuEmp8vgjvrraTYbqRjvuZbLs+vFg2oeN+87QTVYX2EAXM90T4bzBm7HIFFzAp7\";}}}s:6:\"5.11.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-KA6wR/X5RY4zFAHpv/CnoG2UW1uogYfdnP67Uv7eULvTveboZJg0qUpmJZb5VqzN\";s:14:\"css/brands.css\";s:71:\"sha384-tft2+pObMD7rYFMZlLUziw/8QrQeKHU4GYYvA5jVaggC74ZrYdTASheA2vckPcX5\";s:19:\"css/fontawesome.css\";s:71:\"sha384-+pqJl+lfXqeZZHwVRNTbv2+eicpo+1TR/AEzHYYDKfAits/WRK21xLOwzOxZzJEZ\";s:15:\"css/regular.css\";s:71:\"sha384-zgXo5aJZxI4cJSgWSRtbv7q4JB6PzrmOTAWiZt2CqN25ifeKsCuQZ/pUNoPgjcTb\";s:13:\"css/solid.css\";s:71:\"sha384-doPVn+s3XZuxfJLS7K1E+sUl25XMZtTVb3O46RyV3JDU2ehfc0Aks4z0ufFpA2WC\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PCpLTPQTGcSAXFltutjYRSDJAXJItRY88oa9XgNyYJuwrgJGx+uNVmtGSDS2PPvL\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/EdpJd7d6gGFiQ/vhh7iOjiZdf4+6K4al/XrX6FxxZwDSrAdWxAynr4p/EA/vyPQ\";s:9:\"js/all.js\";s:71:\"sha384-b3ua1l97aVGAPEIe48b4TC60WUQbQaGi2jqAWM90y0OZXZeyaTCWtBTKtjW2GXG1\";s:12:\"js/brands.js\";s:71:\"sha384-b2GpqFrJizV0BUEdbrITdOA5HnxnlrErt7MlEERWd6NSJ32rHeibEvyyCuA13OAS\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-b1XIrGvAvE1F4q9vHz2OmkU7bBKvxebE+Q/bW+d4lG90kACkPFm/ZQuS9tlTwVD+\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EYYaHDhIRoBhd/Ir/1fPnxg9rZLk/55lKtlNT5KrIcONoCS2kjf7ZWzMoCLLACeo\";s:13:\"js/regular.js\";s:71:\"sha384-vIxiYcREJ+yKr8tRXG0gCdepcyuhCTkHwiTdG0qVTHSQvjO0pmllh1QAy93JYsE5\";s:11:\"js/solid.js\";s:71:\"sha384-Mf3ap7OwO+bjTkzM1RsrothLh38uKXvMWJ2TQPXGHqZcqfeI/cyCV+sfV0IDnBDq\";s:14:\"js/v4-shims.js\";s:71:\"sha384-G5fIV0dSzZ1nDQSh+B5u3TRX2UtPcd5UWyi2WS1fZIpJQ/JpJCdShAZ+wmILZ7Qd\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-zrnmn8R8KkWl12rAZFt4yKjxplaDaT7/EUkKm7AovijfrQItFWR7O/JJn4DAa/gx\";s:14:\"css/brands.css\";s:71:\"sha384-dd+UlUKIkNDLBFy2GZJRdMODxfdUjx/PanzxBbsXaRBkyjHzUeDX3mj6q53uL825\";s:15:\"css/duotone.css\";s:71:\"sha384-tHth4ugEmPOZTBSN4Hi2oYiHY6vpxIL8clasFZidKyR6Gm34+U6wx6A9eZHqTs2W\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bQakmC+XBF+eCf93fSR/57kAeX91i0BDyXyj8My8/e/3Bcno5zhEGM02xNvpXV+2\";s:13:\"css/light.css\";s:71:\"sha384-yNf+8hATd/MoR/yfZG0nBBtjTfxZEM1rJos9BgjBaVuLcu711wcecTXBlfS91nfj\";s:15:\"css/regular.css\";s:71:\"sha384-H5RIR1XTDkiiLdUTNtbYvWKpNd2qsPBeGzpT5PD495znZL9JCA7119EMPNfCASw1\";s:13:\"css/solid.css\";s:71:\"sha384-LkNnzh6wVxsC0m3vcQ0T5L6csSYpgSYniG/AKJqWBsHT7PVpeO0QHkBw4dW1WfVu\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Mh++Qzb28x/RVEo6SYO87IyopQpwhzveyGIVg/AfbCLCEHUINYcCy24fkArgPFNc\";s:16:\"css/v4-shims.css\";s:71:\"sha384-A1hDH1BUL9ZdoEFsPEJY4LRFhu70QJj+RaY50Zoqd568i+ONa9LHCI+uoWDT0Lut\";s:9:\"js/all.js\";s:71:\"sha384-S++1cFhwpxbtRScUliTyprAMK33gMHbukurY4rNyt9CxIniGm6PfioUsQPoAITQJ\";s:12:\"js/brands.js\";s:71:\"sha384-NuqRsJYX4n2gSY6iMRHPZJxtpR40C8Lc/CV66yyeP1Vu5W2QSuVyPxMRpRIGihE+\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-GLrjh9czojGY48hc8pYlf/3FRNEBu9OWvNAta7SMilmijx8+ciGGVZyD+VwV4FVP\";s:13:\"js/duotone.js\";s:71:\"sha384-uO8Ntsr5QW0kAl13UUiYRBDhu3foxlKI+jZjPBApRxFDX2tgO/GYiCXIYiGixOU5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-FdPoPmNNPrerz9uF/cNSTyPmNCRf6b81QDEPk0JlXAaailLV3DT9yA8plMzyffNZ\";s:11:\"js/light.js\";s:71:\"sha384-zE0WHJZIhNaysmywEoQBm6THN0uK5wAyfKWoN6lJPGOlrMB8hf0Yt4/+bex9jZi2\";s:13:\"js/regular.js\";s:71:\"sha384-+3mzeMYwSyHPQfOsqYlwcE3OSC7aI/+DjyVLkBxqWP9O+JyoEtzidrSonbNKh1uy\";s:11:\"js/solid.js\";s:71:\"sha384-9I7yL3g1YvBlMZjZ0bWzPqP1m3Ic5t3EgFq/MqNm2r8FUxDVowt7dO4S1IFleLqZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-+Onl+wOd5BbZvaC8Q/mQUO3lZAqsUyD+xqhS57VlU7gIpqXBMcS9Tw94A9uMZRwX\";}}}s:6:\"5.12.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-REHJTs1r2ErKBuJB0fCK99gCYsVjwxHrSU0N7I1zl9vZbggVJXRMsv/sLlOAGb4M\";s:14:\"css/brands.css\";s:71:\"sha384-ouytoyjvzHVJu1m+KEtJ+2Ys+WFsXUlknprEuQAUs62XNn0shj9U2QeTwdJQmPR1\";s:19:\"css/fontawesome.css\";s:71:\"sha384-VoScp22LWX8GkkUAmdkkkj+rz+/r84lmCD6FALIryJxjwBSz6kE6oebSlamQx19e\";s:15:\"css/regular.css\";s:71:\"sha384-uUtN9GUP/RxDz5kko+qO6znqTP45OrABIxrrPhm8tax1s1huRxYCF7xDm+YunNDB\";s:13:\"css/solid.css\";s:71:\"sha384-9AfJF7pZ+RYk3wXpf8ge6fc3XhPaW3Xl57Qj/mSzPckn9Tu8zJ9qUipWq+/utX20\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-e3I5IwYfes9z/NL+oosxhrbsLa9R8TaEY+Krsm07Fcz7q/R+8nswvn20QsrR8tsb\";s:16:\"css/v4-shims.css\";s:71:\"sha384-AL44/7DEVqkvY9j8IjGLGZgFmHAjuHa+2RIWKxDliMNIfSs9g14/BRpYwHrWQgz6\";s:9:\"js/all.js\";s:71:\"sha384-S+e0w/GqyDFzOU88KBBRbedIB4IMF55OzWmROqS6nlDcXlEaV8PcFi4DHZYfDk4Y\";s:12:\"js/brands.js\";s:71:\"sha384-NLUhiMQCi+OH3uxQu0Ems+2GYt6KJ89f90f4kZlK0BoDB63kHZqAICPl7nQHppJy\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-PpGSW7GgJeChJyQc4XW1MIgUrRkMZudoPYOYAqGERZ+w8ammaWDBQvHM3Qp85XCV\";s:17:\"js/fontawesome.js\";s:71:\"sha384-aolToWrR1Hn3EFHDZtvTl0mtjuJJKLxSu/6b2tlr1g9dS+RLt6QVshweU+2e1v6V\";s:13:\"js/regular.js\";s:71:\"sha384-LCyqT0dvDekY5RP1UquYgUJARvp4tHVJocO5ICwoWSyVoSXrKpJrRrDYxj7+ukHO\";s:11:\"js/solid.js\";s:71:\"sha384-QsXs4eh2k/7mk3dvvNMhJJDjh8UQ++vWm4e7ULJ1UZTbOv3wQOzn+4ULg5iLW+Ph\";s:14:\"js/v4-shims.js\";s:71:\"sha384-NNQFVmb048Dmy0GH4ex0kGVcjxaPeY6JA1+ImM4Lsfr4HOD5CNMvCSoIfjeJJWX9\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-ekOryaXPbeCpWQNxMwSWVvQ0+1VrStoPJq54shlYhR8HzQgig1v5fas6YgOqLoKz\";s:14:\"css/brands.css\";s:71:\"sha384-z3CBOpMFSI4D+GXPvBsSW5vXhm4MEzWuC/CycHv+vsuzuztOzPpomZimFLeWNOgk\";s:15:\"css/duotone.css\";s:71:\"sha384-SnqCl1xqt09zXtBnCqJWrwMR2wbeWfxeAEB8e2QuoHdWNY1V5k0HrDi889EMHehh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CtsKDnRWWHDhjRZ5qgpCFCGpib2FU2SChFu0xRt81grgvXq1P+lbpROQoBLxlU4o\";s:13:\"css/light.css\";s:71:\"sha384-i+ivMdAc0+wLEnd+UdXLpYGNTbyn/0Rjz7EqmkqEOkfat5/2T+S63wn3WDk6h4Yh\";s:15:\"css/regular.css\";s:71:\"sha384-hCQzyeTkj8xmAEG5HT7Hx6t6DUkpTM34rr6FHL04J4AWtPtryU6EjsEDb+Gf17KD\";s:13:\"css/solid.css\";s:71:\"sha384-U9f9KTMQ1TBvUUFLpp6FgAy1M59lrF3q3rYTHPRVtT8OzY3xyyFUzKevJFYHEbhq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-CpTDS+d/m1rbSfuYxoVJXNCmq6ovovJAD1qgFE+K1Vf5N/n5Nt5yEoZq1UovRsXR\";s:16:\"css/v4-shims.css\";s:71:\"sha384-w49b1IAwJTEsYuPUW2QuSzpWNnhksbL+b/1q2eGObJ2CVV/HO5ubRS4jyMLB4cGs\";s:9:\"js/all.js\";s:71:\"sha384-t1m5KR+UJYhp5D1IG6cS5MuYjxDyh/lIkrB1YUpSPfGxgR4r7pA2xW+KoAfcE5IZ\";s:12:\"js/brands.js\";s:71:\"sha384-L2A2TL70Fg2x6gHvF0zTdYDo163eb/op5YdWXAr/rWfprmIjt6Ib+mdHv60yzNh2\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-Tj7c3TfdpwGV2RqPFYgEbtUTrY+wJeAPDMsuUTvdrbMDWlP6gpUN6LNbXNf1C8BA\";s:13:\"js/duotone.js\";s:71:\"sha384-wAGnJyD+rhKARbazT5ohAk3YosShbJZGkuSG5lrKQOfQpG+7Q7o6ZmAvNqeJ7mFf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-YdKgBdzRKP5F/uorpoOtlS1fRNfveZicpRkkQTn0pQdqGWQs6AMr7Jby3mA/G53+\";s:11:\"js/light.js\";s:71:\"sha384-VuS+lIluvKV9KjbEENEaZi4Ixed0QRYlUr6DI6+U1vj/rOfMP7wl84Z53+fMZXM5\";s:13:\"js/regular.js\";s:71:\"sha384-lS00sjHGt6pxefm2C7siOngllQ0WM3NoXEgwBb79KI3nh2iB5F/vkL7q09F/Z3tj\";s:11:\"js/solid.js\";s:71:\"sha384-ejND26kSb92qqj9cH70EMoR8jytCElYWiCB0v+JkXBz6+2ccBkNJkJZuMmrXY9L+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-xCtgvUZSTFqAix3U6PrST0KLLMXPkzVPwXq3AbYkoKi81K4Ppryd5D8lUII1MeU+\";}}}s:6:\"5.12.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-v8BU367qNbs/aIZIxuivaU55N5GPF89WBerHoGA4QTcbUjYiLQtKdrfXnqAcXyTv\";s:14:\"css/brands.css\";s:71:\"sha384-+2AYGyI2bR10NExh4Lu/3NQmpNxck8EcRE7aATrMi9QQ9OAKQAQw1bcrlWkp0tdM\";s:19:\"css/fontawesome.css\";s:71:\"sha384-C1VkjHy10mh0wo7rz2xEDdqrfn5C+AJpaCpUyScFHzKb0mnAU3I//2RrdAE+LfQ6\";s:15:\"css/regular.css\";s:71:\"sha384-ZYhRqsbjqPY5BrYAS/7RLN0cbKU9T2MfB24Lb42Gyv2BHvW5sujo7gc5gXEReTq9\";s:13:\"css/solid.css\";s:71:\"sha384-yiUBjfJC2dVbhAEtVzEfH+R8ZQJ91V1C+Vtr1ZDTX+gUBZWrNyVrs/Nvc1fzi8GP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-XBFwYq8dzGeC/rGkEgveavwuEU0D16mIKfWeCX6deYzhMUaa8GX4CgA5c/YHP2xo\";s:16:\"css/v4-shims.css\";s:71:\"sha384-C8a18+Gvny8XkjAdfto/vjAUdpGuPtl1Ix/K2BgKhFaVO6w4onVVHiEaN9h9XsvX\";s:9:\"js/all.js\";s:71:\"sha384-ZbbbT1gw3joYkKRqh0kWyRp32UAvdqkpbLedQJSlnI8iLQcFVxaGyrOgOJiDQTTR\";s:12:\"js/brands.js\";s:71:\"sha384-KASsDRWwlErb8dTf+e5TxRXMnbXrVlbPbn1hS5B/yS4vNsF7mHHO+Gw1bBDhcyOt\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-fHnSzPZE3xYvvXY0y51vln9J+Jd0eK4HughCkcA0NsBpmAGgU97n65RbDqUgnWf1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-H4naMsxnUrIT8qihjWfwIKXi5biIYnqUsQ+vIJGZIKfA+7/O3FxgvMrdH77X+aID\";s:13:\"js/regular.js\";s:71:\"sha384-yUk5aOIIy62R2bRFbFq0+bo+ChWYs75cusETAJ1KYvEMRiEbQZmNU6u+PK60t536\";s:11:\"js/solid.js\";s:71:\"sha384-OSCcNUu98kEBVxq0vZaBr0wdmmd2ojuJwvWuSRKD0V10PWmvTetja8mxGfZm5PsV\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/OZ1Lht4J1/FfstamqqFX1tF7PkDWDKbvat1bkWByC2KRJwGzm/H2bVuw8N4SD8y\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-TxKWSXbsweFt0o2WqfkfJRRNVaPdzXJ/YLqgStggBVRREXkwU7OKz+xXtqOU4u8+\";s:14:\"css/brands.css\";s:71:\"sha384-oRjDIXtfHT9YAjxHLAbf8PsJklTJN+dl7PmnAlOTYJhNAspi+/xgU4f12vi5xGzz\";s:15:\"css/duotone.css\";s:71:\"sha384-qrJ30c8jzW/3IOQRl4RddzzMsw3YIUWq5YhHW/8D8EJnS+5J13GpCGVEVI3ELc/W\";s:19:\"css/fontawesome.css\";s:71:\"sha384-k8n1hWo+b1vuRb6E3KATGC++lfNDnJTtJ6pS2BFF3tp/OshnO7uhzoOj/zJbGfwg\";s:13:\"css/light.css\";s:71:\"sha384-iUpVK/Fzq7teRSWAUmJsnlccV1OgC2fMpgreA8gxAm68UxbZPiMu3GP4IbKdKIUh\";s:15:\"css/regular.css\";s:71:\"sha384-QprxpKrx/cRYKXmWVkM97ert3857dCN6bbf6cRMELoa1+IYdsHoqweHwJksEfb0j\";s:13:\"css/solid.css\";s:71:\"sha384-uef1Ib3WhVuFbw7CZtyE+4IDCiKe1/bGU0vJ2naf8VQHKAeA67yU344LBk/H6nhx\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-GucW5chDMZnyGPL1yaIe1GOHu/X7ixbmNjinYEIVr8a4Q4ewZjgipeXJhVi1lsrd\";s:16:\"css/v4-shims.css\";s:71:\"sha384-58YCAaXf5eAJ+1vna1eEUPuU+Ez6EhIPG77PXmK7QciGJsDNAHt2D8ke3vDio+Hz\";s:9:\"js/all.js\";s:71:\"sha384-RiuSF/PBDHssKXqYfH16Hw3famw7Xg29hNO7Lg636dZXUg42q2UtNLPsGfihOxT9\";s:12:\"js/brands.js\";s:71:\"sha384-yrJPiY+1PdmFAwIfz5kqOJt6qBz7DmhXnjLZWLQ9FopoqnhHIBdOQk6hafYoSquV\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-bIg1sG9EStRr/9ohrrZJs0/uTEvUEEOO+NWuOAsIj3a1ZCHqvWUW6w975b4BSbqI\";s:13:\"js/duotone.js\";s:71:\"sha384-1EFXmt5rBEAK6aeEt/mZiYu0QhdFqz7oRm0Kc4xKyZ2IkrQYBc5F77PWXv3Jl4jY\";s:17:\"js/fontawesome.js\";s:71:\"sha384-P6BxA/EZmb6ypE1RKWOU6G8Ww/wI6w4R6uP6u9mkq3uaBehDQxHOLax3fLvDqkvt\";s:11:\"js/light.js\";s:71:\"sha384-08D3jBd9Co2q3IJB/9qnaukQ4ZhFWVLATRpNirJUQ+yQ/oUORDPfJ7Z2OWySf7/A\";s:13:\"js/regular.js\";s:71:\"sha384-zw99I3pdjnsTnY9W+2pz18pxMpOw12uAiVqYL4dZJOf0Lm8dio2v03Y0L2wzECI7\";s:11:\"js/solid.js\";s:71:\"sha384-Jr2b2cxzFQ84TxM+s7yh1jUu1f4FLCHQQDT3ZeBYZNQo+xvCw52PmB7GbC9yqSqA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-sLzGuPzMXKEht2hBPBvC5ere217qvxFZ1AogesHLWdB5ojWBInm4wE4J+HV7PB6z\";}}}s:6:\"5.13.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-Bfad6CLCknfcloXFOyFnlgtENryhrpZCe29RTifKEixXQZ38WheV+i/6YWSzkz3V\";s:14:\"css/brands.css\";s:71:\"sha384-yZSrIKdp94pouX5Mo4J2MnZUIAuHlZhe3H2c4FRXeUcHvI2k0zNtPrBu8p3bjun5\";s:19:\"css/fontawesome.css\";s:71:\"sha384-syoT0d9IcMjfxtHzbJUlNIuL19vD9XQAdOzftC+llPALVSZdxUpVXE0niLOiw/mn\";s:15:\"css/regular.css\";s:71:\"sha384-rbtXN6sVGIr49U/9DEVUaY55JgfUhjDiDo3EC0wYxfjknaJamv0+cF3XvyaovFbC\";s:13:\"css/solid.css\";s:71:\"sha384-fZFUEa75TqnWs6kJuLABg1hDDArGv1sOKyoqc7RubztZ1lvSU7BS+rc5mwf1Is5a\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-zMDYkJEHc2iapAk7o9HXGGD5N2+GGhOFQPDdNTYvlcc0gBA5r7r5f0aSYeCvm0qn\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/7iOrVBege33/9vHFYEtviVcxjUsNCqyeMnlW/Ms+PH8uRdFkKFmqf9CbVAN0Qef\";s:9:\"js/all.js\";s:71:\"sha384-ujbKXb9V3HdK7jcWL6kHL1c+2Lj4MR4Gkjl7UtwpSHg/ClpViddK9TI7yU53frPN\";s:12:\"js/brands.js\";s:71:\"sha384-c4QRk2vaIFBj+66H3IMCeLBpgmeNbFV8HqOs55qMib1v/dM3JXdodyctPNa9hTyl\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-sDmAMseQ6ZkNcFsP2c8NLyUmSqzUpn9PdoWqr/IP+mXZANSiuN9/09SKaEaMJ39l\";s:17:\"js/fontawesome.js\";s:71:\"sha384-/uNTArWag0fq+MOMnITxuc/uQTqh5NVc+1x0LO4xG//FFwUa8Xff8zrZXIpETdf9\";s:13:\"js/regular.js\";s:71:\"sha384-5FWE8IhPJgMtacw/tJgCapT/ag4ftBYmykFO3KUsozTQ9JKaQhH2oX7RZdCDyWxg\";s:11:\"js/solid.js\";s:71:\"sha384-dCJKkv4KgC8c4IlevkK2DC4yY+rQidnMOt91EmILDbdn8M6cdsjaUbf6awWnsCaZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-XrjUu+3vbvZoLzAa5lC50XIslajkadQ9kvvTTq0odZ+LCoNEGqomuCdORdHv6wZ6\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-IIED/eyOkM6ihtOiQsX2zizxFBphgnv1zbe1bKA+njdFzkr6cDNy16jfIKWu4FNH\";s:14:\"css/brands.css\";s:71:\"sha384-YJugi/aYht+lwnwrJEOZp+tAEQ+DxNy2WByHkJcz+0oxlJu8YMSeEwsvZubB8F/E\";s:15:\"css/duotone.css\";s:71:\"sha384-oRY9z8lvkaf2a1RyLPsz9ba5IbYiz1X/udoO3kZH3WM+gidZ+eELnojAqaBwvAmB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-tSxOKkJ+YPQOZg1RZd01upxL2FeeFVkHtkL0+04oWgcm9jnvH+EQNLxhpaNYblG2\";s:13:\"css/light.css\";s:71:\"sha384-HLeT9I9TL5c2ujLOZhv6z58D+FdF5R//KTyhCOiYBp1ZX9ZEdaVKPxZmzPx/tMWY\";s:15:\"css/regular.css\";s:71:\"sha384-BPtrG4jSUTPogkW6mA5hAGjvJapJnnMa8tKHQOR9MnrINanXN/IGDInK/SngoAFb\";s:13:\"css/solid.css\";s:71:\"sha384-9mSry5MRUHIfL5zghm8hV6FRKJIMfpofq3NWCyo+Kko5c16y0um8WfF5lB2EGIHJ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-9WuNcdGCglpaefA1oUecTWMQL/+LmrCJiJJM+pDHX+82lfkj1CKUYLc6DZJQ+1/s\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/WH+7sthk7TduL5PHd16Jew3Hd7eKInsAclAq/MoZWeyR4bMgUj12MSN79PtHEjc\";s:9:\"js/all.js\";s:71:\"sha384-Z0e6PSokCQP510gixgZGPs+obVv8eogS/eS2+/7lLSMOfmLnWBgPQppPispQXGUM\";s:12:\"js/brands.js\";s:71:\"sha384-T90KA1rFqB4OFs7EjJ9EGjXJkOXPhELY4hLaFVnB0LaTNUFGn3QyzNJZh307KVVc\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-8g5Au/J6e7pPZjkCDisd8Jd9psYpdlosRUbac9lOdXAADXrNgc20T1Xc24eIy3I7\";s:13:\"js/duotone.js\";s:71:\"sha384-dkbWEvgccxMcr38iB9BWNiExUnolXcLY54hGUJkFUqThvx5XsvcEervgRgRWz5fl\";s:17:\"js/fontawesome.js\";s:71:\"sha384-bU46hq+Od2wfS4XGCT7Ab5XmYYYY8LURSiGsr4YLIrUWBPeImW/B+OkFEcHhOzuF\";s:11:\"js/light.js\";s:71:\"sha384-ipYj2yPBG2ozjlrUCd6AheWkvEpqcCQNY7yxX8wDoIJc5Lr1zVXAE4sKB3hVfjfT\";s:13:\"js/regular.js\";s:71:\"sha384-5CC2/v59nxbyM1595fgM84ERvZXK5WbpCnB9/dd1gTJc2LyitbiKhULkaiXZNj6V\";s:11:\"js/solid.js\";s:71:\"sha384-Imz7xdjp2/vTu6azMFMusPHfSLwcYmj5ZWzOXv3esrLD8IDP9AMA28bwpJZwaR1g\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ZbnNry/TJ2Ald71QRyefS1elxArPz0oOfiNFxpfSO0Yb5lnnftVJMFbENL3j0hCf\";}}}s:6:\"5.13.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-xxzQGERXS00kBmZW/6qxqJPyxW3UR0BPsL4c8ILaIWXva5kFi7TxkIIaMiKtqV1Q\";s:14:\"css/brands.css\";s:71:\"sha384-pmyS4Hp0pc0tA0poF+AKYeURgyIgYLt12rD/6gLC98rTImbSYIe75vT2/3jK4zIh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-O6duc3QftgMWW3awKiGYswymy288kVFZgGWC/4YCl48Y0codWJRgs8DA0N4dX/zx\";s:15:\"css/regular.css\";s:71:\"sha384-aDoEE1PtWF0YZqVk7el3O+QPApPko7v9/7VYyuzjhHWwJ3cmn0m7xE3/FkHSpPNT\";s:13:\"css/solid.css\";s:71:\"sha384-wG7JbYjXVhle8f17qIp6KJaO/5PsPzOrT76RgvdRGLHj0yXZZ3jg98yb0GNRv1+M\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-CFCaxC5Lp+1aYrNgJjxz8bNrgnzVPnSxma3pb+m90jym25B+q2vYd3JfLQR00SNn\";s:16:\"css/v4-shims.css\";s:71:\"sha384-KkCLkpBvvcSnFQn3PbNkSgmwKGj7ln8pQe/6BOAE0i+/fU9QYEx5CtwduPRyTNob\";s:9:\"js/all.js\";s:71:\"sha384-heKROmDHlJdBb+n64p+i+wLplNYUZPaZmp2HZ4J6KCqzmd33FJ8QClrOV3IdHZm5\";s:12:\"js/brands.js\";s:71:\"sha384-Ay9V1h0l5sywM7gJ5YvOc05QytfKqZAElRgqU5kPcIIUAUBqLOYwu9gnW6p5t/FN\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-xDU4X/EdF/mFSa0TktUKBTHd/td1gTc+xWNLKdYcvrAUZExjiWhDnrLM4lGkqzeH\";s:17:\"js/fontawesome.js\";s:71:\"sha384-4NJBLvz0eHSgtSVDb+VOLh4cxmVluIBqCaNw97NvJAo18r+qV9pze1g4YnhB/X6Y\";s:13:\"js/regular.js\";s:71:\"sha384-omrmE/gvA72r1j409JaSn3V6w5f7Mx7GZpjB8xqS4nLwGpT7Zj2obev62Y9QcCZr\";s:11:\"js/solid.js\";s:71:\"sha384-81RFXCmeESYg4G/uFGo6Tu/eeK3klw0oKItW3nPhi2BuryJcE4lkOkwWsW6jzoNz\";s:14:\"js/v4-shims.js\";s:71:\"sha384-CtI1i5e/58ZMUgZkT75wgboNZAbEXBNToPY17SfEmfyKvGuJW7DP418LdXkjI++F\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-B9BoFFAuBaCfqw6lxWBZrhg/z4NkwqdBci+E+Sc2XlK/Rz25RYn8Fetb+Aw5irxa\";s:14:\"css/brands.css\";s:71:\"sha384-e0CAD3LQqbxBCI1WW9pe35Vr+ogbg41axplGx9yY6Woaw6h+zHnB7v4sVuZjHDnK\";s:15:\"css/duotone.css\";s:71:\"sha384-jZslG/z2CMKpawOGi2BzAUH7QBRu5umkFNeP0Op1SZksaT8WGx5MuZazFfE/XR9h\";s:19:\"css/fontawesome.css\";s:71:\"sha384-eKHMjnfl7jrOmk1Fw4dpPDTetBHFOho47C/omrsmBVN2ii45aI8s97OUFVtGg1CR\";s:13:\"css/light.css\";s:71:\"sha384-N45G0WPo8CMcXE4y+hOnuWLp2TJxNbhk/YbM4GQEymB5fPGzOXVH+er/7Z15oBjl\";s:15:\"css/regular.css\";s:71:\"sha384-h1Eirl+AlKkBdUtIMW1hm36KarFrx3iEfjcnTYKeeUdZTOsT8hLDc0lnlNG2jPn5\";s:13:\"css/solid.css\";s:71:\"sha384-F78AVlY1oEzT5bXRSwVzraqWTcbpglP7ILEEE3rmu1gIfm/TUo5gpdN4YVfvp7Xj\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ZFFudtU+0nvUFj6ogUZSspaq7QhLb6JJX6jSIu5UiZAbZMhnBJfNwZahptQ4MQ/i\";s:16:\"css/v4-shims.css\";s:71:\"sha384-He820UjOck3Qu+A0dH2+CmHOeYAYN0kqRW3s6hHC/Jzu8IXSeZF2pn+lgVpz4KuJ\";s:9:\"js/all.js\";s:71:\"sha384-RFburpZVVirucdjarLLIoBiT+LY5YuPB8XboZYWRuWpElr46csH7Ia2nsHfkfBZF\";s:12:\"js/brands.js\";s:71:\"sha384-bM9U2rf0yP/4jsztQkRVwJnqtVcLJzwAMaVgd4sfQYxxm0ru+TieQ4ZaxKW4vsyo\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-DuzRvwD99f8XqXEPIxkpB1F+Ik6c2AZMj6gWcEDwFUCAgtVSelRH9Dos4SMxw/+i\";s:13:\"js/duotone.js\";s:71:\"sha384-uABtWM9HIHso7RIYTkd4w0zB8IgL/hTcPNyYTVA62Qw0lK3umduLb+vIYtXCd6W8\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ta21ZAqXVyXVqLCnHENnO2ULnrJQzNdGFAbMR1nbZOSV7PcTcZVIWZJCCcRYy2Q4\";s:11:\"js/light.js\";s:71:\"sha384-+8Y6x3Roex77ZBdaQqtTN2QKu/TIOdzoswRYxryfW9ELmUxMTYLgzdz5nlA/3ndC\";s:13:\"js/regular.js\";s:71:\"sha384-sSHWg/dKYjGSJU6C17C2qGImASfPcJqy2BaW/iTzifkPJmzprIMH1tl4/tIbWq8M\";s:11:\"js/solid.js\";s:71:\"sha384-VBOdkc1roPM6EIGTBi2yraUNs04SZ9+TsLzF0vIecIKYf6oXYxAYgjzMpH8UdZYh\";s:14:\"js/v4-shims.js\";s:71:\"sha384-iwdWtJevtQK06+Bbqeb7Oo+osfnPQWsHQWR+5SeND0soWVUGjfyRC2XdttrYI2j+\";}}}s:6:\"5.14.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-HzLeBuhoNPvSl5KYnjx0BT+WB0QEEqLprO+NBkkk5gbc67FTaL7XIGa2w1L0Xbgc\";s:14:\"css/brands.css\";s:71:\"sha384-MiOGyNsVTeSVUjE9q/52dpdZjrr7yQAjVRUs23Bir5NhrTq0YA0rny4u/qe4dxNj\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PRy/NDAXVTUcXlWA3voA+JO/UMtzWgsYuwMxjuu6DfFPgzJpciUiPwgsvp48fl3p\";s:15:\"css/regular.css\";s:71:\"sha384-e46AbGhCSICtPh8xpc35ZioOrHg2PGsH1Bpy/vyr9AhEMVhttzxc+2GSMSP+Y60P\";s:13:\"css/solid.css\";s:71:\"sha384-TN9eFVoW87zV3Q7PfVXNZFuCwsmMwkuOTOUsyESfMS9uwDTf7yrxXH78rsXT3xf0\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PB7dcmSOBXciTYYzTvxdvcCEy4k3woMwwVAtsIA3LUQyKW21C7UL9EcGtd6IRNLc\";s:16:\"css/v4-shims.css\";s:71:\"sha384-9aKO2QU3KETrRCCXFbhLK16iRd15nC+OYEmpVb54jY8/CEXz/GVRsnM73wcbYw+m\";s:9:\"js/all.js\";s:71:\"sha384-3Nqiqht3ZZEO8FKj7GR1upiI385J92VwWNLj+FqHxtLYxd9l+WYpeqSOrLh0T12c\";s:12:\"js/brands.js\";s:71:\"sha384-V7gsTxvUZaeC6NAsCa24o3WvPOXwSsUM8/SBgy+fxlzWL3xEGXHsAv2E3UO5zKcZ\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-uMs7U5rgbKM9mJ/p05oZ+z+8uK1lwLhl96KWxP5odG0wm26IfhzgKQ0ktZnc2PYP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-DNo9bmYZCHLtp0n0l0XA2UsoRHX1nx38aRP+p9yoP5A8kVTfeWG3aySMOq5FD/v3\";s:13:\"js/regular.js\";s:71:\"sha384-zHXcIX0meH+eFgqCa9QdLtYfc+0p7KcF4fVB+gMVFjV6rzYv+LxSIuF5i2eGVDlt\";s:11:\"js/solid.js\";s:71:\"sha384-4RG3cEPIlCBy6VNzxM9ZoEwZW+65ed5JDOfaJAnQqwV6ha/jZDJTXjFmvjFM4bk4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-g+ezV6Pq6549QkJkkz2wmW/wpazNaliTdSg/HX4bKsQ7S8cfyMOiyAfzfWPtlVR9\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-VhBcF/php0Z/P5ZxlxaEx1GwqTQVIBu4G4giRWxTKOCjTxsPFETUDdVL5B6vYvOt\";s:14:\"css/brands.css\";s:71:\"sha384-DkuHshSFBB5Ozmaoq36ICABPCsIIbamipzuH7NO0sxDIDrJloLD43yBzNLI3gxS6\";s:15:\"css/duotone.css\";s:71:\"sha384-QRFqAT1IRNAzMGALiXfanFtQEBoLDPPh1vnrMbxHa+UeJkCTHO3TpYXHQ+GK1pKg\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CAxg0L30Vie2vI3AniQ4UA+pSswoJmr/MK5Dl5DP9YlE1nzJn4z5updw5S3i/Nsn\";s:13:\"css/light.css\";s:71:\"sha384-LmKkPHDqucxgmrtLKWrMGZc5nnHQYAdFkSzMtl1OcvTZn4pebmVziSZPtp27MA6u\";s:15:\"css/regular.css\";s:71:\"sha384-izRgjQadEFrlAsdFZjlQ4v6Ff2E0R02RwYZwdL8lrt398rQmLNOFYYNk9qQoqjDP\";s:13:\"css/solid.css\";s:71:\"sha384-qJugmlTDyF5CNuv00JB+04BCmCVi5C2ZZhsIVMX0wxWr7U3ZuOsmO+nOLtoTxeWG\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-EjLtrKO3gucE2cOzLw8A5aJpQ9oXEJTxlTkbLrrL4JR7xGLPI8B1fyK3ygNxeLxq\";s:16:\"css/v4-shims.css\";s:71:\"sha384-oydBLEZZlqJqf0OWwXyyj91mRqrL25j/VMAvTl0BA0iIMoJGDTSksMDnqkl+TWLA\";s:9:\"js/all.js\";s:71:\"sha384-8nFttujfhbCh3CZJ34J+BtLPrg9cGflbku3ZQUTUewA7mqA8TG5Uip4fzQRbERs0\";s:12:\"js/brands.js\";s:71:\"sha384-9112PiGcvkxlUNBecZ0rk0c6zEGUKlR/enlHdLy0Xu42kfHEbIKsFVBsmEn+6cEt\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-9rbnCwKDHzpLDHYvYRqRWcyLZc3anAu+oe1dRxPOk7RcqBzjAv7CYTvAQJGkUNXS\";s:13:\"js/duotone.js\";s:71:\"sha384-HFlrQxjzjMUAiYmFuUKrkp90VMEpD/dpb8unLEWH5QXnUs2xHw5zd8aiztrPBLbT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-XULY2W1C7bGq9gruRvsk8Zyhq33b1/TgBBKzJ+8dzWkJm0kObgcry2qU+Qf+HOZw\";s:11:\"js/light.js\";s:71:\"sha384-a8Ul+Nmi3glFYXvks3ShdxGHyk09LsZ3+TIjDr2vj9lMx2F29TqTJm7U0EutxFdH\";s:13:\"js/regular.js\";s:71:\"sha384-B8V2/SCNt/naDJB0LkeljUBBYYhGFm/rUVnNsFYlutzbeSTTzVEqxRo8SN3tuHSl\";s:11:\"js/solid.js\";s:71:\"sha384-CjNAVlgtLE9uQuDgWphA+b5vXjcy5spSSezhnbGWUZl0VDkAxzeU8elFOdDs4qaU\";s:14:\"js/v4-shims.js\";s:71:\"sha384-kN/8Lc85No/I30OsF5JSmBzc0W1W0AvgBJGA1eEtVSfaiIeg8oPTJ8CerHqDREVn\";}}}s:6:\"5.15.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-vp86vTRFVJgpjF9jiIGPEEqYqlDwgyBgEF109VFjmqGmIY/Y4HV4d3Gp2irVfcrp\";s:14:\"css/brands.css\";s:71:\"sha384-/feuykTegPRR7MxelAQ+2VUMibQwKyO6okSsWiblZAJhUSTF9QAVR0QLk6YwNURa\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ijEtygNrZDKunAWYDdV3wAZWvTHSrGhdUfImfngIba35nhQ03lSNgfTJAKaGFjk2\";s:15:\"css/regular.css\";s:71:\"sha384-APzfePYec2VC7jyJSpgbPrqGZ365g49SgeW+7abV1GaUnDwW7dQIYFc+EuAuIx0c\";s:13:\"css/solid.css\";s:71:\"sha384-yo370P8tRI3EbMVcDU+ziwsS/s62yNv3tgdMqDSsRSILohhnOrDNl142Df8wuHA+\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-wvKQCF3aHjf73vG90/oO/tFarRthMbxfbW1DeHM+eJJYWmiFLJ0DyCzE1aSFHazB\";s:16:\"css/v4-shims.css\";s:71:\"sha384-WCuYjm/u5NsK4s/NfnJeHuMj6zzN2HFyjhBu/SnZJj7eZ6+ds4zqIM3wYgL59Clf\";s:9:\"js/all.js\";s:71:\"sha384-9/D4ECZvKMVEJ9Bhr3ZnUAF+Ahlagp1cyPC7h5yDlZdXs4DQ/vRftzfd+2uFUuqS\";s:12:\"js/brands.js\";s:71:\"sha384-GUtlu2Qit8cdodM5DbKnbDIWFJA8nWCVEwETZXY2xvKV1TFLtD/AL+bCOsPyh05M\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-sefi04js7ZytQojQsuOy097ewgefakplyIWjkCI75Wz1IxHB/9NAAinmgLG3uDt/\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v0OPwyxrMWxEgAVlmUqvjeEr48Eh/SOZ2DRtVYJCx1ZNDfWBfNMWUjwUwBCJgfO4\";s:13:\"js/regular.js\";s:71:\"sha384-i9Vys31h0tPXNeAe12HKp4zkBi0S3LAH4OGYRSWKSrdnPYTS4pQgCc/HakrenJBh\";s:11:\"js/solid.js\";s:71:\"sha384-oKbh94nlFq571cjny1jaIBlQwzTJW4KYExGYjslYSoG/J/w68zUI+KHPRveXB6EY\";s:14:\"js/v4-shims.js\";s:71:\"sha384-IEHK9LKBXJdi7Y/gik7R6VYPuwx8hMiwQuaOh7BQUQ9rKmWr2N04KYFdmt5Xi0qG\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-9ZfPnbegQSumzaE7mks2IYgHoayLtuto3AS6ieArECeaR8nCfliJVuLh/GaQ1gyM\";s:14:\"css/brands.css\";s:71:\"sha384-YgEKO0tR8hhGPO9Dv3YGK+GstKp44//D72dbOA0oTX+7myWawnkifErid6FIpP9W\";s:15:\"css/duotone.css\";s:71:\"sha384-bXXzjCj9fg9FACS6tpRWhBsNqQ7j7swH/U3MKTJrZuRbF3ktmj9g/lie7L3CNSTd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RFOcGND+1HYm6OyEAF5WKkoZnwv/cXQpCX6KduKC1vAKAoohkNYWNPhkx4fsH9Fn\";s:13:\"css/light.css\";s:71:\"sha384-yWmEVLm9kM0L2w+XPDQQUv6tARNHEYPPwdDplMiVced5iOVoiUIToRveagZ56DVa\";s:15:\"css/regular.css\";s:71:\"sha384-pvlGSUiPzTZa8YsqGs23BENlf3D4ddnLRdl2q5R1ekGw7nnWJZ0AK74DUr0mzLTH\";s:13:\"css/solid.css\";s:71:\"sha384-LRz1HmzqffP7wO7piC0QSObi89cOdpFP7qMIx/UZ+qK2TdoDBdl+LidxFVnYu23p\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-mFHdQxElacASluqApikB6+SUGnAOWouxc19KqW5eZGoZ+b4A/Cj6pMUCGn6g1uZ+\";s:16:\"css/v4-shims.css\";s:71:\"sha384-r35xeRHwDKxzFjeApFdZuwo9D/nV4p0BPL4BxIVmsyKQGWWBaxG59Gr/9x7IfVog\";s:9:\"js/all.js\";s:71:\"sha384-Vipr9QSlUeD/qnhkau6GBnZnUmVkbaRZ0PgB1KjvWa1UoNBKnuzg1TgbJJn2a12T\";s:12:\"js/brands.js\";s:71:\"sha384-rdZ4AVYAMfVJRjRJzozK2JY6LOdLxKdUkHuegulAuMdllLH7M9AllgBLuYmBe+zm\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-qgGl/EYa0JYIveAO7M9W/hshMqlMyo0G/QHio/5D5r1ZbZxAoqcTTReeL4gRrL4m\";s:13:\"js/duotone.js\";s:71:\"sha384-4qqOVq7ZvSMSgZij30G8q1kOs7pBiAWrSVKqWRv32l99D/qqXlMpFQK8wLSfeQEZ\";s:17:\"js/fontawesome.js\";s:71:\"sha384-whiLNjPVOuBfSNjL/tLtRWANHP97vxmZ5OoUK496MOTzH07UdmxDLsnSBgvvjLNf\";s:11:\"js/light.js\";s:71:\"sha384-AEYbWLXnCyDCeopMCsF+A4qHLchpzJ4wMnZiE74Bcp6qLWwXIJCWY0ASqAf0qYrf\";s:13:\"js/regular.js\";s:71:\"sha384-wM50oZlS/21q6M6tlw0EWan+0yFpuRC/PrPeimdGxjCjfx45F0x3NZggS5uFp5uv\";s:11:\"js/solid.js\";s:71:\"sha384-PezVa2U3+0USHwNA7bgvfA+uSS1IPVdTat51a5IgvNGHUJjcvsj+TheZ6X30JybM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-MafE1kr6MZ6PhxNeH0/kvg7f5ramk1tE+y/dBi4C6WgxaKU4mNGRxPNxcEZ5maAx\";}}}s:6:\"5.15.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-vSIIfh2YWi9wW0r9iZe7RJPrKwp6bG+s9QZMoITbCckVJqGCCRhc+ccxNcdpHuYu\";s:14:\"css/brands.css\";s:71:\"sha384-RTi1U6SIW2G3kUi5NslKQjA34F8CsQCVduJO50jqtxhR2KY++LR7KZS2886EwXrk\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Hx1dya9ptAdKu2hLNR5C2Cwgm+wCfwD0VMGE6jk5OUxxa9I58YfxOCwEtRog+3wk\";s:15:\"css/regular.css\";s:71:\"sha384-GMkIgTgosuQEt2PEwBHI7MMRsrQplN2sT/7bzPOIxG+Hn37iTlZXFb37m6uE+iHj\";s:13:\"css/solid.css\";s:71:\"sha384-6qO6EOFIDfvv6uzAzozX/BvMu/qkIIHxWYOVMjpVjX+NtPuNyd3YiOEflKIIV2ka\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-6iJDq4HKs21oqDV0KkGhh5uve3aJBXwTX0ACa8Fp5Sx7fcZtIumvT+GSzqSEsceV\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1CjXmylX8++C7CVZORGA9EwcbYDfZV2D4Kl1pTm3hp2I/usHDafIrgBJNuRTDQ4f\";s:9:\"js/all.js\";s:71:\"sha384-vuFJ2JiSdUpXLKGK+tDteQZBqNlMwAjhZ3TvPaDfN9QmbPb7Q8qUpbSNapQev3YF\";s:12:\"js/brands.js\";s:71:\"sha384-CFHIjJ6e4s9fugmZkgMS+xAN9t3pMb8WzxVLSL61rvRx/NfBorLHHVF+7/xxhpll\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-SY45zU2Pf71PV9B/kvEgK9jzpEbe14MiprEwrg1VcbXdBcjXbNTPwoXfp6A+ntJG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-PIP1h/CVyNo59Pr+vM6s86Zkm82HEv890eKMTpB5eqJZFZQwZuMwf73Sy5SzVrK8\";s:13:\"js/regular.js\";s:71:\"sha384-ghS5pTGfZccQRYN4cnBH4kBWGY/ePY4j4VKfFliJmM6ZYomFMIo462PxXa2RGqWR\";s:11:\"js/solid.js\";s:71:\"sha384-rKdfCFMYG2O/K+5WQDPmcKngEtAvqyIxYkazidXjp48yEiCcl//F6lxZ9cZ8MhM+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-VxtQ3wW8qt0QTDld0MGEB9IMEOyCOtvOXC7I0JU3T01V6NR+C6MP5HxC+tGNkhdV\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-yJpxAFV0Ip/w63YkZfDWDTU6re/Oc3ZiVqMa97pi8uPt92y0wzeK3UFM2yQRhEom\";s:14:\"css/brands.css\";s:71:\"sha384-rsNdgxJGzM0RuTegPn4p1eHXocyvt3ZbnTifPXmOewdRLCOqzP22d/M+WxbRiwSN\";s:15:\"css/duotone.css\";s:71:\"sha384-E4/odus3ylondNThYB3uIGSZpewOhvhh0QD8x2p7S0ot6p/JcbVd//lr7cMEUIBc\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RZW433tEsVW3OLEaC2n31z0V1DmyQdjrwNKMRLBjyZQ7r4RU0PxYhkvjKCsZMCO3\";s:13:\"css/light.css\";s:71:\"sha384-oJib4m7hS3ZSiUXjFvObb+ZFf2AGOBOUX+MFk3CuBZwz8LQSe3d3EgZHHJBkJGXT\";s:15:\"css/regular.css\";s:71:\"sha384-ffFT2jJN64hGajTqkZsA2KE2SDBO2Gcmb0wr10fRLpKNDWYcl3M3KsLuzQHg5QAh\";s:13:\"css/solid.css\";s:71:\"sha384-PfqDBw8PmSrNcYq7F4SvYoZekYP2x84SYAyG41rncZdySTjSS9eWEE7ynvJRElQY\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MeQL8xjLhct6yZa8AXEQOD0yWeV925K9YrlcgspMC+IdCbI3q1b8B7VX8NS6N3lS\";s:16:\"css/v4-shims.css\";s:71:\"sha384-vfegZgYJmcP2K/VrhAwtTtU1OgvF83Y8zoQ524YvQFIGowI3tr8C6wvpWUsSLUZA\";s:9:\"js/all.js\";s:71:\"sha384-ZbBwfM248+qoG5GJvuV2PmK9gvlW3dXpgC/jeIn45pWWroL3v+5K1ZAth+gs165y\";s:12:\"js/brands.js\";s:71:\"sha384-K53M8ZRlon+Wd3MVzcIEU1NZXEh4h98NnLM8WZ/7E98pbg0J1q17tKGgr45c5qCs\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-whZrbu3lLf9+EK7QxSHsdpAWM0drsjefOTFm3zfcUhZSInAwLaIrdOd2Qd8MKDMW\";s:13:\"js/duotone.js\";s:71:\"sha384-nTarcZNLMStpbHz1QpoaqVDyKoUrzncdV+zZ040hkinCtVKl8gTXSiyUM4h0K48M\";s:17:\"js/fontawesome.js\";s:71:\"sha384-dy2wSTcBbCGnFNjThZw/FfuNbPeoGoOSWgX7HmvH3PKcJ0Se3w3CZnalamfRuLpE\";s:11:\"js/light.js\";s:71:\"sha384-gL1IbgNyLHskDPg9uinrWBfxmDsla3neHzcEAIjbzQTx6W69Jvs9S/fRBXUt6FbW\";s:13:\"js/regular.js\";s:71:\"sha384-9JMXUFvwOD5rSQZs74FEC4SsybjccRbbwK7iiQiriFSd4sPr7pB7/ghp1KZH7tCr\";s:11:\"js/solid.js\";s:71:\"sha384-oVJ5+ellTPbci7MOrfl59xerw0M0RnQEGG0jx/JlNyOpkvrXHaZUCfKJUs08+gVi\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ht5Q/pi1VU6byhn9MctthIZ2kSBqK5GhhR9gnTzPM+BJlAyCymRS3xx74c9twxdh\";}}}s:6:\"5.15.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-SZXxX4whJ79/gErwcOYf+zWLeJdY/qpuqC4cAa9rOGUstPomtqpuNWT9wdPEn2fk\";s:14:\"css/brands.css\";s:71:\"sha384-V5Z1KgRRJyY878qCx7+zUeTDm0FgjoYrbmSortFqRPGz+Ue6XDe4uIiMqB3tB/wd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-wESLQ85D6gbsF459vf1CiZ2+rr+CsxRY0RpiF1tLlQpDnAgg6rwdsUF1+Ics2bni\";s:15:\"css/regular.css\";s:71:\"sha384-Dn9L7vwedvmbdep+J8U5Zbrp+ES46dt8pm8ZMUu9iOR9isC4+Y/KP1h4StrDd/F+\";s:13:\"css/solid.css\";s:71:\"sha384-LA8Ug4T/nhVkyhrSmSirsoAo9iDrBk8E7U80aSPeD+w3vO8PzOJIS6agGcbIwwX0\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-C4KLoR3asMHYArL0nLQXEaFZIFfRMiV0Ul0DvsMfSMZ+YLJwFu0Rpxix+EZwqxOy\";s:16:\"css/v4-shims.css\";s:71:\"sha384-C2B+KlPW+WkR0Ld9loR1x3cXp7asA0iGVodhCoJ4hwrWm/d9qKS59BGisq+2Y0/D\";s:9:\"js/all.js\";s:71:\"sha384-haqrlim99xjfMxRP6EWtafs0sB1WKcMdynwZleuUSwJR0mDeRYbhtY+KPMr+JL6f\";s:12:\"js/brands.js\";s:71:\"sha384-oEE/PrsvhwsuT1MjC4sgnz39CQ84HoPt8jwH0RLyJDdDOKulN+UEbm9IgJW0aTu5\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-OwOgf6Oss8Oh+cy6VnIGLlcyMhaaOPN+3gyLv2UyvjybuPrTNNgJljGYEAqSglUM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hD97VKS04Rv8VYShf782apVZOVP6bVH/ubzrWXIIbKOwnD6gsDIcB29K03FL1A9J\";s:13:\"js/regular.js\";s:71:\"sha384-bPKzNk+f6IzEi89cU+jf3bwWzJQqo+U1/QYUijuD7XD9WO3MSrrAVVEglIOCo6VD\";s:11:\"js/solid.js\";s:71:\"sha384-9xA4r2/2cctd+IZZKLvI1hmeHZ5Yp8xXkS6J8inDtdyZCqhEHVcTGmSUCbNED5Ae\";s:14:\"js/v4-shims.js\";s:71:\"sha384-oJX16kNznlRQV8hvYpOXlQKGc8xQj+HgmxViFoFiQgx0jZ4QKELTQecpcx905Pkg\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-iKbFRxucmOHIcpWdX9NTZ5WETOPm0Goy0WmfyNcl52qSYtc2Buk0NCe6jU1sWWNB\";s:14:\"css/brands.css\";s:71:\"sha384-GTxp/8UKFkexlguDtPsFi90d++F9f26nZCM99OSQo69514FK7Of5mgM9Efhs5O9L\";s:15:\"css/duotone.css\";s:71:\"sha384-nuPd13VLdsw5iBtqelv9tQ6l6+CteSUrmoT5enzHVJodx7WdNUYXNwgVpA7bgsXn\";s:19:\"css/fontawesome.css\";s:71:\"sha384-DHjwMcq12OEB4DQ+qulZDDroaXZqm7h9V6AjiP/RuUF8NhxUa8x6UWdv1AeZS+90\";s:13:\"css/light.css\";s:71:\"sha384-IvEgf1JJYgCtB5fP9nmT3uC7DY96POpmhUjo/98B8FMju1w295nj5yGBfwgD3MYj\";s:15:\"css/regular.css\";s:71:\"sha384-Z3GHSXKByZgv1Ri9CiFq0jYUQ982JHZOOg4awUHcuVBjTxwNd+PVQO1/PSwChyzK\";s:13:\"css/solid.css\";s:71:\"sha384-Ymp/JSUSR6EuZ4KjxcliW8lJ7wkYBR6oasX7EMi6SG0QBPmNUDAEG9rd7Ogy0Ca/\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-n/+zO4Fk1/R4EL7q+xf44zBEgvFziVgA7BUNwfjcGjHq/X6U0v25ESHqN/l5Wprm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-yV4xIIsecn1iqxJy3IC5YyRSLwtkkFuOvfPvj1hGH5NLLej9Cum4hPOUL2uQYfQ6\";s:9:\"js/all.js\";s:71:\"sha384-OF9QwbqmlzSPpIxe2GYS8lkGFyaFfrgUPD2J3qj8zGVps17Y/x8EK2U8PEl6UrpH\";s:12:\"js/brands.js\";s:71:\"sha384-5u0zCiPDAEBQPvGxnai1VRZiSs9yQmyspSLrg0Fc7ru5CeddU1cef/24itMCpcWb\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-W0jz7GGBNDbeSyOhqqJrtOVDFLX4Qlqm/5K4RqM9ZpPIZL6tmDCMkEIheypFOiSK\";s:13:\"js/duotone.js\";s:71:\"sha384-rutYU6OuFfIS5MmBE4wrpMhP633bNlRHqn/SFpcetMTKr+rsBxnoTd80mkHI7wum\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hwdDrjZFQbBwoFcHZZ/6e61XHiwY9csS0Wxi8i5jUgTurxmYITntaGLFYCssX7By\";s:11:\"js/light.js\";s:71:\"sha384-soVEahH07bOeX1Nlhdi4VQ+yvDpIGN9A/qbzm/PgfDrpvh7AaCTyMkQNk1spjHbf\";s:13:\"js/regular.js\";s:71:\"sha384-GR++czVV+1briVrgT0SHxwKuKqqXqfkRb2NxZ8O4rad/c/iKIn85PDSaZQ3cjiAZ\";s:11:\"js/solid.js\";s:71:\"sha384-JwTquvZ50ZD4wvDw99MHsjx621x02jCoiXBKy103wTwDMBbDLmhRcCV4v9mq5CV4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-xczhE4W0SRyRFalFfxUKqclGdqLDVnc/F118WebJIQ/QyS3XKXIHXTieQKG1rG/+\";}}}s:6:\"5.15.4\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-DyZ88mC6Up2uqS4h/KRgHuoeGwBcD4Ng9SiP4dIRy0EXTlnuz47vAwmeGwVChigm\";s:14:\"css/brands.css\";s:71:\"sha384-S5yUroXKhsCryF2hYGm7i8RQ/ThL96qmmWD+lF5AZTdOdsxChQktVW+cKP/s4eav\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jLKHWM3JRmfMU0A5x5AkjWkw/EYfGUAGagvnfryNV3F9VqM98XiIH7VBGVoxVSc7\";s:15:\"css/regular.css\";s:71:\"sha384-e7wK18mMVsIpE/BDLrCQ99c7gROAxr9czDzslePcAHgCLGCRidxq1mrNCLVF2oaj\";s:13:\"css/solid.css\";s:71:\"sha384-Tv5i09RULyHKMwX0E8wJUqSOaXlyu3SQxORObAI08iUwIalMmN5L6AvlPX2LMoSE\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-meSUsKN46Q06zfndZ6zDskLd5vJrCPwgb2izpfSMfWpQLijQApceQWIsbpLy2lAF\";s:16:\"css/v4-shims.css\";s:71:\"sha384-Vq76wejb3QJM4nDatBa5rUOve+9gkegsjCebvV/9fvXlGWo4HCMR4cJZjjcF6Viv\";s:9:\"js/all.js\";s:71:\"sha384-rOA1PnstxnOBLzCLMcre8ybwbTmemjzdNlILg8O7z1lUkLXozs4DHonlDtnE7fpc\";s:12:\"js/brands.js\";s:71:\"sha384-xf4z6gHzXeY6YwFJm8AKcD9SSq8TsfF4+UJj1JxzwQHk+VNATxkknGEzmdtYV0w1\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-b4+d5l6vwWgdPDCbk4SG+VPRplFp3JtWehGqKvfat/MWON5/PSWvf0l89dpfUDUG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-dPBGbj4Uoy1OOpM4+aRGfAOc0W37JkROT+3uynUgTHZCHZNMHfGXsmmvYTffZjYO\";s:13:\"js/regular.js\";s:71:\"sha384-EEuk6Tk/hsJ0IJMUp+btTmHLuWPGGIm8I3xmxRawuWaY1xqWEm3EKVdnHNlYX+6t\";s:11:\"js/solid.js\";s:71:\"sha384-/BxOvRagtVDn9dJ+JGCtcofNXgQO/CCCVKdMfL115s3gOgQxWaX/tSq5V8dRgsbc\";s:14:\"js/v4-shims.js\";s:71:\"sha384-bx00wqJq+zY9QLCMa/zViZPu1f0GJ3VXwF4GSw3GbfjwO28QCFr4qadCrNmJQ/9N\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-rqn26AG5Pj86AF4SO72RK5fyefcQ/x32DNQfChxWvbXIyXFePlEktwD18fEz+kQU\";s:14:\"css/brands.css\";s:71:\"sha384-Q9/9nfR6hUHbM3NjqxA59j5l/9c23JjwDDuPsV5SKplBvgLpFDtJmukyC2oCwp28\";s:15:\"css/duotone.css\";s:71:\"sha384-Zi3Yce9z7/mhFiZHlM/DEBTnheymZyqrjMoWYPP8xtNCl+LtJKnaJ0vaGnPfqc/i\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ig3RKyui4sECvuz+WE8EmFYy7sjRvEvy82mmhfV7ljRieb+0f8eEZKxHv2KC0+io\";s:13:\"css/light.css\";s:71:\"sha384-zCLzLBaV9kpBZtwZ72K00PI4UjqXZhrzMeVtYGOOHqL2N5PXSVw2MtJjaWTKYDHW\";s:15:\"css/regular.css\";s:71:\"sha384-sDvgA98ePLM7diZOYxIrDEITlUxoFxdt0CPuqjdLr/w62pPuOc73uFoigWEnVpDa\";s:13:\"css/solid.css\";s:71:\"sha384-2aj01VFITmYatwqdIKc7PHVmhLqFnnkVCilBk0Uj/fGoczNJXKvV45XlyHr/HU9g\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-cHJCnE8H1fC+puOpWCd6OSOmJ1q8KxWtIm/JUpb9705KggGjyKbMzryJWJDw2OPb\";s:16:\"css/v4-shims.css\";s:71:\"sha384-sKQhO4q55X7e4nIIO+wnutVfpIITv8+QJG6hE15hThUjV3ssIxUGT4VAoAGYmOU5\";s:9:\"js/all.js\";s:71:\"sha384-8nTbev/iV1sg3ESYOAkRPRDMDa5s0sknqroAe9z4DiM+WDr1i/VKi5xLWsn87Car\";s:12:\"js/brands.js\";s:71:\"sha384-MwpSaMFXAxVGLfxKR0S/SL1BvfRLmlowKeqIE/yF7uW5ax+r1fqRs12asOCkF9Jf\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-my7QwPFkgZPqsrDx/vNCyAMQw86Ee5ZUeCUBA7CF0l9rWFcxoH+h+NdSGyYBh2pq\";s:13:\"js/duotone.js\";s:71:\"sha384-AFpIAPhppteteZyLTXU8oPEbmuNz5WwwWSVAKJxuEn51LibO/iPZ+fC5DzmLJzoo\";s:17:\"js/fontawesome.js\";s:71:\"sha384-RTs6cAeLGZoCPlBxXNxYfQnVIrvTagXGxIhrXFjWgp4i4E5urdGFLlkfbsk1Nd+L\";s:11:\"js/light.js\";s:71:\"sha384-6EhWHErkaXt19GTK7f+5rRc16ekdzvItcFycGZi1GS/AycADXj7L2tkZ9z2O71ot\";s:13:\"js/regular.js\";s:71:\"sha384-WWzdx7E114gkDQnLVS/7s5WUTa5KQUqY5D8LGqBB7y132sxhUbrIHfqde9aenKnJ\";s:11:\"js/solid.js\";s:71:\"sha384-DfpPYefTs8qX3aeMuUJxalewnmVXDDtxcIJFo+Bz1qrNTaoEwMIaZkfoWx404GvG\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9lueRrgA8PnJBSmeS0/jHPFpZZ/hC/7n/XNQhCroAsZSoTtaEj6Q+ewHcpgFPqFw\";}}}s:11:\"6.0.0-beta1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-QTEmscQJYWW3qGP+JMq44fmHSM1SbRIn3hxdZ0RBhX7yzbDOmdhCzVDY/nCs7Yfh\";s:14:\"css/brands.css\";s:71:\"sha384-YxspAfDWGMmVGaoWFDjr/ceg8QdLKNj76+YDQ3iXiX1d64PMg/rVRUQMIcd7loDR\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Y63uHbYQVeMm+hkTj/YJpPSWvwA7maoOgWIcH/L/Zil8zxKQNclQIgNioLyE+zQT\";s:15:\"css/regular.css\";s:71:\"sha384-3+YTU1oGJl/DJPoU+JvGaD8K0waHM6gIPSWeabncnJ1y/LzxnMdPNvXxvbJtzkH4\";s:13:\"css/solid.css\";s:71:\"sha384-SVoL9P0p4yDjJ7K7qukXf8FBr4TcwUEZpvnQv80juxlb+QtrhT0zH3Gidw6aACkN\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-bhQY/O7CPf/LJ1fFQ19Hb4zwFDg7vUCZT9GLZM4RVTzxhZCINjHGSM7VaB36hnHe\";s:16:\"css/v4-shims.css\";s:71:\"sha384-4q5P4wLQvP0vMZgsfSOPe2qSqfL+Y76J/5hi9QW1QqtZ0qdgSrcFRIv5MgSNtFX4\";s:9:\"js/all.js\";s:71:\"sha384-s6zGSTvDy4KZ4ncPlsj+2l4ATGBt+gXsKFfd4lR4QKFl2RgB4iOoqZzDkRqndbvR\";s:12:\"js/brands.js\";s:71:\"sha384-gksSOJLGNOMoFqSuS5Ki/PIhYoVzeS8bWP7Gg6b/6gY3FXNGW3ZwRY12rkFGpvz9\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-JsmVGsnClQ/8mX7vDm+8UJ9XHlqIuwxPIKrIkpXt4mJZiaeCzg/uXxY3OjB7MajC\";s:17:\"js/fontawesome.js\";s:71:\"sha384-PkZHTzZps6BUB70Jc6Ujwh17lPpgjVJlG98uCR+Dg+bsDNAHk7UbcsVq9pUY0QM5\";s:13:\"js/regular.js\";s:71:\"sha384-i/4zUQF6PMLPil02YpE9smRx7XTQ0/bwaSlMl4QZRk0yFj0PCJqkv231+5hjbcsq\";s:11:\"js/solid.js\";s:71:\"sha384-ufQzc6WFPbylIrm5F6yJOtKS4KCrT6hoEuGPNEMv+9Y2ZVmEC0Jt5Tqf25Q2hOa8\";s:14:\"js/v4-shims.js\";s:71:\"sha384-3dTEd1SkEJhxEBZpeAOJF+PzflHEdVc87NLQ1dQd1UFpZNiygckU0Ku29kJavA2Q\";}s:3:\"pro\";a:0:{}}}s:11:\"6.0.0-beta2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-H8oq+jCbb0QVbhroj1DucOj59MYLAHR4vQPc0ClgJJzMS/YL7OcRJfM/ehkfKqhU\";s:14:\"css/brands.css\";s:71:\"sha384-9RVmH5wLHK5upannGNFElXHKDeCRaoz+RuosjPpGqwUmn2+p5J5IBUd0P726kTk3\";s:19:\"css/fontawesome.css\";s:71:\"sha384-m+NmQ9JGB4PGDECPUaU3EyjsUk6jyyMoM53D/n//nHSADtoSKusJc/BF/ZffIvI0\";s:15:\"css/regular.css\";s:71:\"sha384-mwb6xqj3Cg9cBoRZDNp2p4Sv49gYTCgHVLVwbErL3sJCA+RJ3Xhwq19ezzyT1KqX\";s:13:\"css/solid.css\";s:71:\"sha384-sBOgtFigRpSU/zNyZLGNKX6O+VrUJzHdITsX3+nGRutcAaSdRMmnc8LOJk8XzoDM\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-/ShrxWgDzY0RmtJK6gusdzSMS1yYysWIr6y1FFEG9B7naj2HqXMNxatmNRgmRDCx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-wA6dLShvXgKngeGUYrFpv9/zgLLUtPxBL9y1OD9u5uQmeT3wWxvZVue3BO4xo4f0\";s:9:\"js/all.js\";s:71:\"sha384-vwquPQ7YyWL/EWINiNcgCpPP9Wbx44bLyI1NbrUJmEacQGGGWUzpERymaTAjvS9H\";s:12:\"js/brands.js\";s:71:\"sha384-X5eSej258z73rxsuRybt1adaWo6MobuyduuEYgYhbJMavb1jXYBhCqd1ZwRC9/7W\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-MOke50TwkELSa34Yzu6DEGxTlT3Wdn5DynHvqLANi/pFPBZxRDnFhJnD6mE/GuoP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-vo5XH3GmQrg9pkTZYURBhzEXm7Xslw9fD0z49HVMvdquMGvwTiUKJP4he5iFSPot\";s:13:\"js/regular.js\";s:71:\"sha384-UDm7R3v5rW8y32ssB0WDalZIS8AztwsdQERaPBHTRLStI7Bfr/fhWLuXr5nYZG8M\";s:11:\"js/solid.js\";s:71:\"sha384-f199SbfL8tgeze5wETQ87SF+anBX6Dmf9bWZSBvW02HFz602Fqhv1u1iCnKgdbls\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Teg5BVlogMJp4To5SNk5eS6Ct/+y3KN9D/UWWXr4e2JhUbT1rgnLDWGXp/TG/0a/\";}s:3:\"pro\";a:0:{}}}s:11:\"6.0.0-beta3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-5e2ESR8Ycmos6g3gAKr1Jvwye8sW4U1u/cAKulfVJnkakCcMqhOudbtPnvJ+nbv7\";s:14:\"css/brands.css\";s:71:\"sha384-Lzg1sLP4sLS8KyVySlmRH4QzbOnIzlp/h2MYRTDkxMPKwaD+zxathmN655nRjRSG\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RAtjHVFRUZs4Tif4stxk4r1UN31mhO2m2ii67jtwlyWDXls6IDZ6/N2bHxt3bA48\";s:15:\"css/regular.css\";s:71:\"sha384-TvfVCWnd24+5zZ+qmyScSguhYpT7YtOajZ0b4IVLn3+T3dFYzXkgu/EE/Nrf2km5\";s:13:\"css/solid.css\";s:71:\"sha384-4veAyGk1Tas2qyx7CD/29iLDa8aarX6vdaWWVPD7K/m8FdvH9ae9yFNbWOxmP1hZ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MLxC4sgXwbw5k1vFBDb68XNAF7UdJ7e1ibhu+ySJnAakTpweYCcq7jCcQpd5nJjU\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-LJQ43yQLnfgXK8pn645vHWEmSJrVqisZaieRPj7NGV7cCzlL/B67BDv8gMRBS53i\";s:16:\"css/v4-shims.css\";s:71:\"sha384-zCIuCI9fw3QOcUPL5/7JfB3Qw6sjEimma+57eLWmHPHyVgqGmX5XLwGi3Ak5fLzQ\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-W7b35mq2oJvzl9StEqMDWhapHEgwLh3/iohOpz2RopU0+3/eOmb8eubYCz0OwUcj\";s:9:\"js/all.js\";s:71:\"sha384-6e7nA5mhBVXnMIAtGPETl10C7oipDhu2IN/lyxyjAJG+KzNtRLqrqFJN5wJ+6/qU\";s:12:\"js/brands.js\";s:71:\"sha384-zY1eKUaz/NWcOf6xnU5eePxV3anVtTTAlu33RytBcT9jGz8dstwzZbVpp2l609NT\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-rN+BHnX2WMsUD7VYL6PykWIyqG6SyEu6IdhgM42fLyWqC7JlY2k76ufmZvMFU43a\";s:17:\"js/fontawesome.js\";s:71:\"sha384-W1qlouWJA+8MQIORaSCnwNHhaPuAMwQGosDEwU/g4kkawDb4WwLy3ZWVpa/KtRXb\";s:13:\"js/regular.js\";s:71:\"sha384-Axuj5+DJ+mQA38QqwpWCujH6bCefx3brdTdN+ffhy6oxdqSvs1evxn4iX828SSe6\";s:11:\"js/solid.js\";s:71:\"sha384-9d1SM0Z1PczSHlc0bwe5j/n1kjp14H06SgMcxbmNkp6ZSQa6CqneEHKQkfVGPcR7\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ZkRpffzN60bZU7hfI/zFR3Nv603593UFKpz6QAm3FUAUqGa60uzGmuEGLB5BZNsY\";}s:3:\"pro\";a:0:{}}}s:5:\"6.0.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-3B6NwesSXE7YJlcLI9RpRqGf2p/EgVH8BgoKTaUrmKNDkHPStTQ3EyoYjCGXaOTS\";s:14:\"css/brands.css\";s:71:\"sha384-Adcde+txsvO9VVaHmK9GsiU0ps9W6rwF+IlMCjHpCeU5j18z8lenKNx6AV7OuQKy\";s:19:\"css/fontawesome.css\";s:71:\"sha384-caIQK8zI/KcZVq2HWogTcGbcxd9c0Alp2SDcy0eOHIjipClzJQ8HEkSNcoXtKq+w\";s:15:\"css/regular.css\";s:71:\"sha384-CAcRRHVEmhGr2UjS0hlffWvnfewfvVqvDJP03d3f3NctPBCvDfPMY6L8r4to10MT\";s:13:\"css/solid.css\";s:71:\"sha384-zW4IamLJkgRrzYFdEixnM4hbhScK8Q/B0aYHqhGxQf6jrj1pxNaEzS7n65YVdFsW\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+FYTcfgXTek/jHYrY62q/wv2/QxcumMqXHB/9ZHrAwFBiACe0XD+xXBvrlpG93Qd\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-K7jXM/Fd0TzcNoMz1bK2/PRaJLYkgynKTlUyKXatOFEovvEO1Zownee30wS0rxq4\";s:16:\"css/v4-shims.css\";s:71:\"sha384-Mo3tUbn02WJ1eXNOTbemz64sjSQx9PEUk4o3BJbDNrfhSAfbPobKWeqYpV3xkTBC\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-iYWocEeLglluGxouLD/E0jzilCIbE6LTAKof7ZPB7/YSAogAA6bLTJyo2T98POzn\";s:9:\"js/all.js\";s:71:\"sha384-l+HksIGR+lyuyBo1+1zCBSRt6v4yklWu7RbG0Cv+jDLDD9WFcEIwZLHioVB4Wkau\";s:12:\"js/brands.js\";s:71:\"sha384-ZCobqGyWQ2Qg///QRAi+jqRlO/9aWmMHd6tb0emtG9QBX9t77I71IHg19T90mlfk\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-5v1FR2qOT+wEONoibSzBiWIvpXEOyyRuvOtNOfwijR3h4K7tg12vL4TNx4iSsQWX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-pULjvYk4ZbCHxvgkOUhY3s6wbSkRp/9WHqh+NdM+FkmDQsdJeg2XyOHSEQ0AZlr4\";s:13:\"js/regular.js\";s:71:\"sha384-7XHlSs/t85udVElMnHlVDct1GXjA01UIyQLQRbYc3bxChziaGT776dBUgqd/o82r\";s:11:\"js/solid.js\";s:71:\"sha384-IWq2srnodX6Z+US+NFdwALHXDvdogKkBx7sUMzfypASSeqsNzF+gAS48WnkPcYbf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ybkuz/OxDnyDU81HhdheMi5FjVHdKkPPnnfX2H5pClfR9x+aAMkenwEbVe0AdPt9\";}s:3:\"pro\";a:0:{}}}s:5:\"6.1.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-eLT4eRYPHTmTsFGFAzjcCWX+wHfUInVWNm9YnwpiatljsZOwXtwV2Hh6sHM6zZD9\";s:14:\"css/brands.css\";s:71:\"sha384-E8UvjEv9HnIyjcD0D2Nfr/M7y5wA7GK+DoLhh5Sbfd0MtCSpdREBn8Wc/SdeaBDA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RLM8Rxp/DcBfCfSI3bGwwoMMxxy34D2e58WAqXmmdnh0WYlAQ8jeOB3A1ed5KUSm\";s:15:\"css/regular.css\";s:71:\"sha384-luZMTbX5lx1yPkwYfjdCtbXx2AL3j1H+ffZ1LJSuxepC2TKyGzv3zkgftThS/BDN\";s:13:\"css/solid.css\";s:71:\"sha384-ltWlpN+Dl8XfKEnC9oW+dDRF8Z7jsYkxQ/WMRoJ2VHH5G2nQZ4if2NWwmV0ybzZ7\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-gLJsqV+iGZdsakTXDecPQLbmHTTUB6vIJ2ukjLJTPa+YXsdHu5alOSYZZTagrVSG\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-WTcUA4jr+YtMif40YOsaoMazuo9cigaWqC7Vrj6PjPzPt/VegPK08OEyRvvIauzD\";s:16:\"css/v4-shims.css\";s:71:\"sha384-k1PPow2i4/GbflsJCusORB91wBmXUDdw6pOkXu2vQWXIsmLbIL0t/aA7FroyJf1r\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-SXOfPW9HC6/r4BP4QoUVZNVol9D+ncClNpAseJsRONb9L1F7QgV6ltEXcLnYJv9H\";s:9:\"js/all.js\";s:71:\"sha384-vLLEq/Un/eZFmXAu4Xxf8F00RSSMzPcI7iDiT6hpB4zFpezCEGhb5daeR8PLyrLI\";s:12:\"js/brands.js\";s:71:\"sha384-cNUzI2P088AN66Vx9jSolJDKuj/ZWgTtbwYleQo9MedrXul9DrmthXUDN2iFVk9u\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-te3/sj8uC87v52yVrB6zr3Fm5m0AyGLAHYUIx853+yLbLffUUfXrdztSp/yFACrc\";s:17:\"js/fontawesome.js\";s:71:\"sha384-n82ItqkVbr/bDMKi4caJ2ZLCgihjr3y0aF69FTVAfwQmyFRVucR9QvBKz7DliBNY\";s:13:\"js/regular.js\";s:71:\"sha384-/wcH7fFePVuXUD0zgIUKgQwvWV21321nbGpvX01SjmZ01yE/n68/Wp8rBxpsKI/+\";s:11:\"js/solid.js\";s:71:\"sha384-A4ZBrBkKFVj3yXr0kIOFHs3vCQDJSHAU9OiRxm9X42e+amWJl68HpDCbONxiMp12\";s:14:\"js/v4-shims.js\";s:71:\"sha384-WqC1w5exlfB7/5UiHTZp/YAnoS9Ovlzh55EwGjzaMxZZtL1omDGlh7KehDlpgKUr\";}s:3:\"pro\";a:0:{}}}s:5:\"6.1.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-/frq1SRXYH/bSyou/HUp/hib7RVN1TawQYja658FEOodR/FQBKVqT9Ol+Oz3Olq5\";s:14:\"css/brands.css\";s:71:\"sha384-GjGxypaJovIS9KvmJ0F1G5aXPEfMvk9dMgnwAAw7UOfX7zTQZMapUiXX/+8HlctD\";s:19:\"css/fontawesome.css\";s:71:\"sha384-zIaWifL2YFF1qaDiAo0JFgsmasocJ/rqu7LKYH8CoBEXqGbb9eO+Xi3s6fQhgFWM\";s:15:\"css/regular.css\";s:71:\"sha384-i84Ve3MkmiZYhWmYDjLPpHYYvg36qy5F11ipncNWsQMTrwZ8nGSSX3Q2QnmwEGdR\";s:13:\"css/solid.css\";s:71:\"sha384-DhmF1FmzR9+RBLmbsAts3Sp+i6cZMWQwNTRsew7pO/e4gvzqmzcpAzhDIwllPonQ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ET/prSuhSJFD66MbC3j2l1MrZtW8jdamNc+wmMcmh804U+5Isyo29kVkPjr+4+9P\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-DPkhMKJRq9+6LzxVlr0poYa5+EQVr/onntse7iwk6coJonLqzoCBzSKF6ccKoXRm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-4Jczmr1SlicmtiAiHGxwWtSzLJAS97HzJsKGqfC0JtZktLrPXIux1u6GJNVRRqiN\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-QmV/KObe6h/Mb8GC5urJmE9hmFaZDtdnqpCUz9P9nDHFgMeDXyI6IARqnuDRkYu1\";s:9:\"js/all.js\";s:71:\"sha384-xBXmu0dk1bEoiwd71wOonQLyH+VpgR1XcDH3rtxrLww5ajNTuMvBdL5SOiFZnNdp\";s:12:\"js/brands.js\";s:71:\"sha384-jUDsa+5FKZnKIWUpGkvYZHGEx5UxPEu6XJtEMH9ZGXZZkUNVWX1vs+a51vHKs3EY\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-SgqpzfPaFrGdMcCtSUb4dAD1aDr5a93AfPBL+tk14acF93aGDvasqDcPFbHe24pS\";s:17:\"js/fontawesome.js\";s:71:\"sha384-9zErGp+biBilRrlpD1l3ExnaqXc8QLITlNpGtb4OL6W1JChl0wwmDNs4U/0UA8L8\";s:13:\"js/regular.js\";s:71:\"sha384-5ZhDHsI9yoa8E6DaGJCLj2Lgi8w4KE42IQi4jvmqYVCaza4Iqi8/hSniWspK7fUs\";s:11:\"js/solid.js\";s:71:\"sha384-KPytPVc+hwHwX9HXl4tA7SWJ0Sob6StzjVRoxC4Q4U0JgXujpuVrkBxR0Hsf8A25\";s:14:\"js/v4-shims.js\";s:71:\"sha384-lUDzd+x9AFWWpLYlM0ZCD+x586cN20gzVDrjHh8HUz22j1QwqTKQGkmd64bfBeZi\";}s:3:\"pro\";a:0:{}}}s:5:\"6.1.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-fZCoUih8XsaUZnNDOiLqnby1tMJ0sE7oBbNk2Xxf5x8Z4SvNQ9j83vFMa/erbVrV\";s:14:\"css/brands.css\";s:71:\"sha384-bSSRmv/7zc8N//nlEscKMJrVdXnmDX0i3KY5/Z25DbCimvRgRrefGMGQORqrdfD+\";s:19:\"css/fontawesome.css\";s:71:\"sha384-X8QTME3FCg1DLb58++lPvsjbQoCT9bp3MsUU3grbIny/3ZwUJkRNO8NPW6zqzuW9\";s:15:\"css/regular.css\";s:71:\"sha384-VkONnoon0mCxG87ODS8tYdngkEsiD8Sd23d3b4KRiZfPqB9YD9hlTNWSc1pkWUct\";s:13:\"css/solid.css\";s:71:\"sha384-0BumEd2qDQ2SCps2Pnnhegpr+si0PveDhbdhKgLYwY9x611h8s22Zh8td+W7jeys\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-GCDsQfUYx2ESsVn+lTf9CyU+PGOUBXnknizovQ4IJxE5loN0RHLpN+vRHxwybMFN\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-E84k0fsWgsf0UqlJxsjgvjalIakzDn/aoXROK5S9mgTazm9ZOb/8zZ0qyqkdKDD7\";s:16:\"css/v4-shims.css\";s:71:\"sha384-iW7MVRJO9Fj06GFbRcMqdZBcVQhjBWlVXUjtY7XCppA+DZUoHBQ7B8VB+EjXUkPV\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-C2uLsOCgtzzsIRkD2hyqhqJnsO6tKm8ec1erAE0iUqF9rveCxghE19k8tc41ksjq\";s:9:\"js/all.js\";s:71:\"sha384-11X1bEJVFeFtn94r1jlvSC7tlJkV2VJctorjswdLzqOJ6ZvYBSZQkaQVXG0R4Flt\";s:12:\"js/brands.js\";s:71:\"sha384-U5yq7AQDGZ6J9YLnrFCX7Qb4jl4/ARIio5SQIZcB5bLjDxI9j3Z3rg1jows2sbu3\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-vGTTZfVQhZ4yWSot55BXgm/SDH+MsKEeG2GFPNoKnoFJmosfJzkaPyMucBkV94KT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hAYe7Q//ZOaw3fT5VW5hCn+guWuzOj8+KjXlS95ZxcRnVX+SxyugquCJURnqC7UK\";s:13:\"js/regular.js\";s:71:\"sha384-60G9FrRhST1TC039tICDDsfkkIa1Smg8kwF6wa9wYEpDqGrd5kQtp9JCsfWW7GCA\";s:11:\"js/solid.js\";s:71:\"sha384-tc7MH1B8eIPGWXxQScItgwJcDhnfKKXr7R39oJJCo9oQ5QssIq6fJM9HvdSHlmUE\";s:14:\"js/v4-shims.js\";s:71:\"sha384-JwJ3z2CNw6j4LN4k+tA6GEN2OQSUzcSBpWIsEqlngCZqnfxDsQUe5SURjhpXLhvY\";}s:3:\"pro\";a:0:{}}}s:5:\"6.2.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-SOnAn/m2fVJCwnbEYgD4xzrPtvsXdElhOVvR8ND1YjB5nhGNwwf7nBQlhfAwHAZC\";s:14:\"css/brands.css\";s:71:\"sha384-aPlaxY3ZTSh7uDmsF2W7hsMfri06sIyTmCDnY7ERd0fdq3Sf5bUKYZMvomNxUaXn\";s:19:\"css/fontawesome.css\";s:71:\"sha384-z4tVnCr80ZcL0iufVdGQSUzNvJsKjEtqYZjiQrrYKlpGow+btDHDfQWkFjoaz/Zr\";s:15:\"css/regular.css\";s:71:\"sha384-wn3adrQUGPbU211xcXhUrH0E0l+tYlkc3uXQ8WiBvnHj6ZU9E1vKwzjRaCKUenlU\";s:13:\"css/solid.css\";s:71:\"sha384-0mfI7+kSnb5u0q8irmrfJVv1jYIBfeR+8BsSsgUDjP4HCYuQ+kLshHc4xpHeBqrp\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-lvs3gozt+olLidIy5GkpdCk5cvS3LPkq49a9KDlN1Xh1bkPTNGeTL6SJCX6gqyYx\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-RSx4BCEB9OLjPKMTvFSenXMC8VTsramvoyHB5iSB1VvRvjZ+nendH6WKbigGUl31\";s:16:\"css/v4-shims.css\";s:71:\"sha384-MAgG0MNwzSXBbmOw4KK9yjMrRaUNSCk3WoZPkzVC1rmhXzerY4gqk/BLNYtdOFCO\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-RS0a4x4GGXTod9x2HdKnveb/E8M6PuU4d/ZQVzhS+333QRA/Ozo84SeOKdLTZ2yN\";s:9:\"js/all.js\";s:71:\"sha384-W5zCdxUh9KjkijDohSc4bFCIfbZKNYcz/hdWjfRL1whrEJO6YBXMaZcAZU5YWJNW\";s:12:\"js/brands.js\";s:71:\"sha384-09m3HDo5mYd2JdkpussYgOLApaYuUblFkHtmeNGHcQv5bXjDeCFdH2iVYjUT8dQ/\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-lbmBDViH+2PwoLg/9cPkkkTMdiyjpcY/jpRNab/Tt0ZmaSdv+85nXkEXaCe/kFp0\";s:17:\"js/fontawesome.js\";s:71:\"sha384-KZ1LJTCtJ2KL1x2pH7hR3CElXzG3s0P624sTHaiTFoSKBMBlwu0mrvkjm8jKox6f\";s:13:\"js/regular.js\";s:71:\"sha384-9P5qtFxImyObPMiImjKy+Kc+r+0+br3QTmRpQSswRkuWxTlb1Jsn7wG/i1i5xJjp\";s:11:\"js/solid.js\";s:71:\"sha384-H6YBpm4VRWLTfp0nRZIrLoT2zc1rWaEEYxYC+HyWXxSKY+AUn5evalgkgT0EpMDN\";s:14:\"js/v4-shims.js\";s:71:\"sha384-FirTqNsw+MidIWcJQan+CwXPSApCil9UBGO7gSOrDvmnzlApH42azPyb5gSH12vT\";}s:3:\"pro\";a:0:{}}}s:5:\"6.2.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-twcuYPV86B3vvpwNhWJuaLdUSLF9+ttgM2A6M870UYXrOsxKfER2MKox5cirApyA\";s:14:\"css/brands.css\";s:71:\"sha384-zzq6oTpui+lGFqUViC9Wq0M0ruPnfZLT+vZoMnTIf7z5TIhLggF72ZKZD0dGWakx\";s:19:\"css/fontawesome.css\";s:71:\"sha384-QYIZto+st3yW+o8+5OHfT6S482Zsvz2WfOzpFSXMF9zqeLcFV0/wlZpMtyFcZALm\";s:15:\"css/regular.css\";s:71:\"sha384-ec0IxhWgl7nOQwUxu15+OAt2ylNSDoZllO5JM+Wlfp5iRzHOV7834BmFjztiNi1a\";s:13:\"css/solid.css\";s:71:\"sha384-XA4GNh8NX8EYkM7X7NCXQzS7tTEzSelPJ2gF6s+KKgR7Fcep3WAa9iKAxyYEQBqh\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hb+xoMIh5T/8ALSNePRt0QBxUzia2Csd7In9RrXrwe3btQGQk9QHDQtpl5W/3oNR\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-O4Uaae/V6mzTlKODhK4IpUZZiXIuaH//HQIvOJgzp+YRf+0ms93I87n4WtBYLudx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-RreHPODFsMyzCpG+dKnwxOSjmjkuPWWdYP8sLpBRoSd8qPNJwaxKGUdxhQOKwUc7\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-MReR7mQQUkCxHgYCao8fyFmmRcib7wPhbYWSNMZeFKTaoe0r0NePq6eeDHHfDHoR\";s:9:\"js/all.js\";s:71:\"sha384-sCgwm7cN2+PN5J6MEF+tnqkCY4Wc5WRcGU+I9b04LSQaPRMO09dnbrVilAWAbH1z\";s:12:\"js/brands.js\";s:71:\"sha384-paSlHD0OmJVQU3bqeDxqGDmSDHe9M4KOKTS5fMPqUnLBatCB5mFvvUWCyFmuaWU/\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-+VJZyx6TPe/0fC+AtQuiPhcJ3vxer0IsFetCmdTQKAlBkj0JQPtHG5wlHTjTMR2P\";s:17:\"js/fontawesome.js\";s:71:\"sha384-zqHeJ5LxaaUrtMetMhaqvaChYEnpeC2GD7jY9JtkUU7ALLAiMHF8VEs/9hI45Rlk\";s:13:\"js/regular.js\";s:71:\"sha384-V8GcQvIrFZ6r5GLjZ1HYSOuM0xejDxJM7Q88AzR4e3ErN2SHiVEIRJ9fMxu8hLD9\";s:11:\"js/solid.js\";s:71:\"sha384-hnLkLr3nX34CKy5QEs25fE1nSgfHyy9WeOa2te+FT3Q9L5m4L5aNizHqOEdFPX7s\";s:14:\"js/v4-shims.js\";s:71:\"sha384-r4s+tpoonjJ7uL821D+ZropRuilrahBs/t7I5GxACKAAVGLOlq+1O+yQklgFyawo\";}s:3:\"pro\";a:0:{}}}s:5:\"6.3.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-nYX0jQk7JxCp1jdj3j2QdJbEJaTvTlhexnpMjwIkYQLdk9ZE3/g8CBw87XP2N0pR\";s:14:\"css/brands.css\";s:71:\"sha384-nAID/7ZbfvEYU+xSZ0WSonEMJwE3L/H601tipVgerMsWXyzaigVLkTK01HvpcFXt\";s:19:\"css/fontawesome.css\";s:71:\"sha384-IfdMaxM7xApqzQmi9UKLIQPSX+440ganmZq+rMGyqDukniVtKl003KdPruUrtXtK\";s:15:\"css/regular.css\";s:71:\"sha384-ix51dCg7sGikKC5kWHfI3mtSd1gIH4xMi7/QU+Af5fqLFjJf8hpbeb3TYZ6cIUV+\";s:13:\"css/solid.css\";s:71:\"sha384-PxcNnk8LvpDOF9+oRKY/0jnWn7dad+8aYUBNBvUlkcVedXQVe08FomQti4AD5v8V\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-/siyQcTjrZDFe29mEtEHK7Eb4EhdKEvYw+vgxleGBDIrHDHZbq3CnTLFfBubXXI4\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-NKf3ykwJFzOuD3j328idnfCz39TdN8EmH8pKT9lKR8HGEwrr7e8EetwwJ4easRJd\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SQz6YOYE9rzJdPMcxCxNEmEuaYeT0ayZY/ZxArYWtTnvBwcfHI6rCwtgsOonZ+08\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-a4b/G2DeLnJR7cWqyrY2Sp1zq2yloVgemqVyajo2TOgC+CyG89CFGs3h/4t6tE6C\";s:9:\"js/all.js\";s:71:\"sha384-QM3vQ1ro1SUguF26PKxC17ZxibTi/ixpgL9NRL5/RHw1AmA0pfSeGCh6k+uqbyzJ\";s:12:\"js/brands.js\";s:71:\"sha384-+dgonENyuv/Ma5wK3qD7a5ah/QkyvBj6vKZRydt/XL8UZ4/vW+knK6Mzgz0n1Tur\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-9spX59FjXN5m4FE1qKeJAkbeccFpPSSkK7uRDbyfsWMLoovjBrKMwI7QPzr9IItI\";s:17:\"js/fontawesome.js\";s:71:\"sha384-/fIp3d9vqOYL5eP47pOEUYZ/h5dXL4fD9Rc4DWSuIqMZkUj+DA94qNELNYZm8VJS\";s:13:\"js/regular.js\";s:71:\"sha384-sQbun49r1isRugOLIXUMavarR+iGPwX3CD+RnzFVwcq5a6ytn90mjg95EavZR7FQ\";s:11:\"js/solid.js\";s:71:\"sha384-G+v/7MQzsBBqsKVV3XKv8ThIDYIyXG6LJWqTPBrADbzQf/Ok8cTgjl0X+smak2c5\";s:14:\"js/v4-shims.js\";s:71:\"sha384-wIToinlzS6m/RbLlDnKRNYNV9AH+JiQw4YYjKJLDHvRHM3otJbm3Yo6HW5Tmlm6Q\";}s:3:\"pro\";a:0:{}}}s:5:\"6.4.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-iw3OoTErCYJJB9mCa8LNS2hbsQ7M3C0EpIsO/H5+EGAkPGc6rk+V8i04oW/K5xq0\";s:14:\"css/brands.css\";s:71:\"sha384-2ExAXhxetFPlyL5ZypKQbz0ZrD6S0xW1jF2n+bGda67tIfsjcfHQy3FkuA1IjuxK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bGIKHDMAvn+yR8S/yTRi+6S++WqBdA+TaJ1nOZf079H6r492oh7V6uAqq739oSZC\";s:15:\"css/regular.css\";s:71:\"sha384-PwY/RecMsWJ0YLCPnyfLG+ditDiQgCzulWE8Smf0xlxWwmIct3nAJIYTB4KiBmol\";s:13:\"css/solid.css\";s:71:\"sha384-o96F2rFLAgwGpsvjLInkYtEFanaHuHeDtH47SxRhOsBCB2GOvUZke4yVjULPMFnv\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-TYQbrAtum7hSQLm6r6N4LzjKCQcUdp06+INnw7PSirZXzTDCnTYfXHs9rKgd3rXF\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-RJB8qXHAWja9guGLx18CQW+Z9LexNZMjoJw8l6YyjDEbb0KGlh9Zm82z19LHC1Am\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TjXU13dTMPo+5ZlOUI1IGXvpmajjoetPqbUJqTx+uZ1bGwylKHNEItuVe/mg/H6l\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-QjaWSlkEh5wyDERdlOeoQqTkMLC4uT8RssNlE2KX9a59xyaVpqRTyfed0QhFkT6H\";s:9:\"js/all.js\";s:71:\"sha384-Y7LSKwoY+C2iyfu/oupNnkGEN3EgA6skmJeVg5AyQk7ttcjX0XsLREmmuJW/SdbU\";s:12:\"js/brands.js\";s:71:\"sha384-LZKIVE6U9qJ1ysu6iReojA6FFHyh3907bZcgwYnIGZZGKNFIbzPGCF76fZdKRIpS\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-PJJ6fWM8zRjqPjf5DIS4/IdPD0hjOoh1BJdH1TKp7N/Kl6Udgg0WaO6fc0IeMYvX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-UOiUgfGrkdraMjJCXCBJ3es7S0WlAfRzwutEkKdSvdAJBEi80T6ccH436MepipvI\";s:13:\"js/regular.js\";s:71:\"sha384-fjFyr4zQKu1Z1JVjcnvN7Leu0+LILepNI2mfYinScaEyzjpQeBqpaOzw63muFY6v\";s:11:\"js/solid.js\";s:71:\"sha384-AjHxetn+/jiyhsDh7L3DL9B9DkI+MfPjArOp6M34vqincKmDeAn77n8d5tFsopuW\";s:14:\"js/v4-shims.js\";s:71:\"sha384-nWS6DcsdR7/yv6wq4luARu6vZs/04baVXV/1X6zrvy63FZuMoIv5DvS0I9HRZuNE\";}s:3:\"pro\";a:0:{}}}s:5:\"6.4.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-kjpykepEMjugguAhJkXwcfET7pbrXrP3Xv+uS6EUmR2aHXI4b7zHffvacfrhF39/\";s:14:\"css/brands.css\";s:71:\"sha384-J1jdtNZGe4Wc5IYc1OlZow87jcNr6HnHpojEw9YuPbTwkl7Kx7NqvEgxb59Iski3\";s:19:\"css/fontawesome.css\";s:71:\"sha384-P6O5pbBNnrpS0pILLzahZhFOP1UpcX7AMd73G9IuE2nF8HyPrUbIeLjvZEs0Ug7b\";s:15:\"css/regular.css\";s:71:\"sha384-MbJGQW0c7awBys9sW+AAoBKV1U2kQxiIxXqd8A4febZ60zN3B4UVTSRjRDYntCv+\";s:13:\"css/solid.css\";s:71:\"sha384-6tgiprR9pLbvcfkGzWxHwhJH2jzw56OQ7s2NnY2FuILGo5UmXETk8L3aFYwPpteC\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NQoFKbwXmyuKVJTvBi7CsAIsHXT6mwCybNUvHrU32r1X+BTbaMoiT3Ir6tg7MX+L\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-U3414fYccumRqk4+ReNAk1QyXcZ6yPQskOCLFtjj+LH1H9Br3fraFMi2UsvxlOWg\";s:16:\"css/v4-shims.css\";s:71:\"sha384-NAfgAM5AYoEaYx6qI1zuWC7Vnm+IGYraBS6e3Ictl2u7+giHMRDHuiU2VdIhpwG/\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-Zf5ib/vBlmsWb669+mZLzGHfsdf7+F1cMBmYUYjWSUOunf2TmRo/y9FLMKQ6MFDq\";s:9:\"js/all.js\";s:71:\"sha384-XTz3JQr6C2UgQyMjOXqtE1ktB22L84QvY/8e3iReKei6VGYNS1c3vfN7tkatleGm\";s:12:\"js/brands.js\";s:71:\"sha384-bN6dDWPHPXl3lPomKGOzW55M7flHxNfki0fIeDHz5I95fUy/KSPRyoLa2cFmmeHd\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-/tkC+DsW6wGAAuYHzm8moq4WwyPHbxeoeYIdmYCqnCBwPfEVbma64R5StM6McXfT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Aj/6TFpUzUHDZXFwF1XFeekLst+gcZBlYfTBFTFuAJ421PJ3prYGyWJnIwyE6mVy\";s:13:\"js/regular.js\";s:71:\"sha384-tnBSYFMgfb4WogZHJ3seCNCCpk3MYR021WyVrcOOy+pXWRXx58/5ERosIXTkPUdg\";s:11:\"js/solid.js\";s:71:\"sha384-hDNCpQUw2n0Ov+4u2SwyiGyABcpjtGu2S2D9OU7SOO7thmkEeXKHPiAWCH6xG+qr\";s:14:\"js/v4-shims.js\";s:71:\"sha384-oclpB7dZf9YOfq4V7npmeZegIGMkDUrO4O8SWF4DmaWxhvrx2KDt+5S5OU10W24Q\";}s:3:\"pro\";a:0:{}}}s:5:\"6.4.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-blOohCVdhjmtROpu8+CfTnUWham9nkX7P7OZQMst+RUnhtoY/9qemFAkIKOYxDI3\";s:14:\"css/brands.css\";s:71:\"sha384-zLGWoEQo4d0pyo9mhl8re+s13DMgD50yZvmt2KepO9EKPRKSKb6ejYyyrOacdxbF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-BY+fdrpOd3gfeRvTSMT+VUZmA728cfF9Z2G42xpaRkUGu2i3DyzpTURDo5A6CaLK\";s:15:\"css/regular.css\";s:71:\"sha384-Gr3CEO2spqs7Ewi5axeUTudhnllwvDm72lMG5zKbXWSq+U2Ff8hmq0WdfRrI5nKd\";s:13:\"css/solid.css\";s:71:\"sha384-mg8zF75oNHlYRnMloT+F976njuLh73k82hwA0CQiqS/puYzt7Malpig8RB7LITnK\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PCXckRqKk8Xt3VfIU/oSoVwuHBgHF9BH4O3YqogDn6oyjR522YZn39faZ53B4D5p\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-ei3Y0Qqq+DvNJsXkVPPQXhcsPOyaiBoUs3RNHwBpCEg2IPjfyoGWr/TvaJzcuG7t\";s:16:\"css/v4-shims.css\";s:71:\"sha384-IqMDcR2qh8kGcGdRrxwop5R2GiUY5h8aDR/LhYxPYiXh3sAAGGDkFvFqWgFvTsTd\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-RxpdTG8UQZB3H27HKEylcaGUDSJZCrrGOimS4DWEHS7jUgWlV9hKmCKx99zQRgmA\";s:9:\"js/all.js\";s:71:\"sha384-NhxsZw9+Y+PdEOvg8BK3sOUXXTzoRmr4/ncl+Ogurt6kQgJAVJaJ4LFhjD8qXtol\";s:12:\"js/brands.js\";s:71:\"sha384-HgDRzw9OXl6njKttsRM6bzXDEX0jXjFz4ftMEacmpWzS/YHZMrzhqmx/hCizzsD+\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-1yE9Wj7LRkXyyUe0SlAsUwkMCqav8PeA/E9JQG6l1eM0VF+CZLdyD2eMeXRAGlDU\";s:17:\"js/fontawesome.js\";s:71:\"sha384-/iuJV08jLDUeRALEMlZ6fs0Bw++/li2mlOSJxBM7Iv5yj5XbrUdLKtMQN43ZZFBp\";s:13:\"js/regular.js\";s:71:\"sha384-k9pHsn2VVHLVUoLLHm5UPmO16bFnmJc7la2s6uYaMQiHNADkZEig8rlqQaqLI150\";s:11:\"js/solid.js\";s:71:\"sha384-zBYnK6/d/8LjD972/72gCvlHfb+ySSWaznogBkpV6JsVtY9cvEmRy1ACPom2Frtr\";s:14:\"js/v4-shims.js\";s:71:\"sha384-qx63XMht9MNrP09QOmEVrRXzomNz1CKA/p07kyef8nQ+qC/FNDZROxdpMzpLVjeD\";}s:3:\"pro\";a:0:{}}}s:5:\"6.5.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-/o6I2CkkWC//PSjvWC/eYN7l3xM3tJm8ZzVkCOfp//W05QcE3mlGskpoHB6XqI+B\";s:14:\"css/brands.css\";s:71:\"sha384-rc8N/WOF/H+rKehhzM5ImP8wTvPozK8RQvzO8o6JAfDzq0KRSgo6i+j66nIEudeH\";s:19:\"css/fontawesome.css\";s:71:\"sha384-7ZjpdZCGaVoUcrOCjSdvnVVuVG1lIsZ2aQ209jwcxdvLz2fmPLwupbXnHctdLoU7\";s:15:\"css/regular.css\";s:71:\"sha384-jwLSR3Fa8bOns4+ORzfXEKi/bQnPF0530na7DqUyRNnaJcWC9rrCer+Go7a1EC8m\";s:13:\"css/solid.css\";s:71:\"sha384-iWtHCKbAjIX4uT8lZc6XhUb5MvYyD8dxuw3FydZMTESdM3TbaWCk2xZBwnoXiD3r\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-sezckoKjOoY7xa6Q1yl/mBoyUcWdzURzLDUHqGc6eCwXg/8uTyufNe8hG1tX7hXY\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-rgO2rp/0KW+mzt0ore2KYf+TKafkSiUSIplK+Ta5b/QdpcpcCwfsjVa4ot+dSKI6\";s:16:\"css/v4-shims.css\";s:71:\"sha384-Gchs3pk5vJ6rNXyLYEW0h4LxMtAZtY6TI1xrFSBYD6AVTmQTwqBWkrQgHYjVFH98\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-YQ8l7/1+xvgQd7Sj9/eQJNTS6ypVoZxDJWOVJMll2DPk+oVZ36vlNNoJ62QVsGQ6\";s:9:\"js/all.js\";s:71:\"sha384-xJg9IXkLBF6DBCGIEmpH5d2Pzct5onYpW8EegteK+7n0rxjhN4PUzfPxGbpWVjQf\";s:12:\"js/brands.js\";s:71:\"sha384-L6PiDa9VmZdeblRHc9Lvjj/cBVmIpC3wTOCenJbV3a6VkkfR54U+blZ9U/rAknfM\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-/Rc5s6lpUSRVKERpkcP/EyGJMY/vNfeLAHFaY0dVpU1Bcgq3hy8DLzntbctckjSN\";s:17:\"js/fontawesome.js\";s:71:\"sha384-fczeVPs3vI1I4dC9UE4Rn3p4XtoE+5vVsWJvjppuzU0M01EcO1Y2ngjQPM6bCyRg\";s:13:\"js/regular.js\";s:71:\"sha384-fRE+LPjVJ2ZEpQEitNFCGQ8WmWw7JA62+2UZ3dG4+rDSA3aGOaiat1XS8yUKLnRs\";s:11:\"js/solid.js\";s:71:\"sha384-Vws6iS4SDsBgBLGHFxVz6O/maT4KwPqDxxkd+KNAaZCNPSnU5WAqc2/wQXl69hDo\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/92mVmELKUSys+AjbeSvITO3rhI9KtDAENPjak7fYPIxTdmKqt1Z2WCbRbI8ybF2\";}s:3:\"pro\";a:0:{}}}s:5:\"6.5.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-t1nt8BQoYMLFN5p42tRAtuAAFQaCQODekUVeKKZrEnEyp4H2R0RHFz0KWpmj7i8g\";s:14:\"css/brands.css\";s:71:\"sha384-/BRyRRN0wxxRgh/DAXU621go9pdoMHl6LFPiX5Pp8PZYZlKBQCDXj9X9DHx6LOud\";s:19:\"css/fontawesome.css\";s:71:\"sha384-55jldat+GoQjPHn/QQUMQuFEtiGB4UuSki3Jl9keOFLCpi1mQ5KRzpezhqCTiOOm\";s:15:\"css/regular.css\";s:71:\"sha384-k5640LgghgAohDLPwSqVWa96yQwWouT6wsAL+J1g0CFJVITNKYkIh1XpPLYKQe7Y\";s:13:\"css/solid.css\";s:71:\"sha384-8yO/A/BtltnG0hDxdwmmkza8UAleyDoAD1FhXiH6rsOQQsCho1P6WZP9TpBBH3YP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-yMdWfzE9MX4Kfw6CAOm3HwUY9dTg+q0iASAGCCc8WHwpjTpTWnVD+sceD2fhmOkh\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-d2Yn1/9Iw78r3oqwk5B+EcpRcmepXR5LyhmRF2a+WoSe9mpRGvVk0ZviFwDGDOTO\";s:16:\"css/v4-shims.css\";s:71:\"sha384-5Jfdy0XO8+vjCRofsSnGmxGSYjLfsjjTOABKxVr8BkfvlaAm14bIJc7Jcjfq/xQI\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-/mBKnLlGtog8q2qQrgugURRDV+iHWHAPvM5KulYXT1C2ErKOKkBI0vbff8ZPq7rL\";s:9:\"js/all.js\";s:71:\"sha384-3ve3u7etWcm2heCe4TswfZSAYSg2jR/EJxRHuKM5foOiKS8IJL/xRlvmjCaHELBz\";s:12:\"js/brands.js\";s:71:\"sha384-ZLiXRVukSL14lFTleu1lTAr2TeLHPaDuMiJCkchL/8FPG7dwZ2wtrXxpC/zdv5xn\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-UYRdH8bK5N1CVJCNns5uaqi/6Ar3kibcem5vpabHgcMxElJynrnhz/KsdHcKhgX3\";s:17:\"js/fontawesome.js\";s:71:\"sha384-E14KwrB3IyWfxYMw1QY2oDIPw9rx0prapjOJl4SQfXyxoFrUahGl9xhVYoDAOawk\";s:13:\"js/regular.js\";s:71:\"sha384-rtVRl2UebrkBOegQzvNMdCV3O9bYq2eB3FYS0aTuZ1wQf8tfLfk9O2Frlo2VA+AA\";s:11:\"js/solid.js\";s:71:\"sha384-Ek2vi33vZQTWariNBJSX6YQzIKkAWI00/OhiBBm7QAccyWpXrOaoWh7Ry3oeUmhM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-HJMj0TodsrM5KmHW8l+5NnGnq9DLtu9LlpFYFFXVne/+pnZYGxIWtFFGRQSbcPo9\";}s:3:\"pro\";a:0:{}}}s:5:\"6.5.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-PPIZEGYM1v8zp5Py7UjFb79S58UeqCL9pYVnVPURKEqvioPROaVAJKKLzvH2rDnI\";s:14:\"css/brands.css\";s:71:\"sha384-hu7sKftLeB/8IYmWPfl2Jo6MTRHquwXVmGPT/08RqhuANVZrbNFBIsvWPOiUduYX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-5t0634b3BeTSoxIIgd8lhUy22xY2BGs89gw0vReAMGcfJXXfA7fblIRGVkRFWRDL\";s:15:\"css/regular.css\";s:71:\"sha384-bvJbeZziR9BXg5K01HJM2RVTINetqVhPDH2/SJzZRIfFnC4FCiqU1iUYCoUBAOAZ\";s:13:\"css/solid.css\";s:71:\"sha384-+CMpNM/Tv3YfWmU43LPsvXlIdOUnxSooWv5fY/Tkap65JU4QTLBHp8nMrEkIEb3u\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Ja4dExpeo54nrFkcdBEDj8bT+Z8/kHeA+SYpzysVyGEQ0poh2xSpG94Pz1xM4o8h\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-6Oel/YhLbBdCe8ERRAZyt2pZBFGhzrHu87JyGbASfl5UYxaNMVcIXbuhjZGKMPH/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-XyvK/kKwgVW+fuRkusfLgfhAMuaxLPSOY8W7wj8tUkf0Nr2WGHniPmpdu+cmPS5n\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-a1AIUapvbI3jyVtWxhc0MU3C5l6s4pGZ2NO8lda3JOqFh2prsG41pkLD09tgo90j\";s:9:\"js/all.js\";s:71:\"sha384-QvGJBgkqeVjFCXW39Q3psy0yEymI5WTMC5V+6LnvmNIeDfvGo1AI/j0AlTrID9lQ\";s:12:\"js/brands.js\";s:71:\"sha384-IDPW/rHApD6Ix3qBqXAu6q9G6nIxKRabaI4ckYN0ZUi2kWctYXM+yASINDvx3XZM\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-LuC3i5Ct+5JSmt0n2l/KFBk9NnSBOqI5eYeLnYY4LBM7LvawT7y8mIlcn14zDIzL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-k95boTdQuOXfMHiAQ5KS8ut5+VDe/XkMOa7cHZthiY9NyrGMjeGyFdQRV5qkJIBo\";s:13:\"js/regular.js\";s:71:\"sha384-VENQe1UnxdGwDelZI4zTMu9pOwnwDZbg8bzjnJGsEK5uhl0TXZRho/pmwD5LXKEV\";s:11:\"js/solid.js\";s:71:\"sha384-EXSuehoGxvgthEEh8uj117jhbr9OJ8AqfxfZyLxZUpklNJ8+q6qO5J3s2TMSRxCO\";s:14:\"js/v4-shims.js\";s:71:\"sha384-tj5YmFIdBVO/XRERdNj8QOyAFv67yagv304wrKG+kWqr14aj14FTlN5L5ijoDM9a\";}s:3:\"pro\";a:0:{}}}s:5:\"6.6.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-h/hnnw1Bi4nbpD6kE7nYfCXzovi622sY5WBxww8ARKwpdLj5kUWjRuyiXaD1U2JT\";s:14:\"css/brands.css\";s:71:\"sha384-kONVjBbDa5e18xBGGoLguGqAr2FtXB+dqTdiDLZVkKogOJnS12iAheJLVYIa5J8h\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NvKbDTEnL+A8F/AA5Tc5kmMLSJHUO868P+lDtTpJIeQdGYaUIuLr4lVGOEA1OcMy\";s:15:\"css/regular.css\";s:71:\"sha384-PLNAinc+pk6pWS1N3h3B/AncazdeYQGFQj2vtyzzbi4n8nkoy/fki9txBWVQ8/zs\";s:13:\"css/solid.css\";s:71:\"sha384-JN5YK8e9Be0IBEB/Z3BYAzxlDbH7hFQbYtlnB60vKU7JE8v86SmeuD4031oI7nAy\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-F2ItJJttusGddRtPG+oSkIWaypigkYuC1XJLzapknSsevbuLRW68aNCoAWQfxALA\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-nmJ0khbCDW2kQtbB3+FbzIaUYRYH5Ka3EnqKXpydgAXJgxj1+YR7MXs3CCzzJ6lh\";s:16:\"css/v4-shims.css\";s:71:\"sha384-Heamg4F/EELwbmnBJapxaWTkcdX/DCrJpYgSshI5BkI7xghn3RvDcpG+1xUJt/7K\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-NTfn38O/5bHHzqmrowrnqFpW1PLPr5V1GjTQ7Cr7E1tYNhPMI3UOiMb5YMNFw8Ps\";s:9:\"js/all.js\";s:71:\"sha384-dgEl3vRKux81M373f/TdgoDTV5oZj+yjHrr/1qR5b4btG5q63kYS62t5kod+7Q6v\";s:12:\"js/brands.js\";s:71:\"sha384-WGmCmFVcmbr3qbRF50iEqdK5BUZs0j60avmXTYWoEtkzl1+TKc1twYLrChw4qWv+\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-pWrGfmykUr9ujlZv4t5d8IzZjGrbXIPCbc1TAK9gu4+6Y3niDr+V5MnlbSBfpYn8\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v45///5Qcli6mecEr/gdSpzEluOAFIqluhZ4F6LZ30s23Dv9EU76fyJvTC/A3ncA\";s:13:\"js/regular.js\";s:71:\"sha384-Gk2RYSJ/TjgKQv6ccayyf1dccurihJUVtv6e8Lfv3g8/cZNFedp/SHUWal78Kri+\";s:11:\"js/solid.js\";s:71:\"sha384-NRBi/Kq1lDLpYNcj2E06xTq03Y6jqNGv3DGELNisBlWBSIUilmB4WYdPzMLK/ToO\";s:14:\"js/v4-shims.js\";s:71:\"sha384-M9y++reQwf5nddw5loUHChCbGE4kwaeHzeEM2yWidMfaRMQeHM6MSwwPuiSnSMHF\";}s:3:\"pro\";a:0:{}}}s:5:\"6.7.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-nMrp5ZsUTqQhbYtRk9ykIA4NlAIb530sj9RpfUkoGv/2gV+x0ZzFdUnT7Q8J8EgH\";s:14:\"css/brands.css\";s:71:\"sha384-x+7dxPZBVPou9OnYzqRD6TIDU4pgZb4nm8W/CjSoAQiyyg7YlLk9am1mpKORKPjs\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HeR4h/kzKX4V6BeDV0EhPt8aMEBt9T28mmbvPyrkkWGWBVbV/Hs+uznrkbs/WLeK\";s:15:\"css/regular.css\";s:71:\"sha384-3jqusAlgwk3x1MKlsWqRELP8smmE56gqooNFDa3k4tgXHXPZkoo/bA8SBE8ijHlB\";s:13:\"css/solid.css\";s:71:\"sha384-WcE4cHjihykkU/ggqLtOuWZS9j9ujIxLh+4OWKgXMa80Lq7X00Vq7xCtu6Zko43z\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-nYuP4tjk7+rX6nLMA2jKmkHuDEltHUq4C+ahl0KxxVl8RgG3MznNIu5DV7gCZUBp\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-BIMXrelgMrPKqNfKscbmlUJC7MSs7wcxksdJ2H0pNHvCZpf2V0ulpf2L4XXPvfnM\";s:16:\"css/v4-shims.css\";s:71:\"sha384-wLq06ctqRnOQKBQeLwsgn+WXyTQl6i+8FiIw9yF32a8xBWM8fAYTWobpo9xDZk74\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-bE2ab5QI4hbOJ+/WoeAXj7GobeGOcIP+Gat400iVAMuhQMDkYNaUZWzqlqhA9Jae\";s:9:\"js/all.js\";s:71:\"sha384-W/RULPqPfRI1AFuJTFpd4KXbd0zUede93robiDPaDUqCTsmfpAdkGQLJL2y51XNt\";s:12:\"js/brands.js\";s:71:\"sha384-tPR8xaNjG181pYBvMFLlOwpK1li/66bT6Dsyy3h7R6LWV8kOZYLWtkfom6QTYAGk\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-tMX9gWQ9aNwYp+dDU9qMk/oaRspF6mibutTr61iQWm5GtV5kD9cYufsobWopVRUq\";s:17:\"js/fontawesome.js\";s:71:\"sha384-/R4616VE/b8hy9qC67aqozbhgEfSyAtiEu5US/nFht/KHmQ3+MUfg9FpWN1a9fHA\";s:13:\"js/regular.js\";s:71:\"sha384-X0mP7r66/fLSBJYJneaSDWxUMF4ENzrGMMgNqPclratZNu3CY0mljb02Z7MoCxzz\";s:11:\"js/solid.js\";s:71:\"sha384-3nNnrtwWJpds1OejnxV445eKnehoB1v/LhKkXWNSDIWhyPh/qGWh4C/5oFYQEHbA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-uXhYgYbJWEDWnahlKFxLmGQwC19Ja7mkY/RG+tVIz1EnwNAoSxwg3YGyS1943jYf\";}s:3:\"pro\";a:0:{}}}s:5:\"6.7.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-QI8z31KmtR+tk1MYi0DfgxrjYgpTpLLol3bqZA/Q1Y8BvH+6k7/Huoj38gQOaCS7\";s:14:\"css/brands.css\";s:71:\"sha384-b+WfhKuxSUfSpx4cHUnwW9AYQ9NjTYa05djzsD9uueGwQSUmMpB7WmX4/4GB1Yjr\";s:19:\"css/fontawesome.css\";s:71:\"sha384-EAbQoRbplocyBu1YBhlFf6o4MzZytG/DZuc3iQOvYNJouRrN9+AxSan5naDfaoqe\";s:15:\"css/regular.css\";s:71:\"sha384-NIsDz+gz6pFEfTuZBXT4siHyRAuVQEMpKt+WX7o9EqWfqIe1PJvMx0Jjr2/K9Igz\";s:13:\"css/solid.css\";s:71:\"sha384-VMniHmVvH7847gFXdwU6LLmyA9PDmJdk8BUlfBcZI6sbK/Hxs0qdmLSqALTVOwdt\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-FkZTpTIsMMUUQPTqa28B1Q9fA3Z038vJSn+Yzxh2W6T3C38yr4sE7JtXMSxdXzKp\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-/mNHWa1pJzu+Gayjr0FS6Ed1Gt5yoN1bDeGWPkn3J2I5C1/fE2LyirFQ9Q+q7aWM\";s:16:\"css/v4-shims.css\";s:71:\"sha384-R64+fQmO33bGWclNEac7wTslE6q6qYBlYBl8/ih3jdfiYZsUJ3OvPpaWQNgnKZL0\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-qFR2RMDRlRyeubfqfEzMGgh4to3lm3eUQQn4pYQIKMYNGHqHw9BdAdMwi7ck9RU+\";s:9:\"js/all.js\";s:71:\"sha384-rxRGDl9CoH4u0AIeVyasIKlE45FVz6H2qXIl+fmc+3ImJn0CvfCseru5J4PALGH/\";s:12:\"js/brands.js\";s:71:\"sha384-D2NOkO1LiszTSE5eCA7Ygx6kT0clUZGJrNPS5n41GL3zEsxTA7BhpK2ZLJ7GxrPM\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-kefX+ApQKOdTsEjrvtOKgHXTuNvjNlzYacJwflj3RafXLE8TtTiMfpVxJzAsHRNP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TIrPY+KnwskX0FR5bxDcwecBz6kaVflVjVHmsM83f6pe/Akko+GzLcTsgWBkKf9L\";s:13:\"js/regular.js\";s:71:\"sha384-Dl0OBhvLxvr1sUQaK6GP9Im5T0iZi5cIrXHq9SYcH8O6D/fa94W9wTJhtDikS7DD\";s:11:\"js/solid.js\";s:71:\"sha384-tOGJDd550PR1D0FSqKjS8FehwyDZWHO6AGg8lZe58jFNCN2Q5kdrNtKCLhfQ5L/B\";s:14:\"js/v4-shims.js\";s:71:\"sha384-T50+nl9L/K0z0g6gcb6R2hZ5tAPG1aKeU6jdPm1QMnbFY2gTJrjoTWY4lmAQdGJ4\";}s:3:\"pro\";a:0:{}}}s:5:\"6.7.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-nRgPTkuX86pH8yjPJUAFuASXQSSl2/bBUiNV47vSYpKFxHJhbcrGnmlYpYJMeD7a\";s:14:\"css/brands.css\";s:71:\"sha384-CNhPUG5cpX8UuKLY0BCb+gzedmWkhHPKATz919jTKgOXajXjkEY99Qr51B5V2wOQ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-AGSGRaBRodcsy1n0F2zMm+LfXuZry/ZJ6nfio36UgMuNBs/AOC8ciJ7py4SgkpoY\";s:15:\"css/regular.css\";s:71:\"sha384-6Zsk745fBctG7JVrpWegJSSYk7xb3Zjy7CNEEG3dFcFGiTU/ti4muXgYnTZ6nYys\";s:13:\"css/solid.css\";s:71:\"sha384-H/BU8KfYKZ0VK4RJyclToSd6x8TmMY4/Rym2YtHXnGQOUZAoLIYIaOxkIfyTAuVh\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-La1g8AtwEh825NtYn5xyAQN3usA4ZizE2nZWvCt+g8okhStlHtUXuNSgfgo/u+ja\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-Y5XZJkJTFFCVfezUSk/mT3rropmGgfaIDhPShFdyjhON0UAHQjaq3t+bX+N+6aY/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-npPMK6zwqNmU3qyCCxEcWJkLBNYxEFM1nGgSoAWuCCXqVVz0cvwKEMfyTNkOxM2N\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-RxG9D9PsmiOdDFY0jfNnLlApnnL36kC04NEVKbj0S2RUc8ninvZZsgzCKdtsgQkk\";s:9:\"js/all.js\";s:71:\"sha384-DsXFqEUf3HnCU8om0zbXN58DxV7Bo8/z7AbHBGd2XxkeNpdLrygNiGFr/03W0Xmt\";s:12:\"js/brands.js\";s:71:\"sha384-wRU6vtIpkIdXnWzp+Hq7CNH527PHkmlZz1n7ITVY0YhEPUcSlz2voGAQfVb3d9xe\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-1DJDcrFUodFx+Lmy9p6Xay8G2Iilua4vOtatfywfvhNgsa9pgJrVgOGyxHsuoxpM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-dCcP+1ToHaZKWNvVqy4+4ekZYXP73UfD3KsBQ0xg54c0+R0I6zsewwjQiM3JUwg+\";s:13:\"js/regular.js\";s:71:\"sha384-MW39uKwb/t9lOlXyzHqlUTAWu9JpFN3aDTfaeUg8y6V0WJY5jSDspEoE05PVIBQT\";s:11:\"js/solid.js\";s:71:\"sha384-Jx4lvM3f1foL3gcKtEZPpp/IOxYaIOJ+KQRq3vP7Towpgy4bjb6wo5QK5VRtnpLh\";s:14:\"js/v4-shims.js\";s:71:\"sha384-WVm8++sQXsfFD5HmhLau6q7RS11CQOYMBHGi1pfF2PHd/vthiacQvsVLrRk6lH8O\";}s:3:\"pro\";a:0:{}}}}}}", "off");
INSERT INTO `wp_obs_options` VALUES("24101", "font-awesome", "a:8:{s:6:\"usePro\";b:0;s:6:\"compat\";b:1;s:10:\"technology\";s:7:\"webfont\";s:14:\"pseudoElements\";b:1;s:8:\"kitToken\";N;s:8:\"apiToken\";b:0;s:11:\"dataVersion\";i:4;s:7:\"version\";s:5:\"6.7.2\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("24102", "font-awesome-conflict-detection", "a:2:{s:20:\"detectConflictsUntil\";i:0;s:19:\"unregisteredClients\";a:0:{}}", "auto");
INSERT INTO `wp_obs_options` VALUES("24112", "wsp-loader-opt", "a:5:{s:6:\"loader\";s:8:\"Loader 1\";s:16:\"custom_animation\";s:65:\"  <div class=\"container\">\r\n <div class=\"loader\"></div> \r\n </div> \";s:10:\"custom_css\";s:291:\"/* HTML: <div class=\"loader\"></div> */\r\n.loader {\r\n  width: 120px;\r\n  height: 20px;\r\n  border-radius: 20px;\r\n  background:\r\n   linear-gradient(orange 0 0) 0/0% no-repeat lightblue;\r\n  animation: l2 2s infinite steps(10);\r\n  position: ;\r\n}\r\n@keyframes l2 {\r\n    100% {background-size:110%}\r\n}\";s:5:\"delay\";s:0:\"\";s:7:\"fadeout\";s:0:\"\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("24261", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"24.5\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("24262", "wpseo", "a:106:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:20:\"taxonomy_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"24.5\";s:16:\"previous_version\";s:4:\"24.4\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1738937764;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:22:\"http://localhost:10004\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:1:{i:0;s:15:\"optimizeSeoData\";}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:5:{s:30:\"aioseo_custom_archive_settings\";b:1;s:31:\"aioseo_default_archive_settings\";b:1;s:23:\"aioseo_general_settings\";b:1;s:32:\"aioseo_posttype_default_settings\";b:1;s:24:\"aioseo_taxonomy_settings\";b:1;}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1738937766;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"composante\";i:3;s:13:\"etablissement\";i:4;s:9:\"formation\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:6:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1741277985;s:31:\"wpseo_unindexed_post_link_count\";i:1741374661;s:31:\"wpseo_unindexed_term_link_count\";i:1741277985;s:27:\"wpseo_total_unindexed_posts\";i:1738941543;s:27:\"wpseo_total_unindexed_terms\";i:1739292343;s:35:\"wpseo_total_unindexed_general_items\";i:1741277985;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:1:{i:3;s:23:\"categorie_etablissement\";}s:34:\"show_new_content_type_notification\";b:1;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;}", "auto");
INSERT INTO `wp_obs_options` VALUES("24263", "wpseo_titles", "a:162:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:50:\"%%name%%, auteur/autrice sur %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Page non trouvée %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:30:\"Erreur 404 : Page introuvable\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:16:\"title-composante\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-composante\";s:0:\"\";s:18:\"noindex-composante\";b:0;s:29:\"display-metabox-pt-composante\";b:1;s:29:\"post_types-composante-maintax\";i:0;s:27:\"schema-page-type-composante\";s:7:\"WebPage\";s:30:\"schema-article-type-composante\";s:4:\"None\";s:23:\"social-title-composante\";s:9:\"%%title%%\";s:29:\"social-description-composante\";s:0:\"\";s:27:\"social-image-url-composante\";s:0:\"\";s:26:\"social-image-id-composante\";i:0;s:19:\"title-etablissement\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-etablissement\";s:0:\"\";s:21:\"noindex-etablissement\";b:0;s:32:\"display-metabox-pt-etablissement\";b:1;s:32:\"post_types-etablissement-maintax\";i:0;s:30:\"schema-page-type-etablissement\";s:7:\"WebPage\";s:33:\"schema-article-type-etablissement\";s:4:\"None\";s:26:\"social-title-etablissement\";s:9:\"%%title%%\";s:32:\"social-description-etablissement\";s:0:\"\";s:30:\"social-image-url-etablissement\";s:0:\"\";s:29:\"social-image-id-etablissement\";i:0;s:15:\"title-formation\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-formation\";s:0:\"\";s:17:\"noindex-formation\";b:0;s:28:\"display-metabox-pt-formation\";b:1;s:28:\"post_types-formation-maintax\";i:0;s:26:\"schema-page-type-formation\";s:7:\"WebPage\";s:29:\"schema-article-type-formation\";s:4:\"None\";s:22:\"social-title-formation\";s:9:\"%%title%%\";s:28:\"social-description-formation\";s:0:\"\";s:26:\"social-image-url-formation\";s:0:\"\";s:25:\"social-image-id-formation\";i:0;s:18:\"title-tax-category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `wp_obs_options` VALUES("24264", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("24625", "wpseo_taxonomy_meta", "a:1:{s:8:\"category\";a:1:{i:3;a:2:{s:13:\"wpseo_linkdex\";s:5:\"-2803\";s:19:\"wpseo_content_score\";s:1:\"0\";}}}", "auto");
INSERT INTO `wp_obs_options` VALUES("24626", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("24689", "wpmdb_usage", "a:2:{s:6:\"action\";s:8:\"savefile\";s:4:\"time\";i:1741982723;}", "off");
INSERT INTO `wp_obs_options` VALUES("24805", "wpmdb_saved_profiles", "", "off");
INSERT INTO `wp_obs_options` VALUES("24806", "wpmdb_recent_migrations", "a:3:{i:0;a:4:{s:4:\"name\";s:6:\"Export\";s:5:\"value\";s:3379:\"{\"current_migration\":{\"connected\":false,\"intent\":\"savefile\",\"tables_option\":\"all\",\"tables_selected\":[\"wp_obs_commentmeta\",\"wp_obs_comments\",\"wp_obs_duplicator_packages\",\"wp_obs_links\",\"wp_obs_options\",\"wp_obs_podsrel\",\"wp_obs_postmeta\",\"wp_obs_posts\",\"wp_obs_term_relationships\",\"wp_obs_term_taxonomy\",\"wp_obs_termmeta\",\"wp_obs_terms\",\"wp_obs_usermeta\",\"wp_obs_users\",\"wp_obs_yoast_indexable\",\"wp_obs_yoast_indexable_hierarchy\",\"wp_obs_yoast_migrations\",\"wp_obs_yoast_primary_term\",\"wp_obs_yoast_seo_links\"],\"backup_option\":\"none\",\"backup_tables_selected\":[],\"post_types_option\":\"all\",\"post_types_selected\":[],\"advanced_options_selected\":[\"gzip_file\",\"replace_guids\",\"exclude_transients\"],\"profile_name\":\"Export\",\"selected_existing_profile\":null,\"profile_type\":null,\"status\":\"\",\"stages\":[],\"current_stage\":\"\",\"stages_complete\":[],\"running\":false,\"migration_enabled\":false,\"migration_id\":\"06ec503c-eaab-405c-886b-6a340703a887\",\"source_prefix\":\"\",\"destination_prefix\":\"\",\"preview\":false,\"selectedComboOption\":\"preview\",\"twoMultisites\":false,\"localSource\":true,\"databaseEnabled\":true,\"currentPayloadSize\":0,\"currentMaxPayloadSize\":null,\"fileTransferRequests\":0,\"payloadSizeHistory\":[],\"fileTransferStats\":[],\"forceHighPerformanceTransfers\":true,\"fseDumpFilename\":null},\"search_replace\":{\"standard_search_replace\":{\"domain\":{\"search\":\"\\/\\/localhost:10004\",\"replace\":\"\",\"enabled\":true},\"path\":{\"search\":\"\\/home\\/observl\\/www\",\"replace\":\"\",\"enabled\":true}},\"standard_options_enabled\":[\"domain\",\"path\"],\"standard_search_visible\":true,\"custom_search_replace\":[{\"replace_old\":\"\",\"replace_new\":\"\",\"focus\":false,\"regex\":false,\"isValidRegex\":null,\"replace_old_placeholder\":null,\"replace_new_placeholder\":null,\"id\":\"87519665-6cb2-4fc1-b9cc-377efd653018\"}],\"custom_search_domain_locked\":false},\"media_files\":{\"enabled\":false,\"option\":\"all\",\"available\":true,\"is_licensed\":false,\"message\":\"<b>Addon Missing<\\/b> - The Media Files addon is inactive on the <strong>remote site<\\/strong>. Please install and activate it to enable media file migration.\",\"excludes\":\".DS_Store\\n*.log\\n*backup*\\/\\n*cache*\\/\",\"last_migration\":\"\",\"date\":\"2025-02-07T19:28:24.513Z\"},\"theme_plugin_files\":{\"available\":true,\"is_licensed\":false,\"message\":\"<b>Addon Missing<\\/b> - The Theme & Plugin Files addon is inactive on the <strong>remote site<\\/strong>. Please install and activate it to enable Theme & Plugin Files migration.\",\"theme_files\":{\"enabled\":false},\"themes_option\":\"all\",\"themes_selected\":[],\"themes_excluded\":[],\"themes_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"plugin_files\":{\"enabled\":true},\"plugins_option\":\"selected\",\"plugins_selected\":[\"\\/home\\/romain\\/Local Sites\\/observatoire-enseignement-suprieur-priv\\/app\\/public\\/wp-content\\/plugins\\/pods\"],\"plugins_excluded\":[],\"plugins_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"muplugin_files\":{\"enabled\":false},\"muplugins_option\":\"selected\",\"muplugins_selected\":[],\"muplugins_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"other_files\":{\"enabled\":false},\"others_option\":\"selected\",\"others_selected\":[],\"others_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"core_files\":{\"enabled\":true},\"core_option\":\"all\",\"core_selected\":[],\"core_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"state\":{\"status\":\"MIGRATION_STARTED\"}},\"multisite_tools\":{\"enabled\":false,\"available\":false,\"is_licensed\":false,\"selected_subsite\":0,\"destination_subsite\":0,\"new_prefix\":\"\",\"message\":\"\"}}\";s:4:\"date\";i:1738956561;s:4:\"guid\";s:36:\"c0ee72af-6886-4a2b-8317-6b2c8236eb13\";}i:1;a:4:{s:4:\"name\";s:6:\"Export\";s:5:\"value\";s:5107:\"{\"current_migration\":{\"connected\":false,\"intent\":\"savefile\",\"tables_option\":\"all\",\"tables_selected\":[\"wp_actionscheduler_actions\",\"wp_actionscheduler_claims\",\"wp_actionscheduler_groups\",\"wp_actionscheduler_logs\",\"wp_acym_action\",\"wp_acym_automation\",\"wp_acym_campaign\",\"wp_acym_condition\",\"wp_acym_configuration\",\"wp_acym_custom_zone\",\"wp_acym_field\",\"wp_acym_followup\",\"wp_acym_followup_has_mail\",\"wp_acym_form\",\"wp_acym_history\",\"wp_acym_list\",\"wp_acym_mail\",\"wp_acym_mail_has_list\",\"wp_acym_mail_override\",\"wp_acym_mail_stat\",\"wp_acym_mailbox_action\",\"wp_acym_plugin\",\"wp_acym_queue\",\"wp_acym_rule\",\"wp_acym_segment\",\"wp_acym_step\",\"wp_acym_tag\",\"wp_acym_url\",\"wp_acym_url_click\",\"wp_acym_user\",\"wp_acym_user_has_field\",\"wp_acym_user_has_list\",\"wp_acym_user_stat\",\"wp_apexnb_subscriber\",\"wp_auto_robot_logs\",\"wp_blc_filters\",\"wp_blc_instances\",\"wp_blc_links\",\"wp_blc_synch\",\"wp_commentmeta\",\"wp_comments\",\"wp_em_bookings\",\"wp_em_bookings_meta\",\"wp_em_events\",\"wp_em_locations\",\"wp_em_meta\",\"wp_em_tickets\",\"wp_em_tickets_bookings\",\"wp_em_tickets_bookings_meta\",\"wp_ff_scheduled_actions\",\"wp_fluentform_entry_details\",\"wp_fluentform_form_analytics\",\"wp_fluentform_form_meta\",\"wp_fluentform_forms\",\"wp_fluentform_logs\",\"wp_fluentform_submission_meta\",\"wp_fluentform_submissions\",\"wp_fsmpt_email_logs\",\"wp_links\",\"wp_mclean_refs\",\"wp_mclean_scan\",\"wp_mystickymenu_contact_lists\",\"wp_nx_entries\",\"wp_nx_posts\",\"wp_nx_stats\",\"wp_obs_commentmeta\",\"wp_obs_comments\",\"wp_obs_duplicator_packages\",\"wp_obs_links\",\"wp_obs_options\",\"wp_obs_podsrel\",\"wp_obs_postmeta\",\"wp_obs_posts\",\"wp_obs_term_relationships\",\"wp_obs_term_taxonomy\",\"wp_obs_termmeta\",\"wp_obs_terms\",\"wp_obs_usermeta\",\"wp_obs_users\",\"wp_obs_yoast_indexable\",\"wp_obs_yoast_indexable_hierarchy\",\"wp_obs_yoast_migrations\",\"wp_obs_yoast_primary_term\",\"wp_obs_yoast_seo_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_realmedialibrary\",\"wp_realmedialibrary_meta\",\"wp_realmedialibrary_posts\",\"wp_realmedialibrary_tmp\",\"wp_rednaopdfwpform_custom_field\",\"wp_rednaopdfwpform_form_config\",\"wp_rednaopdfwpform_links\",\"wp_rednaopdfwpform_records\",\"wp_rednaopdfwpform_templates\",\"wp_statify\",\"wp_tec_events\",\"wp_tec_occurrences\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wp_phpmyadmin_extension__errors_log\",\"wp_wpforms_tasks_meta\",\"wp_wprss_logs\"],\"backup_option\":\"none\",\"backup_tables_selected\":[],\"post_types_option\":\"all\",\"post_types_selected\":[],\"advanced_options_selected\":[\"gzip_file\",\"replace_guids\",\"exclude_transients\"],\"profile_name\":\"Export\",\"selected_existing_profile\":null,\"profile_type\":null,\"status\":\"\",\"stages\":[],\"current_stage\":\"\",\"stages_complete\":[],\"running\":false,\"migration_enabled\":false,\"migration_id\":\"dae6ec72-03b3-432f-bc6d-d5861ba610a1\",\"source_prefix\":\"\",\"destination_prefix\":\"\",\"preview\":false,\"selectedComboOption\":\"preview\",\"twoMultisites\":false,\"localSource\":true,\"databaseEnabled\":true,\"currentPayloadSize\":0,\"currentMaxPayloadSize\":null,\"fileTransferRequests\":0,\"payloadSizeHistory\":[],\"fileTransferStats\":[],\"forceHighPerformanceTransfers\":true,\"fseDumpFilename\":null},\"search_replace\":{\"standard_search_replace\":{\"domain\":{\"search\":\"//localhost:10004\",\"replace\":\"\",\"enabled\":true},\"path\":{\"search\":\"/www/observatoire.franceserv.com\",\"replace\":\"\",\"enabled\":true}},\"standard_options_enabled\":[\"domain\",\"path\"],\"standard_search_visible\":true,\"custom_search_replace\":[{\"replace_old\":\"\",\"replace_new\":\"\",\"focus\":false,\"regex\":false,\"isValidRegex\":null,\"replace_old_placeholder\":null,\"replace_new_placeholder\":null,\"id\":\"b2d8eae9-2f94-4ae4-8314-f7ad1be783ef\"}],\"custom_search_domain_locked\":false},\"media_files\":{\"enabled\":true,\"option\":\"all\",\"available\":true,\"is_licensed\":false,\"message\":\"<b>Addon Missing</b> - The Media Files addon is inactive on the <strong>remote site</strong>. Please install and activate it to enable media file migration.\",\"excludes\":\".DS_Store\\n*.log\\n*backup*/\\n*cache*/\",\"last_migration\":\"\",\"date\":\"2025-02-08T16:58:26.007Z\"},\"theme_plugin_files\":{\"available\":true,\"is_licensed\":false,\"message\":\"<b>Addon Missing</b> - The Theme & Plugin Files addon is inactive on the <strong>remote site</strong>. Please install and activate it to enable Theme & Plugin Files migration.\",\"theme_files\":{\"enabled\":true},\"themes_option\":\"all\",\"themes_selected\":[],\"themes_excluded\":[],\"themes_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"plugin_files\":{\"enabled\":true},\"plugins_option\":\"all\",\"plugins_selected\":[],\"plugins_excluded\":[],\"plugins_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"muplugin_files\":{\"enabled\":false},\"muplugins_option\":\"selected\",\"muplugins_selected\":[],\"muplugins_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"other_files\":{\"enabled\":false},\"others_option\":\"selected\",\"others_selected\":[],\"others_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"core_files\":{\"enabled\":true},\"core_option\":\"all\",\"core_selected\":[],\"core_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"state\":{\"status\":\"MIGRATION_STARTED\"}},\"multisite_tools\":{\"enabled\":false,\"available\":false,\"is_licensed\":false,\"selected_subsite\":0,\"destination_subsite\":0,\"new_prefix\":\"\",\"message\":\"\"}}\";s:4:\"date\";i:1739033949;s:4:\"guid\";s:36:\"259ef888-58d0-4eff-a832-5cc9b3ac1889\";}i:2;a:4:{s:4:\"name\";s:6:\"Export\";s:5:\"value\";s:3296:\"{\"current_migration\":{\"connected\":false,\"intent\":\"savefile\",\"tables_option\":\"all\",\"tables_selected\":[\"wp_obs_admin_columns\",\"wp_obs_commentmeta\",\"wp_obs_comments\",\"wp_obs_duplicator_packages\",\"wp_obs_links\",\"wp_obs_options\",\"wp_obs_podsrel\",\"wp_obs_postmeta\",\"wp_obs_posts\",\"wp_obs_snippets\",\"wp_obs_term_relationships\",\"wp_obs_term_taxonomy\",\"wp_obs_termmeta\",\"wp_obs_terms\",\"wp_obs_usermeta\",\"wp_obs_users\",\"wp_obs_yoast_indexable\",\"wp_obs_yoast_indexable_hierarchy\",\"wp_obs_yoast_migrations\",\"wp_obs_yoast_primary_term\",\"wp_obs_yoast_seo_links\"],\"backup_option\":\"none\",\"backup_tables_selected\":[],\"post_types_option\":\"all\",\"post_types_selected\":[],\"advanced_options_selected\":[\"gzip_file\",\"replace_guids\",\"exclude_transients\"],\"profile_name\":\"Export\",\"selected_existing_profile\":null,\"profile_type\":null,\"status\":\"\",\"stages\":[],\"current_stage\":\"\",\"stages_complete\":[],\"running\":false,\"migration_enabled\":false,\"migration_id\":\"2b42c434-2a88-4c08-b7c3-12b31f46aa69\",\"source_prefix\":\"\",\"destination_prefix\":\"\",\"preview\":false,\"selectedComboOption\":\"preview\",\"twoMultisites\":false,\"localSource\":true,\"databaseEnabled\":true,\"currentPayloadSize\":0,\"currentMaxPayloadSize\":null,\"fileTransferRequests\":0,\"payloadSizeHistory\":[],\"fileTransferStats\":[],\"forceHighPerformanceTransfers\":true,\"fseDumpFilename\":null},\"search_replace\":{\"standard_search_replace\":{\"domain\":{\"search\":\"//localhost:10004\",\"replace\":\"\",\"enabled\":true},\"path\":{\"search\":\"/home/observl/www\",\"replace\":\"\",\"enabled\":true}},\"standard_options_enabled\":[\"domain\",\"path\"],\"standard_search_visible\":true,\"custom_search_replace\":[{\"replace_old\":\"\",\"replace_new\":\"\",\"focus\":false,\"regex\":false,\"isValidRegex\":null,\"replace_old_placeholder\":null,\"replace_new_placeholder\":null,\"id\":\"7fbca790-d614-4de2-abf1-d80ddbce8e4d\"}],\"custom_search_domain_locked\":false},\"media_files\":{\"enabled\":false,\"option\":\"all\",\"available\":true,\"is_licensed\":false,\"message\":\"<b>Addon Missing</b> - The Media Files addon is inactive on the <strong>remote site</strong>. Please install and activate it to enable media file migration.\",\"excludes\":\".DS_Store\\n*.log\\n*backup*/\\n*cache*/\",\"last_migration\":\"\",\"date\":\"2025-03-14T20:04:43.362Z\"},\"theme_plugin_files\":{\"available\":true,\"is_licensed\":false,\"message\":\"<b>Addon Missing</b> - The Theme & Plugin Files addon is inactive on the <strong>remote site</strong>. Please install and activate it to enable Theme & Plugin Files migration.\",\"theme_files\":{\"enabled\":false},\"themes_option\":\"all\",\"themes_selected\":[],\"themes_excluded\":[],\"themes_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"plugin_files\":{\"enabled\":false},\"plugins_option\":\"all\",\"plugins_selected\":[],\"plugins_excluded\":[],\"plugins_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"muplugin_files\":{\"enabled\":false},\"muplugins_option\":\"selected\",\"muplugins_selected\":[],\"muplugins_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"other_files\":{\"enabled\":false},\"others_option\":\"selected\",\"others_selected\":[],\"others_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"core_files\":{\"enabled\":false},\"core_option\":\"all\",\"core_selected\":[],\"core_excludes\":\".DS_Store\\n.git\\nnode_modules\",\"state\":{\"status\":\"MIGRATION_STARTED\"}},\"multisite_tools\":{\"enabled\":false,\"available\":false,\"is_licensed\":false,\"selected_subsite\":0,\"destination_subsite\":0,\"new_prefix\":\"\",\"message\":\"\"}}\";s:4:\"date\";i:1741982724;s:4:\"guid\";s:36:\"8d8a71fc-7b5e-480a-b08c-89fbef58d9eb\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("24810", "wpmdb_remote_migration_state", "", "off");
INSERT INTO `wp_obs_options` VALUES("24811", "wpmdb_schema_version", "3.8.0", "off");
INSERT INTO `wp_obs_options` VALUES("26704", "themeisle_sdk_promotions", "{\"om-attachment\":1739019435}", "auto");
INSERT INTO `wp_obs_options` VALUES("28217", "code_snippets_version", "3.6.7", "auto");
INSERT INTO `wp_obs_options` VALUES("28219", "code_snippets_settings", "a:3:{s:5:\"debug\";a:0:{}s:7:\"general\";a:8:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:18:\"visual_editor_rows\";i:5;s:10:\"list_order\";s:12:\"priority-asc\";s:13:\"disable_prism\";b:0;s:17:\"hide_upgrade_menu\";b:0;s:18:\"complete_uninstall\";b:0;}s:6:\"editor\";a:11:{s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:10:\"wrap_lines\";b:1;s:12:\"code_folding\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;s:6:\"keymap\";s:7:\"default\";s:5:\"theme\";s:7:\"default\";}}", "auto");
INSERT INTO `wp_obs_options` VALUES("29581", "secret_key", "B74t$WfoZY!*a}&?p`%R5!i5*ZttYUhP8`T7:AlL|u|%GX|UO>UiIKYzIB+5|sjw", "off");
INSERT INTO `wp_obs_options` VALUES("33484", "ac_version", "4.7.7", "off");
INSERT INTO `wp_obs_options` VALUES("33486", "_ac_colors_colors", "a:8:{s:7:\"success\";s:7:\"#00a32a\";s:7:\"warning\";s:7:\"#dba617\";s:5:\"error\";s:7:\"#d63638\";s:4:\"info\";s:7:\"#72aee6\";s:11:\"success-alt\";s:7:\"#edfaef\";s:11:\"warning-alt\";s:7:\"#fcf9e8\";s:9:\"error-alt\";s:7:\"#fcf0f1\";s:8:\"info-alt\";s:7:\"#f0f6fc\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33487", "_ac_colors_shipped_colors_version", "6.7.2", "off");
INSERT INTO `wp_obs_options` VALUES("33488", "ac-deprecated-message-count_timestamp", "1741901937", "off");
INSERT INTO `wp_obs_options` VALUES("33489", "ac-deprecated-message-count", "0", "off");
INSERT INTO `wp_obs_options` VALUES("33490", "cpac_options_easy_charts__default", "a:3:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:4:\"date\";s:4:\"Date\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33491", "cpac_options_etablissement__default", "a:10:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:4:\"date\";s:4:\"Date\";s:11:\"wpseo-score\";s:162:\"<span class=\"yoast-column-seo-score yoast-column-header-has-tooltip\" data-tooltip-text=\"Score SEO\"><span class=\"screen-reader-text\">Score SEO</span></span></span>\";s:23:\"wpseo-score-readability\";s:186:\"<span class=\"yoast-column-readability yoast-column-header-has-tooltip\" data-tooltip-text=\"Score de lisibilité\"><span class=\"screen-reader-text\">Score de lisibilité</span></span></span>\";s:11:\"wpseo-title\";s:9:\"Titre SEO\";s:14:\"wpseo-metadesc\";s:11:\"Méta Desc.\";s:13:\"wpseo-focuskw\";s:8:\"Requête\";s:11:\"wpseo-links\";s:205:\"<span class=\"yoast-linked-to yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes sortants de cette publication.\"><span class=\"screen-reader-text\">Liens internes émis</span></span>\";s:12:\"wpseo-linked\";s:209:\"<span class=\"yoast-linked-from yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes renvoyant à cette publication.\"><span class=\"screen-reader-text\">Liens internes reçus</span></span>\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33492", "cpac_options_composante__default", "a:9:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:4:\"date\";s:4:\"Date\";s:11:\"wpseo-score\";s:162:\"<span class=\"yoast-column-seo-score yoast-column-header-has-tooltip\" data-tooltip-text=\"Score SEO\"><span class=\"screen-reader-text\">Score SEO</span></span></span>\";s:23:\"wpseo-score-readability\";s:186:\"<span class=\"yoast-column-readability yoast-column-header-has-tooltip\" data-tooltip-text=\"Score de lisibilité\"><span class=\"screen-reader-text\">Score de lisibilité</span></span></span>\";s:11:\"wpseo-title\";s:9:\"Titre SEO\";s:14:\"wpseo-metadesc\";s:11:\"Méta Desc.\";s:13:\"wpseo-focuskw\";s:8:\"Requête\";s:11:\"wpseo-links\";s:205:\"<span class=\"yoast-linked-to yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes sortants de cette publication.\"><span class=\"screen-reader-text\">Liens internes émis</span></span>\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33493", "cpac_options_formation__default", "a:10:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:4:\"date\";s:4:\"Date\";s:11:\"wpseo-score\";s:162:\"<span class=\"yoast-column-seo-score yoast-column-header-has-tooltip\" data-tooltip-text=\"Score SEO\"><span class=\"screen-reader-text\">Score SEO</span></span></span>\";s:23:\"wpseo-score-readability\";s:186:\"<span class=\"yoast-column-readability yoast-column-header-has-tooltip\" data-tooltip-text=\"Score de lisibilité\"><span class=\"screen-reader-text\">Score de lisibilité</span></span></span>\";s:11:\"wpseo-title\";s:9:\"Titre SEO\";s:14:\"wpseo-metadesc\";s:11:\"Méta Desc.\";s:13:\"wpseo-focuskw\";s:8:\"Requête\";s:11:\"wpseo-links\";s:205:\"<span class=\"yoast-linked-to yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes sortants de cette publication.\"><span class=\"screen-reader-text\">Liens internes émis</span></span>\";s:12:\"wpseo-linked\";s:209:\"<span class=\"yoast-linked-from yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes renvoyant à cette publication.\"><span class=\"screen-reader-text\">Liens internes reçus</span></span>\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33494", "cpac_options_post__default", "a:14:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:6:\"author\";s:14:\"Auteur/autrice\";s:10:\"categories\";s:11:\"Catégories\";s:4:\"tags\";s:11:\"Étiquettes\";s:8:\"comments\";s:138:\"<span class=\"vers comment-grey-bubble\" title=\"Commentaires\" aria-hidden=\"true\"></span><span class=\"screen-reader-text\">Commentaires</span>\";s:4:\"date\";s:4:\"Date\";s:11:\"wpseo-score\";s:162:\"<span class=\"yoast-column-seo-score yoast-column-header-has-tooltip\" data-tooltip-text=\"Score SEO\"><span class=\"screen-reader-text\">Score SEO</span></span></span>\";s:23:\"wpseo-score-readability\";s:186:\"<span class=\"yoast-column-readability yoast-column-header-has-tooltip\" data-tooltip-text=\"Score de lisibilité\"><span class=\"screen-reader-text\">Score de lisibilité</span></span></span>\";s:11:\"wpseo-title\";s:9:\"Titre SEO\";s:14:\"wpseo-metadesc\";s:11:\"Méta Desc.\";s:13:\"wpseo-focuskw\";s:8:\"Requête\";s:11:\"wpseo-links\";s:205:\"<span class=\"yoast-linked-to yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes sortants de cette publication.\"><span class=\"screen-reader-text\">Liens internes émis</span></span>\";s:12:\"wpseo-linked\";s:209:\"<span class=\"yoast-linked-from yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes renvoyant à cette publication.\"><span class=\"screen-reader-text\">Liens internes reçus</span></span>\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33501", "cpac_options_page__default", "a:12:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:6:\"author\";s:14:\"Auteur/autrice\";s:8:\"comments\";s:138:\"<span class=\"vers comment-grey-bubble\" title=\"Commentaires\" aria-hidden=\"true\"></span><span class=\"screen-reader-text\">Commentaires</span>\";s:4:\"date\";s:4:\"Date\";s:11:\"wpseo-score\";s:162:\"<span class=\"yoast-column-seo-score yoast-column-header-has-tooltip\" data-tooltip-text=\"Score SEO\"><span class=\"screen-reader-text\">Score SEO</span></span></span>\";s:23:\"wpseo-score-readability\";s:186:\"<span class=\"yoast-column-readability yoast-column-header-has-tooltip\" data-tooltip-text=\"Score de lisibilité\"><span class=\"screen-reader-text\">Score de lisibilité</span></span></span>\";s:11:\"wpseo-title\";s:9:\"Titre SEO\";s:14:\"wpseo-metadesc\";s:11:\"Méta Desc.\";s:13:\"wpseo-focuskw\";s:8:\"Requête\";s:11:\"wpseo-links\";s:205:\"<span class=\"yoast-linked-to yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes sortants de cette publication.\"><span class=\"screen-reader-text\">Liens internes émis</span></span>\";s:12:\"wpseo-linked\";s:209:\"<span class=\"yoast-linked-from yoast-column-header-has-tooltip\" data-tooltip-text=\"Nombre de liens internes renvoyant à cette publication.\"><span class=\"screen-reader-text\">Liens internes reçus</span></span>\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33502", "cpac_options_wp_block__default", "a:4:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Titre\";s:28:\"taxonomy-wp_pattern_category\";s:27:\"Catégories de compositions\";s:4:\"date\";s:4:\"Date\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33505", "cpac_options_wp-comments__default", "a:5:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:6:\"author\";s:14:\"Auteur/autrice\";s:7:\"comment\";s:11:\"Commentaire\";s:8:\"response\";s:14:\"En réponse à\";s:4:\"date\";s:10:\"Envoyé le\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33506", "cpac_options_wp-users__default", "a:6:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:8:\"username\";s:11:\"Identifiant\";s:4:\"name\";s:3:\"Nom\";s:5:\"email\";s:6:\"E-mail\";s:4:\"role\";s:5:\"Rôle\";s:5:\"posts\";s:8:\"Articles\";}", "off");
INSERT INTO `wp_obs_options` VALUES("33507", "cpac_options_wp-media__default", "a:6:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:7:\"Fichier\";s:6:\"author\";s:14:\"Auteur/autrice\";s:6:\"parent\";s:17:\"Téléversé sur \";s:8:\"comments\";s:138:\"<span class=\"vers comment-grey-bubble\" title=\"Commentaires\" aria-hidden=\"true\"></span><span class=\"screen-reader-text\">Commentaires</span>\";s:4:\"date\";s:4:\"Date\";}", "off");
INSERT INTO `wp_obs_options` VALUES("35053", "ecoles_de_commerce_children", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("36385", "wp_debugging_restore", "a:1:{s:8:\"wp_debug\";a:1:{s:5:\"value\";s:5:\"false\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("36396", "wp_debugging", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("36403", "categorie_etablissement_children", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("36456", "display_posts_survey_2", "a:2:{s:4:\"time\";i:1741427471;s:9:\"dismissed\";b:0;}", "auto");
INSERT INTO `wp_obs_options` VALUES("36473", "recently_activated_snippets", "a:0:{}", "auto");
INSERT INTO `wp_obs_options` VALUES("37081", "bvmgredirect", "no", "off");
INSERT INTO `wp_obs_options` VALUES("37082", "bvActivateTime", "1741971379", "off");
INSERT INTO `wp_obs_options` VALUES("37084", "bv_default_secret_key", "a:2:{s:3:\"key\";s:32:\"DiQekgwRTgUnn2n6s2vd3nwUj4sLxmb5\";s:10:\"expires_at\";i:1742057783;}", "off");
INSERT INTO `wp_obs_options` VALUES("37108", "duplicator_expire_search-replace-wpcode", "{\"expire\":1743196365,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_obs_options` VALUES("37109", "duplicator_expire_wp-mail-smtp", "{\"expire\":1743196366,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.2\"}}", "on");
INSERT INTO `wp_obs_options` VALUES("37110", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1743196366,\"value\":{\"wp_version\":\"4.6\",\"php_version\":\"5.5\"}}", "on");
INSERT INTO `wp_obs_options` VALUES("37113", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_obs_options` VALUES("37114", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_obs_options` VALUES("37116", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.11.2\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\",\n        \"OVERWRITE\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/observl\\/www\\/20241123_observatoiredelenseignements_7c393a82b0ff2dda3075_20250314212618_archive.zip\",\n    \"packageHash\": \"7c393a8-14212618\",\n    \"installerPath\": \"\\/home\\/observl\\/www\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/observl\\/www\\/dup-installer-bootlog__86ecd32-14212618.txt\",\n    \"installerLog\": \"\\/home\\/observl\\/www\\/dup-installer\\/dup-installer-log__86ecd32-14212618.txt\",\n    \"dupInstallerPath\": \"\\/home\\/observl\\/www\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/observl\\/www\\/dup-installer\\/original_files_7c393a8-14212618\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"8.2.23\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 91086283,\n    \"siteNumFiles\": 13048,\n    \"siteDbSize\": 40435712,\n    \"siteDBNumTables\": 21,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"3;F;kqZX3SaMLpQriLcKemwvXwh5n8CQcJO&Lp4-yn;H\",\n    \"time\": 1741984818\n}", "no");
INSERT INTO `wp_obs_options` VALUES("37167", "_transient_timeout_font-awesome-last-used-release", "1773520820", "off");
INSERT INTO `wp_obs_options` VALUES("37168", "_transient_font-awesome-last-used-release", "a:5:{s:7:\"version\";s:5:\"6.7.2\";s:7:\"use_pro\";b:0;s:7:\"use_svg\";b:0;s:17:\"use_compatibility\";b:1;s:9:\"resources\";a:2:{s:3:\"all\";O:32:\"FortAwesome\\FontAwesome_Resource\":2:{s:9:\"\0*\0source\";s:55:\"https://use.fontawesome.com/releases/v6.7.2/css/all.css\";s:16:\"\0*\0integrity_key\";s:71:\"sha384-nRgPTkuX86pH8yjPJUAFuASXQSSl2/bBUiNV47vSYpKFxHJhbcrGnmlYpYJMeD7a\";}s:8:\"v4-shims\";O:32:\"FortAwesome\\FontAwesome_Resource\":2:{s:9:\"\0*\0source\";s:60:\"https://use.fontawesome.com/releases/v6.7.2/css/v4-shims.css\";s:16:\"\0*\0integrity_key\";s:71:\"sha384-npPMK6zwqNmU3qyCCxEcWJkLBNYxEFM1nGgSoAWuCCXqVVz0cvwKEMfyTNkOxM2N\";}}}", "off");
INSERT INTO `wp_obs_options` VALUES("37169", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"d76ea274bf430496295fc6cac460e48f\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_obs_options` VALUES("37196", "_site_transient_wpmdb_disabled_legacy_addons", "1", "off");
INSERT INTO `wp_obs_options` VALUES("37203", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 1742569992,\n    \"identifier\": \"3;F;kqZX3SaMLpQriLcKemwvXwh5n8CQcJO&Lp4-yn;H\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 223.75,\n    \"siteNumFiles\": 13266,\n    \"siteDbSizeMB\": 37.030000000000001,\n    \"siteDbNumTables\": 21\n}", "auto");
INSERT INTO `wp_obs_options` VALUES("37260", "_site_transient_timeout_browser_cce0fbea5e95d5eeee19d6d34d4556a6", "1742656442", "off");
INSERT INTO `wp_obs_options` VALUES("37261", "_site_transient_browser_cce0fbea5e95d5eeee19d6d34d4556a6", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"136.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_obs_options` VALUES("37262", "_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271", "1742656443", "off");
INSERT INTO `wp_obs_options` VALUES("37263", "_site_transient_php_check_38979a08dcd71638878b7b4419751271", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_obs_options` VALUES("37443", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":4,\"critical\":0}", "on");
INSERT INTO `wp_obs_options` VALUES("37529", "_site_transient_timeout_browser_2333b8d335abc6e14aef1caed0ae26fc", "1743001236", "off");
INSERT INTO `wp_obs_options` VALUES("37530", "_site_transient_browser_2333b8d335abc6e14aef1caed0ae26fc", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"136.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_obs_options` VALUES("38289", "_transient_timeout_code_snippets_welcome_data", "1742756434", "off");
INSERT INTO `wp_obs_options` VALUES("38290", "_transient_code_snippets_welcome_data", "a:5:{s:6:\"banner\";a:9:{s:3:\"key\";s:12:\"backtonormal\";s:14:\"start_datetime\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2025-01-24 07:00:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:12:\"end_datetime\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2025-07-05 16:00:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:9:\"text_free\";s:79:\"Code Without Limits – Experience Ultimate Flexibility with Code Snippets Pro!\";s:15:\"action_url_free\";s:22:\"https://snipco.de/TFHM\";s:17:\"action_label_free\";s:10:\"Go Pro now\";s:8:\"text_pro\";s:73:\"Enjoying the Power of Pro? Make It Yours Forever with a Lifetime Upgrade!\";s:14:\"action_url_pro\";s:22:\"https://snipco.de/TFIP\";s:16:\"action_label_pro\";s:10:\"Go Pro now\";}s:9:\"hero-item\";a:3:{s:4:\"name\";s:26:\"Code Snippet AI is here…\";s:10:\"follow_url\";s:54:\"https://codesnippets.pro/blog/code-snippet-ai-is-here/\";s:9:\"image_url\";s:71:\"https://codesnippets.pro/wp-content/uploads/2024/05/cs_ai_demo_full.gif\";}s:8:\"features\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"Pssss... Get Secret Discount\";s:10:\"follow_url\";s:22:\"https://snipco.de/TFIG\";s:9:\"image_url\";s:81:\"https://codesnippets.pro/wp-content/uploads/2024/09/Promotions_Hero_All_Plans.png\";s:8:\"category\";s:5:\"offer\";s:11:\"description\";s:100:\"Get secret discount on all Code Snippets Pro plans. Just use coupon code \'General5\' at the checkout!\";}i:1;a:5:{s:5:\"title\";s:25:\"Add Unsplash to WordPress\";s:10:\"follow_url\";s:22:\"https://snipco.de/Mind\";s:9:\"image_url\";s:53:\"https://i3.ytimg.com/vi/kRSwWDanX0A/maxresdefault.jpg\";s:8:\"category\";s:3:\"tip\";s:11:\"description\";s:70:\"Code Snippet to Add Unsplash to WordPress - Find and Download Images..\";}i:2;a:5:{s:5:\"title\";s:30:\"Code Snippet Cloud Setup Guide\";s:10:\"follow_url\";s:22:\"https://snipco.de/Mine\";s:9:\"image_url\";s:149:\"https://cdn.getgist.com/attachment_images/76ca6cef08ca8e69ac1e7fbc15004bebbd08ad595ee67e0d7b55d1a9555354bfScreenshot%202023-11-23%20at%2000.50.02.png\";s:8:\"category\";s:5:\"guide\";s:11:\"description\";s:143:\"We have done our best to make the cloud set up as smooth and easy as possible. This guide below will walk you through the process step by step.\";}i:3;a:5:{s:5:\"title\";s:14:\"Cloud and AI +\";s:10:\"follow_url\";s:22:\"https://snipco.de/Minf\";s:9:\"image_url\";s:53:\"https://i3.ytimg.com/vi/rEOC2bIwY-w/maxresdefault.jpg\";s:8:\"category\";s:11:\"new feature\";s:11:\"description\";s:68:\"Code Snippets 3.6 Announcement - AI CodeSnippets - Generate AI Code!\";}}s:8:\"partners\";a:4:{i:0;a:3:{s:5:\"title\";s:9:\"Elementor\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3d\";s:9:\"image_url\";s:76:\"https://codesnippets.pro/wp-content/uploads/2024/05/Elementor-logo-green.png\";}i:1;a:3:{s:5:\"title\";s:7:\"InstaWP\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3n\";s:9:\"image_url\";s:68:\"https://codesnippets.pro/wp-content/uploads/2024/05/instawp-logo.png\";}i:2;a:3:{s:5:\"title\";s:8:\"Codeable\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3j\";s:9:\"image_url\";s:69:\"https://codesnippets.pro/wp-content/uploads/2024/05/codeable-logo.png\";}i:3;a:3:{s:5:\"title\";s:10:\"Crocoblock\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3l\";s:9:\"image_url\";s:71:\"https://codesnippets.pro/wp-content/uploads/2024/05/crocoblock-logo.png\";}}s:9:\"changelog\";a:3:{s:5:\"3.6.7\";a:3:{s:5:\"Added\";a:1:{s:4:\"core\";a:2:{i:0;s:90:\"Generated snippet shortcode tags will include the snippet name, for easier identification.\";i:1;s:130:\"Admin notices will dismiss automatically after five seconds. ([#208](https://github.com/codesnippetspro/code-snippets/issues/208))\";}}s:7:\"Changed\";a:1:{s:4:\"core\";a:3:{i:0;s:40:\"Updated CSS to use latest Sass features.\";i:1;s:161:\"Moved theme selector to just above editor preview on settings page (thanks to [brandonjp]). ([#206](https://github.com/codesnippetspro/code-snippets/issues/206))\";i:2;s:134:\"`[code_snippet]` shortcodes can now be nested within each other. ([#198](https://github.com/codesnippetspro/code-snippets/issues/198))\";}}s:5:\"Fixed\";a:2:{s:3:\"pro\";a:2:{i:0;s:144:\"Save buttons above editor did not follow usual validation process in Pro.  ([#197](https://github.com/codesnippetspro/code-snippets/issues/197))\";i:1;s:111:\"Issue with Elementor source code widget.  ([#205](https://github.com/codesnippetspro/code-snippets/issues/205))\";}s:4:\"core\";a:5:{i:0;s:69:\"Minor inconsistencies in consistent UI elements between Core and Pro.\";i:1;s:100:\"Tags input not allowing input. ([#211](https://github.com/codesnippetspro/code-snippets/issues/211))\";i:2;s:67:\"Snippet descriptions not visible when viewing cloud search results.\";i:3;s:76:\"Snippet import page not displaying number of successfully imported snippets.\";i:4;s:60:\"Use UTC time when deciding when to display campaign notices.\";}}}s:7:\"3.6.6.1\";a:1:{s:5:\"Fixed\";a:2:{s:4:\"core\";a:1:{i:0;s:79:\"Redeployment of [v3.6.6](#366-2024-11-27) to overcome issue with initial build.\";}s:3:\"pro\";a:1:{i:0;s:36:\"Type issue when caching cloud links.\";}}}s:5:\"3.6.6\";a:2:{s:7:\"Changed\";a:1:{s:4:\"core\";a:4:{i:0;s:51:\"Improved compatability with modern versions of PHP.\";i:1;s:46:\"Extended welcome API to include admin notices.\";i:2;s:111:\"Action hook `code_snippets/update_snippet` now only includes the snippet ID instead of the full snippet object.\";i:3;s:80:\"Action hook `code_snippets/admin/manage` now includes the currently viewed type.\";}}s:5:\"Fixed\";a:1:{s:4:\"core\";a:5:{i:0;s:86:\"Memory issue from checking aggregate posts while loading front-end syntax highlighter.\";i:1;s:98:\"Translation functions being called too early on upgrade, resulting in localisation loading errors.\";i:2;s:89:\"Bug preventing the \'share on network\' status of network snippets from correctly updating.\";i:3;s:98:\"Incorrect logic controlling when to display \'Save Changes\' or \'Save Changes and Activate\' buttons.\";i:4;s:76:\"Old notices persisting when switching between editing and creating snippets.\";}}}}}", "off");
INSERT INTO `wp_obs_options` VALUES("38433", "_transient_timeout_visualizer_db_wp_obs_admin_columns_columns", "1742670143", "off");
INSERT INTO `wp_obs_options` VALUES("38434", "_transient_visualizer_db_wp_obs_admin_columns_columns", "a:8:{i:0;a:2:{s:4:\"name\";s:23:\"wp_obs_admin_columns.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:28:\"wp_obs_admin_columns.list_id\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:29:\"wp_obs_admin_columns.list_key\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:26:\"wp_obs_admin_columns.title\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:28:\"wp_obs_admin_columns.columns\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:29:\"wp_obs_admin_columns.settings\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:33:\"wp_obs_admin_columns.date_created\";s:4:\"type\";s:1:\"d\";}i:7;a:2:{s:4:\"name\";s:34:\"wp_obs_admin_columns.date_modified\";s:4:\"type\";s:1:\"d\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38435", "_transient_timeout_visualizer_db_wp_obs_commentmeta_columns", "1742670143", "off");
INSERT INTO `wp_obs_options` VALUES("38436", "_transient_visualizer_db_wp_obs_commentmeta_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:26:\"wp_obs_commentmeta.meta_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:29:\"wp_obs_commentmeta.comment_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:27:\"wp_obs_commentmeta.meta_key\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:29:\"wp_obs_commentmeta.meta_value\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38437", "_transient_timeout_visualizer_db_wp_obs_comments_columns", "1742670143", "off");
INSERT INTO `wp_obs_options` VALUES("38438", "_transient_visualizer_db_wp_obs_comments_columns", "a:15:{i:0;a:2:{s:4:\"name\";s:26:\"wp_obs_comments.comment_ID\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:31:\"wp_obs_comments.comment_post_ID\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:30:\"wp_obs_comments.comment_author\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:36:\"wp_obs_comments.comment_author_email\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:34:\"wp_obs_comments.comment_author_url\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:33:\"wp_obs_comments.comment_author_IP\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:28:\"wp_obs_comments.comment_date\";s:4:\"type\";s:1:\"d\";}i:7;a:2:{s:4:\"name\";s:32:\"wp_obs_comments.comment_date_gmt\";s:4:\"type\";s:1:\"d\";}i:8;a:2:{s:4:\"name\";s:31:\"wp_obs_comments.comment_content\";s:4:\"type\";s:1:\"s\";}i:9;a:2:{s:4:\"name\";s:29:\"wp_obs_comments.comment_karma\";s:4:\"type\";s:1:\"n\";}i:10;a:2:{s:4:\"name\";s:32:\"wp_obs_comments.comment_approved\";s:4:\"type\";s:1:\"s\";}i:11;a:2:{s:4:\"name\";s:29:\"wp_obs_comments.comment_agent\";s:4:\"type\";s:1:\"s\";}i:12;a:2:{s:4:\"name\";s:28:\"wp_obs_comments.comment_type\";s:4:\"type\";s:1:\"s\";}i:13;a:2:{s:4:\"name\";s:30:\"wp_obs_comments.comment_parent\";s:4:\"type\";s:1:\"n\";}i:14;a:2:{s:4:\"name\";s:23:\"wp_obs_comments.user_id\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38439", "_transient_timeout_visualizer_db_wp_obs_duplicator_packages_columns", "1742670143", "off");
INSERT INTO `wp_obs_options` VALUES("38440", "_transient_visualizer_db_wp_obs_duplicator_packages_columns", "a:7:{i:0;a:2:{s:4:\"name\";s:29:\"wp_obs_duplicator_packages.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:31:\"wp_obs_duplicator_packages.name\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:31:\"wp_obs_duplicator_packages.hash\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:33:\"wp_obs_duplicator_packages.status\";s:4:\"type\";s:1:\"n\";}i:4;a:2:{s:4:\"name\";s:34:\"wp_obs_duplicator_packages.created\";s:4:\"type\";s:1:\"d\";}i:5;a:2:{s:4:\"name\";s:32:\"wp_obs_duplicator_packages.owner\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:34:\"wp_obs_duplicator_packages.package\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38441", "_transient_timeout_visualizer_db_wp_obs_links_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38442", "_transient_visualizer_db_wp_obs_links_columns", "a:13:{i:0;a:2:{s:4:\"name\";s:20:\"wp_obs_links.link_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:21:\"wp_obs_links.link_url\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:22:\"wp_obs_links.link_name\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:23:\"wp_obs_links.link_image\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:24:\"wp_obs_links.link_target\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:29:\"wp_obs_links.link_description\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:25:\"wp_obs_links.link_visible\";s:4:\"type\";s:1:\"s\";}i:7;a:2:{s:4:\"name\";s:23:\"wp_obs_links.link_owner\";s:4:\"type\";s:1:\"n\";}i:8;a:2:{s:4:\"name\";s:24:\"wp_obs_links.link_rating\";s:4:\"type\";s:1:\"n\";}i:9;a:2:{s:4:\"name\";s:25:\"wp_obs_links.link_updated\";s:4:\"type\";s:1:\"d\";}i:10;a:2:{s:4:\"name\";s:21:\"wp_obs_links.link_rel\";s:4:\"type\";s:1:\"s\";}i:11;a:2:{s:4:\"name\";s:23:\"wp_obs_links.link_notes\";s:4:\"type\";s:1:\"s\";}i:12;a:2:{s:4:\"name\";s:21:\"wp_obs_links.link_rss\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38443", "_transient_timeout_visualizer_db_wp_obs_options_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38444", "_transient_visualizer_db_wp_obs_options_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:24:\"wp_obs_options.option_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:26:\"wp_obs_options.option_name\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:27:\"wp_obs_options.option_value\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:23:\"wp_obs_options.autoload\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38445", "_transient_timeout_visualizer_db_wp_obs_podsrel_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38446", "_transient_visualizer_db_wp_obs_podsrel_columns", "a:8:{i:0;a:2:{s:4:\"name\";s:17:\"wp_obs_podsrel.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:21:\"wp_obs_podsrel.pod_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:23:\"wp_obs_podsrel.field_id\";s:4:\"type\";s:1:\"n\";}i:3;a:2:{s:4:\"name\";s:22:\"wp_obs_podsrel.item_id\";s:4:\"type\";s:1:\"n\";}i:4;a:2:{s:4:\"name\";s:29:\"wp_obs_podsrel.related_pod_id\";s:4:\"type\";s:1:\"n\";}i:5;a:2:{s:4:\"name\";s:31:\"wp_obs_podsrel.related_field_id\";s:4:\"type\";s:1:\"n\";}i:6;a:2:{s:4:\"name\";s:30:\"wp_obs_podsrel.related_item_id\";s:4:\"type\";s:1:\"n\";}i:7;a:2:{s:4:\"name\";s:21:\"wp_obs_podsrel.weight\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38447", "_transient_timeout_visualizer_db_wp_obs_postmeta_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38448", "_transient_visualizer_db_wp_obs_postmeta_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:23:\"wp_obs_postmeta.meta_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:23:\"wp_obs_postmeta.post_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:24:\"wp_obs_postmeta.meta_key\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:26:\"wp_obs_postmeta.meta_value\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38449", "_transient_timeout_visualizer_db_wp_obs_posts_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38450", "_transient_visualizer_db_wp_obs_posts_columns", "a:23:{i:0;a:2:{s:4:\"name\";s:15:\"wp_obs_posts.ID\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:24:\"wp_obs_posts.post_author\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:22:\"wp_obs_posts.post_date\";s:4:\"type\";s:1:\"d\";}i:3;a:2:{s:4:\"name\";s:26:\"wp_obs_posts.post_date_gmt\";s:4:\"type\";s:1:\"d\";}i:4;a:2:{s:4:\"name\";s:25:\"wp_obs_posts.post_content\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:23:\"wp_obs_posts.post_title\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:25:\"wp_obs_posts.post_excerpt\";s:4:\"type\";s:1:\"s\";}i:7;a:2:{s:4:\"name\";s:24:\"wp_obs_posts.post_status\";s:4:\"type\";s:1:\"s\";}i:8;a:2:{s:4:\"name\";s:27:\"wp_obs_posts.comment_status\";s:4:\"type\";s:1:\"s\";}i:9;a:2:{s:4:\"name\";s:24:\"wp_obs_posts.ping_status\";s:4:\"type\";s:1:\"s\";}i:10;a:2:{s:4:\"name\";s:26:\"wp_obs_posts.post_password\";s:4:\"type\";s:1:\"s\";}i:11;a:2:{s:4:\"name\";s:22:\"wp_obs_posts.post_name\";s:4:\"type\";s:1:\"s\";}i:12;a:2:{s:4:\"name\";s:20:\"wp_obs_posts.to_ping\";s:4:\"type\";s:1:\"s\";}i:13;a:2:{s:4:\"name\";s:19:\"wp_obs_posts.pinged\";s:4:\"type\";s:1:\"s\";}i:14;a:2:{s:4:\"name\";s:26:\"wp_obs_posts.post_modified\";s:4:\"type\";s:1:\"d\";}i:15;a:2:{s:4:\"name\";s:30:\"wp_obs_posts.post_modified_gmt\";s:4:\"type\";s:1:\"d\";}i:16;a:2:{s:4:\"name\";s:34:\"wp_obs_posts.post_content_filtered\";s:4:\"type\";s:1:\"s\";}i:17;a:2:{s:4:\"name\";s:24:\"wp_obs_posts.post_parent\";s:4:\"type\";s:1:\"n\";}i:18;a:2:{s:4:\"name\";s:17:\"wp_obs_posts.guid\";s:4:\"type\";s:1:\"s\";}i:19;a:2:{s:4:\"name\";s:23:\"wp_obs_posts.menu_order\";s:4:\"type\";s:1:\"n\";}i:20;a:2:{s:4:\"name\";s:22:\"wp_obs_posts.post_type\";s:4:\"type\";s:1:\"s\";}i:21;a:2:{s:4:\"name\";s:27:\"wp_obs_posts.post_mime_type\";s:4:\"type\";s:1:\"s\";}i:22;a:2:{s:4:\"name\";s:26:\"wp_obs_posts.comment_count\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38451", "_transient_timeout_visualizer_db_wp_obs_snippets_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38452", "_transient_visualizer_db_wp_obs_snippets_columns", "a:11:{i:0;a:2:{s:4:\"name\";s:18:\"wp_obs_snippets.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:20:\"wp_obs_snippets.name\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:27:\"wp_obs_snippets.description\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:20:\"wp_obs_snippets.code\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:20:\"wp_obs_snippets.tags\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:21:\"wp_obs_snippets.scope\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:24:\"wp_obs_snippets.priority\";s:4:\"type\";s:1:\"n\";}i:7;a:2:{s:4:\"name\";s:22:\"wp_obs_snippets.active\";s:4:\"type\";s:1:\"n\";}i:8;a:2:{s:4:\"name\";s:24:\"wp_obs_snippets.modified\";s:4:\"type\";s:1:\"d\";}i:9;a:2:{s:4:\"name\";s:24:\"wp_obs_snippets.revision\";s:4:\"type\";s:1:\"n\";}i:10;a:2:{s:4:\"name\";s:24:\"wp_obs_snippets.cloud_id\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38453", "_transient_timeout_visualizer_db_wp_obs_term_relationships_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38454", "_transient_visualizer_db_wp_obs_term_relationships_columns", "a:3:{i:0;a:2:{s:4:\"name\";s:35:\"wp_obs_term_relationships.object_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:42:\"wp_obs_term_relationships.term_taxonomy_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:36:\"wp_obs_term_relationships.term_order\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38455", "_transient_timeout_visualizer_db_wp_obs_term_taxonomy_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38456", "_transient_visualizer_db_wp_obs_term_taxonomy_columns", "a:6:{i:0;a:2:{s:4:\"name\";s:37:\"wp_obs_term_taxonomy.term_taxonomy_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:28:\"wp_obs_term_taxonomy.term_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:29:\"wp_obs_term_taxonomy.taxonomy\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:32:\"wp_obs_term_taxonomy.description\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:27:\"wp_obs_term_taxonomy.parent\";s:4:\"type\";s:1:\"n\";}i:5;a:2:{s:4:\"name\";s:26:\"wp_obs_term_taxonomy.count\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38457", "_transient_timeout_visualizer_db_wp_obs_termmeta_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38458", "_transient_visualizer_db_wp_obs_termmeta_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:23:\"wp_obs_termmeta.meta_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:23:\"wp_obs_termmeta.term_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:24:\"wp_obs_termmeta.meta_key\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:26:\"wp_obs_termmeta.meta_value\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38459", "_transient_timeout_visualizer_db_wp_obs_terms_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38460", "_transient_visualizer_db_wp_obs_terms_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:20:\"wp_obs_terms.term_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:17:\"wp_obs_terms.name\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:17:\"wp_obs_terms.slug\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:23:\"wp_obs_terms.term_group\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38461", "_transient_timeout_visualizer_db_wp_obs_usermeta_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38462", "_transient_visualizer_db_wp_obs_usermeta_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:24:\"wp_obs_usermeta.umeta_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:23:\"wp_obs_usermeta.user_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:24:\"wp_obs_usermeta.meta_key\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:26:\"wp_obs_usermeta.meta_value\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38463", "_transient_timeout_visualizer_db_wp_obs_users_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38464", "_transient_visualizer_db_wp_obs_users_columns", "a:10:{i:0;a:2:{s:4:\"name\";s:15:\"wp_obs_users.ID\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:23:\"wp_obs_users.user_login\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:22:\"wp_obs_users.user_pass\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:26:\"wp_obs_users.user_nicename\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:23:\"wp_obs_users.user_email\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:21:\"wp_obs_users.user_url\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:28:\"wp_obs_users.user_registered\";s:4:\"type\";s:1:\"d\";}i:7;a:2:{s:4:\"name\";s:32:\"wp_obs_users.user_activation_key\";s:4:\"type\";s:1:\"s\";}i:8;a:2:{s:4:\"name\";s:24:\"wp_obs_users.user_status\";s:4:\"type\";s:1:\"n\";}i:9;a:2:{s:4:\"name\";s:25:\"wp_obs_users.display_name\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38465", "_transient_timeout_visualizer_db_wp_obs_yoast_indexable_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38466", "_transient_visualizer_db_wp_obs_yoast_indexable_columns", "a:53:{i:0;a:2:{s:4:\"name\";s:25:\"wp_obs_yoast_indexable.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:32:\"wp_obs_yoast_indexable.permalink\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:37:\"wp_obs_yoast_indexable.permalink_hash\";s:4:\"type\";s:1:\"s\";}i:3;a:2:{s:4:\"name\";s:32:\"wp_obs_yoast_indexable.object_id\";s:4:\"type\";s:1:\"n\";}i:4;a:2:{s:4:\"name\";s:34:\"wp_obs_yoast_indexable.object_type\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:38:\"wp_obs_yoast_indexable.object_sub_type\";s:4:\"type\";s:1:\"s\";}i:6;a:2:{s:4:\"name\";s:32:\"wp_obs_yoast_indexable.author_id\";s:4:\"type\";s:1:\"n\";}i:7;a:2:{s:4:\"name\";s:34:\"wp_obs_yoast_indexable.post_parent\";s:4:\"type\";s:1:\"n\";}i:8;a:2:{s:4:\"name\";s:28:\"wp_obs_yoast_indexable.title\";s:4:\"type\";s:1:\"s\";}i:9;a:2:{s:4:\"name\";s:34:\"wp_obs_yoast_indexable.description\";s:4:\"type\";s:1:\"s\";}i:10;a:2:{s:4:\"name\";s:39:\"wp_obs_yoast_indexable.breadcrumb_title\";s:4:\"type\";s:1:\"s\";}i:11;a:2:{s:4:\"name\";s:34:\"wp_obs_yoast_indexable.post_status\";s:4:\"type\";s:1:\"s\";}i:12;a:2:{s:4:\"name\";s:32:\"wp_obs_yoast_indexable.is_public\";s:4:\"type\";s:1:\"n\";}i:13;a:2:{s:4:\"name\";s:35:\"wp_obs_yoast_indexable.is_protected\";s:4:\"type\";s:1:\"n\";}i:14;a:2:{s:4:\"name\";s:39:\"wp_obs_yoast_indexable.has_public_posts\";s:4:\"type\";s:1:\"n\";}i:15;a:2:{s:4:\"name\";s:38:\"wp_obs_yoast_indexable.number_of_pages\";s:4:\"type\";s:1:\"n\";}i:16;a:2:{s:4:\"name\";s:32:\"wp_obs_yoast_indexable.canonical\";s:4:\"type\";s:1:\"s\";}i:17;a:2:{s:4:\"name\";s:44:\"wp_obs_yoast_indexable.primary_focus_keyword\";s:4:\"type\";s:1:\"s\";}i:18;a:2:{s:4:\"name\";s:50:\"wp_obs_yoast_indexable.primary_focus_keyword_score\";s:4:\"type\";s:1:\"n\";}i:19;a:2:{s:4:\"name\";s:40:\"wp_obs_yoast_indexable.readability_score\";s:4:\"type\";s:1:\"n\";}i:20;a:2:{s:4:\"name\";s:37:\"wp_obs_yoast_indexable.is_cornerstone\";s:4:\"type\";s:1:\"n\";}i:21;a:2:{s:4:\"name\";s:40:\"wp_obs_yoast_indexable.is_robots_noindex\";s:4:\"type\";s:1:\"n\";}i:22;a:2:{s:4:\"name\";s:41:\"wp_obs_yoast_indexable.is_robots_nofollow\";s:4:\"type\";s:1:\"n\";}i:23;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.is_robots_noarchive\";s:4:\"type\";s:1:\"n\";}i:24;a:2:{s:4:\"name\";s:45:\"wp_obs_yoast_indexable.is_robots_noimageindex\";s:4:\"type\";s:1:\"n\";}i:25;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.is_robots_nosnippet\";s:4:\"type\";s:1:\"n\";}i:26;a:2:{s:4:\"name\";s:36:\"wp_obs_yoast_indexable.twitter_title\";s:4:\"type\";s:1:\"s\";}i:27;a:2:{s:4:\"name\";s:36:\"wp_obs_yoast_indexable.twitter_image\";s:4:\"type\";s:1:\"s\";}i:28;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.twitter_description\";s:4:\"type\";s:1:\"s\";}i:29;a:2:{s:4:\"name\";s:39:\"wp_obs_yoast_indexable.twitter_image_id\";s:4:\"type\";s:1:\"s\";}i:30;a:2:{s:4:\"name\";s:43:\"wp_obs_yoast_indexable.twitter_image_source\";s:4:\"type\";s:1:\"s\";}i:31;a:2:{s:4:\"name\";s:39:\"wp_obs_yoast_indexable.open_graph_title\";s:4:\"type\";s:1:\"s\";}i:32;a:2:{s:4:\"name\";s:45:\"wp_obs_yoast_indexable.open_graph_description\";s:4:\"type\";s:1:\"s\";}i:33;a:2:{s:4:\"name\";s:39:\"wp_obs_yoast_indexable.open_graph_image\";s:4:\"type\";s:1:\"s\";}i:34;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.open_graph_image_id\";s:4:\"type\";s:1:\"s\";}i:35;a:2:{s:4:\"name\";s:46:\"wp_obs_yoast_indexable.open_graph_image_source\";s:4:\"type\";s:1:\"s\";}i:36;a:2:{s:4:\"name\";s:44:\"wp_obs_yoast_indexable.open_graph_image_meta\";s:4:\"type\";s:1:\"s\";}i:37;a:2:{s:4:\"name\";s:33:\"wp_obs_yoast_indexable.link_count\";s:4:\"type\";s:1:\"n\";}i:38;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.incoming_link_count\";s:4:\"type\";s:1:\"n\";}i:39;a:2:{s:4:\"name\";s:46:\"wp_obs_yoast_indexable.prominent_words_version\";s:4:\"type\";s:1:\"n\";}i:40;a:2:{s:4:\"name\";s:33:\"wp_obs_yoast_indexable.created_at\";s:4:\"type\";s:1:\"d\";}i:41;a:2:{s:4:\"name\";s:33:\"wp_obs_yoast_indexable.updated_at\";s:4:\"type\";s:1:\"d\";}i:42;a:2:{s:4:\"name\";s:30:\"wp_obs_yoast_indexable.blog_id\";s:4:\"type\";s:1:\"n\";}i:43;a:2:{s:4:\"name\";s:31:\"wp_obs_yoast_indexable.language\";s:4:\"type\";s:1:\"s\";}i:44;a:2:{s:4:\"name\";s:29:\"wp_obs_yoast_indexable.region\";s:4:\"type\";s:1:\"s\";}i:45;a:2:{s:4:\"name\";s:39:\"wp_obs_yoast_indexable.schema_page_type\";s:4:\"type\";s:1:\"s\";}i:46;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.schema_article_type\";s:4:\"type\";s:1:\"s\";}i:47;a:2:{s:4:\"name\";s:36:\"wp_obs_yoast_indexable.has_ancestors\";s:4:\"type\";s:1:\"n\";}i:48;a:2:{s:4:\"name\";s:53:\"wp_obs_yoast_indexable.estimated_reading_time_minutes\";s:4:\"type\";s:1:\"n\";}i:49;a:2:{s:4:\"name\";s:30:\"wp_obs_yoast_indexable.version\";s:4:\"type\";s:1:\"n\";}i:50;a:2:{s:4:\"name\";s:43:\"wp_obs_yoast_indexable.object_last_modified\";s:4:\"type\";s:1:\"d\";}i:51;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_indexable.object_published_at\";s:4:\"type\";s:1:\"d\";}i:52;a:2:{s:4:\"name\";s:47:\"wp_obs_yoast_indexable.inclusive_language_score\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38467", "_transient_timeout_visualizer_db_wp_obs_yoast_indexable_hierarchy_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38468", "_transient_visualizer_db_wp_obs_yoast_indexable_hierarchy_columns", "a:4:{i:0;a:2:{s:4:\"name\";s:45:\"wp_obs_yoast_indexable_hierarchy.indexable_id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:44:\"wp_obs_yoast_indexable_hierarchy.ancestor_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:38:\"wp_obs_yoast_indexable_hierarchy.depth\";s:4:\"type\";s:1:\"n\";}i:3;a:2:{s:4:\"name\";s:40:\"wp_obs_yoast_indexable_hierarchy.blog_id\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38469", "_transient_timeout_visualizer_db_wp_obs_yoast_migrations_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38470", "_transient_visualizer_db_wp_obs_yoast_migrations_columns", "a:2:{i:0;a:2:{s:4:\"name\";s:26:\"wp_obs_yoast_migrations.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:31:\"wp_obs_yoast_migrations.version\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38471", "_transient_timeout_visualizer_db_wp_obs_yoast_primary_term_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38472", "_transient_visualizer_db_wp_obs_yoast_primary_term_columns", "a:7:{i:0;a:2:{s:4:\"name\";s:28:\"wp_obs_yoast_primary_term.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:33:\"wp_obs_yoast_primary_term.post_id\";s:4:\"type\";s:1:\"n\";}i:2;a:2:{s:4:\"name\";s:33:\"wp_obs_yoast_primary_term.term_id\";s:4:\"type\";s:1:\"n\";}i:3;a:2:{s:4:\"name\";s:34:\"wp_obs_yoast_primary_term.taxonomy\";s:4:\"type\";s:1:\"s\";}i:4;a:2:{s:4:\"name\";s:36:\"wp_obs_yoast_primary_term.created_at\";s:4:\"type\";s:1:\"d\";}i:5;a:2:{s:4:\"name\";s:36:\"wp_obs_yoast_primary_term.updated_at\";s:4:\"type\";s:1:\"d\";}i:6;a:2:{s:4:\"name\";s:33:\"wp_obs_yoast_primary_term.blog_id\";s:4:\"type\";s:1:\"n\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38473", "_transient_timeout_visualizer_db_wp_obs_yoast_seo_links_columns", "1742670144", "off");
INSERT INTO `wp_obs_options` VALUES("38474", "_transient_visualizer_db_wp_obs_yoast_seo_links_columns", "a:12:{i:0;a:2:{s:4:\"name\";s:25:\"wp_obs_yoast_seo_links.id\";s:4:\"type\";s:1:\"n\";}i:1;a:2:{s:4:\"name\";s:26:\"wp_obs_yoast_seo_links.url\";s:4:\"type\";s:1:\"s\";}i:2;a:2:{s:4:\"name\";s:30:\"wp_obs_yoast_seo_links.post_id\";s:4:\"type\";s:1:\"n\";}i:3;a:2:{s:4:\"name\";s:37:\"wp_obs_yoast_seo_links.target_post_id\";s:4:\"type\";s:1:\"n\";}i:4;a:2:{s:4:\"name\";s:27:\"wp_obs_yoast_seo_links.type\";s:4:\"type\";s:1:\"s\";}i:5;a:2:{s:4:\"name\";s:35:\"wp_obs_yoast_seo_links.indexable_id\";s:4:\"type\";s:1:\"n\";}i:6;a:2:{s:4:\"name\";s:42:\"wp_obs_yoast_seo_links.target_indexable_id\";s:4:\"type\";s:1:\"n\";}i:7;a:2:{s:4:\"name\";s:29:\"wp_obs_yoast_seo_links.height\";s:4:\"type\";s:1:\"n\";}i:8;a:2:{s:4:\"name\";s:28:\"wp_obs_yoast_seo_links.width\";s:4:\"type\";s:1:\"n\";}i:9;a:2:{s:4:\"name\";s:27:\"wp_obs_yoast_seo_links.size\";s:4:\"type\";s:1:\"n\";}i:10;a:2:{s:4:\"name\";s:31:\"wp_obs_yoast_seo_links.language\";s:4:\"type\";s:1:\"s\";}i:11;a:2:{s:4:\"name\";s:29:\"wp_obs_yoast_seo_links.region\";s:4:\"type\";s:1:\"s\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("38889", "_transient_timeout_wpseo_unindexed_post_link_count", "1742670270", "off");
INSERT INTO `wp_obs_options` VALUES("38890", "_transient_wpseo_unindexed_post_link_count", "1", "off");
INSERT INTO `wp_obs_options` VALUES("39232", "_transient_visualizer_all_languages", "a:1:{s:12:\"translations\";a:5:{i:0;a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:6:\"3.10.6\";s:7:\"updated\";s:19:\"2018-04-28 20:02:06\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/visualizer/3.10.6/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:1;a:7:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:6:\"3.10.6\";s:7:\"updated\";s:19:\"2019-11-01 08:25:02\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/visualizer/3.10.6/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}}i:2;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"3.10.6\";s:7:\"updated\";s:19:\"2019-11-01 08:24:02\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/visualizer/3.10.6/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}}i:3;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:6:\"3.10.6\";s:7:\"updated\";s:19:\"2021-12-18 14:49:45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/visualizer/3.10.6/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}}i:4;a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:6:\"3.10.6\";s:7:\"updated\";s:19:\"2021-07-16 02:44:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/visualizer/3.10.6/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}}}}", "off");
INSERT INTO `wp_obs_options` VALUES("39234", "_transient_timeout_visualizer_all_languages", "1743200838", "off");
INSERT INTO `wp_obs_options` VALUES("39243", "_transient_timeout_neve_all_languages", "1743200838", "off");
INSERT INTO `wp_obs_options` VALUES("39246", "_transient_neve_all_languages", "a:1:{s:12:\"translations\";a:51:{i:0;a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-11-15 10:09:50\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}}i:1;a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-02-26 11:24:11\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}}i:2;a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2024-01-08 07:14:04\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}}i:3;a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-05-10 10:54:24\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}}i:4;a:7:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-10-26 15:36:26\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}}i:5;a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-03-31 10:58:39\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}}i:6;a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-02-22 15:28:09\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:7;a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-01-17 16:40:02\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:8;a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-03-01 16:19:31\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:9;a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-03-01 16:20:02\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:10;a:7:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-03-01 16:19:05\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:11;a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2021-10-04 06:12:46\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}}i:12;a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-01-30 09:54:21\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:13;a:7:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2021-08-06 00:44:02\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:14;a:7:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-02-06 23:41:00\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:15;a:7:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2021-08-06 19:29:29\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:16;a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-12-17 20:01:13\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:17;a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-04-03 15:53:18\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:18;a:7:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-02-08 06:56:09\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:19;a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:44:13\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:20;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-09-25 13:14:52\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:21;a:7:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-07-03 02:27:14\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:22;a:7:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-07-03 02:28:18\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:23;a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2024-01-14 00:33:49\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}}i:24;a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2021-09-23 08:22:02\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}}i:25;a:7:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:47:33\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}}i:26;a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2021-10-01 12:45:24\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}}i:27;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-03-27 05:30:42\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}}i:28;a:7:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-09-29 10:40:03\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}}i:29;a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:49:51\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}}i:30;a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:55:31\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}}i:31;a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-10-21 15:11:06\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}}i:32;a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:50:19\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}}i:33;a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-06-08 00:49:07\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}}i:34;a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-09-30 13:43:04\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}}i:35;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2024-01-11 23:30:17\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:36;a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-12-21 11:46:39\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:37;a:7:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-07-02 21:32:44\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:38;a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:44:44\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}}i:39;a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:52:22\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}}i:40;a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:51:08\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}}i:41;a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-12-19 23:21:55\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}}i:42;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-08-20 06:03:13\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}}i:43;a:7:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2021-03-24 06:57:16\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}}i:44;a:7:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-02-27 15:47:53\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}}i:45;a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-12-20 15:06:42\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}}i:46;a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2023-09-27 12:54:46\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}}i:47;a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:54:48\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}}i:48;a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-11-03 10:54:25\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}}i:49;a:7:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2020-03-04 23:38:45\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}}i:50;a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"3.8.0\";s:7:\"updated\";s:19:\"2022-09-29 16:15:29\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/3.8.0/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}}}}", "off");
INSERT INTO `wp_obs_options` VALUES("39285", "_transient_timeout_tsk_attachment_count", "1742716833", "off");
INSERT INTO `wp_obs_options` VALUES("39286", "_transient_tsk_attachment_count", "23", "off");
INSERT INTO `wp_obs_options` VALUES("39287", "_transient_timeout_tsk_posts_count", "1742716833", "off");
INSERT INTO `wp_obs_options` VALUES("39288", "_transient_tsk_posts_count", "a:2:{s:11:\"total_posts\";i:1;s:9:\"old_posts\";i:1;}", "off");
INSERT INTO `wp_obs_options` VALUES("39302", "_site_transient_timeout_wp_theme_files_patterns-6e1a51d2345ba45048c7005d070264b3", "1742637892", "off");
INSERT INTO `wp_obs_options` VALUES("39303", "_site_transient_wp_theme_files_patterns-6e1a51d2345ba45048c7005d070264b3", "a:2:{s:7:\"version\";s:5:\"3.8.1\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_obs_options` VALUES("39304", "wpmdb_settings", "a:14:{s:3:\"key\";s:40:\"0Sdz/Re0Xc5LzEOY1Be4Lrq0Me93Xv8ZjcGtE88W\";s:10:\"allow_pull\";b:0;s:10:\"allow_push\";b:0;s:8:\"profiles\";a:0:{}s:7:\"licence\";s:0:\"\";s:10:\"verify_ssl\";b:0;s:17:\"whitelist_plugins\";a:0:{}s:11:\"max_request\";i:1048576;s:22:\"delay_between_requests\";i:0;s:18:\"prog_tables_hidden\";b:1;s:21:\"pause_before_finalize\";b:0;s:14:\"allow_tracking\";N;s:26:\"high_performance_transfers\";b:0;s:18:\"compatibility_mode\";b:1;}", "off");
INSERT INTO `wp_obs_options` VALUES("39308", "_site_transient_timeout_wp_theme_files_patterns-24dbc437cc94919b4bfd342382e5d717", "1742642023", "off");
INSERT INTO `wp_obs_options` VALUES("39309", "_site_transient_wp_theme_files_patterns-24dbc437cc94919b4bfd342382e5d717", "a:2:{s:7:\"version\";b:0;s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_obs_options` VALUES("39311", "active_plugins", "a:17:{i:0;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1;s:31:\"code-snippets/code-snippets.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:51:\"display-posts-shortcode/display-posts-shortcode.php\";i:4;s:33:\"duplicate-post/duplicate-post.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:27:\"easy-charts/easy-charts.php\";i:7;s:22:\"font-awesome/index.php\";i:8;s:27:\"leaflet-map/leaflet-map.php\";i:9;s:28:\"migrate-guru/migrateguru.php\";i:10;s:13:\"pods/init.php\";i:11;s:27:\"svg-support/svg-support.php\";i:12;s:20:\"visualizer/index.php\";i:13;s:24:\"wordpress-seo/wp-seo.php\";i:14;s:29:\"wp-debugging/wp-debugging.php\";i:15;s:31:\"wp-migrate-db/wp-migrate-db.php\";i:16;s:35:\"wp-smart-preloader/wp-preloader.php\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("39312", "ai1wm_secret_key", "e7F1HalEdFQx", "auto");
INSERT INTO `wp_obs_options` VALUES("39313", "ai1wm_status", "a:3:{s:4:\"type\";s:4:\"done\";s:5:\"title\";s:41:\"Your data has been imported successfully!\";s:7:\"message\";s:520:\"You need to perform two more steps:<br /><strong>1. You must save your permalinks structure twice. <a class=\"ai1wm-no-underline\" href=\"http://localhost:10004/wp-admin/options-permalink.php#submit\" target=\"_blank\">Permalinks Settings</a></strong> <small>(opens a new window)</small><br /><strong>2. <a class=\"ai1wm-no-underline\" href=\"https://wordpress.org/support/view/plugin-reviews/all-in-one-wp-migration?rate=5#postform\" target=\"_blank\">Optionally, review the plugin</a>.</strong> <small>(opens a new window)</small>\";}", "auto");
INSERT INTO `wp_obs_options` VALUES("39316", "template", "neve", "auto");
INSERT INTO `wp_obs_options` VALUES("39317", "stylesheet", "neve", "auto");
INSERT INTO `wp_obs_options` VALUES("39325", "_site_transient_timeout_php_check_a34f4a08303dd29cee70e79d780daa9d", "1743245961", "off");
INSERT INTO `wp_obs_options` VALUES("39326", "_site_transient_php_check_a34f4a08303dd29cee70e79d780daa9d", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_obs_options` VALUES("39329", "_site_transient_timeout_community-events-1aecf33ab8525ff212ebdffbb438372e", "1742684365", "off");
INSERT INTO `wp_obs_options` VALUES("39330", "_site_transient_community-events-1aecf33ab8525ff212ebdffbb438372e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:9:\"127.0.0.0\";}s:6:\"events\";a:3:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:76:\"27 maart 2025: Slaagt Jouw Website voor het Europese Toegankelijkheidsexamen\";s:3:\"url\";s:64:\"https://www.meetup.com/antwerp-wordpress-meetup/events/305897791\";s:6:\"meetup\";s:24:\"WordPress Meetup Antwerp\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/Antwerp-WordPress-Meetup/\";s:4:\"date\";s:19:\"2025-03-27 18:00:00\";s:8:\"end_date\";s:19:\"2025-03-27 22:00:00\";s:20:\"start_unix_timestamp\";i:1743094800;s:18:\"end_unix_timestamp\";i:1743109200;s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Mechelen, Belgium\";s:7:\"country\";s:2:\"be\";s:8:\"latitude\";d:51.033410000000003;s:9:\"longitude\";d:4.4797029999999998;}}i:1;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:39:\"Meetup #8 in Kortrijk - nieuwe locatie!\";s:3:\"url\";s:65:\"https://www.meetup.com/kortrijk-wordpress-meetup/events/306309493\";s:6:\"meetup\";s:25:\"Kortrijk WordPress Meetup\";s:10:\"meetup_url\";s:49:\"https://www.meetup.com/kortrijk-wordpress-meetup/\";s:4:\"date\";s:19:\"2025-04-03 19:00:00\";s:8:\"end_date\";s:19:\"2025-04-03 22:00:00\";s:20:\"start_unix_timestamp\";i:1743699600;s:18:\"end_unix_timestamp\";i:1743710400;s:8:\"location\";a:4:{s:8:\"location\";s:16:\"Kortrijk, Belize\";s:7:\"country\";s:2:\"bz\";s:8:\"latitude\";d:50.829650000000001;s:9:\"longitude\";d:3.255039;}}i:2;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:15:\"WordCamp Europe\";s:3:\"url\";s:33:\"https://europe.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-06-05 00:00:00\";s:8:\"end_date\";s:19:\"2025-06-07 00:00:00\";s:20:\"start_unix_timestamp\";i:1749074400;s:18:\"end_unix_timestamp\";i:1749247200;s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Basel, Switzerland\";s:7:\"country\";s:2:\"CH\";s:8:\"latitude\";d:47.5627438;s:9:\"longitude\";d:7.5993871999999998;}}}}", "off");
INSERT INTO `wp_obs_options` VALUES("39331", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1742684367", "off");
INSERT INTO `wp_obs_options` VALUES("39332", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 16:47:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59827\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28124:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"uMdKNlBoCL\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=qmaY5pXzTl#?secret=uMdKNlBoCL\" data-secret=\"uMdKNlBoCL\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WgyaZOCHrA\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=vZmeFCPHik#?secret=WgyaZOCHrA\" data-secret=\"WgyaZOCHrA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eMYoPzBbo4\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=GWcYXO1duD#?secret=eMYoPzBbo4\" data-secret=\"eMYoPzBbo4\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NPZA5TJPdn\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=7xhnb18OOq#?secret=NPZA5TJPdn\" data-secret=\"NPZA5TJPdn\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KJzsYABs6e\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=bU509N5zTq#?secret=KJzsYABs6e\" data-secret=\"KJzsYABs6e\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cgYDsB9BeF\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ahd0C4rIgD#?secret=cgYDsB9BeF\" data-secret=\"cgYDsB9BeF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7mDUijDFk2\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=AVDYRuiEbq#?secret=7mDUijDFk2\" data-secret=\"7mDUijDFk2\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"mwSy0wULCz\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=3hQMOVXqfJ#?secret=mwSy0wULCz\" data-secret=\"mwSy0wULCz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5G0bvIkW0h\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=1xRq1veJ2v#?secret=5G0bvIkW0h\" data-secret=\"5G0bvIkW0h\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NYzaXUkHI3\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=iEwkK7OKSw#?secret=NYzaXUkHI3\" data-secret=\"NYzaXUkHI3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DP8l0CiCdI\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=MCSsLcKVNl#?secret=DP8l0CiCdI\" data-secret=\"DP8l0CiCdI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"LiMcRNquOr\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=2au4COS7ru#?secret=LiMcRNquOr\" data-secret=\"LiMcRNquOr\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"741P7G7pRI\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=jrG82zsmtK#?secret=741P7G7pRI\" data-secret=\"741P7G7pRI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jPhUPBY0Od\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=yPPthJgGpb#?secret=jPhUPBY0Od\" data-secret=\"jPhUPBY0Od\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"IH9C1mVH4S\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=EpH55CK7AE#?secret=IH9C1mVH4S\" data-secret=\"IH9C1mVH4S\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.6 « Dorsey »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:40:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3181\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:68929:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/dorsey.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"680\" src=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png\" alt=\"\" class=\"wp-image-3199\" srcset=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang=\"en\" dir=\"ltr\">leader</bdo> de <bdo lang=\"en\" dir=\"ltr\">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang=\"en\" dir=\"ltr\">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/color-palettes.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Aperçu rapide des pages</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-2 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/page-previews.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-3 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/feature-rollbacks.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Surcharges</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-4 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/overrides.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href=\"https://fr.wordpress.org/download/releases/6-6/\">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-6/\">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.6</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;</li>\n\n\n\n<li>Responsables de la documentation&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction artistique : <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Responsable des performances&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n\n\n\n<li>Responsables des tests&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.6 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>630 personnes provenant d’au moins 50 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 150 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.6 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p style=\"font-size:10px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h1 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress 6.6 en français</h1>\n\n\n\n<p>WordPress est un projet international et la version 6.6 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.6 en français :</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">laeti972</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/nlangle\">Nicolas Langle</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/valer1e\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>, et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Comment contribuer aux « release parties » des nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2024/07/15/comment-contribuer-aux-release-parties-des-nouvelles-versions-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jul 2024 13:28:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3159\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et release candidate de WP en participant aux « release parties », qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&#8217;une version finale, et à sa [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7155:\"\n<p>Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WP en participant aux <em><bdo lang=\"en\" dir=\"ltr\">« release parties »</bdo></em>, qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&rsquo;une version finale, et à sa livraison au public.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Prérequis</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aucun niveau technique particulier n’est nécessaire à part savoir utiliser WordPress</li>\n\n\n\n<li>Avoir un site de test installé en local ou en ligne</li>\n\n\n\n<li>Installer l’extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester</a></bdo></em> et la paramétrer (dans <code>Outils &gt; Test Bêta</code>) de la façon suivante (ici nous sommes sur une installation en anglais, si vous êtes sur une installation en français, faites la correspondance des options)&nbsp;:</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"427\" src=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png\" alt=\"\" class=\"wp-image-3160\" srcset=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png 1024w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-300x125.png 300w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-768x320.png 768w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1536x641.png 1536w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-2048x854.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge</bdo></em> : version en cours de développement. Cette version utilise le code en cours de développement (<em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge nightlies</bdo></em>) qui peut parfois être instable. <em>Ne l’utilisez en production que si vous savez vraiment ce que vous faites</em>.</p>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bêta/RC only </bdo></em>: ceci concerne uniquement les versions bêta/RC du canal sélectionné.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Déroulement de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em></h2>\n\n\n\n<p>Les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> se déroulent entièrement sur le Slack <a href=\"http://Make.WordPress.org\">Make.WordPress.org</a>, sur le canal #core. Pour le rejoindre utilisez votre nom de compte WordPress.org, ici : <a href=\"https://make.wordpress.org/chat/\">https://make.wordpress.org/chat/</a>.</p>\n\n\n\n<p>Généralement, il y en a pour 30-40 minutes si c’est une version beta/RC.</p>\n\n\n\n<p>Normalement les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> commencent à peu près à l’heure, souvent en fin d’après midi. Voici le déroulement :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Message d’accueil de la personne qui dirige la <bdo lang=\"en\" dir=\"ltr\"><em>release party</em></bdo>, tout le monde fait coucou et ça permet de consigner le nombre de contributrices et contributeurs qui participent à la <em><bdo lang=\"en\" dir=\"ltr\">release</bdo></em></li>\n\n\n\n<li>Quelques<bdo lang=\"en\" dir=\"ltr\"> vérificatio</bdo>ns techniques entre le ou la <em><bdo lang=\"en\" dir=\"ltr\">lead</bdo></em>, la personne faisant office de <em><bdo lang=\"en\" dir=\"ltr\">committer</bdo></em> (qui va créer la version de WordPress concernée) et le contrôle de mission (<em><bdo lang=\"en\" dir=\"ltr\">mission control</bdo></em>, qui est chargé de construire le paquet ZIP de la version), ça peut prendre 10-15 minutes mais c’est souvent moins.</li>\n\n\n\n<li>Les checks de sécurité et les tests unitaires sont lancés par la personne chargée des <em><bdo lang=\"en\" dir=\"ltr\">commits</bdo></em> et le contrôle de mission</li>\n\n\n\n<li>Le ou la <em><bdo lang=\"en\" dir=\"ltr\">core committer</bdo></em> fait un premier <bdo lang=\"en\" dir=\"ltr\"><em>commit</em></bdo> de version</li>\n\n\n\n<li>Le contrôle de mission livre un premier ZIP de la version</li>\n\n\n\n<li>C’EST LÀ QUE VOUS INTERVENEZ ! Vous pouvez&nbsp;:\n<ul class=\"wp-block-list\">\n<li>(plus long) Récupérer le ZIP et l’installer en local</li>\n\n\n\n<li>(plus rapide mais plus technique) Installer la version via <em>WP-CLI</em></li>\n\n\n\n<li>(recommandé) Via Beta Tester :\n<ul class=\"wp-block-list\">\n<li>Aller sur une installation avec l’extension WP Beta Tester installée, paramétrée comme expliqué ci-dessus</li>\n\n\n\n<li>Normalement, au bout de quelques secondes après que le ZIP soit disponible, vous devriez voir un petit message sur l’écran d’accueil de l’admin indiquant qu’une nouvelle version est disponible pour test</li>\n\n\n\n<li>Pensez à noter le numéro de version de WP que vous aviez avant de mettre à jour !</li>\n\n\n\n<li>Cliquez sur le lien de mise à jour et installez la version</li>\n</ul>\n</li>\n</ul>\n</li>\n\n\n\n<li>Les choses que vous pouvez tester :\n<ul class=\"wp-block-list\">\n<li>Fonctionnement de quelques écrans de l’admin</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur : insertion d’un bloc, enregistrement d’un article</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur de site (navigation dans quelques écrans)</li>\n\n\n\n<li>Bon fonctionnement de quelques écrans du front</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation d&rsquo;un thème classique</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation de l&rsquo;extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/classic-editor/\">Classic Editor</a></bdo></em></li>\n\n\n\n<li>Si vous disposez d&rsquo;une instance multisite, mentionnez-le</li>\n\n\n\n<li>Si vous avez les moyens de tester la mise à jour depuis une vieille version de WP (version 4.9 ou au dessus), c&rsquo;est très utile aussi. Mentionnez la version depuis laquelle vous avez fait la mise à jour</li>\n</ul>\n</li>\n\n\n\n<li>Une fois que vous avez testé, mettez un petit message dans le canal #core, en indiquant la version que vous aviez avant la <abbr title=\"Mise à jour\">MAJ</abbr> et la version vers laquelle vous avez mis à jour. Par exemple :</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\"><img loading=\"lazy\" decoding=\"async\" width=\"706\" height=\"806\" src=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\" alt=\"\" class=\"wp-image-3161\" style=\"width:400px\" srcset=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png 706w, https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10-263x300.png 263w\" sizes=\"auto, (max-width: 706px) 100vw, 706px\" /></a></figure>\n\n\n\n<p>Vous pourrez ensuite suivre le reste de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em> tranquillement.</p>\n\n\n\n<p>Et vous serez aussi crédité·es pour votre participation à cette version. Bravo&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Jun 2024 08:36:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3125\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress 6.6, dont la sortie est prévue le 16 juillet 2024.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33232:\"\n<figure class=\"wp-block-image alignfull size-large\"><a href=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"548\" src=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png\" alt=\"\" class=\"wp-image-3134\" srcset=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png 1024w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-300x160.png 300w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-768x411.png 768w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1536x821.png 1536w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-2048x1095.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p class=\"is-style-serif has-blueberry-4-background-color has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.6, dont la sortie est prévue le 16 juillet 2024.</p>\n\n\n\n<p>WordPress 6.6 comprend au minimum la résolution de <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;order=type\" target=\"_blank\" rel=\"noreferrer noopener\">299 tickets Trac</a>, dont <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">108 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">171 résolutions de bogues</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">10 autres tâches de maintenance</a>. Pour cette version, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">16 tickets étaient centrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">24 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">15 tickets portaient sur la modernisation du code source de notre CMS</a>. Les modifications de WP&nbsp;6.6 concernent <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du code source de WordPress</a>.</p>\n\n\n\n<p>Cette version comprend aussi 392 améliorations, 462 corrections de bogues et 46 améliorations de l&rsquo;accessibilité de <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.6\">l&rsquo;éditeur de blocs</a> (Gutenberg).</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.6, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.6 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/02/28/whats-new-in-gutenberg-17-8-28-february/\">17.8</a>, <a href=\"https://make.wordpress.org/core/2024/03/13/whats-new-in-gutenberg-17-9-13-march/\">17.9</a>, <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">18.0</a>, <a href=\"https://make.wordpress.org/core/2024/04/10/whats-new-in-gutenberg-18-1-10-april/\">18.1</a>, <a href=\"https://make.wordpress.org/core/2024/04/24/whats-new-in-gutenberg-18-2-24-april/\">18.2</a>, <a href=\"https://make.wordpress.org/core/2024/05/08/whats-new-in-gutenberg-18-3-8-may/\">18.3</a>, <a href=\"https://make.wordpress.org/core/2024/05/23/whats-new-in-gutenberg-18-4-22-may/\">18.4</a> et <a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\">18.5</a>. L&rsquo;éditeur de blocs reçoit ainsi de nombreuses améliorations liées à la bibliothèque React, à l’API <code>Block</code>, à la gestion des thèmes, et bien plus encore.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">React</h3>\n\n\n\n<p>Une nouvelle version de React et la nouvelle <a href=\"https://legacy.reactjs.org/blog/2020/09/22/introducing-the-new-jsx-transform.html\">API JSX transform</a> font leur entrée dans WordPress&nbsp;6.6.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dWLxJUI3h0\"><a href=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/\">JSX in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;JSX in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/embed/#?secret=XMglYBeDLC#?secret=dWLxJUI3h0\" data-secret=\"dWLxJUI3h0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"52Rfu8yAtE\"><a href=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/\">Preparation for React 19 Upgrade</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparation for React 19 Upgrade&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/embed/#?secret=YV2Zkzjfyy#?secret=52Rfu8yAtE\" data-secret=\"52Rfu8yAtE\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-api\">API <code>Block</code></h3>\n\n\n\n<p>Des changements arrivent sur l&rsquo;API <code>Block</code>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Unification des API d&rsquo;extensibilité entre les éditeurs de publications et du site</li>\n\n\n\n<li>Amélioration de la propriété <code>isActive</code> sur les variations de blocs</li>\n\n\n\n<li>Améliorations de plusieurs blocs proposés par le cœur de WordPress</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"FC595uD9El\"><a href=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/\">Editor: Unified Extensibility APIs in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Editor: Unified Extensibility APIs in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/embed/#?secret=d9wcTgYeLu#?secret=FC595uD9El\" data-secret=\"FC595uD9El\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vsiCQ8RUpF\"><a href=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/\">Improvements to active block variation detection</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Improvements to active block variation detection&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/embed/#?secret=BlfgJ2v86t#?secret=vsiCQ8RUpF\" data-secret=\"vsiCQ8RUpF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fcUHSrfEG8\"><a href=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/\">Social Links block changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Social Links block changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/embed/#?secret=KTnVlZwICZ#?secret=fcUHSrfEG8\" data-secret=\"fcUHSrfEG8\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes-6-6\">Thèmes</h3>\n\n\n\n<p>WordPress 6.6 introduit plusieurs mises à jour liées aux thèmes, comprenant&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Une nouvelle version 3 du <code>theme.json</code></li>\n\n\n\n<li>L&rsquo;uniformisation de la spécificité CSS appliquée aux styles du cœur de WP</li>\n\n\n\n<li>Introduction de la section «&nbsp;styles&nbsp;» pour améliorer l&rsquo;efficacité de la personnalisation des blocs et de leurs éléments internes</li>\n\n\n\n<li>Fonctionnalités additionnelles de la mise en page en grille dans les blocs</li>\n\n\n\n<li>Capacité de définir des images d&rsquo;arrière-plan pour l&rsquo;ensemble du site via le <code>theme.json</code> et via l’éditeur de site</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3qkQI6VB3V\"><a href=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/\">Theme.json version 3</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Theme.json version 3&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/embed/#?secret=qFVVO9yctD#?secret=3qkQI6VB3V\" data-secret=\"3qkQI6VB3V\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WwNatJ4yuP\"><a href=\"https://make.wordpress.org/core/2024/06/24/section-styles/\">Section Styles</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Section Styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/section-styles/embed/#?secret=myss8Gv9Su#?secret=WwNatJ4yuP\" data-secret=\"WwNatJ4yuP\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5tYWFN7C0m\"><a href=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/\">WordPress 6.6 CSS Specificity</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.6 CSS Specificity&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/embed/#?secret=0Ak975GLQd#?secret=5tYWFN7C0m\" data-secret=\"5tYWFN7C0m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g0n7RPlGmY\"><a href=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/\">Grid layout type</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Grid layout type&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/embed/#?secret=c59OLorfmE#?secret=g0n7RPlGmY\" data-secret=\"g0n7RPlGmY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZPfvPc14dl\"><a href=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/\">Site-wide background images in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Site-wide background images in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/embed/#?secret=GtFb16IOEz#?secret=ZPfvPc14dl\" data-secret=\"ZPfvPc14dl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Modifications diverses concernant l’éditeur</h3>\n\n\n\n<p>Plusieurs autres modifications de l’éditeur de bloc sont aussi incluses dans WordPress 6.6 :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-wp-block-list-class-to-the-list-block\">Ajout de la classe <code>wp-block-list</code>&nbsp;au bloc Liste</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#New-Interactivity-API-directives\">Nouvelles directives pour l&rsquo;API <code>Interactivity</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Allow-view-access-of-the-template-REST-API-endpoint-to-anyone-with-the-edit_post-capability\">Ajout de l’accès en lecture au point de terminaison <code>template</code> de l’API REST à toute personne disposant de la permission <code>edit_post</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Unified-split-logic-for-writing-flow\">Unification de la logique de séparation dans le flux de rédaction</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#BlockPopover-Component-is-now-public\">Le composant BlockPopover est maintenant public</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-filter-to-modify-the-list-of-post-content-block-types\">Ajout d&rsquo;un filtre pour modifier la liste des types de blocs de contenu</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Global-Styles-Filter-out-color-and-typography-variations\">Styles globaux&nbsp;: ajout de filtres pour les variations de couleur et de typographie</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-custom-Aspect-Ratio-presets-through-theme-json\">Ajout de pré-réglages de proportions gérables via le fichier&nbsp;<code>theme.json</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#root-padding-style-updates\">Mise à jour des styles de marge interne racine via <code>:root</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-Text-alignment-block-support\">Ajout de la prise en charge de l&rsquo;alignement de texte des blocs</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zwjsgiLBc3\"><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/\">Miscellaneous Editor changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/embed/#?secret=ixOVYPSn2d#?secret=zwjsgiLBc3\" data-secret=\"zwjsgiLBc3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Un tableau des outils de conception supportés par chaque bloc sur WordPress&nbsp;6.6 a été publié en guise de référence.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dIjJDZTSGY\"><a href=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/\">Roster of design tools per block (WordPress 6.6 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.6 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/embed/#?secret=xV9lWVls3h#?secret=dIjJDZTSGY\" data-secret=\"dIjJDZTSGY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.6 comprend une version de maintenance de l&rsquo;API HTML. Cela inclut quelques nouvelles fonctionnalités et une amélioration majeure de l&rsquo;utilisabilité du processeur HTML. Cela poursuit les travaux d&rsquo;amélioration continue engagés depuis WP 6.5.</p>\n\n\n\n<p>Une nouvelle structure de données vient aussi avec la version 6.6&nbsp;: il s&rsquo;agit de l&rsquo;API&nbsp;<code>WP_Token_Map</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wuD7UIc043\"><a href=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/\">Updates to the HTML API in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/embed/#?secret=jA5d2tI5LY#?secret=wuD7UIc043\" data-secret=\"wuD7UIc043\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cLzvpODa71\"><a href=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/\">Introducing the Token Map</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the Token Map&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/embed/#?secret=96WcqwTl9C#?secret=cLzvpODa71\" data-secret=\"cLzvpODa71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"options-api\">API <code>Options</code></h2>\n\n\n\n<p>Plusieurs modifications ont été faites sur l&rsquo;API <code>Options</code> pour prendre en charge une optimisation du comportement de chargement automatique et pour créer une façon d’appliquer les prochaines optimisations à venir.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"sY4OPd8z50\"><a href=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/\">Options API: Disabling autoload for large options</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Options API: Disabling autoload for large options&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/embed/#?secret=Fd1Vmk80wn#?secret=sY4OPd8z50\" data-secret=\"sY4OPd8z50\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.5&amp;&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Plusieurs améliorations de l&rsquo;internationalisation</a> ont été intégrées dans WP&nbsp;6.6&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Enhanced-support-for-only-using-PHP-translation-files\">Amélioration de la prise en charge des fichiers de traduction PHP</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#New-lang_dir_for_domain-filter\">Nouveau filtre&nbsp;<code>lang_dir_for_domain</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Additional-context-for-the-load_translation_file-filter\">Ajout d&rsquo;un contexte pour le filtre <code>load_translation_file</code></a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MSrk50CwxF\"><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/\">Internationalization improvements in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/embed/#?secret=3bBLcbcQOl#?secret=MSrk50CwxF\" data-secret=\"MSrk50CwxF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#allowed-disabling-autosave-support-for-individual-post-types\">Désactivation de la sauvegarde automatique indépendamment pour chaque type de publication</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#default-length-of-time-for-comment-author-cookies-has-changed\">Modification de la durée native de conservation des cookies de commentaires</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#site-editor-patterns-on-classic-themes\">Prise en charge des compositions de l’éditeur de site dans les thèmes classiques</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#fluid-typography\">Prise en charge des polices fluides</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#jquery-ui-library-update\">Mise à jour de la bibliothèque jQuery UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#new-array-arguments-for-wp-login-form\">Nouveaux paramètres pour la fonction for wp_login_form()</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#custom-ports-for-multisite-site-addresses\">Ports personnalisés pour les adresses des sites d&rsquo;un multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#update-enabled-mime-types-for-new-multisite-installs\">Mise à jour des types MIME activés pour les nouvelles installations multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#obsolete-polyfills-dependencies-have-been-removed\">Suppression des dépendances polyfill obsolètes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#script-modules-can-now-be-used-in-the-wordpress-admin\">Les modules de Script peuvent maintenant être utilisés sur l&rsquo;administration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#search-has-a-much-later-priority\">Mise en place d&rsquo;une priorité moins importante sur le composant de recherche de la barre d&rsquo;administration</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"q0i57KuxlF\"><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/\">Miscellaneous developer changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/embed/#?secret=q70OxXcdsS#?secret=q0i57KuxlF\" data-secret=\"q0i57KuxlF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.6 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.6.0/\">https://developer.wordpress.org/reference/since/6.6.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-9bd75783906267b91255ee59d7f76693\" style=\"background:linear-gradient(135deg,rgb(189,21,50) 0%,rgb(248,68,11) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/06/wordpress-6-6-rc1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.6</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.6</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny</a>, <a href=\"https://profiles.wordpress.org/clementpolito/\">Clément</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Le 28 juin 2024 : deuxième WordPress Translation Day FR !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://fr.wordpress.org/2024/06/13/le-28-juin-2024-deuxieme-wordpress-translation-day-fr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Jun 2024 08:08:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:4:\"wptd\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3070\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Que vous soyez débutant·e ou aguerri·e à la traduction de WordPress et de son écosystème, rejoignez-nous en visio-conférence quand vous le souhaitez, entre 10 et 17 heures, en toute décontraction, pour rencontrer les membres de l&#8217;équipe de traduction de WordPress en français et pour traduire ensemble aussi bien WordPress lui-même, qu’une extension ou un thème [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10157:\"<figure class=\"wp-block-post-featured-image\"><img loading=\"lazy\" decoding=\"async\" width=\"1200\" height=\"800\" src=\"https://fr.wordpress.org/files/2024/06/WPTD-FR-2024.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover;\" srcset=\"https://fr.wordpress.org/files/2024/06/WPTD-FR-2024.png 1200w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-300x200.png 300w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-1024x683.png 1024w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-768x512.png 768w\" sizes=\"auto, (max-width: 1200px) 100vw, 1200px\" /></figure>\n\n\n<p>Que vous soyez <strong>débutant·e ou aguerri·e</strong> à la traduction de WordPress et de son écosystème, rejoignez-nous en visio-conférence quand vous le souhaitez, <strong>entre 10 et 17 heures</strong>, <em>en toute décontraction</em>, pour rencontrer les membres de l&rsquo;équipe de traduction de WordPress en français et pour traduire ensemble aussi bien WordPress lui-même, qu’une extension ou un thème qui vous tient à cœur, ou encore un des nombreux sites wordpress.org.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Le WordPress Translation Day FR, qu’est-ce que c’est&nbsp;?</h2>\n\n\n\n<p>Habituellement, un&nbsp;<em><strong>WordPress Translation Day</strong></em>, ce sont 24 heures pendant lesquelles les différentes équipes de traduction de chaque langue contribuent ensemble à la traduction de l’écosystème&nbsp;: cœur WordPress, extensions, thèmes, ainsi que tous les sites WordPress.org. Cela se déroule sur 24 heures et sur tous les fuseaux horaires, avec des conférences données en direct dans toutes les langues.</p>\n\n\n\n<p>Le 28 juin prochain, nous vous proposerons une version allégée d’un&nbsp;<em>WordPress Translation Day</em>&nbsp;mondial. Il s’agira de contribuer ensemble à la traduction de WordPress en français, au moment où vous le souhaitez, entre 10 et 17 heures, en visioconférence. Les membres de l’équipe traduction seront là pour vous guider et valider vos suggestions.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Comment participer&nbsp;?</h2>\n\n\n\n<p>Vous aurez besoin d’un compte wordpress.org pour vous inscrire et traduire le jour J.</p>\n\n\n\n<p>Si vous n’avez pas encore de compte, suivez ce <a href=\"https://fr.wordpress.org/team/handbook/polyglots/rejoindre-lequipe-de-traduction-de-wordpress/\">petit guide</a> pour le créer.</p>\n\n\n\n<p>L’évènement se déroulera en visioconférence sur le logiciel Zoom. Vous pouvez déjà vous y inscrire gratuitement&nbsp;:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-4 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://translate.wordpress.org/events/2024/wordpress-translation-day-fr-du-28-juin-2024/\">S’inscrire au WPTD du 28 juin 2024<br></a></div>\n</div>\n\n\n\n<p>Grâce à cette inscription, toutes vos contributions du jour seront comptabilisées, ce qui nous permettra de mesurer facilement le travail accompli !</p>\n\n\n\n<div class=\"wp-block-columns are-vertically-aligned-center has-lemon-3-background-color has-background is-layout-flex wp-container-core-columns-is-layout-5 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:4%\">\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<p>Si vous débutez dans la traduction, nous vous invitons à lire le guide de contribution dédié à la <a href=\"https://fr.wordpress.org/team/handbook/polyglots/\">Traduction de WordPress</a>, et en particulier la page <a href=\"https://fr.wordpress.org/team/handbook/polyglots/recommandations/\">Recommandations</a>.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Le programme</h2>\n\n\n\n<p>La visio-conférence sera ouverte dès 10h et jusqu’à 17h, l&rsquo;équipe des GTE et GPTE vous accueillera au fil de vos arrivées et vous guidera dans vos traductions ou vos premières traductions, si vous débutez, et répondra bien évidemment à toutes vos questions. </p>\n\n\n\n<p>En parallèle, nous utiliserons le canal <strong><em>#évènements-translationday</em></strong> du <a href=\"https://join.slack.com/t/wordpressfr/shared_invite/zt-1rvk7csl3-M1jWYcn71tSRLsAluZ9CmQ\">slack WordPress-FR</a> pour diffuser des informations et nous coordonner.</p>\n\n\n\n<p>Normalement, les chaînes de la version 6.6 seront disponibles, aussi vous aurez l&rsquo;occasion de les traduire et d&rsquo;être ainsi mentionné·e dans les crédits de cette nouvelle version&nbsp;!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Pourquoi participer à cet évènement</h2>\n\n\n\n<p>WordPress est un projet open source que nous sommes nombreuses et nombreux à utiliser. Qui dit open source dit contribution. Il y a différentes manières de contribuer au projet WordPress : entre autres, en améliorant le cœur du CMS, en organisant des évènements (meetups, WordCamps) mais aussi en traduisant WordPress lui-même, ses extensions, ses thèmes, ses tutoriaux et cours ou encore sa documentation. Alors vous aussi contribuez !</p>\n\n\n\n<p>Si vous souhaitez plus d’informations sur les équipes de contribution en français, consultez&nbsp;<a href=\"https://fr.wordpress.org/team\">le blog officiel</a> des équipes.</p>\n\n\n\n<p class=\"has-white-color has-blueberry-1-background-color has-text-color has-background has-link-color wp-elements-6e90a0661a60803691fd7425a3abb690\" style=\"margin-top:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\">N’hésitez pas à nous rejoindre le 28 juin 2024, l’équipe de traduction de WordPress en français sera ravie de vous accueillir tout au long de la journée.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Partagez l’info</h2>\n\n\n\n<p>Si vous souhaitez communiquer sur l’évènement, voici différents visuels prévus pour les réseaux sociaux&nbsp;:</p>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-f60c68b6-141a-4190-831e-52e56cd44f29\" href=\"https://fr.wordpress.org/files/2024/06/Facebook-Event-image-1920x1005-1.png\">Facebook-Event-image-1920&#215;1005-1</a><a href=\"https://fr.wordpress.org/files/2024/06/Facebook-Event-image-1920x1005-1.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-f60c68b6-141a-4190-831e-52e56cd44f29\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-171ff8e2-9a21-4e00-87f4-ea0566ec87ec\" href=\"https://fr.wordpress.org/files/2024/06/Facebook-paysage.png\">Facebook-paysage</a><a href=\"https://fr.wordpress.org/files/2024/06/Facebook-paysage.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-171ff8e2-9a21-4e00-87f4-ea0566ec87ec\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-5ca45389-e759-4d1d-b05f-ec5222dddea2\" href=\"https://fr.wordpress.org/files/2024/06/FB-portrait.png\">FB-portrait</a><a href=\"https://fr.wordpress.org/files/2024/06/FB-portrait.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-5ca45389-e759-4d1d-b05f-ec5222dddea2\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b592849b-c93d-4384-8198-16de351f2efc\" href=\"https://fr.wordpress.org/files/2024/06/IG-ou-Li-carousel.png\">IG-ou-Li-carousel</a><a href=\"https://fr.wordpress.org/files/2024/06/IG-ou-Li-carousel.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b592849b-c93d-4384-8198-16de351f2efc\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-191d59ad-b451-4144-ad3b-cfc9206e1311\" href=\"https://fr.wordpress.org/files/2024/06/LinkedIn.png\">LinkedIn</a><a href=\"https://fr.wordpress.org/files/2024/06/LinkedIn.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-191d59ad-b451-4144-ad3b-cfc9206e1311\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b0eb707c-9c03-4976-ad6e-52f596a0701c\" href=\"https://fr.wordpress.org/files/2024/06/Slide-4_3.png\">Slide-4_3</a><a href=\"https://fr.wordpress.org/files/2024/06/Slide-4_3.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b0eb707c-9c03-4976-ad6e-52f596a0701c\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b948ac87-b032-44c5-9454-9858890e6a94\" href=\"https://fr.wordpress.org/files/2024/06/Slide-16_9.png\">Slide-16_9</a><a href=\"https://fr.wordpress.org/files/2024/06/Slide-16_9.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b948ac87-b032-44c5-9454-9858890e6a94\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-1393cca2-1c84-4e6d-afbe-c067f007a8ee\" href=\"https://fr.wordpress.org/files/2024/06/X-Twitter.png\">X-Twitter</a><a href=\"https://fr.wordpress.org/files/2024/06/X-Twitter.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-1393cca2-1c84-4e6d-afbe-c067f007a8ee\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-ca5d6b68-5aea-4207-aa36-af33bba9f158\" href=\"https://fr.wordpress.org/files/2024/06/post-WPTD-2024.png\">post-WPTD-2024</a><a href=\"https://fr.wordpress.org/files/2024/06/post-WPTD-2024.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-ca5d6b68-5aea-4207-aa36-af33bba9f158\">Télécharger</a></div>\n\n\n\n<p>Merci à Béryl de la Grandière (<a href=\"https://profiles.wordpress.org/beryldlg/\">@beryldlg</a>) pour ces visuels.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3070\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.5 « Regina »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/04/02/wordpress-6-5-regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 19:04:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3027\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"Souhaitons la bienvenue à WordPress&#160;6.5 «&#160;Regina&#160;». Le nom de cette version a été inspiré par le dynamisme de la violoniste de jazz reconnue Regina Carter. Cette artiste renommée et grande pédagogue a tiré profit de ses fondamentaux techniques classiques et de sa grande connaissance du jazz pour se forger la réputation de transcender les possibilités [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:70246:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1024x683.png\" alt=\"\" class=\"wp-image-3041\" srcset=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1024x683.png 1024w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-300x200.png 300w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-768x512.png 768w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1536x1024.png 1536w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-2048x1365.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Souhaitons la bienvenue à WordPress&nbsp;6.5 «&nbsp;Regina&nbsp;». Le nom de cette version a été inspiré par le dynamisme de la violoniste de jazz reconnue <a href=\"https://fr.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. Cette artiste renommée et grande pédagogue a tiré profit de ses fondamentaux techniques classiques et de sa grande connaissance du jazz pour se forger la réputation de transcender les possibilités du violon.</p>\n\n\n\n<p>N&rsquo;hésitez pas à <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">découvrir les sonorités du violon de Regina</a> pendant que vous jetterez un œil aux nouveautés de WordPress&nbsp;6.5 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3bb.png\" alt=\"🎻\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> </p>\n\n\n\n<p>Cette dernière version de WordPress s&rsquo;est consacrée à l&rsquo;amélioration de nombreux détails de l’expérience d’administration et de personnalisation de votre site. De la bibliothèque de polices à la gestion des révisions au sein de l’éditeur de site, en passant par les nombreuses améliorations de performances, WordPress&nbsp;6.5 apportera beaucoup à votre site.</p>\n\n\n\n<p>&nbsp;«&nbsp;Regina&nbsp;» apporte également plusieurs outils de développement ayant pour objectif de transformer la façon dont les développeuses et développeurs interagissent avec l’éditeur afin d’étendre le système de blocs. L&rsquo;API de gestion des interactions ouvre un nouveau champ de possibilités tandis que l’API <em><bdo lang=\"en\" dir=\"ltr\">Block Bindings</bdo></em> permet de réaliser des connexions dynamiques entre les blocs et les champs personnalisés (ou tout autre type de donnée dynamique). Et ce ne sont que deux exemples des nombreuses évolutions techniques de cette version.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Télécharger WordPress 6.5 «&nbsp;Regina&nbsp;»</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les nouveautés de WordPress&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Gérez les polices d’écriture de votre site</h3>\n\n\n\n<p>La nouvelle bibliothèque de polices vous permet de contrôler la typographie de votre site sans avoir à mettre les mains dans le code. Installez, supprimez et activez sans effort vos polices locales ou les polices Google sur votre site, quel que soit votre thème actif. La possibilité d‘inclure des collections de polices personnalisées offre encore plus de choix aux personnes qui créent et administrent des sites WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Font-Manager-1024x666.png\" alt=\"A stylized view of the font manager; part of the new Font Library feature in WordPress 6.5.\" class=\"wp-image-17147\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Davantage d’informations sur vos révisions de styles</h3>\n\n\n\n<p>Travaillez sur vos projets de création avec une vision plus complète de ce qui a été fait et de ce sur quoi vous pouvez vous appuyer. Obtenez des détails tels que l&rsquo;horodatage de chaque modification, des résumés rapides et une liste paginée avec toutes les révisions enregistrées. Consultez les révisions du guide de styles pour voir les changements effectués. Des révisions sont également désormais disponibles pour les modèles et les éléments de modèles.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Revisions-1024x666.png\" alt=\"A closer look at some of the comprehensive details now available for revisions. \" class=\"wp-image-17149\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Des nouveaux contrôles de mise en page et de mise en forme</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Contrôlez les options de taille, de répétition et de point de focalisation afin d’ajouter un intérêt visuel et créatif à vos mises en page.</li>\n\n\n\n<li>Réglez les proportions de taille d’image du bloc Bannière et ajoutez facilement des superpositions de couleurs se basant sur une couleur automatiquement extraite de l’image choisie.</li>\n\n\n\n<li>En activant le support des ombres portées, vous pouvez créer des mises en page avec une profondeur visuelle ou ajouter un peu de personnalité à votre design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/design-tools-1024x666.png\" alt=\"A stylized close up of setting a focal point on a minimalist background image featuring a pale blue sky and contrasting dark grey building. \" class=\"wp-image-17150\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez les nouvelles vues de données</h3>\n\n\n\n<p>Retrouvez et organisez vos données comme vous le souhaitez avec des vues de données pour les pages, les modèles de pages, les compositions et les éléments de modèles. Affichez-les sous forme de tableau ou de grille avec la possibilité d’afficher ou de masquer les champs et de faire des modifications groupées.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Data-Views-1024x666.png\" alt=\"A snapshot of the UI that lets you choose your data view. \" class=\"wp-image-17151\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Un glisser-déposer plus fluide</h3>\n\n\n\n<p>Vous verrez la différence lorsque vous déplacerez des éléments, grâce à des indices visuels utiles tels que les objets immédiatement déplacés dans la vue liste ou le glissement fluide vers n’importe quel endroit de votre espace de travail.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/drag-and-drop-1024x666.png\" alt=\"\" class=\"wp-image-17152\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration des réglages des liens</h3>\n\n\n\n<p>Créez et gérez facilement les liens avec une expérience de gestion plus intuitive&nbsp;: une interface d’utilisation simplifiée et un raccourci pour copier les liens.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/ink-controls-1024x666.png\" alt=\"\" class=\"wp-image-17153\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Quelques nouveautés pour le développement sur WP&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez des interactions aux blocs avec l’API de gestion des interactions</h3>\n\n\n\n<p>L’API de gestion des interactions offre aux développeurs et développeuses une méthode normée pour construire des expériences d’interfaces interactives avec des blocs. Elle simplifie le processus en réduisant les dépendances à des outils externes, tout en conservant des performances optimales. Utilisez-la pour créer des expériences utilisateur mémorables, par exemple en récupérant instantanément les résultats de recherche ou en permettant aux internautes d’interagir avec le contenu en temps réel.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez les blocs aux champs personnalisés ou autres contenus dynamiques</h3>\n\n\n\n<p>Liez les attributs des blocs de base aux champs personnalisés et utilisez la valeur des champs personnalisés sans créer de blocs personnalisés. Grâce à l’API «&nbsp;Block Bindings&nbsp;», les développeurs/développeuses peuvent étendre cette fonctionnalité en liant les blocs à n’importe quel contenu dynamique, même au-delà des champs personnalisés. Si des données sont stockées ailleurs, les blocs peuvent facilement pointer vers cette nouvelle source en quelques lignes de code seulement.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez les outils de gestion de l’apparence aux thèmes classiques</h3>\n\n\n\n<p>Améliorez l‘expérience de conception des designers et créateurs utilisant des thèmes classiques. Optez pour cela pour l’activation du support des options d‘espacement, de bordure, de typographie et de couleur, même sans utiliser theme.json. Une fois le support activé, plus d‘outils seront automatiquement ajoutés au fur et à mesure de leur disponibilité.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez les améliorations de l’expérience de gestion des extensions</h3>\n\n\n\n<p>Il existe à présent un moyen plus simple de gérer les dépendances des extensions. Les auteurs et les autrices d’extensions peuvent fournir un nouvel en-tête&nbsp;<code>Requires Plugins</code>&nbsp;avec la liste des slugs, séparés par des virgules, des extensions nécessaires donnant aux utilisateurs et utilisatrices, des liens pour installer et activer ces extensions au préalable.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>Cette version comprend plus de 110 améliorations de performance, avec une augmentation impressionnante de la vitesse et de l’efficacité de l’éditeur de bloc et l’éditeur de site. Le chargement, la saisie et la navigation dans l’éditeur de site sont deux fois plus rapides que sur la version 6.4.</p>\n\n\n\n<p>Les sites traduits bénéficient d’une amélioration de 25% de leur temps de chargement sur cette version.</p>\n\n\n\n<p>Le support du format d’images AVIF a aussi été ajouté.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Cette version comprend plus de 65 améliorations en matière d‘accessibilité sur toute la plateforme, la rendant plus accessible que jamais. Cette mise à jour apporte des corrections aux réglages de contraste, à la focalisation du curseur, aux sous-menus et au positionnement des éléments, parmi bien d‘autres, qui aident à améliorer l‘expérience WordPress pour tout le monde.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.5</h2>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/03/16/guide-des-changements-techniques-de-wordpress-6-5/\">Guide des changements techniques de WordPress 6.5</a> pour découvrir les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p>Vous pouvez suivre le <a href=\"https://developer.wordpress.org/news/\">blog d’aide au développement avec WordPress (en anglais)</a> pour suivre l&rsquo;évolution technique de WordPress et consulter des tutoriels sur les fonctionnalités du CMS.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Pour plus d’informations techniques sur WordPress 6.5 comme par exemple les fichiers modifiés, les mises à jour de paquets ou les bugs corrigés consultez la <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">notice technique de WP&nbsp;6.5 (en anglais)</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.5</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> et <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> et <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> et <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> et <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> et <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Direction du design&nbsp;: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> et <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> et <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Responsable de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> et <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Responsables des performances&nbsp;: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> et <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Responsables des tests&nbsp;: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> et <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.5 n’aurait pas pu sortir sans la contribution passionnée de <strong>702 personnes provenant d’au moins 57 pays différents</strong> et de <strong>plus de 200 entreprises</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les 702 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.5 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull has-black-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-0d70530c06fde7a1042490da172d9e21\" style=\"background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">Alexander</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">niravsherasiya7707</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.5 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.5 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.5 en français&nbsp;:</p>\n\n\n\n<p class=\"has-black-color has-text-color has-background has-link-color has-small-font-size wp-elements-82f462fa066a7b8c1ada5f06497f997d\" style=\"background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\"><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>, <a href=\"https://profiles.wordpress.org/cauzyolo\">cauzyolo</a>, <a href=\"https://profiles.wordpress.org/charlie67p\">charlie67p</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/ebrockway\">EBrockway</a>, <a href=\"https://profiles.wordpress.org/milouze\">Emil1</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/frmo\">Frmo</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a>, <a href=\"https://profiles.wordpress.org/oellin\">Magali</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>, <a href=\"https://profiles.wordpress.org/nandow\">nandow</a>, <a href=\"https://profiles.wordpress.org/nicolasricher\">Nicolas Richer</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/tobifjellner\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a> et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p>N’hésitez pas à&nbsp;<a href=\"https://fr.wordpress.org/team/handbook/\">rejoindre les équipes de contribution francophones&nbsp;!</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article publié par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3027\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/03/16/guide-des-changements-techniques-de-wordpress-6-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 16 Mar 2024 00:04:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2999\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&#160;6.5, dont la sortie est prévue le 26 mars 2024. Sur Trac (l&#8217;outil de tickets utilisés par le cœur de WordPress, environ 344 tickets on été clôturés&#160;: 99 d&#8217;entre eux concernent des améliorations et des nouvelles fonctionnalités, 210 concernent des corrections de bugs, et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:31860:\"\n<p class=\"has-very-light-gray-to-cyan-bluish-gray-gradient-background has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.5, dont la sortie est prévue le 26 mars 2024.</p>\n\n\n\n<p>Sur Trac (l&rsquo;outil de tickets utilisés par le cœur de WordPress, environ <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">344 tickets</a> on été clôturés&nbsp;: <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">99 d&rsquo;entre eux concernent des améliorations et des nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">210 concernent des corrections de bugs</a>, et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">35 d&rsquo;autres tâches diverses et variées</a>. Cette fois, il y a eu <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">20 tickets qui se sont concentrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">19 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">23 sur la modernisation du code source et sur l&rsquo;application des standards de programmation du CMS</a>.</p>\n\n\n\n<p>Les <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5\">versions du projet Gutenberg inclues dans WP 6.5</a> contiennent 373 évolutions, 515 corrections de bugs et 65 améliorations de l&rsquo;accessibilité.</p>\n\n\n\n<p>Les évolutions apportées sur la version 6.5 s&rsquo;étalent sur <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du cœur WP</a>. Vous trouverez dans cet article une liste des changements les plus importants.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.5, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-6df67768f7a11549211ad53b7e24c257\" id=\"high-impact-changes\">Prérequis techniques pour faire tourner WordPress&nbsp;6.5</h2>\n\n\n\n<p>La version minimale supportée de MySQL est passée de 5.0 à 5.5.5 (<a href=\"https://core.trac.wordpress.org/ticket/60036\">ticket #60036</a>).</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"tlSiCOHR47\"><a href=\"https://make.wordpress.org/core/2023/12/08/raising-the-minimum-version-of-mysql-required-in-wordpress-6-5/\">Raising the minimum version of MySQL required in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Raising the minimum version of MySQL required in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/12/08/raising-the-minimum-version-of-mysql-required-in-wordpress-6-5/embed/#?secret=RQN3EtHRSy#?secret=tlSiCOHR47\" data-secret=\"tlSiCOHR47\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"major-features-dev-notes\">Fonctionnalités majeures apportées par WP&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-editor\">Changements concernant l’éditeur</h3>\n\n\n\n<p>WordPress 6.5 implémente 10 versions de Gutenberg&nbsp;: <a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">16.8</a>, <a href=\"https://make.wordpress.org/core/2023/10/25/whats-new-in-gutenberg-16-9-25-october-2/\">16.9</a>, <a href=\"https://make.wordpress.org/core/2023/11/10/whats-new-in-gutenberg-17-0-9-november/\">17.0</a>, <a href=\"https://make.wordpress.org/core/2023/11/22/whats-new-in-gutenberg-17-1-22-november/\">17.1</a>, <a href=\"https://make.wordpress.org/core/2023/12/06/whats-new-in-gutenberg-17-2-6-december/\">17.2</a>, <a href=\"https://make.wordpress.org/core/2023/12/20/whats-new-in-gutenberg-17-3-20-december/\">17.3</a>, <a href=\"https://make.wordpress.org/core/2024/01/04/whats-new-in-gutenberg-17-4-03-january/\">17.4</a>, <a href=\"https://make.wordpress.org/core/2024/01/17/whats-new-in-gutenberg-17-5-17-january-2024/\">17.5</a>, <a href=\"https://make.wordpress.org/core/2024/01/31/whats-new-in-gutenberg-17-6-31-january/\">17.6</a> et <a href=\"https://make.wordpress.org/core/2024/02/14/whats-new-in-gutenberg-17-7-14th-february/\">17.7</a>. Vous trouverez de nouvelles fonctionnalités, de nouvelles API et de nombreuses améliorations comme par exemple l&rsquo;API de gestion des interactions, la bibliothèque de polices ou l&rsquo;API <em><bdo lang=\"en\" dir=\"ltr\">Block Bindings</bdo></em> qui permet de charger dynamiquement du contenu dans les blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zTGJeIG79x\"><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/embed/#?secret=BP3bfBzPe0#?secret=zTGJeIG79x\" data-secret=\"zTGJeIG79x\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"aeHTn70nhm\"><a href=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/\">New Feature: Font Library</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Feature: Font Library&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/embed/#?secret=t8LR8aiZf0#?secret=aeHTn70nhm\" data-secret=\"aeHTn70nhm\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wXhMjnlZWs\"><a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">New Feature: The Block Bindings API</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Feature: The Block Bindings API&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/embed/#?secret=9LDqQR1jOn#?secret=wXhMjnlZWs\" data-secret=\"wXhMjnlZWs\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kSOEJXANFd\"><a href=\"https://make.wordpress.org/core/2024/03/04/block-metadata-viewscriptmodule-field-in-6-5/\">Block metadata viewScriptModule field in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block metadata viewScriptModule field in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/block-metadata-viewscriptmodule-field-in-6-5/embed/#?secret=yRl8NrcZXE#?secret=kSOEJXANFd\" data-secret=\"kSOEJXANFd\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fgr7Eh9WG0\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/\">Updates to Block Hooks in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/embed/#?secret=xqHNQnC5pX#?secret=fgr7Eh9WG0\" data-secret=\"fgr7Eh9WG0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"i7jW1A2sTY\"><a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">Performance improvements for registering block variations with callbacks</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Performance improvements for registering block variations with callbacks&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/embed/#?secret=wBSi3tRFIE#?secret=i7jW1A2sTY\" data-secret=\"i7jW1A2sTY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7oIfaxmlW9\"><a href=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\">Unification of the site and post editors in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Unification of the site and post editors in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/embed/#?secret=1EIvfu7nj1#?secret=7oIfaxmlW9\" data-secret=\"7oIfaxmlW9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6EIPP73tAr\"><a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\">Miscellaneous Editor changes in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/embed/#?secret=WtvUY2vLJl#?secret=6EIPP73tAr\" data-secret=\"6EIPP73tAr\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"html-api\">API processeur HTML</h3>\n\n\n\n<p>WordPress 6.5 apporte des changements significatifs de l&rsquo;API HTML. Le processeur de balises a reçu une attention particulière et un plus grand nombre d&rsquo;éléments HTML sont maintenant supportés. Si vous utilisez la classe <code>WP_HTML_Tag_Processor</code>, alors il y a plusieurs changements dont vous devriez prendre connaissance.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"BN0e1F8yMe\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/\">Updates to the HTML API in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/embed/#?secret=ln9KARtfky#?secret=BN0e1F8yMe\" data-secret=\"BN0e1F8yMe\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performant-translations/\" target=\"_blank\" rel=\"noreferrer noopener\">L&rsquo;extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Performant Translations</bdo></em> »</a> a été intégrée au cœur de WordPress. Ce nouveau système de gestion des traductions est bien plus rapide et bien moins gourmand en mémoire que l&rsquo;ancien, grâce au nouveau format <code>.l10n.php</code>. Tous les formats disponibles restent supportés&nbsp;: le nouveau format <code>.l10n.php</code>, mais aussi les formats classiques basés sur des fichiers <code>.mo</code> et <code>.po</code>. Deux nouveau filtres font leur entrée dans le cœur du CMS&nbsp;: <code>translation_file_format</code> et <code>load_translation_file</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KT4MEhfgP4\"><a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">I18N Improvements in 6.5 (Performant Translations)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;I18N Improvements in 6.5 (Performant Translations)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/embed/#?secret=fbxqrebUJq#?secret=KT4MEhfgP4\" data-secret=\"KT4MEhfgP4\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"media\">Gestion des médias</h3>\n\n\n\n<p>La prise en charge du format d&rsquo;image AVIF a été ajoutée dans WP 6.5. AVIF est un format moderne qui peut être jusqu&rsquo;à 50&nbsp;% moins lourd que JPEG, avec la même qualité d&rsquo;image. Vous pouvez maintenant téléverser, modifier, redimensionner et enregistrer ce format d&rsquo;image, s&rsquo;il est pris en charge par votre hébergement web. La façon de travailler avec des fichiers AVIF reste la même que pour les autres formats d&rsquo;images déjà supportés. En revanche si vous utilisez un réseau multisite il y a quelques spécificités à connaître. Nous vous conseillons dans ce cas de jeter un œil à la FAQ disponible sur cette note de développement.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"682RAd31H2\"><a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">WordPress 6.5 adds AVIF support </a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.5 adds AVIF support &#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/embed/#?secret=dxdpDKfjp5#?secret=682RAd31H2\" data-secret=\"682RAd31H2\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"script-loader\">Chargement des ressources</h3>\n\n\n\n<p>L&rsquo;API de gestion des scripts apporte la prise en charge native des <em>Modules JavaScript</em> et fournit deux modules utilisables dans le cas de <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">l&rsquo;API de gestion des interactions</a>.</p>\n\n\n\n<p>qu&rsquo;un</p>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"SDLOPVPvCc\"><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Script Modules in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/embed/#?secret=vjQsNq4gMQ#?secret=SDLOPVPvCc\" data-secret=\"SDLOPVPvCc\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upgrade-install\">Gestion des mises à jour</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/wp-plugin-dependencies/\">L&rsquo;extension « <em><bdo lang=\"en\" dir=\"ltr\">Plugin Dependencies</bdo></em> »</a> fait enfin son entrée dans le cœur du CMS. Elle permet de gérer les dépendances entre extensions, par exemple pour indiquer qu&rsquo;une extension dépend de l&rsquo;activation d&rsquo;une autre extension et d&rsquo;en informer les personnes chargées de l&rsquo;administration du site directement sur l&rsquo;interface d&rsquo;admin.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4svgv5uY7m\"><a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">Introducing Plugin Dependencies in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing Plugin Dependencies in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/embed/#?secret=tPhoOCr57d#?secret=4svgv5uY7m\" data-secret=\"4svgv5uY7m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\"><summary>Plus d&rsquo;informations sur la gestion des dépendances d&rsquo;extensions (cliquer pour déplier le contenu)</summary>\n<p>Les dépendances d&rsquo;une extension peuvent être déclarées en utilisant le nouvel entête <code>Requires Plugins</code> sur le fichier principal de l&rsquo;extension. L&rsquo;entête doit contenir une liste de slugs d&rsquo;extensions séparés par une virgule.</p>\n\n\n\n<p>Exemple&nbsp;:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>/**<br> * Plugin Name: Ma super extension<br> * Requires Plugins: une-extension-cool, une-autre-extension<br> */</code></pre>\n\n\n\n<p>Conditions d&rsquo;utilisation&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Les extensions hébergées sur WordPress.org ne peuvent que déclarer des dépendances aussi hébergées sur WordPress.org</li>\n\n\n\n<li>Les extensions qui ne sont pas hébergées sur WordPress.org peuvent déclarer des dépendances hébergées sur WordPress.org ou n&rsquo;importe où ailleurs</li>\n</ul>\n\n\n\n<p>La déclaration de dépendances nécessite de respecter les prérequis suivants&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les extensions déclarant une dépendance&nbsp;:\n<ul class=\"wp-block-list\">\n<li>Elles ne peuvent pas être installées avant que les dépendances ne soient installées</li>\n\n\n\n<li>Elles ne peuvent pas être activées avant que les dépendances ne soient activées</li>\n</ul>\n</li>\n\n\n\n<li>Pour les extensions qui sont des dépendances d&rsquo;autres extensions&nbsp;:\n<ul class=\"wp-block-list\">\n<li>Elles ne peuvent pas être désactivées avant que les extensions qui en dépendent ne soient désactivées</li>\n\n\n\n<li>Elles ne peuvent pas être supprimées tant que les extensions qui en dépendent sont toujours installées sur le site</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>Les fonctionnalités suivantes <strong>ne sont pas encore prises en charge</strong>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Gestion des versions</li>\n\n\n\n<li>Déclaration des extensions indispensables («&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Must-Use</bdo></em>&nbsp;», ou «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">mu-plugins</bdo></em>&nbsp;») en tant que dépendances</li>\n\n\n\n<li>Thèmes nécessitant des extensions spécifiques</li>\n\n\n\n<li>Désactivation automatique des extensions dépendant d&rsquo;autres extensions qui ont été supprimées</li>\n</ul>\n\n\n\n<p>Un nouveau filtre <code>wp_plugin_dependencies_slug</code> a été introduit afin de permettre d&rsquo;altérer les slugs des dépendances.</p>\n\n\n\n<p>Une nouvelle classe PHP <code>WP_Plugin_Dependencies</code> a été introduite avec une API contenant plusieurs méthodes publiques.</p>\n\n\n\n<p>L&rsquo;interface de l&rsquo;écran de gestion des extensions a été modifiée afin d&rsquo;afficher les dépendances des extensions. L&rsquo;interface des fiches des extensions qui sont dépendantes d&rsquo;autres extensions a été modifiée pour afficher leurs dépendances, avec des liens vers des fenêtres modales pour les installer/activer en premier.</p>\n\n\n\n<p>La redirection automatique depuis l&rsquo;écran <strong>Extensions &gt; Ajouter</strong> n&rsquo;est plus disponible pour les développeuses et développeurs d&rsquo;extensions, qui ne pourront donc plus directement rediriger par exemple vers un écran de configuration après activation de leur extension depuis cet écran.</p>\n</details>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"additional-changes\">Autres changements</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"external-libraries\">Bibliothèques tierces</h3>\n\n\n\n<p>Les bibliothèques tierces suivantes ont été mises à jour&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>getID3 a été mises à jour vers la version 1.9.23 (<a href=\"https://core.trac.wordpress.org/ticket/59683\">ticket #59683</a>)</li>\n\n\n\n<li>PHPMailer a été mise à jour vers la version 6.9.1 (<a href=\"https://core.trac.wordpress.org/ticket/59966\">ticket #59966</a>)</li>\n\n\n\n<li><code>@wordpress/scripts</code> en version 17 arrête le support des versions de Node.js non maintenues. La plus vieille version de Node.js encore supportée est la version 18 (cf. note de développement&nbsp;: <a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Misc Editor Dev Changes</bdo></a>)</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes\">Thèmes</h3>\n\n\n\n<p>Les thèmes classiques (non basés sur des blocs) peuvent maintenant proposer l&rsquo;accès aux outils d&rsquo;apparence (<a href=\"https://core.trac.wordpress.org/ticket/60118\">ticket #60118</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"media-1\">Bibliothèque de médias</h3>\n\n\n\n<p>La gestion des images JEPG progressives a été activée. Un nouveau filtre <code>image_save_progressive</code> a été ajouté, afin de contrôler si les tailles d&rsquo;images intermédiaires sont enregistrées en format progressif ou non (s&rsquo;il est disponible). Par défaut, le rendu progressif est désactivé, ce qui correspond au fonctionnement passé (<a href=\"https://core.trac.wordpress.org/ticket/21668\">ticket #21668</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"permalinks\">Permaliens</h3>\n\n\n\n<p>Prise en charge de la gestion des permaliens sur les serveurs <em>Caddy</em> (<a href=\"https://core.trac.wordpress.org/ticket/41877\">ticket #41877</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"rest-api\">API REST</h3>\n\n\n\n<p>Un champ <code>featured_media</code> pour les vignettes de publications a été ajouté au point de terminaison <code>wp/v2/media</code> de l’API REST (<a href=\"https://core.trac.wordpress.org/ticket/41692\">ticket #41692</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"site-health\">Santé du site</h3>\n\n\n\n<p>L&rsquo;identifiant du site courant a été ajouté aux informations de déboguage pour les installations multisite (<a href=\"https://core.trac.wordpress.org/ticket/60081\">ticket #60081</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upgrade-install-1\">Gestion des mises à jours</h3>\n\n\n\n<p>Lors des mises à jour multiples, une vérification des mises à jour des thèmes est maintenant effectuée afin de vérifier que le thème est bien compatible avec la version de WordPress et de PHP utilisée. Cette vérification était déjà en place pour les extensions, mais pas encore pour les thèmes (<a href=\"https://core.trac.wordpress.org/ticket/59758\">ticket #59758</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres modifications</h3>\n\n\n\n<p>Consultez la note de développement listant les autres modifications plus mineures sur WordPress&nbsp;6.5. Certaines modifications peuvent vous concerner.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g7PUJV073d\"><a href=\"https://make.wordpress.org/core/2024/03/08/miscellaneous-developer-changes-in-wordpress-6-5/\">Miscellaneous developer changes in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/08/miscellaneous-developer-changes-in-wordpress-6-5/embed/#?secret=Ho1X2giOH7#?secret=g7PUJV073d\" data-secret=\"g7PUJV073d\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-modified-hooks\">Nouveaux filtres et crochets d&rsquo;action, ou modifications sur les <bdo lang=\"en\" dir=\"ltr\"><em>hooks</em></bdo> existants</h2>\n\n\n\n<p>Pour une liste complète de tous les filtres et crochets d&rsquo;actions modifiés ou ajoutés sur WP 6.5, veuillez consulter le lien suivant (note : il ne sera disponible qu&rsquo;après la sortie de la version) : <a href=\"https://developer.wordpress.org/reference/since/6.5.0/\">https://developer.wordpress.org/reference/since/6.5.0/</a></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"new-filter-hooks\">Nouveaux filtres</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code>new_admin_email_subject</code> (<a href=\"https://core.trac.wordpress.org/ticket/59250\">ticket #59250</a>)</li>\n\n\n\n<li><code>wp_is_rest_endpoint</code> (<a href=\"https://core.trac.wordpress.org/ticket/42061\">ticket #42061</a>)</li>\n\n\n\n<li><code>image_save_progressive</code> (<a href=\"https://core.trac.wordpress.org/ticket/21668\">ticket #21668</a>)</li>\n\n\n\n<li><code>wp_admin_canonical_url</code> (<a href=\"https://core.trac.wordpress.org/ticket/59545\">ticket #59545</a>)</li>\n\n\n\n<li><code>wp_plugin_dependencies_slug</code> (<a href=\"https://core.trac.wordpress.org/ticket/22316\">ticket #22316</a>)</li>\n\n\n\n<li><code>hooked_block</code> (<a href=\"https://core.trac.wordpress.org/ticket/59572\">ticket #59572</a>)</li>\n\n\n\n<li><code>hooked_block_{$block_type}</code> (<a href=\"https://core.trac.wordpress.org/ticket/59572\">ticket #59572</a>)</li>\n\n\n\n<li><code>get_block_type_variations</code> (<a href=\"https://core.trac.wordpress.org/ticket/59969\">ticket #59969</a>)</li>\n\n\n\n<li><code>translation_file_format</code> (<a href=\"https://core.trac.wordpress.org/ticket/59656\">ticket #59656</a>)</li>\n\n\n\n<li><code>load_translation_file</code> (<a href=\"https://core.trac.wordpress.org/ticket/59656\">ticket #59656</a>)</li>\n</ul>\n\n\n\n<p class=\"has-very-light-gray-to-cyan-bluish-gray-gradient-background has-background\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la version de test&nbsp;<a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-2/\">WordPress 6.5&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Release Candidate</bdo></em>&nbsp;2</a>.&nbsp;Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.5</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/altitudedev/\">Florian Prache</a> et <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2999\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordCamp Europe – Turin – Juin 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://fr.wordpress.org/2023/12/26/wordcamp-europe-turin-juin-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Dec 2023 13:55:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"wceu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2952\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Le prochain WordCamp Europe aura lieu du 13 au 15 juin à Turin en Italie. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante. D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&#160;: Et si vous gérez un meetup local et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5926:\"\n<p>Le prochain <strong>WordCamp Europe</strong> aura lieu du <strong>13 au 15 juin à Turin en Italie</strong>. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante.</p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\">bénévole</a> (date limite de candidature : 28 février 2024)&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\">sponsor</a>&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\">partenaire de communication</a> (postulez jusqu’au 9 février 2024)&nbsp;;</li>\n\n\n\n<li>ou encore comme <a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\">orateur ou oratrice</a> (soumettez vos sujets de conférences jusqu’au 15 janvier 2024).</li>\n</ul>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-2 is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2966\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2966\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2964\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png\" alt=\"\" class=\"wp-image-2964\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-300x158.png 300w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-768x403.png 768w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin.png 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2963\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2963\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2967\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2967\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2962\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2962\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n</figure>\n\n\n\n<p>Et si vous gérez un meetup local et souhaitez proposer votre ville comme <a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\">prochaine ville hôte</a> pour le <strong>WordCamp Europe 2025</strong>, l’appel à candidature est ouvert jusqu’au 14 février 2024.</p>\n</div>\n\n\n\n<p>Concernant les conférences, <strong>l’équipe organisatrice souhaite recevoir une grande variété de candidatures</strong>, y compris de personnes issues de groupes habituellement sous-représentés, afin d’offrir aux participants un programme diversifié. Notez qu’un programme de mentorat est disponible pour les personnes sélectionnées qui le désirent. Donc n’hésitez pas à postuler&nbsp;!</p>\n\n\n\n<p>Au final, il vous suffit de choisir comment vous souhaitez participer à ce prochain WordCamp Europe via les liens proposés ci-dessus, et vous ne serez plus qu’à quelques clics de votre départ pour Turin ! Lancez-vous, vous ne le regretterez pas…</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 22 Mar 2025 09:59:33 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 10 Dec 2024 16:47:42 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1738953816;s:21:\"cache_expiration_time\";i:1742684367;s:23:\"__cache_expiration_time\";i:1742684367;}", "off");
INSERT INTO `wp_obs_options` VALUES("39333", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1742684367", "off");
INSERT INTO `wp_obs_options` VALUES("39334", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1742641167", "off");
INSERT INTO `wp_obs_options` VALUES("39335", "_transient_timeout_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "1742684367", "off");
INSERT INTO `wp_obs_options` VALUES("39336", "_transient_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:36:\"https://rss.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://rss.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2025-03-22T10:01:57+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://beapi.fr/blog/comment-utiliser-le-wp-dfsr-pour-vos-projets-institutionnels-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Comment utiliser le WP-DFSR pour vos projets institutionnels WordPress ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"https://beapi.fr/blog/comment-utiliser-le-wp-dfsr-pour-vos-projets-institutionnels-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-20T10:04:57.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-20T10:04:57.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:473:\"Le WP-DFSR est un thème WordPress open source, pensé pour simplifier la création de sites institutionnels conformes au Design Système de l’État (DSFR) et aux normes d’accessibilité RGAA. Il offre une solution clé en main, directement utilisable, flexible et évolutive. Et comme il est open source, il évolue en permanence grâce aux contributions de la […]\nThe post Comment utiliser le WP-DFSR pour vos projets institutionnels WordPress ? appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:12994:\"\n        \n<p>Le <a href=\"https://wp-dsfr.fr/\">WP-DFSR</a> est un<strong> thème WordPress open source, pensé pour simplifier la création de sites institutionnels conformes au Design Système de l’État </strong>(DSFR) et aux normes d’accessibilité RGAA. Il offre une solution clé en main, directement utilisable, flexible et évolutive. Et comme il est open source, il évolue en permanence grâce aux contributions de la communauté. Dans cet article, nous allons voir <strong>comment installer, utiliser et contribuer au WP-DFSR </strong>pour vos projets institutionnels.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wp-dsfr.fr/\">Découvrir le thème</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wp-dsfr.fr/demo/\">Voir la démo</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">I. Installation et configuration du DSFR</h2>\n\n\n\n<p>Installer le WP-DFSR est un processus simple et rapide. Voici les étapes à suivre pour démarrer avec ce thème sur votre site WordPress, et être opérationnels en quelques minutes.</p>\n\n\n\n<p>⚠️ Mais avant, un petit avertissement : Le Design Système de l’État (DSFR) est <strong>réservé aux sites web des services publics français</strong>. Son utilisation doit respecter les règles définies par l’équipe DSFR et nécessite une validation officielle. Avant d’adopter le WP-DFSR, assurez-vous que votre projet est éligible.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Étapes d’installation</h3>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Téléchargez la <a href=\"https://github.com/BeAPI/wp-dsfr/tags\">dernière archive</a> depuis le dépôt <a href=\"https://github.com/beapi/wp-dsfr\">GitHub officiel du WP-DFSR</a></strong><a href=\"https://github.com/beapi/wp-dsfr\">.</a> Celle-ci contient le thème <code>wp-dsfr-theme</code> et le plugin de blocs Gutenberg <code>wp-dsfr-blocks</code></li>\n\n\n\n<li><strong>Importez <code>wp-dsfr-theme</code> </strong>dans le dossier <code>themes</code> de votre installation WordPress et le dossier <code>wp-dsfr-blocks</code> dans le dossier <code>plugins</code> et activez-les via le back-office de votre site WordPress.</li>\n\n\n\n<li><strong>Configurez les paramètres initiaux </strong>(les éléments transverses via le customizer, menus, templates prédéfinis)</li>\n</ol>\n\n\n\n<p>📥 Prêt à installer WP-DFSR ? <a href=\"https://github.com/beapi/wp-dsfr\">Téléchargez-le et démarrez en quelques minutes.</a></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img width=\"1024\" height=\"512\" src=\"https://beapi.fr/app/uploads/2025/03/image-3-1024x512-1.jpg\" alt=\"\" class=\"wp-image-7009\" //></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Ressources pour les développeurs</h3>\n\n\n\n<p>Pour les développeurs souhaitant aller plus loin dans la personnalisation du WP-DFSR, toutes les informations détaillées sont disponibles dans la documentation officielle du projet.</p>\n\n\n\n<p><a href=\"https://github.com/BeAPI/wp-dsfr/wiki/\">Consultez le wiki du projet sur GitHub</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">II. Pourquoi choisir WordPress pour un projet institutionnel ?</h2>\n\n\n\n<h3 class=\"wp-block-heading\">1. Un CMS robuste, open source et sécurisé</h3>\n\n\n\n<p>WordPress est le CMS le plus utilisé au monde, particulièrement apprécié pour sa flexibilité, sa solidité et son accessibilité. Sa plateforme hautement personnalisable permet aux développeurs de répondre aux besoins spécifiques des projets tout en offrant une interface simple pour les utilisateurs non-techniques.</p>\n\n\n\n<p>Son écosystème solide et sa grande communauté garantissent des mises à jour régulières en matière de sécurité et de performance. En tant que solution open source, WordPress permet aux institutions de garder la main sur leurs projets, sans dépendre d’une solution propriétaire.</p>\n\n\n\n<p>C’est aussi une plateforme qui s’adapte aux besoins des utilisateurs. Avec l’éditeur Gutenberg, la gestion du contenu est plus intuitive, offrant davantage d’autonomie aux équipes éditoriales. Résultat : des workflows optimisés, des mises à jour plus rapides et une mise en production facilitée. Un réel atout pour les sites gouvernementaux et institutionnels.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2. Un thème conçu pour une conformité simplifiée</h3>\n\n\n\n<p>Le WP-DFSR a été développé pour faciliter la mise en conformité avec le Design Système de l’État (DSFR) et les normes d’accessibilité RGAA, désormais obligatoires pour les sites publics depuis 2025. Initialement conçu pour répondre à un projet client, il a rapidement évolué pour devenir une solution mutualisée. </p>\n\n\n\n<p><a href=\"https://beapi.fr/blog/wp-dsfr-le-theme-wordpress-qui-simplifie-la-mise-en-conformite-des-sites-de-letat/\">(Re)Découvrez l’histoire du projet.</a></p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Plus besoin de se soucier de la conformité : chaque élément est déjà optimisé selon les standards en vigueur. Vous pouvez vous concentrer sur le contenu et les fonctionnalités.</p></blockquote></figure>\n\n\n\n<p>Développé par les experts de Be API, ce thème offre :</p>\n\n\n\n<p><strong>Une conformité immédiate</strong> : dès l’installation, votre site respecte automatiquement les règles du DSFR et du RGAA. Chaque élément est optimisé selon les standards en vigueur, vous laissant vous concentrer sur le contenu et les fonctionnalités.</p>\n\n\n\n<p><strong>22 blocs prêts à l’emploi</strong> : des blocs natifs, des compositions et des blocs sur mesure compatibles avec Gutenberg pour une gestion simplifiée du contenu.</p>\n\n\n\n<p><strong>Des templates structurés</strong> : des modèles de pages préconçus assurant une cohérence visuelle et fonctionnelle, tout en accélérant le développement.</p>\n\n\n\n<p><strong>Un projet open source et collaboratif</strong> : Le WP-DFSR évolue grâce aux contributions de la communauté. Vous pouvez y participer en proposant des améliorations ou en développant vos propres blocs et extensions sur GitHub</p>\n\n\n\n<h3 class=\"wp-block-heading\">3. Le WP-DFSR est fait pour vous si…</h3>\n\n\n\n<p><strong>Vous êtes responsable d’un projet public ou institutionnel</strong> et avez besoin d’une solution rapide et clé en main pour assurer la conformité RGAA et DSFR sans partir de zéro.</p>\n\n\n\n<p><strong>Vous travaillez pour l’État ou une collectivité publique</strong> et cherchez un moyen efficace de créer un site sur WordPress dans les standards officiels , sans perdre de temps sur des aspects techniques complexes.</p>\n\n\n\n<p><strong>Vous êtes développeur ou intégrateur dans une institution publique</strong> et souhaitez personnaliser un site tout en garantissant sa conformité. Avec le WP-DFSR, l’intégration avec Gutenberg et sa structure modulaire rendent l’ajout de blocs et de fonctionnalités spécifiques plus simple et sécurisé.</p>\n\n\n\n<h2 class=\"wp-block-heading\">III. Fonctionnalités principales : un thème pensé pour les sites institutionnels</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Des blocs natifs conformes au DSFR</h3>\n\n\n\n<p>Le WP-DFSR intègre des blocs prêts à l’emploi essentiels pour structurer facilement votre site tout en respectant les normes du Design Système de l’État.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Hero de page</strong> : Trois variantes disponibles pour des introductions impactantes sur vos pages clés.</li>\n\n\n\n<li><strong>Accordéons et FAQ</strong> : Idéal pour organiser des contenus denses tout en assurant une navigation fluide.</li>\n\n\n\n<li><strong>Tuiles et mises en avant</strong> : Pour structurer visuellement les informations essentielles.</li>\n\n\n\n<li><strong>Blocs médias</strong> : Intégrez images, vidéos ou documents téléchargeables avec un design optimisé DSFR.</li>\n\n\n\n<li><strong>Onglets et boutons</strong> : Pour hiérarchiser l’information et mettre en avant les éléments clés.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img width=\"1024\" height=\"512\" src=\"https://beapi.fr/app/uploads/2025/03/image-7-1024x512-1.jpg\" alt=\"\" class=\"wp-image-7030\" //></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Navigation et templates prédéfinis</h3>\n\n\n\n<p><strong>Menus personnalisables</strong> : Configurez votre navigation en quelques clics pour l’adapter aux besoins de votre site.</p>\n\n\n\n<p><strong>Templates prêts à l’emploi</strong> : Des modèles préconçus facilitent la mise en production et assurent une cohérence graphique et fonctionnelle.</p>\n\n\n\n<p><strong>Accessibilité</strong> : Chaque composant du WP-DFSR a été conçu pour respecter les normes RGAA 4, garantissant une expérience fluide et accessible à tous les utilisateurs.</p>\n\n\n\n<h2 class=\"wp-block-heading\">IV. Contribuer au WP-DFSR : un projet ouvert à tous</h2>\n\n\n\n<p>Le WP-DFSR est un projet mené par Be API, mais pour qu’il devienne une référence encore plus forte dans l’écosystème public, <strong>nous avons besoin de contributions venues directement des organismes gouvernementaux et des collectivités</strong>. Votre expertise et votre implication peuvent faire la différence pour façonner un outil qui répond encore mieux aux attentes des institutions. Vous souhaitez l’améliorer ou y ajouter de nouvelles fonctionnalités ? Voici comment vous pouvez participer !</p>\n\n\n\n<h3 class=\"wp-block-heading\">Comment contribuer techniquement ?</h3>\n\n\n\n<p>La gestion du projet se fait sur <a href=\"https://github.com/beapi/wp-dsfr\">GitHub,</a> où vous pouvez proposer des améliorations ou signaler des problèmes. :</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Forkez le dépôt GitHub</strong> : Rendez-vous sur le <a href=\"https://github.com/beapi/wp-dsfr\">dépôt officiel du WP-DFSR</a>, et forkez le projet pour travailler sur votre propre version.</li>\n\n\n\n<li><strong>Créez une branche dédiée</strong> : Travaillez sur une branche spécifique pour chaque contribution (ex. : feature/new-block ou fix/accessibility).</li>\n\n\n\n<li><strong>Apportez vos modifications</strong> : Ajoutez des améliorations, qu’il s’agisse de nouveaux blocs, d’ajustements CSS ou de documentation.</li>\n\n\n\n<li><strong>Soumettez une pull request (PR)</strong> : Une fois vos modifications terminées, créez une PR vers la branche principale du dépôt. Décrivez clairement votre contribution et son impact dans le commentaire de la PR.</li>\n</ol>\n\n\n\n<figure class=\"wp-block-image size-full\"><img width=\"1024\" height=\"512\" src=\"https://beapi.fr/app/uploads/2025/03/image-8-1024x512-1.jpg\" alt=\"\" class=\"wp-image-7008\" //></figure>\n\n\n\n<p>👉 <strong>Si vous travaillez dans une institution publique, votre contribution est essentielle.</strong> En participant au développement du WP-DFSR, vous permettez au projet d’évoluer en adéquation avec les besoins réels des administrations et favorisez son adoption au sein des instances officielles.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Processus de validation des contributions</h3>\n\n\n\n<p>Chaque contribution est examinée par l’équipe Be API avant d’être intégrée au projet.</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Vérification de la conformité avec le Design System et les normes RGAA.</li>\n\n\n\n<li>Revue du code pour garantir sa qualité et son intégration harmonieuse.</li>\n\n\n\n<li>Tests pour s’assurer que la modification fonctionne correctement.</li>\n</ol>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusion</h2>\n\n\n\n<p>Le WP-DFSR n’est pas seulement un outil technique : c’est une solution pensée pour simplifier la création de sites institutionnels conformes, tout en privilégiant la collaboration et l’innovation.</p>\n\n\n\n<p>Avec ses fonctionnalités prêtes à l’emploi et son approche open source, il permet de déployer rapidement des sites respectant les normes du DSFR et du RGAA, tout en laissant la liberté de personnaliser et d’améliorer l’outil selon les besoins. En l’adoptant, vous accédez à une solution clé en main pour vos projets web publics.</p>\n\n\n\n<p>Et si vous souhaitez aller plus loin, vous pouvez aussi contribuer à son évolution !</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wp-dsfr.fr/\"><strong>Téléchargez le WP-DFSR dès aujourd’hui</strong></a> et découvrez ses fonctionnalités.</li>\n\n\n\n<li><a href=\"https://github.com/beapi/wp-dsfr\"><strong>Contribuez à son évolution</strong></a> en partageant vos idées.</li>\n\n\n\n<li><strong>Restez informé des évolutions du projet</strong> : Inscrivez-vous à notre newsletter ou suivez-nous sur nos réseaux sociaux pour ne rien manquer des dernières mises à jour et nouveautés.</li>\n</ul>\n<p>The post <a href=\"https://beapi.fr/blog/comment-utiliser-le-wp-dfsr-pour-vos-projets-institutionnels-wordpress/\">Comment utiliser le WP-DFSR pour vos projets institutionnels WordPress ?</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://kinsta.com/fr/blog/visite-virtuelle-campus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Ajoutez une visite virtuelle du campus au site WordPress de votre école\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:51:\"https://kinsta.com/fr/blog/visite-virtuelle-campus/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-20T09:15:56.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-20T09:15:56.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:281:\"L’époque où les étudiants devaient se rendre en personne sur un campus pour se faire une idée de l’environnement est révolue. Grâce aux visites virtuelles de ...\nThe post Ajoutez une visite virtuelle du campus au site WordPress de votre école appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:420:\"\n        <p>L&#8217;époque où les étudiants devaient se rendre en personne sur un campus pour se faire une idée de l&#8217;environnement est révolue. Grâce aux visites virtuelles de ...</p>\n<p>The post <a href=\"https://kinsta.com/fr/blog/visite-virtuelle-campus/\">Ajoutez une visite virtuelle du campus au site WordPress de votre école</a> appeared first on <a href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Steve Bonisteel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://kinsta.com/fr/blog/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://www.seomix.fr/ai-overviews-impact-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"AI Overviews de Google : quel impact sur votre SEO et comment s’y préparer ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:46:\"https://www.seomix.fr/ai-overviews-impact-seo/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-19T12:56:17.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-19T12:56:17.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:252:\"Google continue de déployer les AI Overviews, ses résumés IA qui s’affichent sur les résultats. Tous nos conseils pour adapter votre stratégie SEO.Lire la suite : AI Overviews de Google : quel impact sur votre SEO et comment s’y préparer ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:356:\"\n        Google continue de déployer les AI Overviews, ses résumés IA qui s’affichent sur les résultats. Tous nos conseils pour adapter votre stratégie SEO.<br><strong>Lire la suite :</strong> <a href=\"https://www.seomix.fr/ai-overviews-impact-seo/\">AI Overviews de Google&#160;: quel impact sur votre SEO et comment s’y préparer&#160;?</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Valentin Barrière\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://www.seomix.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"SeoMix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpmarmite.com/erreur-504/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Erreur 504 Gateway Timeout : le guide complet pour la résoudre\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:33:\"https://wpmarmite.com/erreur-504/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-11T09:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-11T09:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"Avez-vous déjà croisé une erreur 504 Gateway Timeout en surfant sur le web ou en gérant votre site WordPress ? Si oui, vous savez à quel point ce message peut être frustrant. Un écran qui refuse de charger, un site...\nErreur 504 Gateway Timeout : le guide complet pour la résoudre est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:721:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2025/03/cover-504-gateway-time-out.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Comment résoudre l&#039;erreur 504 Gateway Timeout\" //></p>\n<p>Avez-vous déjà croisé une erreur 504 Gateway Timeout en surfant sur le web ou en gérant votre site WordPress ? Si oui, vous savez à quel point ce message peut être frustrant. Un écran qui refuse de charger, un site...</p>\n<p><a href=\"https://wpmarmite.com/erreur-504/\">Erreur 504 Gateway Timeout : le guide complet pour la résoudre</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Équipe WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://vincentdubroeucq.com/pourquoi-utiliser-un-block-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Pourquoi utiliser un Block Theme ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:62:\"https://vincentdubroeucq.com/pourquoi-utiliser-un-block-theme/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-10T11:13:54.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-10T11:13:54.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:707:\"Depuis WordPress 5.9, l’écosystème des thèmes WordPress bouge énormément. L’éditeur de contenu (le Block Editor) avait déjà révolutionné l’édition du contenu de nos pages en nous proposant une interface nouvelle et un fonctionnement à base de blocs. Ce nouvel éditeur met à notre disposition des blocs flexibles qui permettent de créer du contenu à la mise en page riche et variée. Ce système de blocs s’applique désormais aux thèmes entiers : ce sont les Block Themes. L’éditeur de site permet de modifier vos modèles de pages complets et de les construire à l’aide des blocs proposés par le cœur de WordPress. […]Lire la suite : Pourquoi utiliser un Block Theme ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:847:\"\n        Depuis WordPress 5.9, l&#8217;écosystème des thèmes WordPress bouge énormément. L&#8217;éditeur de contenu (le Block Editor) avait déjà révolutionné l&#8217;édition du contenu de nos pages en nous proposant une interface nouvelle et un fonctionnement à base de blocs. Ce nouvel éditeur met à notre disposition des blocs flexibles qui permettent de créer du contenu à la mise en page riche et variée. Ce système de blocs s&#8217;applique désormais aux thèmes entiers : ce sont les Block Themes. L&#8217;éditeur de site permet de modifier vos modèles de pages complets et de les construire à l&#8217;aide des blocs proposés par le cœur de WordPress. [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://vincentdubroeucq.com/pourquoi-utiliser-un-block-theme/\">Pourquoi utiliser un Block Theme ?</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Vincent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://vincentdubroeucq.com/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vincent Dubroeucq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://promatec.digital/blog/2025/03/10/comment-resoudre-lattaque-ultra-seo-processor-et-securiser-votre-site-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Comment résoudre l’attaque Ultra SEO Processor et sécuriser votre site WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:121:\"https://promatec.digital/blog/2025/03/10/comment-resoudre-lattaque-ultra-seo-processor-et-securiser-votre-site-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-10T11:06:43.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-10T11:06:43.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:518:\"Une vaste campagne de cyberattaques vient de frapper la communauté WordPress, compromettant plus de 1000 sites web avec un système sophistiqué de backdoors multiples. Au cœur de cette attaque : un faux plugin baptisé “Ultra SEO Processor” qui, une fois installé, ouvre plusieurs voies d’accès aux pirates. Votre site est-il vulnérable ? Comment détecter et […]\nL’article Comment résoudre l’attaque Ultra SEO Processor et sécuriser votre site WordPress est apparu en premier sur Promatec Digital.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:742:\"\n        <p>Une vaste campagne de cyberattaques vient de frapper la communauté WordPress, compromettant plus de 1000 sites web avec un système sophistiqué de backdoors multiples. Au cœur de cette attaque : un faux plugin baptisé &#8220;Ultra SEO Processor&#8221; qui, une fois installé, ouvre plusieurs voies d&#8217;accès aux pirates. Votre site est-il vulnérable ? Comment détecter et [&#8230;]</p>\n<p>L’article <a href=\"https://promatec.digital/blog/2025/03/10/comment-resoudre-lattaque-ultra-seo-processor-et-securiser-votre-site-wordpress/\">Comment résoudre l&#8217;attaque Ultra SEO Processor et sécuriser votre site WordPress</a> est apparu en premier sur <a href=\"https://promatec.digital\">Promatec Digital</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Promatec Digital\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://promatec.digital/blog/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Promatec\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://jasonrouet.com/meetup-wordpress-la-rochelle-this-is-the-end/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Meetup WordPress La Rochelle : this is the end.\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:68:\"https://jasonrouet.com/meetup-wordpress-la-rochelle-this-is-the-end/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-07T23:36:08.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-03-07T23:36:08.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Merci de me lire et bravo pour l\'utilisation de ce flux RSS, bonne lecture sur votre lecteur de flux préféré !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:8821:\"\n        <p>Merci de me lire et bravo pour l\'utilisation de ce flux RSS, bonne lecture sur votre lecteur de flux préféré ! &lt;3</p>\n\n<p>Je repartage sur mon blog le message que je viens d&rsquo;envoyer à l&rsquo;ensemble des membres du <a href=\"https://www.meetup.com/wordpress-la-rochelle/\">Meetup WordPress de La Rochelle</a>.</p>\n\n\n\n<p>Cette décision s&rsquo;est imposée à Coralie, Loïc, Nicolas et moi de façon assez naturelle après plusieurs meetups ne regroupant que 5 ou 6 personnes.</p>\n\n\n\n<p>Cela ne veut pas dire que nous n&rsquo;organiseront pas d&rsquo;autres événements autour de WordPress, mais clairement de nombreuses communautés et villes ont du mal à faire perdurer leurs meetups en présentiel ces dernières années.</p>\n\n\n\n<p>J&rsquo;ai l&rsquo;impression que depuis la période Covid, les habitues changent : pour les événements liés au monde professionel, le public ne souhaite moins dédier du temps en dehors des plages du travail pour des meetups. Peut-être que cela fonctionnerait mieux sous la forme de petit déj ou déj comme le font les réseaux comme Digital Bay ou le SPN par exemple. Peut-être aussi tout simplement qu&rsquo;il n&rsquo;y a pas d&rsquo;écosystème numérique suffisament dense sur La Rochelle pour ce que nous proposions. Ou encore que l&rsquo;attrait pour des événements liés à WordPress a baissé : plus de ressources de qualité en ligne, moins d&rsquo;attrait pour WordPress, la lassitude face à des conférences après des années à mater des confés/meetups en ligne ?</p>\n\n\n\n<p>Seul l&rsquo;avenir nous le dira, je pense surtout que l&rsquo;absence d&rsquo;écosystème local et aussi l&rsquo;absence d&rsquo;un lieu identifié pour les pros du numérique n&rsquo;aide pas à organiser ce type d&rsquo;événement. Il n&rsquo;y a pas d&rsquo;habitude pour les entreprises locales d&rsquo;héberger des événements ou de coworking importants qui pourraient aider en attirant plus facilement du monde.</p>\n\n\n\n<p>C&rsquo;est dommage, mais ce n&rsquo;est pas triste pour autant. On aura beaucoup appris et l&rsquo;on se sera bien amusés depuis le relancement du meetup il y a 2 ans.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<p><strong>Voici le message envoyé il y a quelques minutes à l&rsquo;ensemble des membres du Meetup :</strong></p>\n\n\n\n<div class=\"wp-block-group is-vertical is-layout-flex wp-container-core-group-is-layout-1 wp-block-group-is-layout-flex\">\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>À tous les membres du Meetup,</p>\n\n\n\n<p>Coralie, Loïc, Nicolas et moi nous sommes réunis récemment pour évoquer la situation du Meetup WordPress La Rochelle et nous avons décidé d&rsquo;annuler les prochains événements de la saison en cours. Cette décision n&rsquo;a pas été facile à prendre, mais il est devenu clair depuis plusieurs événements que cela ne nous convient plus.</p>\n\n\n\n<p>Je profite donc de ce message pour vous expliquer la raison de notre décision. Depuis que j&rsquo;ai relancé le Meetup WordPress de La Rochelle en Juin 2023, nous avons organisé avec Coralie Tixeront, puis de Loïc Trihan et Nicolas Richer qui nous ont rejoints rapidement, 9 événements à La Rochelle dans 5 lieux différents. Le dernier ayant eu lieu le 17 janvier dernier.</p>\n\n\n\n<p>Force est de constater que l&rsquo;enthousiasme des premières rencontres, avec 15 à 20 personnes, a rapidement décliné pour finir par ne rassembler qu&rsquo;une poignée de personnes.</p>\n\n\n\n<p>Pourtant en parallèle, nous avons eu l&rsquo;impression de faire de plus en plus d&rsquo;efforts. Nous avons trouvé des sponsors, ce qui nous a permis de louer des salles confortables aux Cabanes Urbains ou au coworking Le Bastion. Nous pouvions offrir une tournée de boisson, plus des planches. Nicolas et Loïc ont pris le relai sur la communication, Coralie prenait le temps de prendre des photos pour valoriser les orateurs/oratrices et le groupe. Bref, on a engagé de l&rsquo;énergie et du temps à tenter de faire décoler le Meetup. Tout cela de façon totalement bénévole, sans enjeux business caché. C&rsquo;était du pur « giving back » dans l&rsquo;esprit du libre et de l&rsquo;opensource, qui nous anime depuis toujours.</p>\n\n\n\n<p>Malgré cela, nous n&rsquo;avons pas réussi à fédérer un groupe important autour de nous malgré la fidélité d&rsquo;un petit noyau d&rsquo;habitués. En tant qu&rsquo;organisateurs, nous avons investi beaucoup de temps et d&rsquo;énergie pour rendre ces événements possibles, pour un résultat mitigé. Nous n&rsquo;avions pas d&rsquo;énormes attentes en terme de fréquentation, mais la participation déclinante était évidente sur nos derniers événements.</p>\n\n\n\n<p>Alors nous nous sommes interrogé : trop axé sur WordPress, des horaires mal adaptés, une fréquence trop espacée, un lieu trop peu accessible ? À toutes ces questions, nous ne pouvions que nous résigner : nous avons tenté des sujets plus transversaux (accessibilité, écoconception par exemple) ou inversement plus technique avec la venue de Pierre Lannoy sans que cela n&rsquo;influence le déclin de la fréquentation. Et pour les horaires et la fréquence, seule Coralie habite La Rochelle, cela ne nous semblait pas jouable de changer de créneau/fréquence. Pour le lieu, nos différents tests n&rsquo;ont pas eu d&rsquo;influence. Si l&rsquo;on couple cela au fait qu&rsquo;une partie de notre équipe a désormais des disponibilités réduites, cela rend encore plus difficile la poursuite de nos activités.</p>\n\n\n\n<p>Pour résumer : nous avons l&rsquo;impression de « brasser du vent » et que notre Meetup ne trouve pas son public, malgré nos efforts.</p>\n\n\n\n<p>Concrètement : à moins que d&rsquo;autres membres du Meetup ne nous contacte pour nous aider à redresser la barre, je me donne jusqu&rsquo;à la fin du mois pour contacter nos sponsors pour mettre fin aux partenariats. Puis je demanderai à l&rsquo;équipe Communauté de WordPress.org d&rsquo;archiver le Meetup.</p>\n\n\n\n<p>À titre personnel, j&rsquo;ai passé de bons moments à discuter avec vous de WordPress, de qualité web, d&rsquo;écoconception, d&rsquo;accessibilité, de no/low code, de contribution opensource, de drama, de business, de dire du mal de Wix, de e-commerce, de prendre des bières et des tapas&#8230;</p>\n\n\n\n<p>En bref, j&rsquo;ai pu faire de belles rencontres et passé du temps avec des personnes de qualité et cela faisait du bien d&rsquo;organiser un Meetup alors que ces groupes avaient presque tous disparu depuis la période du Covid.</p>\n\n\n\n<p>Mais ce n&rsquo;est qu&rsquo;un au revoir, si WordPress vous intéresse, le WordCamp Toulouse sera organisé le 23 mai prochain (le site devrait rapidement être en ligne ici : <a href=\"https://toulouse.wordcamp.org/2025/\" rel=\"nofollow\">https://toulouse.wordcamp.org/2025/</a>).</p>\n\n\n\n<p>Vous pouvez aussi suivre <a href=\"https://wpfr.net\">l&rsquo;association WordPress Francophone (WPFR)</a> ou <a href=\"https://join.slack.com/t/wordpressfr/shared_invite/zt-1oq8gg079-cvrxrBjX9FpD9dDGytIY_g\">rejoindre le Slack communautaire</a> pour trouver de l&rsquo;aide.</p>\n\n\n\n<p><strong>Je termine ce message par quelques remerciements :</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Merci au petit groupe de fidèles : Hélène, Noémie, Isabelle, Alexandre, Michael, Maxime, Franck, Vincent, Manu. Et plus globalement, merci à celles et ceux qui ont eu la curiosité, la patience et la gourmandise de nous rejoindre à l&rsquo;un de nos meetups.</li>\n\n\n\n<li>Merci à : Nicolas Richer, Hélène Bruggeman, Michael Lardeux, Alexandre Achain, Pierre Lannoy pour leurs conférences éclairantes.</li>\n\n\n\n<li>Merci aux équipes de Licence Professionnelle MIAW de l&rsquo;Université de La Rochelle, de Digital Bay, des Cabanes Urbaines, du Bathyscaphe, du Bastion pour leur soutien et accueil.</li>\n\n\n\n<li>Merci à l&rsquo;équipe de Crisp (en particulier Antoine Goret) et O2Switch (en particulier Manon Foraison) pour le soutien financier et logistique fourni.</li>\n</ul>\n\n\n\n<p>À bientôt tout le monde,</p>\n\n\n\n<p>Jason Rouet, organisateur principal du Meetup WordPress de La Rochelle</p>\n</blockquote>\n</div>\n<img src=\"https://stats.station.software/piwik.php?idsite=1&amp;rec=1&amp;url=https%3A%2F%2Fjasonrouet.com%2Fmeetup-wordpress-la-rochelle-this-is-the-end%2F&amp;action_name=Meetup+WordPress+La+Rochelle+%3A+this+is+the+end.&amp;urlref=https%3A%2F%2Fjasonrouet.com%2Ffeed%2F\" style=\"border:0;width:0;height:0\" width=\"0\" height=\"0\" alt=\"\" //><p>L’article <a href=\"https://jasonrouet.com/meetup-wordpress-la-rochelle-this-is-the-end/\">Meetup WordPress La Rochelle : this is the end.</a> a été publié sur le site suivant : https://jasonrouet.com/.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jason ROUET\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://jasonrouet.com/categorie/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jason Rouet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://yesweblog.fr/wordpress-bug-flux-feed-rss-envoie-vers-page-d-accueil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WordPress : Bug du flux feed RSS qui envoie vers la page d’accueil\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:76:\"https://yesweblog.fr/wordpress-bug-flux-feed-rss-envoie-vers-page-d-accueil/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-02-17T14:53:44.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-02-17T14:53:44.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:496:\"Nouvel Article\n\n	\n	\n	Il arrive que nous ayons besoin de connaître puis de saisir l’adresse du flux RSS de notre site WordPress. Que ce soit pour soumettre ce flux à un quelconque agrégateur de contenu ou encore plus fréquemment, quand il s’agit de saisir cette adresse web dans un outil de Newsletter afin d’automatiser l’envoi de son Infolettre […]\n- Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:848:\"\n        <p>Nouvel Article</p>\n<div>\n	<a href=\"https://yesweblog.fr/wordpress-bug-flux-feed-rss-envoie-vers-page-d-accueil/\"><img title=\"cron wordpress\" src=\"https://yesweblog.fr/wp-content/uploads/2025/01/cron-wordpress-300x200.webp\" alt=\"cron wordpress\" width=\"300\" height=\"200\" //></a>\n	</div>\n<p>	Il arrive que nous ayons besoin de connaître puis de saisir l&#8217;adresse du flux RSS de notre site WordPress. Que ce soit pour soumettre ce flux à un quelconque agrégateur de contenu ou encore plus fréquemment, quand il s&#8217;agit de saisir cette adresse web dans un outil de Newsletter afin d&#8217;automatiser l&#8217;envoi de son Infolettre [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Griselidis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://holdmywp.com/checklist-securite-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Ma check-list de sécurité WordPress ✅\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:50:\"https://holdmywp.com/checklist-securite-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-02-02T13:24:54.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-02-02T13:24:54.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:210:\"Ma check-list de sécurité WordPress avec laquelle je travaille régulièrement. J’y compile un ensemble d’actions manuelles à effectuer pour renforcer la sécurité d’un site internet WordPress.\nSource\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:296:\"\n        Ma check-list de sécurité WordPress avec laquelle je travaille régulièrement. J’y compile un ensemble d’actions manuelles à effectuer pour renforcer la sécurité d’un site internet WordPress.\n<p><a href=\"https://holdmywp.com/checklist-securite-wordpress/\">Source</a></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Quentin Le Duff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"HoldMyWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wpchannel.com/wordpress/tutoriels-wordpress/bloquer-mails-indesirables-gravity-forms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Bloquer des e-mails indesirables avec Gravity Forms\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"https://wpchannel.com/wordpress/tutoriels-wordpress/bloquer-mails-indesirables-gravity-forms/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-21T14:14:53.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-21T14:14:53.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:396:\"Dans ce tutoriel, nous allons voir comment bloquer certaines adresses e-mail pour empêcher la soumission d’un formulaire Gravity Forms. Cette astuce repose sur un hook PHP qui permet d’assurer un contrôle optimal des soumissions. Une solution pratique et sécurisée pour les administrateurs WordPress soucieux de garder le contrôle sur leurs formulaires sans installer une extension […]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"\n        Dans ce tutoriel, nous allons voir comment bloquer certaines adresses e-mail pour empêcher la soumission d&#8217;un formulaire Gravity Forms. Cette astuce repose sur un hook PHP qui permet d&#8217;assurer un contrôle optimal des soumissions. Une solution pratique et sécurisée pour les administrateurs WordPress soucieux de garder le contrôle sur leurs formulaires sans installer une extension [&#8230;]\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpchannel.com/feed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:12:\"nginx/1.27.0\";s:4:\"date\";s:29:\"Sat, 22 Mar 2025 10:01:57 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:12:\"x-powered-by\";s:10:\"PHP/8.0.30\";s:13:\"last-modified\";s:29:\"Fri, 01 Dec 2023 22:13:18 GMT\";s:4:\"etag\";s:34:\"\"c11b85e08f9a55c369b83cdc4e5e720f\"\";s:4:\"link\";s:57:\"<https://rss.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:25:\"strict-transport-security\";s:16:\"max-age=63072000\";}}s:5:\"build\";i:1738953816;s:21:\"cache_expiration_time\";i:1742684367;s:23:\"__cache_expiration_time\";i:1742684367;}", "off");
INSERT INTO `wp_obs_options` VALUES("39337", "_transient_timeout_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1742684367", "off");
INSERT INTO `wp_obs_options` VALUES("39338", "_transient_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1742641167", "off");
INSERT INTO `wp_obs_options` VALUES("39339", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1742684367", "off");
INSERT INTO `wp_obs_options` VALUES("39340", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\'>WordPress 6.7 « Rollins »</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\'>Guide des changements techniques de WordPress 6.7</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://beapi.fr/blog/comment-utiliser-le-wp-dfsr-pour-vos-projets-institutionnels-wordpress/\'>Comment utiliser le WP-DFSR pour vos projets institutionnels WordPress ?</a></li><li><a class=\'rsswidget\' href=\'https://kinsta.com/fr/blog/visite-virtuelle-campus/\'>Ajoutez une visite virtuelle du campus au site WordPress de votre école</a></li><li><a class=\'rsswidget\' href=\'https://www.seomix.fr/ai-overviews-impact-seo/\'>AI Overviews de Google : quel impact sur votre SEO et comment s’y préparer ?</a></li></ul></div>", "off");
INSERT INTO `wp_obs_options` VALUES("39478", "_transient_timeout_neve_381versions", "1743074034", "off");
INSERT INTO `wp_obs_options` VALUES("39479", "_transient_neve_381versions", "a:183:{i:0;a:2:{s:7:\"version\";s:5:\"1.0.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.0.4.zip\";}i:1;a:2:{s:7:\"version\";s:5:\"1.0.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.0.5.zip\";}i:2;a:2:{s:7:\"version\";s:5:\"1.0.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.0.6.zip\";}i:3;a:2:{s:7:\"version\";s:5:\"1.0.8\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.0.8.zip\";}i:4;a:2:{s:7:\"version\";s:5:\"1.0.9\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.0.9.zip\";}i:5;a:2:{s:7:\"version\";s:6:\"1.0.10\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.10.zip\";}i:6;a:2:{s:7:\"version\";s:6:\"1.0.11\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.11.zip\";}i:7;a:2:{s:7:\"version\";s:6:\"1.0.12\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.12.zip\";}i:8;a:2:{s:7:\"version\";s:6:\"1.0.13\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.13.zip\";}i:9;a:2:{s:7:\"version\";s:6:\"1.0.14\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.14.zip\";}i:10;a:2:{s:7:\"version\";s:6:\"1.0.15\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.15.zip\";}i:11;a:2:{s:7:\"version\";s:6:\"1.0.16\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.16.zip\";}i:12;a:2:{s:7:\"version\";s:6:\"1.0.18\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.18.zip\";}i:13;a:2:{s:7:\"version\";s:6:\"1.0.19\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.19.zip\";}i:14;a:2:{s:7:\"version\";s:6:\"1.0.20\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.20.zip\";}i:15;a:2:{s:7:\"version\";s:6:\"1.0.21\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.21.zip\";}i:16;a:2:{s:7:\"version\";s:6:\"1.0.22\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.22.zip\";}i:17;a:2:{s:7:\"version\";s:6:\"1.0.23\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.23.zip\";}i:18;a:2:{s:7:\"version\";s:6:\"1.0.24\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.24.zip\";}i:19;a:2:{s:7:\"version\";s:6:\"1.0.25\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.25.zip\";}i:20;a:2:{s:7:\"version\";s:6:\"1.0.26\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.26.zip\";}i:21;a:2:{s:7:\"version\";s:6:\"1.0.27\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.27.zip\";}i:22;a:2:{s:7:\"version\";s:6:\"1.0.28\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.28.zip\";}i:23;a:2:{s:7:\"version\";s:6:\"1.0.29\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.1.0.29.zip\";}i:24;a:2:{s:7:\"version\";s:5:\"1.1.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.1.0.zip\";}i:25;a:2:{s:7:\"version\";s:5:\"1.1.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.1.1.zip\";}i:26;a:2:{s:7:\"version\";s:5:\"1.1.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.1.2.zip\";}i:27;a:2:{s:7:\"version\";s:5:\"1.1.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.1.3.zip\";}i:28;a:2:{s:7:\"version\";s:5:\"1.1.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.1.1.4.zip\";}i:29;a:2:{s:7:\"version\";s:5:\"2.0.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.0.0.zip\";}i:30;a:2:{s:7:\"version\";s:5:\"2.1.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.1.0.zip\";}i:31;a:2:{s:7:\"version\";s:5:\"2.2.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.2.0.zip\";}i:32;a:2:{s:7:\"version\";s:5:\"2.3.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.1.zip\";}i:33;a:2:{s:7:\"version\";s:5:\"2.3.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.2.zip\";}i:34;a:2:{s:7:\"version\";s:5:\"2.3.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.3.zip\";}i:35;a:2:{s:7:\"version\";s:5:\"2.3.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.4.zip\";}i:36;a:2:{s:7:\"version\";s:5:\"2.3.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.5.zip\";}i:37;a:2:{s:7:\"version\";s:5:\"2.3.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.6.zip\";}i:38;a:2:{s:7:\"version\";s:5:\"2.3.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.7.zip\";}i:39;a:2:{s:7:\"version\";s:5:\"2.3.8\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.8.zip\";}i:40;a:2:{s:7:\"version\";s:5:\"2.3.9\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.3.9.zip\";}i:41;a:2:{s:7:\"version\";s:6:\"2.3.10\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.10.zip\";}i:42;a:2:{s:7:\"version\";s:6:\"2.3.11\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.11.zip\";}i:43;a:2:{s:7:\"version\";s:6:\"2.3.12\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.12.zip\";}i:44;a:2:{s:7:\"version\";s:6:\"2.3.14\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.14.zip\";}i:45;a:2:{s:7:\"version\";s:6:\"2.3.15\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.15.zip\";}i:46;a:2:{s:7:\"version\";s:6:\"2.3.17\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.17.zip\";}i:47;a:2:{s:7:\"version\";s:6:\"2.3.19\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.19.zip\";}i:48;a:2:{s:7:\"version\";s:6:\"2.3.20\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.20.zip\";}i:49;a:2:{s:7:\"version\";s:6:\"2.3.21\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.21.zip\";}i:50;a:2:{s:7:\"version\";s:6:\"2.3.22\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.3.22.zip\";}i:51;a:2:{s:7:\"version\";s:5:\"2.4.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.4.0.zip\";}i:52;a:2:{s:7:\"version\";s:5:\"2.4.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.4.1.zip\";}i:53;a:2:{s:7:\"version\";s:5:\"2.4.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.4.2.zip\";}i:54;a:2:{s:7:\"version\";s:5:\"2.4.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.4.3.zip\";}i:55;a:2:{s:7:\"version\";s:5:\"2.5.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.5.1.zip\";}i:56;a:2:{s:7:\"version\";s:5:\"2.5.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.5.2.zip\";}i:57;a:2:{s:7:\"version\";s:5:\"2.5.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.5.3.zip\";}i:58;a:2:{s:7:\"version\";s:5:\"2.5.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.5.4.zip\";}i:59;a:2:{s:7:\"version\";s:5:\"2.6.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.0.zip\";}i:60;a:2:{s:7:\"version\";s:5:\"2.6.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.1.zip\";}i:61;a:2:{s:7:\"version\";s:5:\"2.6.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.2.zip\";}i:62;a:2:{s:7:\"version\";s:5:\"2.6.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.3.zip\";}i:63;a:2:{s:7:\"version\";s:5:\"2.6.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.4.zip\";}i:64;a:2:{s:7:\"version\";s:5:\"2.6.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.5.zip\";}i:65;a:2:{s:7:\"version\";s:5:\"2.6.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.6.6.zip\";}i:66;a:2:{s:7:\"version\";s:5:\"2.7.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.0.zip\";}i:67;a:2:{s:7:\"version\";s:5:\"2.7.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.1.zip\";}i:68;a:2:{s:7:\"version\";s:5:\"2.7.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.2.zip\";}i:69;a:2:{s:7:\"version\";s:5:\"2.7.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.3.zip\";}i:70;a:2:{s:7:\"version\";s:5:\"2.7.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.4.zip\";}i:71;a:2:{s:7:\"version\";s:5:\"2.7.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.5.zip\";}i:72;a:2:{s:7:\"version\";s:5:\"2.7.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.6.zip\";}i:73;a:2:{s:7:\"version\";s:5:\"2.7.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.7.7.zip\";}i:74;a:2:{s:7:\"version\";s:5:\"2.8.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.8.0.zip\";}i:75;a:2:{s:7:\"version\";s:5:\"2.8.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.8.1.zip\";}i:76;a:2:{s:7:\"version\";s:5:\"2.8.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.8.2.zip\";}i:77;a:2:{s:7:\"version\";s:5:\"2.8.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.8.3.zip\";}i:78;a:2:{s:7:\"version\";s:5:\"2.8.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.8.4.zip\";}i:79;a:2:{s:7:\"version\";s:5:\"2.9.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.9.0.zip\";}i:80;a:2:{s:7:\"version\";s:5:\"2.9.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.9.1.zip\";}i:81;a:2:{s:7:\"version\";s:5:\"2.9.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.9.2.zip\";}i:82;a:2:{s:7:\"version\";s:5:\"2.9.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.9.3.zip\";}i:83;a:2:{s:7:\"version\";s:5:\"2.9.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.9.4.zip\";}i:84;a:2:{s:7:\"version\";s:5:\"2.9.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.2.9.5.zip\";}i:85;a:2:{s:7:\"version\";s:6:\"2.10.0\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.10.0.zip\";}i:86;a:2:{s:7:\"version\";s:6:\"2.10.1\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.10.1.zip\";}i:87;a:2:{s:7:\"version\";s:6:\"2.10.2\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.10.2.zip\";}i:88;a:2:{s:7:\"version\";s:6:\"2.10.3\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.10.3.zip\";}i:89;a:2:{s:7:\"version\";s:6:\"2.10.4\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.10.4.zip\";}i:90;a:2:{s:7:\"version\";s:6:\"2.11.0\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.0.zip\";}i:91;a:2:{s:7:\"version\";s:6:\"2.11.1\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.1.zip\";}i:92;a:2:{s:7:\"version\";s:6:\"2.11.2\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.2.zip\";}i:93;a:2:{s:7:\"version\";s:6:\"2.11.3\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.3.zip\";}i:94;a:2:{s:7:\"version\";s:6:\"2.11.4\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.4.zip\";}i:95;a:2:{s:7:\"version\";s:6:\"2.11.5\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.5.zip\";}i:96;a:2:{s:7:\"version\";s:6:\"2.11.6\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.2.11.6.zip\";}i:97;a:2:{s:7:\"version\";s:5:\"3.0.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.0.zip\";}i:98;a:2:{s:7:\"version\";s:5:\"3.0.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.1.zip\";}i:99;a:2:{s:7:\"version\";s:5:\"3.0.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.2.zip\";}i:100;a:2:{s:7:\"version\";s:5:\"3.0.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.3.zip\";}i:101;a:2:{s:7:\"version\";s:5:\"3.0.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.4.zip\";}i:102;a:2:{s:7:\"version\";s:5:\"3.0.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.5.zip\";}i:103;a:2:{s:7:\"version\";s:5:\"3.0.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.6.zip\";}i:104;a:2:{s:7:\"version\";s:5:\"3.0.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.7.zip\";}i:105;a:2:{s:7:\"version\";s:5:\"3.0.8\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.8.zip\";}i:106;a:2:{s:7:\"version\";s:5:\"3.0.9\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.0.9.zip\";}i:107;a:2:{s:7:\"version\";s:6:\"3.0.10\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.0.10.zip\";}i:108;a:2:{s:7:\"version\";s:6:\"3.0.11\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.0.11.zip\";}i:109;a:2:{s:7:\"version\";s:5:\"3.1.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.0.zip\";}i:110;a:2:{s:7:\"version\";s:5:\"3.1.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.1.zip\";}i:111;a:2:{s:7:\"version\";s:5:\"3.1.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.2.zip\";}i:112;a:2:{s:7:\"version\";s:5:\"3.1.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.3.zip\";}i:113;a:2:{s:7:\"version\";s:5:\"3.1.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.4.zip\";}i:114;a:2:{s:7:\"version\";s:5:\"3.1.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.5.zip\";}i:115;a:2:{s:7:\"version\";s:5:\"3.1.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.1.6.zip\";}i:116;a:2:{s:7:\"version\";s:5:\"3.2.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.2.0.zip\";}i:117;a:2:{s:7:\"version\";s:5:\"3.2.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.2.1.zip\";}i:118;a:2:{s:7:\"version\";s:5:\"3.2.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.2.2.zip\";}i:119;a:2:{s:7:\"version\";s:5:\"3.2.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.2.3.zip\";}i:120;a:2:{s:7:\"version\";s:5:\"3.2.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.2.4.zip\";}i:121;a:2:{s:7:\"version\";s:5:\"3.2.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.2.5.zip\";}i:122;a:2:{s:7:\"version\";s:5:\"3.3.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.0.zip\";}i:123;a:2:{s:7:\"version\";s:5:\"3.3.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.1.zip\";}i:124;a:2:{s:7:\"version\";s:5:\"3.3.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.2.zip\";}i:125;a:2:{s:7:\"version\";s:5:\"3.3.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.3.zip\";}i:126;a:2:{s:7:\"version\";s:5:\"3.3.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.4.zip\";}i:127;a:2:{s:7:\"version\";s:5:\"3.3.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.5.zip\";}i:128;a:2:{s:7:\"version\";s:5:\"3.3.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.6.zip\";}i:129;a:2:{s:7:\"version\";s:5:\"3.3.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.3.7.zip\";}i:130;a:2:{s:7:\"version\";s:5:\"3.4.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.0.zip\";}i:131;a:2:{s:7:\"version\";s:5:\"3.4.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.1.zip\";}i:132;a:2:{s:7:\"version\";s:5:\"3.4.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.2.zip\";}i:133;a:2:{s:7:\"version\";s:5:\"3.4.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.3.zip\";}i:134;a:2:{s:7:\"version\";s:5:\"3.4.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.4.zip\";}i:135;a:2:{s:7:\"version\";s:5:\"3.4.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.5.zip\";}i:136;a:2:{s:7:\"version\";s:5:\"3.4.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.6.zip\";}i:137;a:2:{s:7:\"version\";s:5:\"3.4.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.7.zip\";}i:138;a:2:{s:7:\"version\";s:5:\"3.4.8\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.8.zip\";}i:139;a:2:{s:7:\"version\";s:5:\"3.4.9\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.4.9.zip\";}i:140;a:2:{s:7:\"version\";s:6:\"3.4.10\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.4.10.zip\";}i:141;a:2:{s:7:\"version\";s:5:\"3.5.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.0.zip\";}i:142;a:2:{s:7:\"version\";s:5:\"3.5.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.1.zip\";}i:143;a:2:{s:7:\"version\";s:5:\"3.5.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.2.zip\";}i:144;a:2:{s:7:\"version\";s:5:\"3.5.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.3.zip\";}i:145;a:2:{s:7:\"version\";s:5:\"3.5.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.4.zip\";}i:146;a:2:{s:7:\"version\";s:5:\"3.5.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.5.zip\";}i:147;a:2:{s:7:\"version\";s:5:\"3.5.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.6.zip\";}i:148;a:2:{s:7:\"version\";s:5:\"3.5.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.7.zip\";}i:149;a:2:{s:7:\"version\";s:5:\"3.5.8\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.5.8.zip\";}i:150;a:2:{s:7:\"version\";s:5:\"3.6.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.0.zip\";}i:151;a:2:{s:7:\"version\";s:5:\"3.6.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.1.zip\";}i:152;a:2:{s:7:\"version\";s:5:\"3.6.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.2.zip\";}i:153;a:2:{s:7:\"version\";s:5:\"3.6.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.3.zip\";}i:154;a:2:{s:7:\"version\";s:5:\"3.6.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.4.zip\";}i:155;a:2:{s:7:\"version\";s:5:\"3.6.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.5.zip\";}i:156;a:2:{s:7:\"version\";s:5:\"3.6.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.6.zip\";}i:157;a:2:{s:7:\"version\";s:5:\"3.6.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.6.7.zip\";}i:158;a:2:{s:7:\"version\";s:5:\"3.7.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.7.0.zip\";}i:159;a:2:{s:7:\"version\";s:5:\"3.7.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.7.1.zip\";}i:160;a:2:{s:7:\"version\";s:5:\"3.7.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.7.2.zip\";}i:161;a:2:{s:7:\"version\";s:5:\"3.7.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.7.3.zip\";}i:162;a:2:{s:7:\"version\";s:5:\"3.7.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.7.4.zip\";}i:163;a:2:{s:7:\"version\";s:5:\"3.7.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.7.5.zip\";}i:164;a:2:{s:7:\"version\";s:5:\"3.8.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.0.zip\";}i:165;a:2:{s:7:\"version\";s:5:\"3.8.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.1.zip\";}i:166;a:2:{s:7:\"version\";s:5:\"3.8.2\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.2.zip\";}i:167;a:2:{s:7:\"version\";s:5:\"3.8.3\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.3.zip\";}i:168;a:2:{s:7:\"version\";s:5:\"3.8.4\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.4.zip\";}i:169;a:2:{s:7:\"version\";s:5:\"3.8.5\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.5.zip\";}i:170;a:2:{s:7:\"version\";s:5:\"3.8.6\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.6.zip\";}i:171;a:2:{s:7:\"version\";s:5:\"3.8.7\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.7.zip\";}i:172;a:2:{s:7:\"version\";s:5:\"3.8.8\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.8.zip\";}i:173;a:2:{s:7:\"version\";s:5:\"3.8.9\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.3.8.9.zip\";}i:174;a:2:{s:7:\"version\";s:6:\"3.8.10\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.10.zip\";}i:175;a:2:{s:7:\"version\";s:6:\"3.8.11\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.11.zip\";}i:176;a:2:{s:7:\"version\";s:6:\"3.8.12\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.12.zip\";}i:177;a:2:{s:7:\"version\";s:6:\"3.8.13\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.13.zip\";}i:178;a:2:{s:7:\"version\";s:6:\"3.8.14\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.14.zip\";}i:179;a:2:{s:7:\"version\";s:6:\"3.8.15\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.15.zip\";}i:180;a:2:{s:7:\"version\";s:6:\"3.8.16\";s:3:\"url\";s:53:\"https://downloads.wordpress.org/theme/neve.3.8.16.zip\";}i:181;a:2:{s:7:\"version\";s:5:\"4.0.0\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.4.0.0.zip\";}i:182;a:2:{s:7:\"version\";s:5:\"4.0.1\";s:3:\"url\";s:52:\"https://downloads.wordpress.org/theme/neve.4.0.1.zip\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("40377", "_transient_timeout_pods_fbbd3eacddfda2f0e09096bf285b0e4a", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40378", "_transient_pods_fbbd3eacddfda2f0e09096bf285b0e4a", "a:24:{s:2:\"ID\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:2:\"ID\";s:5:\"label\";s:2:\"ID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:1:{i:0;s:2:\"id\";}s:20:\"hide_in_default_form\";b:1;}s:10:\"post_title\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"post_title\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:2:{s:14:\"display_filter\";s:9:\"the_title\";s:19:\"display_filter_args\";a:1:{i:0;s:7:\"post_ID\";}}s:5:\"alias\";a:2:{i:0;s:5:\"title\";i:1;s:4:\"name\";}}s:12:\"post_content\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_content\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"wysiwyg\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:25:\"wysiwyg_allowed_html_tags\";s:0:\"\";s:21:\"wysiwyg_media_buttons\";i:1;s:14:\"display_filter\";s:11:\"the_content\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"content\";}}s:12:\"post_excerpt\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_excerpt\";s:5:\"label\";s:7:\"Excerpt\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:20:\"paragraph_allow_html\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";s:14:\"display_filter\";s:11:\"the_excerpt\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"excerpt\";}}s:11:\"post_author\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_author\";s:5:\"label\";s:6:\"Author\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:16:\"pick_format_type\";s:6:\"single\";s:18:\"pick_format_single\";s:12:\"autocomplete\";s:13:\"default_value\";s:10:\"{@user.ID}\";s:21:\"default_evaluate_tags\";i:1;}s:5:\"alias\";a:1:{i:0;s:6:\"author\";}s:11:\"pick_object\";s:4:\"user\";s:8:\"pick_val\";s:4:\"user\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";}s:9:\"post_date\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_date\";s:5:\"label\";s:12:\"Publish Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:7:\"created\";i:1;s:4:\"date\";}}s:13:\"post_date_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_date_gmt\";s:5:\"label\";s:18:\"Publish Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_status\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:5:\"draft\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:11:\"post-status\";s:18:\"pick_format_single\";s:8:\"dropdown\";s:5:\"alias\";a:1:{i:0;s:6:\"status\";}}s:14:\"comment_status\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"comment_status\";s:5:\"label\";s:14:\"Comment Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:0:\"\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}}s:11:\"ping_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"ping_status\";s:5:\"label\";s:11:\"Ping Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:4:\"open\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}s:20:\"hide_in_default_form\";b:1;}s:13:\"post_password\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_password\";s:5:\"label\";s:8:\"Password\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"password\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:20:\"hide_in_default_form\";b:1;}s:9:\"post_name\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_name\";s:5:\"label\";s:9:\"Permalink\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"slug\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:4:\"slug\";i:1;s:9:\"permalink\";}}s:7:\"to_ping\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:7:\"to_ping\";s:5:\"label\";s:7:\"To Ping\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:6:\"pinged\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:6:\"pinged\";s:5:\"label\";s:6:\"Pinged\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"post_modified\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_modified\";s:5:\"label\";s:18:\"Last Modified Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:8:\"modified\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:17:\"post_modified_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:17:\"post_modified_gmt\";s:5:\"label\";s:24:\"Last Modified Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:21:\"post_content_filtered\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:21:\"post_content_filtered\";s:5:\"label\";s:18:\"Content (filtered)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:7:{s:20:\"paragraph_allow_html\";i:1;s:16:\"paragraph_oembed\";i:1;s:21:\"paragraph_wptexturize\";i:1;s:23:\"paragraph_convert_chars\";i:1;s:17:\"paragraph_wpautop\";i:1;s:25:\"paragraph_allow_shortcode\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_parent\";a:26:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_parent\";s:5:\"label\";s:6:\"Parent\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:9:\"post_type\";s:8:\"pick_val\";s:11:\"__current__\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";s:5:\"alias\";a:1:{i:0;s:6:\"parent\";}s:4:\"data\";a:0:{}s:6:\"hidden\";b:1;}s:4:\"guid\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:4:\"guid\";s:5:\"label\";s:4:\"GUID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:10:\"menu_order\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"menu_order\";s:5:\"label\";s:10:\"Menu Order\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:0:{}}s:9:\"post_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_type\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:4:\"type\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:14:\"post_mime_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"post_mime_type\";s:5:\"label\";s:9:\"Mime Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"comment_count\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"comment_count\";s:5:\"label\";s:13:\"Comment Count\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:8:\"comments\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:8:\"comments\";s:5:\"label\";s:8:\"Comments\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"comment\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:19:\"comment_format_type\";s:5:\"multi\";}s:11:\"pick_object\";s:7:\"comment\";s:8:\"pick_val\";s:7:\"comment\";s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}}", "off");
INSERT INTO `wp_obs_options` VALUES("40379", "_transient_timeout_pods_f0c3c8cfc7fed25dcd821004f2342584", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40380", "_transient_pods_f0c3c8cfc7fed25dcd821004f2342584", "a:28:{s:11:\"object_type\";s:9:\"post_type\";s:4:\"type\";s:9:\"post_type\";s:11:\"object_name\";s:14:\"_pods_template\";s:19:\"object_hierarchical\";b:0;s:7:\"storage\";s:4:\"meta\";s:5:\"table\";s:12:\"wp_obs_posts\";s:10:\"meta_table\";s:15:\"wp_obs_postmeta\";s:9:\"pod_table\";s:26:\"wp_obs_pods__pods_template\";s:8:\"field_id\";s:2:\"ID\";s:11:\"field_index\";s:10:\"post_title\";s:10:\"field_slug\";s:9:\"post_name\";s:10:\"field_type\";s:9:\"post_type\";s:12:\"field_parent\";s:11:\"post_parent\";s:19:\"field_parent_select\";s:17:\"`t`.`post_parent`\";s:13:\"meta_field_id\";s:7:\"post_id\";s:16:\"meta_field_index\";s:8:\"meta_key\";s:16:\"meta_field_value\";s:10:\"meta_value\";s:12:\"pod_field_id\";s:2:\"id\";s:15:\"pod_field_index\";s:4:\"name\";s:14:\"pod_field_slug\";N;s:16:\"pod_field_parent\";N;s:4:\"join\";a:0:{}s:5:\"where\";a:1:{s:9:\"post_type\";s:34:\"`t`.`post_type` = \'_pods_template\'\";}s:13:\"where_default\";s:34:\"`t`.`post_status` IN ( \'publish\' )\";s:7:\"orderby\";s:51:\"`t`.`menu_order`, `t`.`post_title`, `t`.`post_date`\";s:3:\"pod\";O:16:\"Pods\\Whatsit\\Pod\":1:{s:7:\"\0*\0args\";a:19:{s:11:\"object_type\";s:3:\"pod\";s:19:\"object_storage_type\";s:10:\"collection\";s:4:\"name\";s:14:\"_pods_template\";s:2:\"id\";s:0:\"\";s:6:\"parent\";s:0:\"\";s:5:\"group\";s:0:\"\";s:5:\"label\";s:13:\"Pod Templates\";s:11:\"description\";s:0:\"\";s:8:\"internal\";b:1;s:4:\"type\";s:9:\"post_type\";s:7:\"storage\";s:4:\"meta\";s:14:\"label_singular\";s:12:\"Pod Template\";s:6:\"public\";i:0;s:7:\"show_ui\";i:1;s:11:\"rest_enable\";i:0;s:14:\"supports_title\";i:1;s:15:\"supports_editor\";i:0;s:15:\"supports_author\";i:1;s:18:\"supports_revisions\";i:1;}}s:7:\"recurse\";b:1;s:13:\"object_fields\";a:24:{s:2:\"ID\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:2:\"ID\";s:5:\"label\";s:2:\"ID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:1:{i:0;s:2:\"id\";}s:20:\"hide_in_default_form\";b:1;}s:10:\"post_title\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"post_title\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:2:{s:14:\"display_filter\";s:9:\"the_title\";s:19:\"display_filter_args\";a:1:{i:0;s:7:\"post_ID\";}}s:5:\"alias\";a:2:{i:0;s:5:\"title\";i:1;s:4:\"name\";}}s:12:\"post_content\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_content\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"wysiwyg\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:25:\"wysiwyg_allowed_html_tags\";s:0:\"\";s:21:\"wysiwyg_media_buttons\";i:1;s:14:\"display_filter\";s:11:\"the_content\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"content\";}}s:12:\"post_excerpt\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_excerpt\";s:5:\"label\";s:7:\"Excerpt\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:20:\"paragraph_allow_html\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";s:14:\"display_filter\";s:11:\"the_excerpt\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"excerpt\";}}s:11:\"post_author\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_author\";s:5:\"label\";s:6:\"Author\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:16:\"pick_format_type\";s:6:\"single\";s:18:\"pick_format_single\";s:12:\"autocomplete\";s:13:\"default_value\";s:10:\"{@user.ID}\";s:21:\"default_evaluate_tags\";i:1;}s:5:\"alias\";a:1:{i:0;s:6:\"author\";}s:11:\"pick_object\";s:4:\"user\";s:8:\"pick_val\";s:4:\"user\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";}s:9:\"post_date\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_date\";s:5:\"label\";s:12:\"Publish Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:7:\"created\";i:1;s:4:\"date\";}}s:13:\"post_date_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_date_gmt\";s:5:\"label\";s:18:\"Publish Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_status\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:5:\"draft\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:11:\"post-status\";s:18:\"pick_format_single\";s:8:\"dropdown\";s:5:\"alias\";a:1:{i:0;s:6:\"status\";}}s:14:\"comment_status\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"comment_status\";s:5:\"label\";s:14:\"Comment Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:0:\"\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}}s:11:\"ping_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"ping_status\";s:5:\"label\";s:11:\"Ping Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:4:\"open\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}s:20:\"hide_in_default_form\";b:1;}s:13:\"post_password\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_password\";s:5:\"label\";s:8:\"Password\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"password\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:20:\"hide_in_default_form\";b:1;}s:9:\"post_name\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_name\";s:5:\"label\";s:9:\"Permalink\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"slug\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:4:\"slug\";i:1;s:9:\"permalink\";}}s:7:\"to_ping\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:7:\"to_ping\";s:5:\"label\";s:7:\"To Ping\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:6:\"pinged\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:6:\"pinged\";s:5:\"label\";s:6:\"Pinged\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"post_modified\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_modified\";s:5:\"label\";s:18:\"Last Modified Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:8:\"modified\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:17:\"post_modified_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:17:\"post_modified_gmt\";s:5:\"label\";s:24:\"Last Modified Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:21:\"post_content_filtered\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:21:\"post_content_filtered\";s:5:\"label\";s:18:\"Content (filtered)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:7:{s:20:\"paragraph_allow_html\";i:1;s:16:\"paragraph_oembed\";i:1;s:21:\"paragraph_wptexturize\";i:1;s:23:\"paragraph_convert_chars\";i:1;s:17:\"paragraph_wpautop\";i:1;s:25:\"paragraph_allow_shortcode\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_parent\";a:26:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_parent\";s:5:\"label\";s:6:\"Parent\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:9:\"post_type\";s:8:\"pick_val\";s:11:\"__current__\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";s:5:\"alias\";a:1:{i:0;s:6:\"parent\";}s:4:\"data\";a:0:{}s:6:\"hidden\";b:1;}s:4:\"guid\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:4:\"guid\";s:5:\"label\";s:4:\"GUID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:10:\"menu_order\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"menu_order\";s:5:\"label\";s:10:\"Menu Order\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:0:{}}s:9:\"post_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_type\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:4:\"type\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:14:\"post_mime_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"post_mime_type\";s:5:\"label\";s:9:\"Mime Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"comment_count\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"comment_count\";s:5:\"label\";s:13:\"Comment Count\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:8:\"comments\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:8:\"comments\";s:5:\"label\";s:8:\"Comments\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"comment\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:19:\"comment_format_type\";s:5:\"multi\";}s:11:\"pick_object\";s:7:\"comment\";s:8:\"pick_val\";s:7:\"comment\";s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}}}", "off");
INSERT INTO `wp_obs_options` VALUES("40381", "_transient_timeout_pods_pods_related_objects-328", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40382", "_transient_pods_pods_related_objects-328", "a:29:{s:13:\"custom-simple\";a:3:{s:5:\"label\";s:36:\"Simple (liste définie manuellement)\";s:5:\"group\";s:13:\"Personnalisé\";s:6:\"simple\";b:1;}s:20:\"post_type-composante\";a:3:{s:5:\"label\";s:23:\"Composante (composante)\";s:5:\"group\";s:17:\"Types de contenus\";s:13:\"bidirectional\";b:1;}s:23:\"post_type-etablissement\";a:3:{s:5:\"label\";s:29:\"Etablissement (etablissement)\";s:5:\"group\";s:17:\"Types de contenus\";s:13:\"bidirectional\";b:1;}s:19:\"post_type-formation\";a:3:{s:5:\"label\";s:22:\"Formations (formation)\";s:5:\"group\";s:17:\"Types de contenus\";s:13:\"bidirectional\";b:1;}s:14:\"post_type-page\";a:3:{s:5:\"label\";s:12:\"Pages (page)\";s:5:\"group\";s:17:\"Types de contenus\";s:13:\"bidirectional\";b:1;}s:14:\"post_type-post\";a:3:{s:5:\"label\";s:15:\"Articles (post)\";s:5:\"group\";s:17:\"Types de contenus\";s:13:\"bidirectional\";b:1;}s:21:\"post_type-easy_charts\";a:3:{s:5:\"label\";s:25:\"Easy Charts (easy_charts)\";s:5:\"group\";s:29:\"Types de publication (privé)\";s:13:\"bidirectional\";b:1;}s:20:\"post_type-visualizer\";a:3:{s:5:\"label\";s:30:\"Visualizer Charts (visualizer)\";s:5:\"group\";s:29:\"Types de publication (privé)\";s:13:\"bidirectional\";b:1;}s:28:\"post_type-wpcf7_contact_form\";a:3:{s:5:\"label\";s:43:\"Formulaires de contact (wpcf7_contact_form)\";s:5:\"group\";s:29:\"Types de publication (privé)\";s:13:\"bidirectional\";b:1;}s:17:\"taxonomy-category\";a:3:{s:5:\"label\";s:22:\"Catégories (category)\";s:5:\"group\";s:10:\"Taxonomies\";s:13:\"bidirectional\";b:1;}s:22:\"taxonomy-link_category\";a:3:{s:5:\"label\";s:36:\"Catégories de liens (link_category)\";s:5:\"group\";s:10:\"Taxonomies\";s:13:\"bidirectional\";b:1;}s:17:\"taxonomy-post_tag\";a:3:{s:5:\"label\";s:22:\"Étiquettes (post_tag)\";s:5:\"group\";s:10:\"Taxonomies\";s:13:\"bidirectional\";b:1;}s:4:\"user\";a:3:{s:5:\"label\";s:12:\"Utilisateurs\";s:5:\"group\";s:16:\"Autres objets WP\";s:13:\"bidirectional\";b:1;}s:4:\"role\";a:4:{s:5:\"label\";s:22:\"Rôles d’utilisateur\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;O:14:\"PodsField_Pick\":0:{}i:1;s:10:\"data_roles\";}}s:10:\"capability\";a:4:{s:5:\"label\";s:30:\"Permissions de l’utilisateur\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:17:\"data_capabilities\";}}s:5:\"media\";a:3:{s:5:\"label\";s:6:\"Média\";s:5:\"group\";s:16:\"Autres objets WP\";s:13:\"bidirectional\";b:1;}s:7:\"comment\";a:3:{s:5:\"label\";s:12:\"Commentaires\";s:5:\"group\";s:16:\"Autres objets WP\";s:13:\"bidirectional\";b:1;}s:10:\"image-size\";a:4:{s:5:\"label\";s:17:\"Tailles d’image\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:16:\"data_image_sizes\";}}s:8:\"nav_menu\";a:2:{s:5:\"label\";s:19:\"Menus de navigation\";s:5:\"group\";s:16:\"Autres objets WP\";}s:11:\"post_format\";a:2:{s:5:\"label\";s:20:\"Formats d’articles\";s:5:\"group\";s:16:\"Autres objets WP\";}s:11:\"post-status\";a:4:{s:5:\"label\";s:17:\"État d’article\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:15:\"data_post_stati\";}}s:20:\"post-status-with-any\";a:4:{s:5:\"label\";s:42:\"État de la publication (le cas échéant)\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:24:\"data_post_stati_with_any\";}}s:10:\"post-types\";a:4:{s:5:\"label\";s:17:\"Post Type Objects\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:15:\"data_post_types\";}}s:10:\"taxonomies\";a:4:{s:5:\"label\";s:17:\"Objets taxonomies\";s:5:\"group\";s:16:\"Autres objets WP\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:15:\"data_taxonomies\";}}s:7:\"country\";a:4:{s:5:\"label\";s:4:\"Pays\";s:5:\"group\";s:20:\"Listes Prédéfinies\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:14:\"data_countries\";}}s:8:\"us_state\";a:4:{s:5:\"label\";s:11:\"États (US)\";s:5:\"group\";s:20:\"Listes Prédéfinies\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:14:\"data_us_states\";}}s:11:\"ca_province\";a:4:{s:5:\"label\";s:21:\"Provinces canadiennes\";s:5:\"group\";s:20:\"Listes Prédéfinies\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:17:\"data_ca_provinces\";}}s:12:\"days_of_week\";a:4:{s:5:\"label\";s:32:\"Calendrier - Jours de la semaine\";s:5:\"group\";s:20:\"Listes Prédéfinies\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:17:\"data_days_of_week\";}}s:14:\"months_of_year\";a:4:{s:5:\"label\";s:31:\"Calendrier - Mois de l’année\";s:5:\"group\";s:20:\"Listes Prédéfinies\";s:6:\"simple\";b:1;s:13:\"data_callback\";a:2:{i:0;r:59;i:1;s:19:\"data_months_of_year\";}}}", "off");
INSERT INTO `wp_obs_options` VALUES("40383", "_transient_timeout_pods_6827340ff2ef4982ed3648fcd439f4a9", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40384", "_transient_pods_6827340ff2ef4982ed3648fcd439f4a9", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40385", "_transient_timeout_pods_pods_components_refresh-328", "1742687189", "off");
INSERT INTO `wp_obs_options` VALUES("40386", "_transient_pods_pods_components_refresh-328", "1", "off");
INSERT INTO `wp_obs_options` VALUES("40387", "_transient_timeout_pods_pods_components-328", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40388", "_transient_pods_pods_components-328", "a:13:{s:22:\"advanced-content-types\";a:28:{s:2:\"ID\";s:22:\"advanced-content-types\";s:4:\"Name\";s:22:\"Advanced Content Types\";s:9:\"ShortName\";s:22:\"Advanced Content Types\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:22:\"Advanced Content Types\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:252:\"A content type that exists outside of the WordPress post and postmeta table and uses custom tables instead. You most likely don\'t need these and we strongly recommend that you use Custom Post Types or Custom Taxonomies instead. FOR ADVANCED USERS ONLY.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.3\";s:8:\"Category\";s:8:\"Advanced\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:27:\"Pods_Advanced_Content_Types\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:26:\"Advanced-Content-Types.php\";}s:22:\"advanced-relationships\";a:28:{s:2:\"ID\";s:22:\"advanced-relationships\";s:4:\"Name\";s:22:\"Advanced Relationships\";s:9:\"ShortName\";s:22:\"Advanced Relationships\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:22:\"Advanced Relationships\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:187:\"Add advanced relationship objects for relating to including Database Tables, Multisite Networks, Multisite Sites, Themes, Page Templates, Sidebars, Post Type Objects, and Taxonomy Objects\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.3\";s:8:\"Category\";s:8:\"Advanced\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:27:\"Pods_Advanced_Relationships\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:26:\"Advanced-Relationships.php\";}s:19:\"builder-integration\";a:28:{s:2:\"ID\";s:19:\"builder-integration\";s:4:\"Name\";s:19:\"Builder Integration\";s:9:\"ShortName\";s:19:\"Builder Integration\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:19:\"Builder Integration\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:169:\"Integration with the <a href=\"http://ithemes.com/\">Builder</a> theme / child themes from <a href=\"http://ithemes.com/\">iThemes</a>; Adds new modules to the Layout engine\";s:10:\"Deprecated\";s:3:\"Yes\";s:19:\"DeprecatedInVersion\";s:6:\"2.9.13\";s:24:\"DeprecatedRemovalVersion\";s:3:\"3.1\";s:7:\"Version\";s:3:\"1.0\";s:8:\"Category\";s:11:\"Integration\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:12:\"Pods_Builder\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:29:\"pods-builder/pods-builder.php\";s:8:\"External\";b:0;s:4:\"File\";s:19:\"Builder/Builder.php\";}s:15:\"markdown-syntax\";a:28:{s:2:\"ID\";s:15:\"markdown-syntax\";s:4:\"Name\";s:15:\"Markdown Syntax\";s:9:\"ShortName\";s:15:\"Markdown Syntax\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:15:\"Markdown Syntax\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:158:\"Integration with Markdown (via Parsedown https://github.com/erusev/parsedown); Adds an option to enable Markdown syntax for Paragraph Text and WYSIWYG fields.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.0\";s:8:\"Category\";s:11:\"Field Types\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:13:\"Pods_Markdown\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:12:\"Markdown.php\";}s:53:\"migrate-import-from-the-advanced-custom-fields-plugin\";a:28:{s:2:\"ID\";s:53:\"migrate-import-from-the-advanced-custom-fields-plugin\";s:4:\"Name\";s:54:\"Migrate: Import from the Advanced Custom Fields plugin\";s:9:\"ShortName\";s:54:\"Migrate: Import from the Advanced Custom Fields plugin\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:11:\"Migrate ACF\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:258:\"Import Custom Post Types and Taxonomies from the Advanced Custom Fields (<a href=\"https://wordpress.org/plugins/advanced-custom-fields/\">https://wordpress.org/plugins/advanced-custom-fields/</a>). This does NOT migrate custom fields or field groups from ACF.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"1.0\";s:8:\"Category\";s:9:\"Migration\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:16:\"Pods_Migrate_ACF\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:37:\"pods-migrate-acf/pods-migrate-acf.php\";s:8:\"External\";b:0;s:4:\"File\";s:27:\"Migrate-ACF/Migrate-ACF.php\";}s:50:\"migrate-import-from-the-custom-post-type-ui-plugin\";a:28:{s:2:\"ID\";s:50:\"migrate-import-from-the-custom-post-type-ui-plugin\";s:4:\"Name\";s:51:\"Migrate: Import from the Custom Post Type UI plugin\";s:9:\"ShortName\";s:51:\"Migrate: Import from the Custom Post Type UI plugin\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:14:\"Migrate CPT UI\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:182:\"Import Custom Post Types and Taxonomies from Custom Post Type UI (<a href=\"https://wordpress.org/plugins/custom-post-type-ui/\">https://wordpress.org/plugins/custom-post-type-ui/</a>)\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"1.0\";s:8:\"Category\";s:9:\"Migration\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:18:\"Pods_Migrate_CPTUI\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:69:\"pods-migrate-custom-post-type-ui/pods-migrate-custom-post-type-ui.php\";s:8:\"External\";b:0;s:4:\"File\";s:31:\"Migrate-CPTUI/Migrate-CPTUI.php\";}s:16:\"migrate-packages\";a:28:{s:2:\"ID\";s:16:\"migrate-packages\";s:4:\"Name\";s:22:\"Import/Export Packages\";s:9:\"ShortName\";s:22:\"Import/Export Packages\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:22:\"Import/Export Packages\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:121:\"Import/Export your Pods, Fields, and other settings from any Pods site; Includes an API to Import/Export Packages via PHP\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.0\";s:8:\"Category\";s:9:\"Migration\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:21:\"Pods_Migrate_Packages\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:47:\"pods-migrate-packages/pods-migrate-packages.php\";s:8:\"External\";b:0;s:4:\"File\";s:37:\"Migrate-Packages/Migrate-Packages.php\";}s:63:\"migrate-pod-page-and-pod-template-php-into-file-based-templates\";a:28:{s:2:\"ID\";s:63:\"migrate-pod-page-and-pod-template-php-into-file-based-templates\";s:4:\"Name\";s:64:\"Migrate: Pod Page and Pod Template PHP into File-based templates\";s:9:\"ShortName\";s:64:\"Migrate: Pod Page and Pod Template PHP into File-based templates\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:21:\"Migrate PHP Templates\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:510:\"Pod Pages and Pod Templates will be migrated into their corresponding file-based locations in the theme. This will overwrite existing files and this is one-way. After migrating the files it will clear the PHP code from the DB content. <a href=\"https://docs.pods.io/displaying-pods/pod-page-template-hierarchy-for-themes/\">More information about Pod Page template hierarchy</a> | <a href=\"https://docs.pods.io/displaying-pods/pod-template-hierarchy-for-themes/\">More information about Pod Template hierarchy</a>\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"1.0\";s:8:\"Category\";s:9:\"Migration\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:16:\"Pods_Migrate_PHP\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:37:\"pods-migrate-php/pods-migrate-php.php\";s:8:\"External\";b:0;s:4:\"File\";s:27:\"Migrate-PHP/Migrate-PHP.php\";}s:5:\"pages\";a:28:{s:2:\"ID\";s:5:\"pages\";s:4:\"Name\";s:5:\"Pages\";s:9:\"ShortName\";s:5:\"Pages\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:9:\"Pod Pages\";s:8:\"MenuPage\";s:29:\"edit.php?post_type=_pods_page\";s:11:\"MenuAddPage\";s:33:\"post-new.php?post_type=_pods_page\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:170:\"Creates advanced URL structures using wildcards in order to enable the front-end display of Pods Advanced Content Types. Not recommended for use with other content types.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.3\";s:8:\"Category\";s:8:\"Advanced\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:10:\"Pods_Pages\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:9:\"Pages.php\";}s:22:\"roles-and-capabilities\";a:28:{s:2:\"ID\";s:22:\"roles-and-capabilities\";s:4:\"Name\";s:22:\"Roles and Capabilities\";s:9:\"ShortName\";s:22:\"Roles and Capabilities\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:24:\"Roles &amp; Capabilities\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:379:\"Create and Manage WordPress User Roles and Capabilities; Uses the \'<a href=\"http://wordpress.org/plugins/members/\" target=\"_blank\" rel=\"noopener noreferrer\">Members</a>\' plugin filters for additional plugin integrations; Portions of code based on the \'<a href=\"http://wordpress.org/plugins/members/\" target=\"_blank\" rel=\"noopener noreferrer\">Members</a>\' plugin by Justin Tadlock\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"1.0\";s:8:\"Category\";s:5:\"Tools\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:10:\"Pods_Roles\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:15:\"Roles/Roles.php\";}s:13:\"table-storage\";a:28:{s:2:\"ID\";s:13:\"table-storage\";s:4:\"Name\";s:13:\"Table Storage\";s:9:\"ShortName\";s:13:\"Table Storage\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:13:\"Table Storage\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:108:\"Enable a custom database table for your custom fields on Post Types, Media, Taxonomies, Users, and Comments.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.3\";s:8:\"Category\";s:8:\"Advanced\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:18:\"Pods_Table_Storage\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:17:\"Table-Storage.php\";}s:9:\"templates\";a:28:{s:2:\"ID\";s:9:\"templates\";s:4:\"Name\";s:9:\"Templates\";s:9:\"ShortName\";s:9:\"Templates\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:13:\"Pod Templates\";s:8:\"MenuPage\";s:33:\"edit.php?post_type=_pods_template\";s:11:\"MenuAddPage\";s:37:\"post-new.php?post_type=_pods_template\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:114:\"An easy to use templating engine for Pods. Use {@field_name} magic tags to output values, within your HTML markup.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"2.3\";s:8:\"Category\";s:8:\"Advanced\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:14:\"Pods_Templates\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:23:\"Templates/Templates.php\";}s:20:\"translate-pods-admin\";a:28:{s:2:\"ID\";s:20:\"translate-pods-admin\";s:4:\"Name\";s:20:\"Translate Pods Admin\";s:9:\"ShortName\";s:20:\"Translate Pods Admin\";s:10:\"PluginName\";s:0:\"\";s:13:\"ComponentName\";s:0:\"\";s:3:\"URI\";s:0:\"\";s:8:\"MenuName\";s:14:\"Translate Pods\";s:8:\"MenuPage\";s:0:\"\";s:11:\"MenuAddPage\";s:0:\"\";s:7:\"MustUse\";b:0;s:11:\"Description\";s:45:\"Allow UI of Pods and fields to be translated.\";s:10:\"Deprecated\";s:0:\"\";s:19:\"DeprecatedInVersion\";s:0:\"\";s:24:\"DeprecatedRemovalVersion\";s:0:\"\";s:7:\"Version\";s:3:\"1.1\";s:8:\"Category\";s:4:\"I18n\";s:6:\"Author\";s:0:\"\";s:9:\"AuthorURI\";s:0:\"\";s:5:\"Class\";s:19:\"Pods_Component_I18n\";s:4:\"Hide\";s:0:\"\";s:16:\"PluginDependency\";s:0:\"\";s:15:\"ThemeDependency\";s:0:\"\";s:13:\"DeveloperMode\";b:0;s:13:\"TablelessMode\";b:0;s:10:\"Capability\";s:0:\"\";s:6:\"Plugin\";s:0:\"\";s:8:\"External\";b:0;s:4:\"File\";s:13:\"I18n/I18n.php\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("40389", "_transient_timeout_pods_9062a6994a2bc83c91cb0b3ab05ce265", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40390", "_transient_pods_9062a6994a2bc83c91cb0b3ab05ce265", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40391", "_transient_timeout_pods_ffa368ce5efb7cef6015316bc1461849", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40392", "_transient_pods_ffa368ce5efb7cef6015316bc1461849", "a:3:{i:0;i:1412;i:1;i:75;i:2;i:147;}", "off");
INSERT INTO `wp_obs_options` VALUES("40393", "_transient_timeout_pods_4df55de306e780945dfcd9565ab99676", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40394", "_transient_pods_4df55de306e780945dfcd9565ab99676", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40395", "_transient_timeout_pods_5c35e3e12d362c330da37c602c4b5712", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40396", "_transient_pods_5c35e3e12d362c330da37c602c4b5712", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40397", "_transient_timeout_pods_7fc5cc0d25f6564a850d30280db43961", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40398", "_transient_pods_7fc5cc0d25f6564a850d30280db43961", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40399", "_transient_timeout_pods_fc4f37233d506809c552a7ee112819af", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40400", "_transient_pods_fc4f37233d506809c552a7ee112819af", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40401", "_transient_timeout_pods_315779bf1d53f6967a73c1a6c06758f1", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40402", "_transient_pods_315779bf1d53f6967a73c1a6c06758f1", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40403", "_transient_timeout_pods_pods_core_loader_objects-328", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40404", "_transient_pods_pods_core_loader_objects-328", "a:5:{s:10:\"taxonomies\";a:0:{}s:5:\"media\";b:0;s:4:\"user\";b:0;s:7:\"comment\";b:0;s:8:\"settings\";a:0:{}}", "off");
INSERT INTO `wp_obs_options` VALUES("40405", "_transient_timeout_pods_pods_wp_cpt_ct-328", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40406", "_transient_pods_pods_wp_cpt_ct-328", "a:3:{s:10:\"post_types\";a:4:{s:14:\"_pods_template\";b:0;s:10:\"composante\";a:24:{s:5:\"label\";s:10:\"Composante\";s:6:\"labels\";a:35:{s:4:\"name\";s:10:\"Composante\";s:13:\"singular_name\";s:10:\"Composante\";s:9:\"menu_name\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:4:\"edit\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:4:\"view\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:6:\"parent\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";s:14:\"filter_by_date\";s:0:\"\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:19:\"exclude_from_search\";b:0;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:17:\"show_in_admin_bar\";b:1;s:9:\"menu_icon\";N;s:15:\"capability_type\";s:4:\"post\";s:12:\"map_meta_cap\";b:1;s:12:\"hierarchical\";b:0;s:10:\"can_export\";b:1;s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:10:\"quick-edit\";}s:11:\"has_archive\";b:0;s:7:\"rewrite\";a:4:{s:4:\"slug\";s:10:\"composante\";s:10:\"with_front\";b:1;s:5:\"feeds\";b:0;s:5:\"pages\";b:1;}s:9:\"query_var\";s:10:\"composante\";s:16:\"delete_with_user\";b:1;s:9:\"_provider\";s:4:\"pods\";s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:10:\"composante\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";}s:13:\"etablissement\";a:24:{s:5:\"label\";s:13:\"Etablissement\";s:6:\"labels\";a:35:{s:4:\"name\";s:13:\"Etablissement\";s:13:\"singular_name\";s:13:\"Etablissement\";s:9:\"menu_name\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:4:\"edit\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:4:\"view\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:6:\"parent\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";s:14:\"filter_by_date\";s:0:\"\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:19:\"exclude_from_search\";b:0;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:17:\"show_in_admin_bar\";b:1;s:9:\"menu_icon\";N;s:15:\"capability_type\";s:4:\"post\";s:12:\"map_meta_cap\";b:1;s:12:\"hierarchical\";b:0;s:10:\"can_export\";b:1;s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:10:\"quick-edit\";}s:11:\"has_archive\";b:0;s:7:\"rewrite\";a:4:{s:4:\"slug\";s:13:\"etablissement\";s:10:\"with_front\";b:1;s:5:\"feeds\";b:0;s:5:\"pages\";b:1;}s:9:\"query_var\";s:13:\"etablissement\";s:16:\"delete_with_user\";b:1;s:9:\"_provider\";s:4:\"pods\";s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:13:\"etablissement\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";}s:9:\"formation\";a:24:{s:5:\"label\";s:10:\"Formations\";s:6:\"labels\";a:35:{s:4:\"name\";s:10:\"Formations\";s:13:\"singular_name\";s:9:\"Formation\";s:9:\"menu_name\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:4:\"edit\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:4:\"view\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:6:\"parent\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";s:14:\"filter_by_date\";s:0:\"\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:19:\"exclude_from_search\";b:0;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:17:\"show_in_admin_bar\";b:1;s:9:\"menu_icon\";N;s:15:\"capability_type\";s:4:\"post\";s:12:\"map_meta_cap\";b:1;s:12:\"hierarchical\";b:0;s:10:\"can_export\";b:1;s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:10:\"quick-edit\";}s:11:\"has_archive\";b:0;s:7:\"rewrite\";a:4:{s:4:\"slug\";s:9:\"formation\";s:10:\"with_front\";b:1;s:5:\"feeds\";b:0;s:5:\"pages\";b:1;}s:9:\"query_var\";s:9:\"formation\";s:16:\"delete_with_user\";b:1;s:9:\"_provider\";s:4:\"pods\";s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:9:\"formation\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";}}s:10:\"taxonomies\";a:0:{}s:22:\"post_format_post_types\";a:0:{}}", "off");
INSERT INTO `wp_obs_options` VALUES("40407", "_transient_timeout_pods_f77ea56462a84da97fe647130e4d0f35", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40408", "_transient_pods_f77ea56462a84da97fe647130e4d0f35", "a:1:{i:0;i:1412;}", "off");
INSERT INTO `wp_obs_options` VALUES("40409", "_transient_timeout_pods_6f58b03c5d2b444952ba3ef454276fb8", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40410", "_transient_pods_6f58b03c5d2b444952ba3ef454276fb8", "a:1:{i:0;i:75;}", "off");
INSERT INTO `wp_obs_options` VALUES("40411", "_transient_timeout_pods_3ce4a957dcf5a53cc4172c266de6e094", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40412", "_transient_pods_3ce4a957dcf5a53cc4172c266de6e094", "a:1:{i:0;i:147;}", "off");
INSERT INTO `wp_obs_options` VALUES("40413", "_transient_timeout_pods_4adfcb3072236c0bfe462e096d924f21", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40414", "_transient_pods_4adfcb3072236c0bfe462e096d924f21", "a:3:{i:0;i:1412;i:1;i:75;i:2;i:147;}", "off");
INSERT INTO `wp_obs_options` VALUES("40415", "_transient_timeout_pods_921348d23fb458bb91c8435f866adb09", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40416", "_transient_pods_921348d23fb458bb91c8435f866adb09", "a:5:{i:0;i:157;i:1;i:1432;i:2;i:1434;i:3;i:1006577;i:4;i:1436;}", "off");
INSERT INTO `wp_obs_options` VALUES("40419", "_transient_timeout_pods_pods_field_types-328", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40420", "_transient_pods_pods_field_types-328", "a:22:{s:4:\"text\";a:7:{s:5:\"group\";s:4:\"Text\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"Plain Text\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:7:\"website\";a:7:{s:5:\"group\";s:4:\"Text\";s:4:\"type\";s:7:\"website\";s:5:\"label\";s:7:\"Website\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:5:\"phone\";a:7:{s:5:\"group\";s:4:\"Text\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:5:\"Phone\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:5:\"email\";a:7:{s:5:\"group\";s:4:\"Text\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:6:\"E-mail\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:8:\"password\";a:7:{s:5:\"group\";s:4:\"Text\";s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:9:\"paragraph\";a:7:{s:5:\"group\";s:9:\"Paragraph\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:20:\"Plain Paragraph Text\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:7:\"wysiwyg\";a:7:{s:5:\"group\";s:9:\"Paragraph\";s:4:\"type\";s:7:\"wysiwyg\";s:5:\"label\";s:23:\"WYSIWYG (Visual Editor)\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"code\";a:7:{s:5:\"group\";s:9:\"Paragraph\";s:4:\"type\";s:4:\"code\";s:5:\"label\";s:26:\"Code (Syntax Highlighting)\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:8:\"datetime\";a:9:{s:5:\"group\";s:11:\"Date / Time\";s:4:\"type\";s:8:\"datetime\";s:5:\"label\";s:11:\"Date / Time\";s:7:\"prepare\";s:2:\"%s\";s:14:\"storage_format\";s:11:\"Y-m-d H:i:s\";s:11:\"empty_value\";s:19:\"0000-00-00 00:00:00\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"date\";a:9:{s:5:\"group\";s:11:\"Date / Time\";s:4:\"type\";s:4:\"date\";s:5:\"label\";s:4:\"Date\";s:7:\"prepare\";s:2:\"%s\";s:14:\"storage_format\";s:5:\"Y-m-d\";s:11:\"empty_value\";s:10:\"0000-00-00\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"time\";a:9:{s:5:\"group\";s:11:\"Date / Time\";s:4:\"type\";s:4:\"time\";s:5:\"label\";s:4:\"Time\";s:7:\"prepare\";s:2:\"%s\";s:14:\"storage_format\";s:5:\"H:i:s\";s:11:\"empty_value\";s:0:\"\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:6:\"number\";a:7:{s:5:\"group\";s:6:\"Number\";s:4:\"type\";s:6:\"number\";s:5:\"label\";s:12:\"Plain Number\";s:7:\"prepare\";s:2:\"%d\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:8:\"currency\";a:8:{s:5:\"group\";s:6:\"Number\";s:4:\"type\";s:8:\"currency\";s:5:\"label\";s:8:\"Currency\";s:7:\"prepare\";s:2:\"%d\";s:10:\"currencies\";a:0:{}s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"file\";a:7:{s:5:\"group\";s:21:\"Relationships / Media\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"File / Image / Video\";s:10:\"deprecated\";b:0;s:7:\"prepare\";s:2:\"%s\";s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:6:\"avatar\";a:7:{s:5:\"group\";s:21:\"Relationships / Media\";s:4:\"type\";s:6:\"avatar\";s:5:\"label\";s:6:\"Avatar\";s:9:\"pod_types\";a:1:{i:0;s:4:\"user\";}s:10:\"deprecated\";b:0;s:7:\"prepare\";s:2:\"%s\";s:4:\"file\";N;}s:6:\"oembed\";a:7:{s:5:\"group\";s:21:\"Relationships / Media\";s:4:\"type\";s:6:\"oembed\";s:5:\"label\";s:6:\"oEmbed\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"pick\";a:11:{s:5:\"group\";s:21:\"Relationships / Media\";s:4:\"type\";s:4:\"pick\";s:5:\"label\";s:12:\"Relationship\";s:15:\"related_objects\";a:0:{}s:22:\"custom_related_objects\";a:0:{}s:12:\"related_data\";a:0:{}s:10:\"field_data\";a:0:{}s:10:\"deprecated\";b:0;s:7:\"prepare\";s:2:\"%s\";s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:7:\"boolean\";a:6:{s:4:\"type\";s:7:\"boolean\";s:5:\"label\";s:8:\"Yes / No\";s:7:\"prepare\";s:2:\"%d\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:5:\"color\";a:6:{s:4:\"type\";s:5:\"color\";s:5:\"label\";s:12:\"Color Picker\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"slug\";a:6:{s:4:\"type\";s:4:\"slug\";s:5:\"label\";s:24:\"Permalink (url-friendly)\";s:7:\"prepare\";s:2:\"%s\";s:9:\"pod_types\";a:2:{i:0;s:3:\"pod\";i:1;s:5:\"table\";}s:10:\"deprecated\";b:0;s:4:\"file\";N;}s:7:\"heading\";a:7:{s:5:\"group\";s:15:\"Layout Elements\";s:4:\"type\";s:7:\"heading\";s:5:\"label\";s:7:\"Heading\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}s:4:\"html\";a:7:{s:5:\"group\";s:15:\"Layout Elements\";s:4:\"type\";s:4:\"html\";s:5:\"label\";s:12:\"HTML Content\";s:7:\"prepare\";s:2:\"%s\";s:10:\"deprecated\";b:0;s:9:\"pod_types\";b:1;s:4:\"file\";N;}}", "off");
INSERT INTO `wp_obs_options` VALUES("40421", "_transient_timeout_pods_pods_form_admin_init_field_types-328", "1743248789", "off");
INSERT INTO `wp_obs_options` VALUES("40422", "_transient_pods_pods_form_admin_init_field_types-328", "a:22:{i:0;s:4:\"text\";i:1;s:7:\"website\";i:2;s:5:\"phone\";i:3;s:5:\"email\";i:4;s:8:\"password\";i:5;s:9:\"paragraph\";i:6;s:7:\"wysiwyg\";i:7;s:4:\"code\";i:8;s:8:\"datetime\";i:9;s:4:\"date\";i:10;s:4:\"time\";i:11;s:6:\"number\";i:12;s:8:\"currency\";i:13;s:4:\"file\";i:14;s:6:\"avatar\";i:15;s:6:\"oembed\";i:16;s:4:\"pick\";i:17;s:7:\"boolean\";i:18;s:5:\"color\";i:19;s:4:\"slug\";i:20;s:7:\"heading\";i:21;s:4:\"html\";}", "off");
INSERT INTO `wp_obs_options` VALUES("40423", "_transient_timeout_pods_pods_blocks_js-328", "1743248790", "off");
INSERT INTO `wp_obs_options` VALUES("40424", "_transient_pods_pods_blocks_js-328", "a:6:{i:0;a:15:{s:9:\"blockName\";s:21:\"pods/pods-block-field\";s:15:\"blockGroupLabel\";s:7:\"Options\";s:5:\"title\";s:16:\"Pods Field Value\";s:11:\"description\";s:56:\"Display a single Pod item\'s field value (custom fields).\";s:10:\"renderType\";s:3:\"php\";s:8:\"category\";s:4:\"pods\";s:4:\"icon\";s:4:\"pods\";s:8:\"keywords\";a:5:{i:0;s:4:\"pods\";i:1;s:5:\"field\";i:2;s:5:\"value\";i:3;s:6:\"custom\";i:4;s:4:\"meta\";}s:8:\"supports\";a:13:{s:4:\"html\";b:0;s:5:\"align\";b:1;s:9:\"alignWide\";b:1;s:6:\"anchor\";b:0;s:15:\"customClassName\";b:1;s:8:\"inserter\";b:1;s:8:\"multiple\";b:1;s:8:\"reusable\";b:1;s:19:\"__experimentalColor\";b:1;s:22:\"__experimentalFontSize\";b:1;s:21:\"__experimentalPadding\";b:1;s:24:\"__experimentalLineHeight\";b:1;s:3:\"jsx\";b:0;}s:12:\"editorScript\";s:15:\"pods-blocks-api\";s:11:\"usesContext\";a:2:{i:0;s:8:\"postType\";i:1;s:6:\"postId\";}s:15:\"providesContext\";a:0:{}s:6:\"fields\";a:5:{i:0;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Nom du pod\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:10:\"composante\";s:5:\"value\";s:10:\"composante\";}i:2;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:3;a:2:{s:5:\"label\";s:9:\"formation\";s:5:\"value\";s:9:\"formation\";}}s:4:\"help\";s:87:\"Choose the pod to reference, or reference the Pod in the current context of this block.\";s:5:\"label\";s:10:\"Nom du pod\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:4:\"name\";}i:1;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:204:\"Read about how access rights control what can be displayed to other users: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:18:\"access_rights_help\";}i:2;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:39:\"Defaults to using the current pod item.\";s:5:\"label\";s:17:\"Identifiant ou ID\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:4:\"slug\";}i:3;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:49:\"C’est le nom du champ que vous voulez afficher.\";s:5:\"label\";s:12:\"Nom du champ\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:5:\"field\";}i:4;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:93:\"You can specify a field to link the output to. Like \"permalink\" or \"related_field.permalink\".\";s:5:\"label\";s:26:\"Link Field Name (optional)\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:10:\"link_field\";}}s:10:\"attributes\";a:10:{s:5:\"align\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"textColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:15:\"backgroundColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"fontSize\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"style\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:18:\"access_rights_help\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"slug\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"field\";a:1:{s:4:\"type\";s:6:\"string\";}s:10:\"link_field\";a:1:{s:4:\"type\";s:6:\"string\";}}s:10:\"transforms\";a:1:{s:4:\"from\";a:1:{i:0;a:4:{s:4:\"type\";s:9:\"shortcode\";s:3:\"tag\";s:4:\"pods\";s:10:\"attributes\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"name\";}s:4:\"slug\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"slug\";}s:5:\"field\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:5:\"field\";}s:10:\"link_field\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:10:\"link_field\";}}s:13:\"isMatchConfig\";a:1:{i:0;a:2:{s:4:\"name\";s:5:\"field\";s:8:\"required\";b:1;}}}}}}i:1;a:15:{s:9:\"blockName\";s:20:\"pods/pods-block-list\";s:15:\"blockGroupLabel\";s:7:\"Options\";s:5:\"title\";s:14:\"Pods Item List\";s:11:\"description\";s:24:\"List multiple Pod items.\";s:10:\"renderType\";s:3:\"php\";s:8:\"category\";s:4:\"pods\";s:4:\"icon\";s:4:\"pods\";s:8:\"keywords\";a:3:{i:0;s:4:\"pods\";i:1;s:4:\"item\";i:2;s:4:\"list\";}s:8:\"supports\";a:13:{s:4:\"html\";b:0;s:5:\"align\";b:1;s:9:\"alignWide\";b:1;s:6:\"anchor\";b:0;s:15:\"customClassName\";b:1;s:8:\"inserter\";b:1;s:8:\"multiple\";b:1;s:8:\"reusable\";b:1;s:19:\"__experimentalColor\";b:1;s:22:\"__experimentalFontSize\";b:1;s:21:\"__experimentalPadding\";b:1;s:24:\"__experimentalLineHeight\";b:1;s:3:\"jsx\";b:0;}s:12:\"editorScript\";s:15:\"pods-blocks-api\";s:11:\"usesContext\";a:1:{i:0;s:8:\"postType\";}s:15:\"providesContext\";a:0:{}s:6:\"fields\";a:19:{i:0;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Nom du pod\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:10:\"composante\";s:5:\"value\";s:10:\"composante\";}i:2;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:3;a:2:{s:5:\"label\";s:9:\"formation\";s:5:\"value\";s:9:\"formation\";}}s:4:\"help\";s:87:\"Choose the pod to reference, or reference the Pod in the current context of this block.\";s:5:\"label\";s:10:\"Nom du pod\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:4:\"name\";}i:1;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:204:\"Read about how access rights control what can be displayed to other users: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:18:\"access_rights_help\";}i:2;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:7:\"Modèle\";s:7:\"options\";a:6:{i:0;a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:2;a:2:{s:5:\"label\";s:17:\"composantes_liste\";s:5:\"value\";s:17:\"composantes_liste\";}i:3;a:2:{s:5:\"label\";s:15:\"etablissement-2\";s:5:\"value\";s:15:\"etablissement-2\";}i:4;a:2:{s:5:\"label\";s:26:\"etablissement_accueil_test\";s:5:\"value\";s:26:\"etablissement_accueil_test\";}i:5;a:2:{s:5:\"label\";s:20:\"etablissements_liste\";s:5:\"value\";s:20:\"etablissements_liste\";}}s:4:\"help\";s:168:\"You can choose a previously saved Pods Template here. We recommend saving your Pods Templates with our Templates component so you can enjoy the full editing experience.\";s:5:\"label\";s:7:\"Modèle\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:8:\"template\";}i:3;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:172:\"Vous pouvez spécifier un modèle personnalisé à utiliser, il accepte les balises HTML et magiques. Tout contenu ici remplacera le modèle que vous avez choisi ci-dessus.\";s:5:\"label\";s:21:\"Modèle personnalisé\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:15:\"template_custom\";}i:4;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:341:\"Ce contenu apparaîtra avant la liste des éléments de modèle. Une façon utile d’utiliser cette option est que si vous avez un modèle qui utilise des balises HTML « li », vous pouvez utiliser la balise HTML « ul » pour débuter une liste non ordonnée. Cela ne sera uniquement affiché que si des éléments ont été trouvés.\";s:5:\"label\";s:19:\"Content Before List\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:14:\"content_before\";}i:5;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:340:\"Ce contenu apparaîtra après la liste des éléments de modèle. Une façon utile d’utiliser cette option est que si vous avez un modèle qui utilise des balises HTML « li », vous pouvez utiliser la balise HTML « /ul » pour clore une liste non ordonnée. Cela ne sera uniquement affiché que si des éléments ont été trouvés.\";s:5:\"label\";s:18:\"Content After List\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:13:\"content_after\";}i:6;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:86:\"S’il n’y a aucun élément affiché, ce contenu sera affiché à la place du bloc.\";s:5:\"label\";s:19:\"Contenu non trouvé\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"string\";s:7:\"default\";s:34:\"Aucun contenu n’a été trouvé.\";}s:4:\"name\";s:9:\"not_found\";}i:7;a:4:{s:4:\"type\";s:13:\"NumberControl\";s:12:\"fieldOptions\";a:5:{s:18:\"isShiftStepEnabled\";b:0;s:9:\"shiftStep\";b:0;s:4:\"step\";i:1;s:4:\"help\";s:346:\"Specify the number of items to show but keep in mind that the more items you show the longer it may take for the page to load. You should avoid using \"-1\" here unless you know what you\'re doing. If your pod has many items, it could stop the page from loading and cause errors. Default number of items to show is to show 15 items. See also: find()\";s:5:\"label\";s:6:\"Limite\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:15;}s:4:\"name\";s:5:\"limit\";}i:8;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:256:\"You can specify what field to order by here. That could be t.post_title ASC or you may want to use a custom field like my_field.meta_value ASC. The normal MySQL syntax works here, so you can sort ascending with ASC or descending with DESC. See also: find()\";s:5:\"label\";s:11:\"Classé Par\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:7:\"orderby\";}i:9;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:290:\"You can specify what field to restrict the item list by here. That could be t.post_title LIKE \"%repairs%\" or you may want to reference a custom field like  my_field.meta_value = \"123\". For a list of all things available for you to query, follow the find() Notation Options. See also: find()\";s:5:\"label\";s:3:\"Où\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:5:\"where\";}i:10;a:4:{s:4:\"type\";s:15:\"CheckboxControl\";s:12:\"fieldOptions\";a:3:{s:7:\"heading\";s:21:\"Activer la pagination\";s:5:\"label\";s:3:\"Oui\";s:4:\"help\";s:116:\"Whether to show pagination for the list of items. This will only show if there is more than one page of items found.\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:4:\"name\";s:10:\"pagination\";}i:11;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:28:\"Emplacement de la pagination\";s:7:\"options\";a:3:{i:0;a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}i:1;a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}i:2;a:2:{s:5:\"label\";s:21:\"Liste avant et après\";s:5:\"value\";s:4:\"both\";}}s:4:\"help\";s:44:\"L’emplacement pour afficher la pagination.\";s:5:\"label\";s:28:\"Emplacement de la pagination\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}}s:4:\"name\";s:19:\"pagination_location\";}i:12;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:18:\"Type de pagination\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:13:\"Liens de base\";s:5:\"value\";s:8:\"advanced\";}i:1;a:2:{s:5:\"label\";s:39:\"Liens Précédent et Suivant uniquement\";s:5:\"value\";s:6:\"simple\";}i:2;a:2:{s:5:\"label\";s:80:\"Utiliser une liste non ordonnée avec la fonctionnalité native paginate_links()\";s:5:\"value\";s:4:\"list\";}i:3;a:2:{s:5:\"label\";s:59:\"Utiliser la fonctionnalité native de base paginate_links()\";s:5:\"value\";s:8:\"paginate\";}}s:4:\"help\";s:42:\"Choisir le type de pagination à afficher.\";s:5:\"label\";s:18:\"Type de pagination\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:13:\"Liens de base\";s:5:\"value\";s:8:\"advanced\";}}s:4:\"name\";s:15:\"pagination_type\";}i:13;a:4:{s:4:\"type\";s:15:\"CheckboxControl\";s:12:\"fieldOptions\";a:3:{s:7:\"heading\";s:19:\"Activer les filtres\";s:5:\"label\";s:3:\"Oui\";s:4:\"help\";s:46:\"Whether to show filters for the list of items.\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:4:\"name\";s:14:\"filters_enable\";}i:14;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:115:\"Comma-separated list of fields you want to allow filtering by. Default is to just show a text field to search with.\";s:5:\"label\";s:16:\"Champs de filtre\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:7:\"filters\";}i:15;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:87:\"Le libellé à afficher pour les filtres. La valeur par défaut est « Rechercher ».\";s:5:\"label\";s:34:\"Libellé de filtres personnalisés\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:13:\"filters_label\";}i:16;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:23:\"Emplacement des filtres\";s:7:\"options\";a:2:{i:0;a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}i:1;a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}}s:4:\"help\";s:42:\"L’emplacement pour afficher les filtres.\";s:5:\"label\";s:23:\"Emplacement des filtres\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}}s:4:\"name\";s:16:\"filters_location\";}i:17;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Cache Mode\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:15:\"Disable Caching\";s:5:\"value\";s:4:\"none\";}i:1;a:2:{s:5:\"label\";s:12:\"Object Cache\";s:5:\"value\";s:5:\"cache\";}i:2;a:2:{s:5:\"label\";s:9:\"Transient\";s:5:\"value\";s:9:\"transient\";}i:3;a:2:{s:5:\"label\";s:14:\"Site Transient\";s:5:\"value\";s:14:\"site-transient\";}}s:4:\"help\";s:34:\"The mode to cache the output with.\";s:5:\"label\";s:10:\"Cache Mode\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Disable Caching\";s:5:\"value\";s:4:\"none\";}}s:4:\"name\";s:10:\"cache_mode\";}i:18;a:4:{s:4:\"type\";s:13:\"NumberControl\";s:12:\"fieldOptions\";a:5:{s:18:\"isShiftStepEnabled\";b:0;s:9:\"shiftStep\";b:0;s:4:\"step\";i:1;s:4:\"help\";s:48:\"Set how long to cache the output for in seconds.\";s:5:\"label\";s:7:\"Expires\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:300;}s:4:\"name\";s:7:\"expires\";}}s:10:\"attributes\";a:24:{s:5:\"align\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"textColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:15:\"backgroundColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"fontSize\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"style\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:18:\"access_rights_help\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"template\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}}s:15:\"template_custom\";a:1:{s:4:\"type\";s:6:\"string\";}s:14:\"content_before\";a:1:{s:4:\"type\";s:6:\"string\";}s:13:\"content_after\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"not_found\";a:2:{s:4:\"type\";s:6:\"string\";s:7:\"default\";s:34:\"Aucun contenu n’a été trouvé.\";}s:5:\"limit\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:15;}s:7:\"orderby\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"where\";a:1:{s:4:\"type\";s:6:\"string\";}s:10:\"pagination\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:19:\"pagination_location\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}}s:15:\"pagination_type\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:13:\"Liens de base\";s:5:\"value\";s:8:\"advanced\";}}s:14:\"filters_enable\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:7:\"filters\";a:1:{s:4:\"type\";s:6:\"string\";}s:13:\"filters_label\";a:1:{s:4:\"type\";s:6:\"string\";}s:16:\"filters_location\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}}s:10:\"cache_mode\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Disable Caching\";s:5:\"value\";s:4:\"none\";}}s:7:\"expires\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:300;}}s:10:\"transforms\";a:1:{s:4:\"from\";a:1:{i:0;a:4:{s:4:\"type\";s:9:\"shortcode\";s:3:\"tag\";s:4:\"pods\";s:10:\"attributes\";a:18:{s:4:\"name\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"name\";}s:8:\"template\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:8:\"template\";}s:15:\"template_custom\";a:3:{s:4:\"type\";s:7:\"content\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:15:\"template_custom\";}s:14:\"content_before\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:14:\"content_before\";}s:13:\"content_after\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:13:\"content_after\";}s:9:\"not_found\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:9:\"not_found\";}s:5:\"limit\";a:3:{s:4:\"type\";s:7:\"integer\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:5:\"limit\";}s:7:\"orderby\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:7:\"orderby\";}s:5:\"where\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:5:\"where\";}s:10:\"pagination\";a:3:{s:4:\"type\";s:7:\"boolean\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:10:\"pagination\";}s:19:\"pagination_location\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:19:\"pagination_location\";}s:15:\"pagination_type\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:15:\"pagination_type\";}s:14:\"filters_enable\";a:3:{s:4:\"type\";s:7:\"boolean\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:14:\"filters_enable\";}s:7:\"filters\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:7:\"filters\";}s:13:\"filters_label\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:13:\"filters_label\";}s:16:\"filters_location\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:16:\"filters_location\";}s:10:\"cache_mode\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:10:\"cache_mode\";}s:7:\"expires\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:7:\"expires\";}}s:13:\"isMatchConfig\";a:4:{i:0;a:2:{s:4:\"name\";s:4:\"slug\";s:8:\"excluded\";b:1;}i:1;a:2:{s:4:\"name\";s:5:\"field\";s:8:\"excluded\";b:1;}i:2;a:2:{s:4:\"name\";s:4:\"form\";s:8:\"excluded\";b:1;}i:3;a:2:{s:4:\"name\";s:4:\"view\";s:8:\"excluded\";b:1;}}}}}}i:2;a:15:{s:9:\"blockName\";s:28:\"pods/pods-block-related-list\";s:15:\"blockGroupLabel\";s:7:\"Options\";s:5:\"title\";s:22:\"Pods Related Item List\";s:11:\"description\";s:32:\"List multiple related Pod items.\";s:10:\"renderType\";s:3:\"php\";s:8:\"category\";s:4:\"pods\";s:4:\"icon\";s:4:\"pods\";s:8:\"keywords\";a:4:{i:0;s:4:\"pods\";i:1;s:7:\"related\";i:2;s:4:\"item\";i:3;s:4:\"list\";}s:8:\"supports\";a:13:{s:4:\"html\";b:0;s:5:\"align\";b:1;s:9:\"alignWide\";b:1;s:6:\"anchor\";b:0;s:15:\"customClassName\";b:1;s:8:\"inserter\";b:1;s:8:\"multiple\";b:1;s:8:\"reusable\";b:1;s:19:\"__experimentalColor\";b:1;s:22:\"__experimentalFontSize\";b:1;s:21:\"__experimentalPadding\";b:1;s:24:\"__experimentalLineHeight\";b:1;s:3:\"jsx\";b:0;}s:12:\"editorScript\";s:15:\"pods-blocks-api\";s:11:\"usesContext\";a:2:{i:0;s:8:\"postType\";i:1;s:6:\"postId\";}s:15:\"providesContext\";a:0:{}s:6:\"fields\";a:21:{i:0;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Nom du pod\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:10:\"composante\";s:5:\"value\";s:10:\"composante\";}i:2;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:3;a:2:{s:5:\"label\";s:9:\"formation\";s:5:\"value\";s:9:\"formation\";}}s:4:\"help\";s:87:\"Choose the pod to reference, or reference the Pod in the current context of this block.\";s:5:\"label\";s:10:\"Nom du pod\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:4:\"name\";}i:1;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:204:\"Read about how access rights control what can be displayed to other users: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:18:\"access_rights_help\";}i:2;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:39:\"Defaults to using the current pod item.\";s:5:\"label\";s:17:\"Identifiant ou ID\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:4:\"slug\";}i:3;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:51:\"This is the related field name you want to display.\";s:5:\"label\";s:18:\"Related Field Name\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:13:\"related_field\";}i:4;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:7:\"Modèle\";s:7:\"options\";a:6:{i:0;a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:2;a:2:{s:5:\"label\";s:17:\"composantes_liste\";s:5:\"value\";s:17:\"composantes_liste\";}i:3;a:2:{s:5:\"label\";s:15:\"etablissement-2\";s:5:\"value\";s:15:\"etablissement-2\";}i:4;a:2:{s:5:\"label\";s:26:\"etablissement_accueil_test\";s:5:\"value\";s:26:\"etablissement_accueil_test\";}i:5;a:2:{s:5:\"label\";s:20:\"etablissements_liste\";s:5:\"value\";s:20:\"etablissements_liste\";}}s:4:\"help\";s:168:\"You can choose a previously saved Pods Template here. We recommend saving your Pods Templates with our Templates component so you can enjoy the full editing experience.\";s:5:\"label\";s:7:\"Modèle\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:8:\"template\";}i:5;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:172:\"Vous pouvez spécifier un modèle personnalisé à utiliser, il accepte les balises HTML et magiques. Tout contenu ici remplacera le modèle que vous avez choisi ci-dessus.\";s:5:\"label\";s:21:\"Modèle personnalisé\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:15:\"template_custom\";}i:6;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:341:\"Ce contenu apparaîtra avant la liste des éléments de modèle. Une façon utile d’utiliser cette option est que si vous avez un modèle qui utilise des balises HTML « li », vous pouvez utiliser la balise HTML « ul » pour débuter une liste non ordonnée. Cela ne sera uniquement affiché que si des éléments ont été trouvés.\";s:5:\"label\";s:19:\"Content Before List\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:14:\"content_before\";}i:7;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:340:\"Ce contenu apparaîtra après la liste des éléments de modèle. Une façon utile d’utiliser cette option est que si vous avez un modèle qui utilise des balises HTML « li », vous pouvez utiliser la balise HTML « /ul » pour clore une liste non ordonnée. Cela ne sera uniquement affiché que si des éléments ont été trouvés.\";s:5:\"label\";s:18:\"Content After List\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:13:\"content_after\";}i:8;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:86:\"S’il n’y a aucun élément affiché, ce contenu sera affiché à la place du bloc.\";s:5:\"label\";s:19:\"Contenu non trouvé\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"string\";s:7:\"default\";s:34:\"Aucun contenu n’a été trouvé.\";}s:4:\"name\";s:9:\"not_found\";}i:9;a:4:{s:4:\"type\";s:13:\"NumberControl\";s:12:\"fieldOptions\";a:5:{s:18:\"isShiftStepEnabled\";b:0;s:9:\"shiftStep\";b:0;s:4:\"step\";i:1;s:4:\"help\";s:346:\"Specify the number of items to show but keep in mind that the more items you show the longer it may take for the page to load. You should avoid using \"-1\" here unless you know what you\'re doing. If your pod has many items, it could stop the page from loading and cause errors. Default number of items to show is to show 15 items. See also: find()\";s:5:\"label\";s:6:\"Limite\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:15;}s:4:\"name\";s:5:\"limit\";}i:10;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:256:\"You can specify what field to order by here. That could be t.post_title ASC or you may want to use a custom field like my_field.meta_value ASC. The normal MySQL syntax works here, so you can sort ascending with ASC or descending with DESC. See also: find()\";s:5:\"label\";s:11:\"Classé Par\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:7:\"orderby\";}i:11;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:290:\"You can specify what field to restrict the item list by here. That could be t.post_title LIKE \"%repairs%\" or you may want to reference a custom field like  my_field.meta_value = \"123\". For a list of all things available for you to query, follow the find() Notation Options. See also: find()\";s:5:\"label\";s:3:\"Où\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:5:\"where\";}i:12;a:4:{s:4:\"type\";s:15:\"CheckboxControl\";s:12:\"fieldOptions\";a:3:{s:7:\"heading\";s:21:\"Activer la pagination\";s:5:\"label\";s:3:\"Oui\";s:4:\"help\";s:116:\"Whether to show pagination for the list of items. This will only show if there is more than one page of items found.\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:4:\"name\";s:10:\"pagination\";}i:13;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:28:\"Emplacement de la pagination\";s:7:\"options\";a:3:{i:0;a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}i:1;a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}i:2;a:2:{s:5:\"label\";s:21:\"Liste avant et après\";s:5:\"value\";s:4:\"both\";}}s:4:\"help\";s:44:\"L’emplacement pour afficher la pagination.\";s:5:\"label\";s:28:\"Emplacement de la pagination\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}}s:4:\"name\";s:19:\"pagination_location\";}i:14;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:18:\"Type de pagination\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:13:\"Liens de base\";s:5:\"value\";s:8:\"advanced\";}i:1;a:2:{s:5:\"label\";s:39:\"Liens Précédent et Suivant uniquement\";s:5:\"value\";s:6:\"simple\";}i:2;a:2:{s:5:\"label\";s:80:\"Utiliser une liste non ordonnée avec la fonctionnalité native paginate_links()\";s:5:\"value\";s:4:\"list\";}i:3;a:2:{s:5:\"label\";s:59:\"Utiliser la fonctionnalité native de base paginate_links()\";s:5:\"value\";s:8:\"paginate\";}}s:4:\"help\";s:42:\"Choisir le type de pagination à afficher.\";s:5:\"label\";s:18:\"Type de pagination\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:13:\"Liens de base\";s:5:\"value\";s:8:\"advanced\";}}s:4:\"name\";s:15:\"pagination_type\";}i:15;a:4:{s:4:\"type\";s:15:\"CheckboxControl\";s:12:\"fieldOptions\";a:3:{s:7:\"heading\";s:19:\"Activer les filtres\";s:5:\"label\";s:3:\"Oui\";s:4:\"help\";s:46:\"Whether to show filters for the list of items.\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:4:\"name\";s:14:\"filters_enable\";}i:16;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:115:\"Comma-separated list of fields you want to allow filtering by. Default is to just show a text field to search with.\";s:5:\"label\";s:16:\"Champs de filtre\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:7:\"filters\";}i:17;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:87:\"Le libellé à afficher pour les filtres. La valeur par défaut est « Rechercher ».\";s:5:\"label\";s:34:\"Libellé de filtres personnalisés\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:13:\"filters_label\";}i:18;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:23:\"Emplacement des filtres\";s:7:\"options\";a:2:{i:0;a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}i:1;a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}}s:4:\"help\";s:42:\"L’emplacement pour afficher les filtres.\";s:5:\"label\";s:23:\"Emplacement des filtres\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}}s:4:\"name\";s:16:\"filters_location\";}i:19;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Cache Mode\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:15:\"Disable Caching\";s:5:\"value\";s:4:\"none\";}i:1;a:2:{s:5:\"label\";s:12:\"Object Cache\";s:5:\"value\";s:5:\"cache\";}i:2;a:2:{s:5:\"label\";s:9:\"Transient\";s:5:\"value\";s:9:\"transient\";}i:3;a:2:{s:5:\"label\";s:14:\"Site Transient\";s:5:\"value\";s:14:\"site-transient\";}}s:4:\"help\";s:34:\"The mode to cache the output with.\";s:5:\"label\";s:10:\"Cache Mode\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Disable Caching\";s:5:\"value\";s:4:\"none\";}}s:4:\"name\";s:10:\"cache_mode\";}i:20;a:4:{s:4:\"type\";s:13:\"NumberControl\";s:12:\"fieldOptions\";a:5:{s:18:\"isShiftStepEnabled\";b:0;s:9:\"shiftStep\";b:0;s:4:\"step\";i:1;s:4:\"help\";s:48:\"Set how long to cache the output for in seconds.\";s:5:\"label\";s:7:\"Expires\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:300;}s:4:\"name\";s:7:\"expires\";}}s:10:\"attributes\";a:26:{s:5:\"align\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"textColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:15:\"backgroundColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"fontSize\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"style\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:18:\"access_rights_help\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"slug\";a:1:{s:4:\"type\";s:6:\"string\";}s:13:\"related_field\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"template\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}}s:15:\"template_custom\";a:1:{s:4:\"type\";s:6:\"string\";}s:14:\"content_before\";a:1:{s:4:\"type\";s:6:\"string\";}s:13:\"content_after\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"not_found\";a:2:{s:4:\"type\";s:6:\"string\";s:7:\"default\";s:34:\"Aucun contenu n’a été trouvé.\";}s:5:\"limit\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:15;}s:7:\"orderby\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"where\";a:1:{s:4:\"type\";s:6:\"string\";}s:10:\"pagination\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:19:\"pagination_location\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Après la liste\";s:5:\"value\";s:5:\"after\";}}s:15:\"pagination_type\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:13:\"Liens de base\";s:5:\"value\";s:8:\"advanced\";}}s:14:\"filters_enable\";a:2:{s:4:\"type\";s:7:\"boolean\";s:7:\"default\";b:0;}s:7:\"filters\";a:1:{s:4:\"type\";s:6:\"string\";}s:13:\"filters_label\";a:1:{s:4:\"type\";s:6:\"string\";}s:16:\"filters_location\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:14:\"Avant la liste\";s:5:\"value\";s:6:\"before\";}}s:10:\"cache_mode\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:15:\"Disable Caching\";s:5:\"value\";s:4:\"none\";}}s:7:\"expires\";a:2:{s:4:\"type\";s:6:\"number\";s:7:\"default\";i:300;}}s:10:\"transforms\";a:0:{}}i:3;a:15:{s:9:\"blockName\";s:22:\"pods/pods-block-single\";s:15:\"blockGroupLabel\";s:7:\"Options\";s:5:\"title\";s:16:\"Pods Single Item\";s:11:\"description\";s:26:\"Display a single Pod item.\";s:10:\"renderType\";s:3:\"php\";s:8:\"category\";s:4:\"pods\";s:4:\"icon\";s:4:\"pods\";s:8:\"keywords\";a:4:{i:0;s:4:\"pods\";i:1;s:6:\"single\";i:2;s:4:\"item\";i:3;s:5:\"field\";}s:8:\"supports\";a:13:{s:4:\"html\";b:0;s:5:\"align\";b:1;s:9:\"alignWide\";b:1;s:6:\"anchor\";b:0;s:15:\"customClassName\";b:1;s:8:\"inserter\";b:1;s:8:\"multiple\";b:1;s:8:\"reusable\";b:1;s:19:\"__experimentalColor\";b:1;s:22:\"__experimentalFontSize\";b:1;s:21:\"__experimentalPadding\";b:1;s:24:\"__experimentalLineHeight\";b:1;s:3:\"jsx\";b:0;}s:12:\"editorScript\";s:15:\"pods-blocks-api\";s:11:\"usesContext\";a:2:{i:0;s:8:\"postType\";i:1;s:6:\"postId\";}s:15:\"providesContext\";a:0:{}s:6:\"fields\";a:5:{i:0;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Nom du pod\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:10:\"composante\";s:5:\"value\";s:10:\"composante\";}i:2;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:3;a:2:{s:5:\"label\";s:9:\"formation\";s:5:\"value\";s:9:\"formation\";}}s:4:\"help\";s:87:\"Choose the pod to reference, or reference the Pod in the current context of this block.\";s:5:\"label\";s:10:\"Nom du pod\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:4:\"name\";}i:1;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:204:\"Read about how access rights control what can be displayed to other users: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:18:\"access_rights_help\";}i:2;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:39:\"Defaults to using the current pod item.\";s:5:\"label\";s:17:\"Identifiant ou ID\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:4:\"slug\";}i:3;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:7:\"Modèle\";s:7:\"options\";a:6:{i:0;a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:2;a:2:{s:5:\"label\";s:17:\"composantes_liste\";s:5:\"value\";s:17:\"composantes_liste\";}i:3;a:2:{s:5:\"label\";s:15:\"etablissement-2\";s:5:\"value\";s:15:\"etablissement-2\";}i:4;a:2:{s:5:\"label\";s:26:\"etablissement_accueil_test\";s:5:\"value\";s:26:\"etablissement_accueil_test\";}i:5;a:2:{s:5:\"label\";s:20:\"etablissements_liste\";s:5:\"value\";s:20:\"etablissements_liste\";}}s:4:\"help\";s:168:\"You can choose a previously saved Pods Template here. We recommend saving your Pods Templates with our Templates component so you can enjoy the full editing experience.\";s:5:\"label\";s:7:\"Modèle\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:8:\"template\";}i:4;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:172:\"Vous pouvez spécifier un modèle personnalisé à utiliser, il accepte les balises HTML et magiques. Tout contenu ici remplacera le modèle que vous avez choisi ci-dessus.\";s:5:\"label\";s:21:\"Modèle personnalisé\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:15:\"template_custom\";}}s:10:\"attributes\";a:10:{s:5:\"align\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"textColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:15:\"backgroundColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"fontSize\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"style\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:18:\"access_rights_help\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"slug\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"template\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:37:\"- Utiliser un modèle personnalisé -\";s:5:\"value\";s:0:\"\";}}s:15:\"template_custom\";a:1:{s:4:\"type\";s:6:\"string\";}}s:10:\"transforms\";a:1:{s:4:\"from\";a:1:{i:0;a:4:{s:4:\"type\";s:9:\"shortcode\";s:3:\"tag\";s:4:\"pods\";s:10:\"attributes\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"name\";}s:4:\"slug\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"slug\";}s:8:\"template\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:8:\"template\";}s:15:\"template_custom\";a:3:{s:4:\"type\";s:7:\"content\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:15:\"template_custom\";}}s:13:\"isMatchConfig\";a:17:{i:0;a:2:{s:4:\"name\";s:5:\"field\";s:8:\"excluded\";b:1;}i:1;a:2:{s:4:\"name\";s:4:\"form\";s:8:\"excluded\";b:1;}i:2;a:2:{s:4:\"name\";s:4:\"view\";s:8:\"excluded\";b:1;}i:3;a:2:{s:4:\"name\";s:14:\"content_before\";s:8:\"excluded\";b:1;}i:4;a:2:{s:4:\"name\";s:13:\"content_after\";s:8:\"excluded\";b:1;}i:5;a:2:{s:4:\"name\";s:9:\"not_found\";s:8:\"excluded\";b:1;}i:6;a:2:{s:4:\"name\";s:5:\"limit\";s:8:\"excluded\";b:1;}i:7;a:2:{s:4:\"name\";s:7:\"orderby\";s:8:\"excluded\";b:1;}i:8;a:2:{s:4:\"name\";s:5:\"where\";s:8:\"excluded\";b:1;}i:9;a:2:{s:4:\"name\";s:10:\"pagination\";s:8:\"excluded\";b:1;}i:10;a:2:{s:4:\"name\";s:19:\"pagination_location\";s:8:\"excluded\";b:1;}i:11;a:2:{s:4:\"name\";s:15:\"pagination_type\";s:8:\"excluded\";b:1;}i:12;a:2:{s:4:\"name\";s:7:\"filters\";s:8:\"excluded\";b:1;}i:13;a:2:{s:4:\"name\";s:13:\"filters_label\";s:8:\"excluded\";b:1;}i:14;a:2:{s:4:\"name\";s:16:\"filters_location\";s:8:\"excluded\";b:1;}i:15;a:2:{s:4:\"name\";s:10:\"cache_mode\";s:8:\"excluded\";b:1;}i:16;a:2:{s:4:\"name\";s:7:\"expires\";s:8:\"excluded\";b:1;}}}}}}i:4;a:15:{s:9:\"blockName\";s:34:\"pods/pods-block-single-list-fields\";s:15:\"blockGroupLabel\";s:7:\"Options\";s:5:\"title\";s:30:\"Pods Single Item - List Fields\";s:11:\"description\";s:37:\"Display fields for a single Pod item.\";s:10:\"renderType\";s:3:\"php\";s:8:\"category\";s:4:\"pods\";s:4:\"icon\";s:4:\"pods\";s:8:\"keywords\";a:5:{i:0;s:4:\"pods\";i:1;s:6:\"single\";i:2;s:4:\"item\";i:3;s:4:\"list\";i:4;s:6:\"fields\";}s:8:\"supports\";a:13:{s:4:\"html\";b:0;s:5:\"align\";b:1;s:9:\"alignWide\";b:1;s:6:\"anchor\";b:0;s:15:\"customClassName\";b:1;s:8:\"inserter\";b:1;s:8:\"multiple\";b:1;s:8:\"reusable\";b:1;s:19:\"__experimentalColor\";b:1;s:22:\"__experimentalFontSize\";b:1;s:21:\"__experimentalPadding\";b:1;s:24:\"__experimentalLineHeight\";b:1;s:3:\"jsx\";b:0;}s:12:\"editorScript\";s:15:\"pods-blocks-api\";s:11:\"usesContext\";a:2:{i:0;s:8:\"postType\";i:1;s:6:\"postId\";}s:15:\"providesContext\";a:0:{}s:6:\"fields\";a:6:{i:0;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Nom du pod\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:10:\"composante\";s:5:\"value\";s:10:\"composante\";}i:2;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:3;a:2:{s:5:\"label\";s:9:\"formation\";s:5:\"value\";s:9:\"formation\";}}s:4:\"help\";s:87:\"Choose the pod to reference, or reference the Pod in the current context of this block.\";s:5:\"label\";s:10:\"Nom du pod\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:4:\"name\";}i:1;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:204:\"Read about how access rights control what can be displayed to other users: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:18:\"access_rights_help\";}i:2;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:39:\"Defaults to using the current pod item.\";s:5:\"label\";s:17:\"Identifiant ou ID\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:4:\"slug\";}i:3;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:14:\"Type de sortie\";s:7:\"options\";a:5:{i:0;a:2:{s:5:\"label\";s:26:\"Liste non ordonnée (<ul>)\";s:5:\"value\";s:2:\"ul\";}i:1;a:2:{s:5:\"label\";s:29:\"Liste des descriptions (<dl>)\";s:5:\"value\";s:2:\"dl\";}i:2;a:2:{s:5:\"label\";s:30:\"Éléments de paragraphe (<p>)\";s:5:\"value\";s:1:\"p\";}i:3;a:2:{s:5:\"label\";s:22:\"Conteneurs div (<div>)\";s:5:\"value\";s:3:\"div\";}i:4;a:2:{s:5:\"label\";s:27:\"Lignes de tableau (<table>)\";s:5:\"value\";s:5:\"table\";}}s:4:\"help\";s:220:\"Choose how you want your output HTML to be set up. This allows you flexibility to build and style your output with any CSS customizations you would like. Some output types are naturally laid out better in certain themes.\";s:5:\"label\";s:14:\"Type de sortie\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:26:\"Liste non ordonnée (<ul>)\";s:5:\"value\";s:2:\"ul\";}}s:4:\"name\";s:19:\"display_output_type\";}i:4;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:122:\"Comma-separated list of the Pod Fields you want to display. Default is to show all. Use this OR the Exclude Fields option.\";s:5:\"label\";s:14:\"Display Fields\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:14:\"display_fields\";}i:5;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:135:\"Comma-separated list of the Pod Fields you want to exclude from display. Default is to show all. Use this OR the Display Fields option.\";s:5:\"label\";s:14:\"Exclude Fields\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:14:\"exclude_fields\";}}s:10:\"attributes\";a:11:{s:5:\"align\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"textColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:15:\"backgroundColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"fontSize\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"style\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:18:\"access_rights_help\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"slug\";a:1:{s:4:\"type\";s:6:\"string\";}s:19:\"display_output_type\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:26:\"Liste non ordonnée (<ul>)\";s:5:\"value\";s:2:\"ul\";}}s:14:\"display_fields\";a:1:{s:4:\"type\";s:6:\"string\";}s:14:\"exclude_fields\";a:1:{s:4:\"type\";s:6:\"string\";}}s:10:\"transforms\";a:0:{}}i:5;a:15:{s:9:\"blockName\";s:20:\"pods/pods-block-form\";s:15:\"blockGroupLabel\";s:7:\"Options\";s:5:\"title\";s:18:\"Formulaire de Pods\";s:11:\"description\";s:72:\"Afficher un formulaire afin de créer et modifier des éléments de Pod.\";s:10:\"renderType\";s:3:\"php\";s:8:\"category\";s:4:\"pods\";s:4:\"icon\";s:4:\"pods\";s:8:\"keywords\";a:3:{i:0;s:4:\"pods\";i:1;s:4:\"form\";i:2;s:5:\"input\";}s:8:\"supports\";a:13:{s:4:\"html\";b:0;s:5:\"align\";b:1;s:9:\"alignWide\";b:1;s:6:\"anchor\";b:0;s:15:\"customClassName\";b:1;s:8:\"inserter\";b:1;s:8:\"multiple\";b:1;s:8:\"reusable\";b:1;s:19:\"__experimentalColor\";b:1;s:22:\"__experimentalFontSize\";b:1;s:21:\"__experimentalPadding\";b:1;s:24:\"__experimentalLineHeight\";b:1;s:3:\"jsx\";b:0;}s:12:\"editorScript\";s:15:\"pods-blocks-api\";s:11:\"usesContext\";a:2:{i:0;s:8:\"postType\";i:1;s:6:\"postId\";}s:15:\"providesContext\";a:0:{}s:6:\"fields\";a:9:{i:0;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:10:\"Nom du pod\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}i:1;a:2:{s:5:\"label\";s:10:\"composante\";s:5:\"value\";s:10:\"composante\";}i:2;a:2:{s:5:\"label\";s:13:\"etablissement\";s:5:\"value\";s:13:\"etablissement\";}i:3;a:2:{s:5:\"label\";s:9:\"formation\";s:5:\"value\";s:9:\"formation\";}}s:4:\"help\";s:87:\"Choose the pod to reference, or reference the Pod in the current context of this block.\";s:5:\"label\";s:10:\"Nom du pod\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:4:\"name\";s:4:\"name\";}i:1;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:204:\"Read about how access rights control what can be displayed to other users: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:18:\"access_rights_help\";}i:2;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:58:\"Utilisez-le pour activer la modification d’un élément.\";s:5:\"label\";s:17:\"Identifiant ou ID\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:4:\"slug\";}i:3;a:4:{s:4:\"type\";s:15:\"TextareaControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:19:\"textarea__container\";s:6:\"auto_p\";b:1;s:4:\"help\";s:122:\"Liste séparée par des virgules des champs de Pod que vous souhaitez inclure. La valeur par défaut est de tout afficher.\";s:5:\"label\";s:20:\"Champs de formulaire\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:6:\"fields\";}i:4;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:63:\"Le libellé à afficher dans le bouton d’envoi du formulaire.\";s:5:\"label\";s:26:\"Libellé du bouton Envoyer\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:5:\"label\";}i:5;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:177:\"After someone submits the form, they can be redirected anywhere you would like. You can reference the saved item ID by using \"X_ID_X\" in the URL. The default is to not redirect.\";s:5:\"label\";s:18:\"URL de redirection\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:9:\"thank_you\";}i:6;a:4:{s:4:\"type\";s:13:\"SelectControl\";s:12:\"fieldOptions\";a:4:{s:7:\"heading\";s:14:\"Type de sortie\";s:7:\"options\";a:4:{i:0;a:2:{s:5:\"label\";s:22:\"Div containers (<div>)\";s:5:\"value\";s:3:\"div\";}i:1;a:2:{s:5:\"label\";s:21:\"Unordered list (<ul>)\";s:5:\"value\";s:2:\"ul\";}i:2;a:2:{s:5:\"label\";s:24:\"Paragraph elements (<p>)\";s:5:\"value\";s:1:\"p\";}i:3;a:2:{s:5:\"label\";s:20:\"Table rows (<table>)\";s:5:\"value\";s:5:\"table\";}}s:4:\"help\";s:217:\"Choose how you want your form HTML to be set up. This allows you flexibility to build and style your forms with any CSS customizations you would like. Some output types are naturally laid out better in certain themes.\";s:5:\"label\";s:14:\"Type de sortie\";}s:16:\"attributeOptions\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:22:\"Div containers (<div>)\";s:5:\"value\";s:3:\"div\";}}s:4:\"name\";s:16:\"form_output_type\";}i:7;a:4:{s:4:\"type\";s:11:\"TextControl\";s:12:\"fieldOptions\";a:4:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:236:\"Give this form a unique slug to reference in our user access checks. When you use the \"pods_user_can_access_object\" filter, you can selectively allow access through PHP if the user does not normally have access through WordPress itself.\";s:5:\"label\";s:15:\"Form Access Key\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:8:\"form_key\";}i:8;a:4:{s:4:\"type\";s:4:\"html\";s:12:\"fieldOptions\";a:5:{s:9:\"className\";s:15:\"text__container\";s:4:\"type\";s:4:\"text\";s:4:\"help\";s:0:\"\";s:12:\"html_content\";s:195:\"Find out more about how to customize access rights for this form: <a href=\"https://docs.pods.io/displaying-pods/access-rights-in-pods/\" target=\"_blank\" rel=\"noopener noreferrer\">Documentation</a>\";s:5:\"label\";s:13:\"Access Rights\";}s:16:\"attributeOptions\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";s:27:\"access_rights_form_key_help\";}}s:10:\"attributes\";a:14:{s:5:\"align\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"textColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:15:\"backgroundColor\";a:1:{s:4:\"type\";s:6:\"string\";}s:8:\"fontSize\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"style\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"name\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:19:\"- Use Current Pod -\";s:5:\"value\";s:0:\"\";}}s:18:\"access_rights_help\";a:1:{s:4:\"type\";s:6:\"string\";}s:4:\"slug\";a:1:{s:4:\"type\";s:6:\"string\";}s:6:\"fields\";a:1:{s:4:\"type\";s:6:\"string\";}s:5:\"label\";a:1:{s:4:\"type\";s:6:\"string\";}s:9:\"thank_you\";a:1:{s:4:\"type\";s:6:\"string\";}s:16:\"form_output_type\";a:2:{s:4:\"type\";s:6:\"object\";s:7:\"default\";a:2:{s:5:\"label\";s:22:\"Div containers (<div>)\";s:5:\"value\";s:3:\"div\";}}s:8:\"form_key\";a:1:{s:4:\"type\";s:6:\"string\";}s:27:\"access_rights_form_key_help\";a:1:{s:4:\"type\";s:6:\"string\";}}s:10:\"transforms\";a:1:{s:4:\"from\";a:2:{i:0;a:4:{s:4:\"type\";s:9:\"shortcode\";s:3:\"tag\";s:9:\"pods-form\";s:10:\"attributes\";a:7:{s:4:\"name\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"name\";}s:4:\"slug\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"slug\";}s:6:\"fields\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:6:\"fields\";}s:5:\"label\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:5:\"label\";}s:9:\"thank_you\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:9:\"thank_you\";}s:16:\"form_output_type\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:16:\"form_output_type\";}s:8:\"form_key\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:8:\"form_key\";}}s:13:\"isMatchConfig\";a:1:{i:0;a:2:{s:4:\"name\";s:4:\"name\";s:8:\"required\";b:0;}}}i:1;a:4:{s:4:\"type\";s:9:\"shortcode\";s:3:\"tag\";s:4:\"pods\";s:10:\"attributes\";a:7:{s:4:\"name\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"name\";}s:4:\"slug\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:4:\"slug\";}s:6:\"fields\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:6:\"fields\";}s:5:\"label\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:5:\"label\";}s:9:\"thank_you\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:9:\"thank_you\";}s:16:\"form_output_type\";a:3:{s:4:\"type\";s:6:\"object\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:16:\"form_output_type\";}s:8:\"form_key\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"source\";s:9:\"shortcode\";s:9:\"attribute\";s:8:\"form_key\";}}s:13:\"isMatchConfig\";a:1:{i:0;a:2:{s:4:\"name\";s:4:\"form\";s:8:\"required\";b:1;}}}}}}}", "off");
INSERT INTO `wp_obs_options` VALUES("40425", "_transient_timeout_pods_3b08c19d61b062f1fb33284388ead5c5", "1743248790", "off");
INSERT INTO `wp_obs_options` VALUES("40426", "_transient_pods_3b08c19d61b062f1fb33284388ead5c5", "a:3:{i:0;i:1412;i:1;i:75;i:2;i:147;}", "off");
INSERT INTO `wp_obs_options` VALUES("40427", "_transient_timeout_pods_7ecd3e6928bc05f6482428e5c8807f4a", "1743248790", "off");
INSERT INTO `wp_obs_options` VALUES("40428", "_transient_pods_7ecd3e6928bc05f6482428e5c8807f4a", "a:3:{i:0;i:1412;i:1;i:75;i:2;i:147;}", "off");
INSERT INTO `wp_obs_options` VALUES("40429", "_transient_timeout_pods_c3765db83d632d4399642623f3c9ea02", "1743248790", "off");
INSERT INTO `wp_obs_options` VALUES("40430", "_transient_pods_c3765db83d632d4399642623f3c9ea02", "a:0:{}", "off");
INSERT INTO `wp_obs_options` VALUES("40431", "_transient_timeout_pods_c35b75336ac8f3bab24a4e4d5698684b", "1743248791", "off");
INSERT INTO `wp_obs_options` VALUES("40432", "_transient_pods_c35b75336ac8f3bab24a4e4d5698684b", "a:5:{i:0;i:157;i:1;i:1432;i:2;i:1434;i:3;i:1006577;i:4;i:1436;}", "off");
INSERT INTO `wp_obs_options` VALUES("40433", "_transient_timeout_pods_9fd009a7d21593e283cbcb6643e385eb", "1743248795", "off");
INSERT INTO `wp_obs_options` VALUES("40434", "_transient_pods_9fd009a7d21593e283cbcb6643e385eb", "a:3:{i:0;i:1412;i:1;i:75;i:2;i:147;}", "off");
INSERT INTO `wp_obs_options` VALUES("40435", "_transient_timeout_pods_pods_pfat_the_pods-328", "1743248795", "off");
INSERT INTO `wp_obs_options` VALUES("40436", "_transient_pods_pods_pfat_the_pods-328", "a:3:{s:10:\"composante\";s:10:\"Composante\";s:13:\"etablissement\";s:13:\"Etablissement\";s:9:\"formation\";s:10:\"Formations\";}", "off");
INSERT INTO `wp_obs_options` VALUES("40437", "_transient_timeout_pods_pods_pfat_auto_pods-328", "1743248795", "off");
INSERT INTO `wp_obs_options` VALUES("40438", "_transient_pods_pods_pfat_auto_pods-328", "a:2:{s:10:\"composante\";a:11:{s:4:\"name\";s:10:\"composante\";s:5:\"label\";s:10:\"Composante\";s:6:\"single\";s:10:\"composante\";s:7:\"archive\";s:17:\"composantes_liste\";s:13:\"single_append\";s:7:\"replace\";s:14:\"archive_append\";s:7:\"replace\";s:11:\"has_archive\";b:0;s:13:\"single_filter\";s:11:\"the_content\";s:14:\"archive_filter\";s:11:\"the_excerpt\";s:16:\"run_outside_loop\";b:0;s:4:\"type\";s:9:\"post_type\";}s:13:\"etablissement\";a:11:{s:4:\"name\";s:13:\"etablissement\";s:5:\"label\";s:13:\"Etablissement\";s:6:\"single\";s:13:\"etablissement\";s:7:\"archive\";s:20:\"etablissements_liste\";s:13:\"single_append\";s:7:\"replace\";s:14:\"archive_append\";s:7:\"replace\";s:11:\"has_archive\";b:0;s:13:\"single_filter\";s:11:\"the_content\";s:14:\"archive_filter\";s:11:\"the_excerpt\";s:16:\"run_outside_loop\";b:0;s:4:\"type\";s:9:\"post_type\";}}", "off");
INSERT INTO `wp_obs_options` VALUES("40439", "_transient_timeout_pods_b62ae783b6db343946a6479e118f2b70", "1743248796", "off");
INSERT INTO `wp_obs_options` VALUES("40440", "_transient_pods_b62ae783b6db343946a6479e118f2b70", "a:24:{s:2:\"ID\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:2:\"ID\";s:5:\"label\";s:2:\"ID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:1:{i:0;s:2:\"id\";}s:20:\"hide_in_default_form\";b:1;}s:10:\"post_title\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"post_title\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:2:{s:14:\"display_filter\";s:9:\"the_title\";s:19:\"display_filter_args\";a:1:{i:0;s:7:\"post_ID\";}}s:5:\"alias\";a:2:{i:0;s:5:\"title\";i:1;s:4:\"name\";}}s:12:\"post_content\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_content\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"wysiwyg\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:25:\"wysiwyg_allowed_html_tags\";s:0:\"\";s:21:\"wysiwyg_media_buttons\";i:1;s:14:\"display_filter\";s:11:\"the_content\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"content\";}}s:12:\"post_excerpt\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_excerpt\";s:5:\"label\";s:7:\"Excerpt\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:20:\"paragraph_allow_html\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";s:14:\"display_filter\";s:11:\"the_excerpt\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"excerpt\";}}s:11:\"post_author\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_author\";s:5:\"label\";s:6:\"Author\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:16:\"pick_format_type\";s:6:\"single\";s:18:\"pick_format_single\";s:12:\"autocomplete\";s:13:\"default_value\";s:10:\"{@user.ID}\";s:21:\"default_evaluate_tags\";i:1;}s:5:\"alias\";a:1:{i:0;s:6:\"author\";}s:11:\"pick_object\";s:4:\"user\";s:8:\"pick_val\";s:4:\"user\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";}s:9:\"post_date\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_date\";s:5:\"label\";s:12:\"Publish Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:7:\"created\";i:1;s:4:\"date\";}}s:13:\"post_date_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_date_gmt\";s:5:\"label\";s:18:\"Publish Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_status\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:5:\"draft\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:11:\"post-status\";s:18:\"pick_format_single\";s:8:\"dropdown\";s:5:\"alias\";a:1:{i:0;s:6:\"status\";}}s:14:\"comment_status\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"comment_status\";s:5:\"label\";s:14:\"Comment Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:0:\"\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}}s:11:\"ping_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"ping_status\";s:5:\"label\";s:11:\"Ping Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:4:\"open\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}s:20:\"hide_in_default_form\";b:1;}s:13:\"post_password\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_password\";s:5:\"label\";s:8:\"Password\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"password\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:20:\"hide_in_default_form\";b:1;}s:9:\"post_name\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_name\";s:5:\"label\";s:9:\"Permalink\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"slug\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:4:\"slug\";i:1;s:9:\"permalink\";}}s:7:\"to_ping\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:7:\"to_ping\";s:5:\"label\";s:7:\"To Ping\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:6:\"pinged\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:6:\"pinged\";s:5:\"label\";s:6:\"Pinged\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"post_modified\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_modified\";s:5:\"label\";s:18:\"Last Modified Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:8:\"modified\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:17:\"post_modified_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:17:\"post_modified_gmt\";s:5:\"label\";s:24:\"Last Modified Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:21:\"post_content_filtered\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:21:\"post_content_filtered\";s:5:\"label\";s:18:\"Content (filtered)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:7:{s:20:\"paragraph_allow_html\";i:1;s:16:\"paragraph_oembed\";i:1;s:21:\"paragraph_wptexturize\";i:1;s:23:\"paragraph_convert_chars\";i:1;s:17:\"paragraph_wpautop\";i:1;s:25:\"paragraph_allow_shortcode\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_parent\";a:26:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_parent\";s:5:\"label\";s:6:\"Parent\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:9:\"post_type\";s:8:\"pick_val\";s:11:\"__current__\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";s:5:\"alias\";a:1:{i:0;s:6:\"parent\";}s:4:\"data\";a:0:{}s:6:\"hidden\";b:1;}s:4:\"guid\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:4:\"guid\";s:5:\"label\";s:4:\"GUID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:10:\"menu_order\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"menu_order\";s:5:\"label\";s:10:\"Menu Order\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:0:{}}s:9:\"post_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_type\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:4:\"type\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:14:\"post_mime_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"post_mime_type\";s:5:\"label\";s:9:\"Mime Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"comment_count\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"comment_count\";s:5:\"label\";s:13:\"Comment Count\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:8:\"comments\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:8:\"comments\";s:5:\"label\";s:8:\"Comments\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"comment\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:19:\"comment_format_type\";s:5:\"multi\";}s:11:\"pick_object\";s:7:\"comment\";s:8:\"pick_val\";s:7:\"comment\";s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}}", "off");
INSERT INTO `wp_obs_options` VALUES("40441", "_transient_timeout_pods_16515b2e67b3bf45be130c9218a9c0a0", "1743248796", "off");
INSERT INTO `wp_obs_options` VALUES("40442", "_transient_pods_16515b2e67b3bf45be130c9218a9c0a0", "a:28:{s:11:\"object_type\";s:9:\"post_type\";s:4:\"type\";s:9:\"post_type\";s:11:\"object_name\";s:10:\"composante\";s:19:\"object_hierarchical\";b:0;s:7:\"storage\";s:4:\"meta\";s:5:\"table\";s:12:\"wp_obs_posts\";s:10:\"meta_table\";s:15:\"wp_obs_postmeta\";s:9:\"pod_table\";s:22:\"wp_obs_pods_composante\";s:8:\"field_id\";s:2:\"ID\";s:11:\"field_index\";s:10:\"post_title\";s:10:\"field_slug\";s:9:\"post_name\";s:10:\"field_type\";s:9:\"post_type\";s:12:\"field_parent\";s:11:\"post_parent\";s:19:\"field_parent_select\";s:17:\"`t`.`post_parent`\";s:13:\"meta_field_id\";s:7:\"post_id\";s:16:\"meta_field_index\";s:8:\"meta_key\";s:16:\"meta_field_value\";s:10:\"meta_value\";s:12:\"pod_field_id\";s:2:\"id\";s:15:\"pod_field_index\";s:4:\"name\";s:14:\"pod_field_slug\";N;s:16:\"pod_field_parent\";N;s:4:\"join\";a:0:{}s:5:\"where\";a:1:{s:9:\"post_type\";s:30:\"`t`.`post_type` = \'composante\'\";}s:13:\"where_default\";s:34:\"`t`.`post_status` IN ( \'publish\' )\";s:7:\"orderby\";s:51:\"`t`.`menu_order`, `t`.`post_title`, `t`.`post_date`\";s:3:\"pod\";O:16:\"Pods\\Whatsit\\Pod\":1:{s:7:\"\0*\0args\";a:33:{s:11:\"object_type\";s:3:\"pod\";s:19:\"object_storage_type\";s:9:\"post_type\";s:4:\"name\";s:10:\"composante\";s:2:\"id\";i:1412;s:6:\"parent\";s:0:\"\";s:5:\"group\";s:0:\"\";s:5:\"label\";s:10:\"Composante\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:4:\"type\";s:9:\"post_type\";s:7:\"storage\";s:4:\"meta\";s:14:\"label_singular\";s:10:\"Composante\";s:6:\"public\";s:1:\"1\";s:7:\"show_ui\";s:1:\"1\";s:11:\"rest_enable\";s:1:\"1\";s:14:\"supports_title\";s:1:\"1\";s:15:\"supports_editor\";s:1:\"1\";s:12:\"_migrated_28\";s:1:\"1\";s:11:\"pick_object\";s:13:\"custom-simple\";s:8:\"required\";s:1:\"0\";s:21:\"required_help_boolean\";s:1:\"0\";s:19:\"supports_quick_edit\";s:1:\"1\";s:11:\"pfat_enable\";s:1:\"1\";s:11:\"pfat_single\";s:10:\"composante\";s:18:\"pfat_filter_single\";s:11:\"the_content\";s:19:\"pfat_filter_archive\";s:11:\"the_excerpt\";s:21:\"pfat_run_outside_loop\";s:1:\"0\";s:12:\"pfat_archive\";s:17:\"composantes_liste\";s:19:\"pfat_append_archive\";s:7:\"replace\";s:18:\"pfat_append_single\";s:7:\"replace\";s:38:\"built_in_taxonomies_ecoles_de_commerce\";s:1:\"1\";s:24:\"built_in_taxonomies_test\";s:1:\"1\";s:43:\"built_in_taxonomies_categorie_etablissement\";s:1:\"1\";}}s:7:\"recurse\";b:1;s:13:\"object_fields\";a:24:{s:2:\"ID\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:2:\"ID\";s:5:\"label\";s:2:\"ID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:1:{i:0;s:2:\"id\";}s:20:\"hide_in_default_form\";b:1;}s:10:\"post_title\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"post_title\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:2:{s:14:\"display_filter\";s:9:\"the_title\";s:19:\"display_filter_args\";a:1:{i:0;s:7:\"post_ID\";}}s:5:\"alias\";a:2:{i:0;s:5:\"title\";i:1;s:4:\"name\";}}s:12:\"post_content\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_content\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"wysiwyg\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:25:\"wysiwyg_allowed_html_tags\";s:0:\"\";s:21:\"wysiwyg_media_buttons\";i:1;s:14:\"display_filter\";s:11:\"the_content\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"content\";}}s:12:\"post_excerpt\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:12:\"post_excerpt\";s:5:\"label\";s:7:\"Excerpt\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:20:\"paragraph_allow_html\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";s:14:\"display_filter\";s:11:\"the_excerpt\";s:8:\"pre_save\";i:0;}s:5:\"alias\";a:1:{i:0;s:7:\"excerpt\";}}s:11:\"post_author\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_author\";s:5:\"label\";s:6:\"Author\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:4:{s:16:\"pick_format_type\";s:6:\"single\";s:18:\"pick_format_single\";s:12:\"autocomplete\";s:13:\"default_value\";s:10:\"{@user.ID}\";s:21:\"default_evaluate_tags\";i:1;}s:5:\"alias\";a:1:{i:0;s:6:\"author\";}s:11:\"pick_object\";s:4:\"user\";s:8:\"pick_val\";s:4:\"user\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";}s:9:\"post_date\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_date\";s:5:\"label\";s:12:\"Publish Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:7:\"created\";i:1;s:4:\"date\";}}s:13:\"post_date_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_date_gmt\";s:5:\"label\";s:18:\"Publish Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_status\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:5:\"draft\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:11:\"post-status\";s:18:\"pick_format_single\";s:8:\"dropdown\";s:5:\"alias\";a:1:{i:0;s:6:\"status\";}}s:14:\"comment_status\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"comment_status\";s:5:\"label\";s:14:\"Comment Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:0:\"\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}}s:11:\"ping_status\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"ping_status\";s:5:\"label\";s:11:\"Ping Status\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";s:4:\"open\";s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:4:\"data\";a:2:{s:4:\"open\";s:6:\"Ouvert\";s:6:\"closed\";s:6:\"Fermé\";}s:20:\"hide_in_default_form\";b:1;}s:13:\"post_password\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_password\";s:5:\"label\";s:8:\"Password\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"password\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:20:\"hide_in_default_form\";b:1;}s:9:\"post_name\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_name\";s:5:\"label\";s:9:\"Permalink\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"slug\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:2:{i:0;s:4:\"slug\";i:1;s:9:\"permalink\";}}s:7:\"to_ping\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:7:\"to_ping\";s:5:\"label\";s:7:\"To Ping\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:6:\"pinged\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:6:\"pinged\";s:5:\"label\";s:6:\"Pinged\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"post_modified\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"post_modified\";s:5:\"label\";s:18:\"Last Modified Date\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:8:\"modified\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:17:\"post_modified_gmt\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:17:\"post_modified_gmt\";s:5:\"label\";s:24:\"Last Modified Date (GMT)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:8:\"datetime\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:21:\"post_content_filtered\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:21:\"post_content_filtered\";s:5:\"label\";s:18:\"Content (filtered)\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:9:\"paragraph\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:7:{s:20:\"paragraph_allow_html\";i:1;s:16:\"paragraph_oembed\";i:1;s:21:\"paragraph_wptexturize\";i:1;s:23:\"paragraph_convert_chars\";i:1;s:17:\"paragraph_wpautop\";i:1;s:25:\"paragraph_allow_shortcode\";i:1;s:27:\"paragraph_allowed_html_tags\";s:0:\"\";}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:11:\"post_parent\";a:26:{s:2:\"id\";i:0;s:4:\"name\";s:11:\"post_parent\";s:5:\"label\";s:6:\"Parent\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"pick\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:11:\"pick_object\";s:9:\"post_type\";s:8:\"pick_val\";s:11:\"__current__\";s:17:\"pick_data_storage\";s:6:\"object\";s:11:\"pick_output\";s:3:\"ids\";s:5:\"alias\";a:1:{i:0;s:6:\"parent\";}s:4:\"data\";a:0:{}s:6:\"hidden\";b:1;}s:4:\"guid\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:4:\"guid\";s:5:\"label\";s:4:\"GUID\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:10:\"menu_order\";a:20:{s:2:\"id\";i:0;s:4:\"name\";s:10:\"menu_order\";s:5:\"label\";s:10:\"Menu Order\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:13:\"number_format\";s:7:\"9999.99\";}s:5:\"alias\";a:0:{}}s:9:\"post_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:9:\"post_type\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:1:{i:0;s:4:\"type\";}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:14:\"post_mime_type\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:14:\"post_mime_type\";s:5:\"label\";s:9:\"Mime Type\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:13:\"comment_count\";a:22:{s:2:\"id\";i:0;s:4:\"name\";s:13:\"comment_count\";s:5:\"label\";s:13:\"Comment Count\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:6:\"number\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:0:{}s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}s:8:\"comments\";a:24:{s:2:\"id\";i:0;s:4:\"name\";s:8:\"comments\";s:5:\"label\";s:8:\"Comments\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"default\";N;s:10:\"attributes\";a:0:{}s:5:\"class\";s:0:\"\";s:4:\"type\";s:7:\"comment\";s:5:\"group\";i:0;s:7:\"grouped\";i:0;s:14:\"developer_mode\";b:0;s:10:\"dependency\";b:0;s:10:\"depends-on\";a:0:{}s:14:\"depends-on-any\";a:0:{}s:16:\"depends-on-multi\";a:0:{}s:11:\"excludes-on\";a:0:{}s:11:\"wildcard-on\";a:0:{}s:7:\"options\";a:1:{s:19:\"comment_format_type\";s:5:\"multi\";}s:11:\"pick_object\";s:7:\"comment\";s:8:\"pick_val\";s:7:\"comment\";s:5:\"alias\";a:0:{}s:6:\"hidden\";b:1;s:20:\"hide_in_default_form\";b:1;}}}", "off");
INSERT INTO `wp_obs_options` VALUES("40443", "_transient_timeout_pods_a1039a9538a0b415a0650fed9fe7892f", "1743248796", "off");
INSERT INTO `wp_obs_options` VALUES("40444", "_transient_pods_a1039a9538a0b415a0650fed9fe7892f", "a:14:{i:0;i:1418;i:1;i:1414;i:2;i:1423;i:3;i:1419;i:4;i:1424;i:5;i:1416;i:6;i:1420;i:7;i:1425;i:8;i:1427;i:9;i:1421;i:10;i:1426;i:11;i:1428;i:12;i:1006517;i:13;i:1006606;}", "off");
INSERT INTO `wp_obs_options` VALUES("40445", "_transient_timeout_pods_3ceb66a9f1d424fa8aa0b96f0d0e66da", "1743248796", "off");
INSERT INTO `wp_obs_options` VALUES("40446", "_transient_pods_3ceb66a9f1d424fa8aa0b96f0d0e66da", "a:24:{s:2:\"ID\";a:21:{s:2:\"id\";i:0;s:4:\"name\";s:2:\"ID\";s:5:\"label\